﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.OleDb;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NilaOCR
{

    public class AccessDbConnector
    {
        //String dbConnectionString;
        OleDbConnection con =null;
        public void ConnectToDatabase()
        {
            con = new OleDbConnection(@"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + OCRSettings.settings.DBPath + ";Jet OLEDB:Database Password=H3mm1ng3r@Esslingen");
        }

        public void CloseDatabase()
        {
            con = null;
        }


        public int InsertInvoiceRecord(InvoiceData invData)
        {
            if(con.State != ConnectionState.Open)
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            if (invData.NettoSumme.Contains(","))
                invData.NettoSumme = invData.NettoSumme.Replace(",", ".");
            String qryString = "insert into Invoices (RechnungsNummer,SAPNummer,Datum,Bestellnummer,Kostenstelle,NettoSumme,Discount,NettoSummeDoc) values ('";
            qryString += invData.InvNummer + "','" + invData.SAPNummer + "'," + "'" + invData.DatumAccessFormat + "'" + ",'" + invData.Bestellnummer + "'," + invData.Kostenstelle + "," + invData.NettoSumme + "," + invData.Discount + "," + invData.NettoSummeDoc + ")";
            myCommand.CommandText = qryString;
            try
            {
                myCommand.ExecuteNonQuery();
            }
            catch(Exception ex)
            {
                MessageBox.Show("Gutschrift kann nicht in der Datenbank upgedatet werden '" + invData.InvNummer + "'.\n" + ex.Message + "\n" + ex.StackTrace + "\n" + qryString );
                con.Close();
                return -1;
            }

          /*  qryString = "insert into InvoicesTemp (InvNummer,SAPNummer,Datum,Bestellnummer,Kostenstelle,NettoSumme,IsValidated,IsUpdated) values (";
            qryString += invData.InvNummer + "," + invData.SAPNummer + "," + "'" + invData.DatumAccessFormat + "'" + ",'" + invData.Bestellnummer + "'," + invData.Kostenstelle + "," + invData.NettoSumme + ",0,1)";
            myCommand.CommandText = qryString;
            myCommand.ExecuteNonQuery(); */
            myCommand.CommandText = "Select  @@identity"; 
            int id = (int)myCommand.ExecuteScalar();
            con.Close();
            return id;
        }

        public int getNumInvoiceTempRecords()
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            String qryString = "select count(*) from InvoicesTemp";
            
            myCommand.CommandText = qryString;
            int rows = (int)myCommand.ExecuteScalar();
            con.Close();
            return rows;
        }

        public int UpdateInvoiceRecord(InvoiceData invData,String oldInvNummer)
        {
            if(con.State != ConnectionState.Open)
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;

            if(invData.NettoSumme.Contains(","))
                invData.NettoSumme = invData.NettoSumme.Replace(",", ".");

            String qryString = "insert into Invoices (RechnungsNummer,SAPNummer,Datum,Bestellnummer,Kostenstelle,NettoSumme,Discount,NettoSummeDoc) values ('";
            qryString += invData.InvNummer + "','" + invData.SAPNummer + "'," + "'" + invData.DatumAccessFormat + "'" + ",'" + invData.Bestellnummer + "'," + invData.Kostenstelle + "," + invData.NettoSumme + "," + invData.Discount + "," + invData.NettoSummeDoc + ")";
            myCommand.CommandText = qryString;
            try
            {
                myCommand.ExecuteNonQuery();
            }
            catch(Exception ex)
            {
                MessageBox.Show("Gutschrift kann nicht in der Datenbank upgedatet werden '" + invData.InvNummer + "'.\n" + ex.Message + "\n" + ex.StackTrace);
                con.Close();
                return -1;
            }

            myCommand.CommandText = "Select  @@identity";
            int id = (int)myCommand.ExecuteScalar();
                qryString = "delete from InvoicesTemp where ID=";
                qryString += oldInvNummer;
                myCommand.CommandText = qryString;
                myCommand.ExecuteNonQuery();


            con.Close();
            return id;
        }

       

        public int InsertInvoiceTempRecord(InvoiceTempData invTempData)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            String qryString = "insert into InvoicesTemp (SourceFilePath, InvNummer,SAPNummer,Datum,Bestellnummer,Kostenstelle,NettoSumme,IsValidated,IsUpdated,Discount) values (";
            qryString += "'" + invTempData.SourcePath + "','" + invTempData.InvNummer + "','" + invTempData.SAPNummer + "'," + "'" + invTempData.DatumAccessFormat + "'" + ",'" + invTempData.Bestellnummer + "','" + invTempData.Kostenstelle + "','" + invTempData.NettoSumme + "',false,false," + invTempData.Discount + ")";
            
           // qryString += invTempData.InvNummer + "," + invTempData.SAPNummer + ",'" + invTempData.Bestellnummer + "'," + invTempData.Kostenstelle + "," + invTempData.NettoSumme + ")";
            myCommand.CommandText += qryString;
            myCommand.ExecuteNonQuery();
            myCommand.CommandText = "Select  @@identity";
            int lastID = (int)myCommand.ExecuteScalar();
            con.Close();
            return lastID;
        }

        public void InsertBookingRecord(List<BookingData> bookDataList)
        {
            if(con.State != ConnectionState.Open)
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            foreach (BookingData bookData in bookDataList)
            {
                String qryString = "insert into Bookings (AvisNummer,RechnungsNummer,Datum,Avissumme) values (";
                qryString += bookData.RefNummer + "," + "'" + bookData.RechnungsNummerHI + "'" + "," + "'" + bookData.DatumAccessFormat + "'" + "," + bookData.Transfersumme + ")";
                myCommand.CommandText = qryString;
                myCommand.ExecuteNonQuery();
                myCommand.CommandText = "Select  @@identity";
                int lastID = (int)myCommand.ExecuteScalar();

                qryString = "update Invoices set AvisNummer=" + bookData.RefNummer + ",Aviswert=" + bookData.Transfersumme + " where RechnungsNummer = '" + bookData.RechnungsNummerHI + "'";
                myCommand.CommandText = qryString;
                int rows = myCommand.ExecuteNonQuery();

                if(rows > 0)
                {
                    myCommand.CommandText = "update Bookings set InvoiceUpdated = true where ID = " + lastID;
                    myCommand.ExecuteNonQuery();
                }

            }

            con.Close();
        }

        public void InsertBookingTempRecord(List<BookingTempData> bookTempDataList)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            foreach (BookingTempData bookTempData in bookTempDataList)
            {
                if (bookTempData.RefNummer == null)
                    bookTempData.RefNummer = "0";
                String qryString = "insert into BookingsTemp (SourceFilePath,RefNummer,RechnungsNummerHI,Datum,Transfersumme,PageNumber,IsValid) values (";
                qryString += "'" + bookTempData.pdfPath + "'," +  bookTempData.RefNummer + "," + "'" + bookTempData.RechnungsNummerHI + "'" + "," + "'" + bookTempData.DatumAccessFormat + "'" + ",'" + bookTempData.Transfersumme + "'," + bookTempData.pageNumber + "," + bookTempData.isValid + ")";
                myCommand.CommandText = qryString;
                try
                {
                    myCommand.ExecuteNonQuery();
                }
                catch(Exception ex)
                {

                }
            }
            con.Close();
        }

        internal void resetTrackerSyncColumn()
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            String qryString = "update Invoices set TrackerDBSync = -1 where TrackerDBSync = 0 and Avisnummer is NOT NULL";
            //qryString += "'" + invTempData.SourcePath + "','" + invTempData.InvNummer + "','" + invTempData.SAPNummer + "'," + "'" + invTempData.DatumAccessFormat + "'" + ",'" + invTempData.Bestellnummer + "','" + invTempData.Kostenstelle + "','" + invTempData.NettoSumme + "',false,false," + invTempData.Discount + ")";

            // qryString += invTempData.InvNummer + "," + invTempData.SAPNummer + ",'" + invTempData.Bestellnummer + "'," + invTempData.Kostenstelle + "," + invTempData.NettoSumme + ")";
            myCommand.CommandText += qryString;
            myCommand.ExecuteNonQuery();
            con.Close();
        }

        internal DataTable getTrackerUnsyncInvoices()
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select SAPNummer,Kontoauszug,NettoSummeDoc from Invoices where Avisnummer is NOT NULL and TrackerDBSync = 0 order by Kontoauszug desc";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }




        /*public void UpdateRecord(String tableName, String[] columnNames, object[] values)
        {

        }

        public String[] GetRecord(String tableName, String columnName, object value)
        {
            return null;
        }

        public void DeleteRecord(String tableName, String columnName, object value)
        {

        }

       */

        public System.Data.DataTable getInvoiceRecords(string idlist)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select * from InvoicesCalc where ID in (" + idlist + ")";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public DataTable getBookingRecords(string idlist)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select * from Bookings where AvisNummer in (" + idlist + ")";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public DataTable getBookingRecordsSummary(string idlist)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select AvisNummer, Sum(Avissumme) as Gesamt_Summe from Bookings where AvisNummer in (" + idlist + ") group by AvisNummer order by AvisNummer";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public DataTable getInvoicesForDates(DateTime startDate, DateTime endDate)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select ReportGroup as CostCenter, sum(NettoHI) as NetHI, sum(NettoALD)as  NetALD, sum(BruttoHI) as Brutto_HI,sum(BruttoALD) as Brutto_ALD , RechNrHi, RechNrALD from InvoiceAnlegenNrView where Kontoauszug >= #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and Kontoauszug < #" + endDate.AddDays(1).ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and (RechnungNrHI is null or RechnungNrHI = '') and Kontoauszug is not null group by ReportGroup,RechNrHi, RechNrALD order by ReportGroup";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public void updateRechnungsNumHIForDates(DateTime startDate, DateTime endDate,DataTable tbl)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            foreach(DataRow row in tbl.Rows)
            {
                if (!row["CostCenter"].ToString().Equals("Aldinger"))
                {
                    myCommand.CommandText = "update Invoices set RechnungNrHI = '" + row["RechNrHi"] + "' where Kontoauszug >= #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and Kontoauszug < #" + endDate.AddDays(1).ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and (RechnungNrHI is null or RechnungNrHI = '') and Kontoauszug is not null and Kostenstelle=" + row["CostCenter"];
                }
                else
                {
                    myCommand.CommandText = "update Invoices set RechnungNrHI = '" + row["RechNrHi"] + "', RechnungNrALD = '" + row["RechNrALD"] + "' where Kontoauszug >= #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and Kontoauszug < #" + endDate.AddDays(1).ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and (RechnungNrHI is null or RechnungNrHI = '') and Kontoauszug is not null and Kostenstelle between 100 and 200";
                }
                myCommand.ExecuteNonQuery();
            }
            con.Close();
        }

        public DataTable getInvoiceDataForReportForPeriod(DateTime startDate, DateTime endDate)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select RechnungsNummer,SAPNummer,Datum,Kostenstelle,NettoSumme,BruttoSumme from InvoiceAnlegenNrView where Datum between #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and #" + endDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and (RechnungNrHI is null or RechnungNrHI = '') and Kontoauszug is not null order by kostenstelle,Datum,RechnungsNummer";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public List<string> getUniqueInvoiceNumbers()
        {
            List<string> result = new List<string>();
            result.Add("");
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select distinct RechnungsNummer from Invoices";

            OleDbDataReader reader = myCommand.ExecuteReader();
            while(reader.Read())
            {
                result.Add(reader[0].ToString());
            }
            reader.Close();
            con.Close();
            return result;
        }

        public DataTable getInvoiceByNumber(string rechnungsNummer)
        {
            if(con.State == ConnectionState.Closed)
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select * from Invoices where RechnungsNummer = '" + rechnungsNummer + "'";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public void UpdateInvoice(long id, long SAPNumber, long OrderNumber, DateTime datum, int costcenter, double netsum, long? avisnumber, DateTime? kont, double? aviswert, string rechhi,string invNummer,string newInvNummer)
        {

            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;

            OleDbParameterCollection coll = myCommand.Parameters;

            coll.Add(new OleDbParameter("@SAPNummer", SAPNumber.ToString()));
            coll.Add(new OleDbParameter("@Datum", datum.ToString("yyyy-MM-dd",CultureInfo.InvariantCulture)));
            coll.Add(new OleDbParameter("@Bestellnummer", OrderNumber));
            coll.Add(new OleDbParameter("@kostenstelle", costcenter));
            coll.Add(new OleDbParameter("@NettoSumme", netsum));
            coll.Add(new OleDbParameter("@Avisnummer", OleDbType.BigInt)).Value = avisnumber.HasValue ? (object)avisnumber.Value : DBNull.Value;
            coll.Add(new OleDbParameter("@Kontoauszug", OleDbType.Date)).Value = kont.HasValue ? (object)kont.Value : DBNull.Value;
            coll.Add(new OleDbParameter("@Aviswert", OleDbType.Double)).Value = aviswert.HasValue ? (object)aviswert.Value : DBNull.Value;
            coll.Add(new OleDbParameter("@RechnungNrHI", rechhi));
            coll.Add(new OleDbParameter("@RechnungsNummer", newInvNummer));
            

            if (id != -1)
            {
                
                coll.Add(new OleDbParameter("@ID", id));
                myCommand.CommandText = "update Invoices set SAPNummer = ?, Datum = ?, Bestellnummer = ?, Kostenstelle =?,NettoSumme = ?,Avisnummer = ?,Kontoauszug = ?, Aviswert = ?, RechnungNrHI = ?,RechnungsNummer = ?,TrackerDBSync=0 where ID = ?";
            }
            else
            {
                
                myCommand.CommandText = "insert into Invoices(SAPNummer, Datum, Bestellnummer, Kostenstelle,NettoSumme ,Avisnummer ,Kontoauszug , Aviswert , RechnungNrHI, RechnungsNummer) values (?,?,?,?,?,?,?,?,?,?)";                

            }
            //myCommand.CommandText = "update Invoices set SAPNummer = ? where ID = ?";
           
            int rows = myCommand.ExecuteNonQuery();
            con.Close();

        }

        public void UpdateInvoiceWithDiscount(long id, long SAPNumber, long OrderNumber, DateTime datum, int costcenter, double netsum, long? avisnumber, DateTime? kont, double? aviswert, string rechhi, string invNummer,double discount,double nettosumdoc,string newInvNumber)
        {

            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;

            OleDbParameterCollection coll = myCommand.Parameters;

            coll.Add(new OleDbParameter("@SAPNummer", SAPNumber.ToString()));
            coll.Add(new OleDbParameter("@Datum", datum.ToString("yyyy-MM-dd", CultureInfo.InvariantCulture)));
            coll.Add(new OleDbParameter("@Bestellnummer", OrderNumber));
            coll.Add(new OleDbParameter("@kostenstelle", costcenter));
            coll.Add(new OleDbParameter("@NettoSumme", netsum));
            coll.Add(new OleDbParameter("@Avisnummer", OleDbType.BigInt)).Value = avisnumber.HasValue ? (object)avisnumber.Value : DBNull.Value;
            coll.Add(new OleDbParameter("@Kontoauszug", OleDbType.Date)).Value = kont.HasValue ? (object)kont.Value : DBNull.Value;
            coll.Add(new OleDbParameter("@Aviswert", OleDbType.Double)).Value = aviswert.HasValue ? (object)aviswert.Value : DBNull.Value;
            coll.Add(new OleDbParameter("@RechnungNrHI", rechhi));
            coll.Add(new OleDbParameter("@Discount", discount));
            coll.Add(new OleDbParameter("@NettoSummeDoc", nettosumdoc));
            coll.Add(new OleDbParameter("@RechnungsNummer", newInvNumber));

            if (id != -1)
            {
                coll.Add(new OleDbParameter("@ID", id));
                myCommand.CommandText = "update Invoices set SAPNummer = ?, Datum = ?, Bestellnummer = ?, Kostenstelle =?,NettoSumme = ?,Avisnummer = ?,Kontoauszug = ?, Aviswert = ?, RechnungNrHI = ?, Discount = ?, NettoSummeDoc = ?,RechnungsNummer = ?,TrackerDBSync=0 where ID = ?";
            }
            else
            {
               // coll.Add(new OleDbParameter("@RechnungsNummer", invNummer));
                myCommand.CommandText = "insert into Invoices(SAPNummer, Datum, Bestellnummer, Kostenstelle,NettoSumme ,Avisnummer ,Kontoauszug , Aviswert , RechnungNrHI,Discount,NettoSummeDoc, RechnungsNummer) values (?,?,?,?,?,?,?,?,?,?,?,?)";

            }
            //myCommand.CommandText = "update Invoices set SAPNummer = ? where ID = ?";

            int rows = myCommand.ExecuteNonQuery();
            con.Close();

        }

        public List<GutschriftNewDocumentModel> getInvoiceTempDocuments()
        {
            List<GutschriftNewDocumentModel> models = new List<GutschriftNewDocumentModel>();
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select * from InvoicesTemp";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            foreach(DataRow row in result.Rows)
            {
                GutschriftNewDocumentModel model = new GutschriftNewDocumentModel(row);
                if(model.ValidDocument)
                {
                    InvoiceData data = model.GetInvoiceData();
                    UpdateInvoiceRecord(data, model.InitInvNumber);
                }
                else
                    models.Add(model);
            }
            con.Close();
            return models;
        }

        public List<GutschriftDocumentModel> getInvoiceTempDocumentsOld()
        {
            List<GutschriftDocumentModel> models = new List<GutschriftDocumentModel>();
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select * from InvoicesTemp";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            foreach (DataRow row in result.Rows)
            {
                GutschriftDocumentModel model = new GutschriftDocumentModel(row);
                if (model.ValidDocument)
                {
                    InvoiceData data = model.GetInvoiceData();
                    UpdateInvoiceRecord(data, model.InitInvNumber);
                }
                else
                    models.Add(model);
            }
            con.Close();
            return models;
        }

        public List<string> getUniqueAvisNumbers()
        {
            List<string> result = new List<string>();
            result.Add("");
            if(con.State!= ConnectionState.Open)
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select distinct AvisNummer from Bookings";

            OleDbDataReader reader = myCommand.ExecuteReader();
            while (reader.Read())
            {
                result.Add(reader[0].ToString());
            }
            reader.Close();
            con.Close();
            return result;
        }

        public DataTable getAvisByNumber(string avisNummer)
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select ID,RechnungsNummer,Datum,Avissumme,InvoiceUpdated from Bookings where AvisNummer = " + avisNummer ;
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public bool IsAvisNumberAlreadyExsists(string avisnummer)
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select count(*) from Bookings where AvisNummer = " + avisnummer;
            int rows = (int)myCommand.ExecuteScalar();
            con.Close();
            return rows > 0;
        }

        public int getNumAvisTempRecords()
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            String qryString = "select count(*) from BookingsTemp";

            myCommand.CommandText = qryString;
            int rows = (int)myCommand.ExecuteScalar();
            con.Close();
            return rows;
        }

        public List<AvisDocumentModel> getAvisTempDocuments()
        {
            List<AvisDocumentModel> models = new List<AvisDocumentModel>();
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select distinct SourceFilePath, RefNummer, Datum  from BookingsTemp";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            foreach (DataRow row in result.Rows)
            {
                AvisDocumentModel model = new AvisDocumentModel(row);
                myCommand.CommandText = "Select RechnungsNummerHI as invoicenumber, Transfersumme as amount,PageNumber as pagenumber,IsValid as isvalid from BookingsTemp where SourceFilePath ='" + row["SourceFilePath"].ToString() + "' and RefNummer ='" + row["RefNummer"].ToString() + "' order by ID";
                OleDbDataAdapter adap = new OleDbDataAdapter(myCommand);
                DataTable avisTable = new DataTable();
                adap.Fill(avisTable);
                model.AvisTable = avisTable;
                model.Validate();
                if (model.ValidDocument)
                {
                    List<BookingData> data = model.GetBookingData();
                    InsertBookingRecord(data);
                }
                else
                    models.Add(model);
            }
            con.Close();
            return models;
        }

        public List<AvisDocumentModelNew> getAvisTempDocumentsNew()
        {
            List<AvisDocumentModelNew> models = new List<AvisDocumentModelNew>();
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select distinct SourceFilePath, RefNummer, Datum  from BookingsTemp";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            foreach (DataRow row in result.Rows)
            {
                AvisDocumentModelNew model = new AvisDocumentModelNew(row);
                myCommand.CommandText = "Select RechnungsNummerHI as invoicenumber, Transfersumme as amount,PageNumber as pagenumber,IsValid as isvalid from BookingsTemp where SourceFilePath ='" + row["SourceFilePath"].ToString() + "' and RefNummer ='" + row["RefNummer"].ToString() + "' order by ID";
                OleDbDataAdapter adap = new OleDbDataAdapter(myCommand);
                DataTable avisTable = new DataTable();
                adap.Fill(avisTable);
                model.AvisTable = avisTable;
                model.Validate();
                if (model.ValidDocument)
                {
                    List<BookingData> data = model.GetBookingData();
                    InsertBookingRecord(data);
                }
                else
                    models.Add(model);
            }
            con.Close();
            return models;
        }
        public void deleteTempAvisbyAvisNummer(string avisNummer, string sourcePath)
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "delete from BookingsTemp where RefNummer = '" + avisNummer + "' and SourceFilePath = '" + sourcePath + "'";
            int rows = (int)myCommand.ExecuteNonQuery();
            con.Close();
        }

        public void InsertNewAvisRecords(string avisNummer,DateTime date, DataTable tbl)
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            if(avisNummer.Equals(""))
            {
                avisNummer = "99999999";
            }
            foreach(DataRow row in tbl.Rows)
            {
                if (row.RowState == DataRowState.Added)
                {
                    double aviswert = double.Parse(row["Avissumme"].ToString().Replace(",", "."),CultureInfo.InvariantCulture);
                    myCommand.CommandText = "Update Invoices set Avisnummer = " + avisNummer + ", Aviswert = " + aviswert.ToString(CultureInfo.InvariantCulture) + " where RechnungsNummer = '" + row["RechnungsNummer"].ToString() + "'";
                    bool updated = ((int)myCommand.ExecuteNonQuery()) > 0;

                    myCommand.CommandText = "Insert into Bookings(AvisNummer,RechnungsNummer,Datum,Avissumme,InvoiceUpdated) values (" + avisNummer + ",'" + row["RechnungsNummer"] + "','" + date.ToString("yyyy-MM-dd",CultureInfo.InvariantCulture) + "'," + aviswert.ToString(CultureInfo.InvariantCulture) + ", " + updated + ")";
                    myCommand.ExecuteNonQuery();
                }
            }
            con.Close();
        }

        public int getNumAvisRecordsByInvoiceNumber(string invoiceNum)
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select count(*) from Bookings where RechnungsNummer = '" + invoiceNum + "'";
            int rows = (int)myCommand.ExecuteScalar();
            con.Close();
            return rows;
        }

        public int getNumAvisRecords(string avisNum)
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select count(*) from Bookings where AvisNummer = " + avisNum;
            int rows = (int)myCommand.ExecuteScalar();
            con.Close();
            return rows;
        }

        public void UpdateAvisRecords(DateTime date, DataTable tbl,String avisNummer)
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            foreach (DataRow row in tbl.Rows)
            {
                double aviswert = double.Parse(row["Avissumme"].ToString().Replace(",", "."), CultureInfo.InvariantCulture);

                myCommand.CommandText = "Update Invoices set Avisnummer = " + avisNummer + ", Aviswert = " + aviswert.ToString(CultureInfo.InvariantCulture) + " where RechnungsNummer = '" + row["RechnungsNummer"].ToString() + "'";
                //MessageBox.Show(myCommand.CommandText);
                bool updated = ((int)myCommand.ExecuteNonQuery()) > 0;

                if (row.RowState == DataRowState.Added)
                {
                    myCommand.CommandText = "Insert into Bookings(AvisNummer,RechnungsNummer,Datum,Avissumme,InvoiceUpdated) values (" + avisNummer + ",'" + row["RechnungsNummer"] + "','" + date.ToString("yyyy-MM-dd") + "'," + aviswert.ToString(CultureInfo.InvariantCulture) + ", " + updated + ")";
                }
                else if(row.RowState == DataRowState.Deleted)
                {
                    myCommand.CommandText = "Delete from Bookings where AvisNummer = " + avisNummer + " and RechnungsNummer = '" + row["RechnungsNummer"] + "'";

                }
                else if(row.RowState == DataRowState.Modified || row.RowState == DataRowState.Unchanged)
                {
                    myCommand.CommandText = "update bookings set RechnungsNummer = '" + row["RechnungsNummer"] + "', Datum = '" + date.ToString("yyyy-MM-dd") + "', Avissumme = " + aviswert.ToString(CultureInfo.InvariantCulture) + ", InvoiceUpdated = " + updated + " where ID = " + row["ID"];
                }
                myCommand.ExecuteNonQuery();
            }
            con.Close();
        }

        public int getNumBookingsNotSyncInvoice()
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select count(*) from Bookings where InvoiceUpdated = false";
            int rows = (int)myCommand.ExecuteScalar();
            con.Close();
            return rows;
        }

        public void SyncBookingsWithInvoice()
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select ID,AvisNummer,RechnungsNummer,Datum,Avissumme,Kontoauszug,InvoiceUpdated from Bookings where InvoiceUpdated = false";
            OleDbDataAdapter adap = new OleDbDataAdapter(myCommand);
            DataTable resultTable = new DataTable();
            adap.Fill(resultTable);

            foreach(DataRow row in resultTable.Rows)
            {
                double aviswert = double.Parse(row["Avissumme"].ToString().Replace(",", "."), CultureInfo.InvariantCulture);
                myCommand = new OleDbCommand();
                myCommand.Connection = con;
                myCommand.CommandText = "update Invoices set Avisnummer = " + row["AvisNummer"] +
                                        ", Aviswert = " + aviswert.ToString(CultureInfo.InvariantCulture) + ", Kontoauszug = ? where RechnungsNummer = '" +
                                        row["RechnungsNummer"] + "'";
                OleDbParameterCollection coll = myCommand.Parameters;
                coll.Add(new OleDbParameter("@Kontoauszug", OleDbType.Date)).Value = row["Kontoauszug"];
                int rows = (int)myCommand.ExecuteNonQuery();
                if(rows > 0)
                {
                    myCommand.CommandText = "update Bookings set InvoiceUpdated = true where ID = " + row["ID"];
                    myCommand.ExecuteNonQuery();
                }
            }

            con.Close();
            
        }

        public DataTable getBookingsNotSyncInvoice()
        {

            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select ID,AvisNummer,RechnungsNummer,Datum,Avissumme,InvoiceUpdated from Bookings where InvoiceUpdated = false";
            OleDbDataAdapter adap = new OleDbDataAdapter(myCommand);
                DataTable resultTable = new DataTable();
                adap.Fill(resultTable);
            con.Close();
            return resultTable;
        
        }

        public void UpdateKontauszug(DateTime date, string avisNummer)
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "update Invoices set Kontoauszug = #" + date.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# where Avisnummer = " + avisNummer; // +" and Kontoauszug is null";
           // OleDbParameterCollection coll = myCommand.Parameters;
           // coll.Add(new OleDbParameter("@Kontoauszug",DbType.Date)).Value = date;
           // coll.Add(new OleDbParameter("@Avisnummer", DbType.Int32)).Value = Int32.Parse(avisNummer);
            myCommand.ExecuteNonQuery();

            myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "update Bookings set Kontoauszug = #" + date.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# where Avisnummer = " + avisNummer; // +" and Kontoauszug is null";
           // coll = myCommand.Parameters;
           // coll.Add(new OleDbParameter("@Kontoauszug", DbType.Date)).Value = date;
            myCommand.ExecuteNonQuery();

            con.Close();
        }

        public void updateIBLBooking(long id,string invoiceNumber, int costCenterFrom, int costCenterTo, double sum,DateTime? invoiceDate)
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;

            OleDbParameterCollection coll = myCommand.Parameters;

            coll.Add(new OleDbParameter("@SchuldnerKS", costCenterFrom));
            coll.Add(new OleDbParameter("@EmpfaengerKS", costCenterTo));
            coll.Add(new OleDbParameter("@Amount", sum));
            if (id != -1) {

                coll.Add(new OleDbParameter("@ID", id));
                myCommand.CommandText = "update IBLBuchung set SchuldnerKS = ?, EmpfaengerKS = ?, Amount = ? where ID = ?";
            }
            else
            {
                coll.Add(new OleDbParameter("@Rechnungsnummer", invoiceNumber));
                coll.Add(new OleDbParameter("@InvoiceDate", invoiceDate));
                myCommand.CommandText = "insert into IBLBuchung(SchuldnerKS, EmpfaengerKS, Amount, Rechnungsnummer,InvoiceDate) values (?,?,?,?,?)";

            }
            //myCommand.CommandText = "update Invoices set SAPNummer = ? where ID = ?";

            int rows = myCommand.ExecuteNonQuery();
            con.Close();
        }

        public DataTable getIBLBookingByRechnungsNummer(string rechnungsNummer)
        {
            if(con.State == ConnectionState.Closed)
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select * from IBLBuchung where RechnungsNummer = '" + rechnungsNummer + "'";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;

        }

        public DataTable getIBLInvoicesForDates(DateTime startDate, DateTime endDate)
        {
            
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select SchuldnerKS, EmpfaengerKS, sum(Amount) as NetSum from IBLBuchung where InvoiceDate >= #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and InvoiceDate < #" + endDate.AddDays(1).ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and Booked = false group by SchuldnerKS,EmpfaengerKS order by SchuldnerKS";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public DataTable getIBLInvoiceDataForReportForPeriod(DateTime startDate, DateTime endDate)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select Rechnungsnummer,InvoiceDate,SchuldnerKS,EmpfaengerKS,Amount from IBLBuchung where InvoiceDate between #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and #" + endDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and Booked = false order by SchuldnerKS,InvoiceDate,Rechnungsnummer";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public void updateIBLBookingsForDates(DateTime startDate, DateTime endDate)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "update IBLBuchung set Booked = true, BookedDate = Date() where InvoiceDate between #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and #" + endDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and Booked = false";
            myCommand.ExecuteNonQuery();
            con.Close();
        }

        internal DataTable getInvoicesForDatesIgnoreKontoauszug(DateTime startDate, DateTime endDate)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select ReportGroup as CostCenter, sum(NettoHI) as NetHI, sum(NettoALD)as  NetALD, sum(BruttoHI) as Brutto_HI,sum(BruttoALD) as Brutto_ALD, RechNrHi, RechNrALD from InvoiceAnlegenNrView where Datum between #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and #" + endDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# group by ReportGroup, RechNrHi, RechNrALD order by ReportGroup";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        internal DataTable getInvoiceDataForReportForPeriodIgnoreKontoauszug(DateTime startDate, DateTime endDate)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select RechnungsNummer,SAPNummer,Datum,Kostenstelle,NettoSumme from Invoices where Datum between #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and #" + endDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# order by kostenstelle,Datum,RechnungsNummer";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        internal DataTable getInvoiceDataForReportForPeriodIgnoreKontoauszugALD(DateTime startDate, DateTime endDate)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select RechnungsNummer,SAPNummer,Datum,kostenstelle,NettoALD,BruttoALD,RechNrALD as RechnungNrALD from InvoiceAnlegenNrView where Datum between #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and #" + endDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and kostenstelle between 100 and 200 order by kostenstelle,Datum,RechnungsNummer";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public DataTable getRechnungsNummersForYearMonthCC(int year, int month, string costcenter)
        {
            if(con.State != ConnectionState.Open)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;

            myCommand.CommandText = "Select RechnungNrHI,RechnungNrALD from InvoiceInternalMap where Year =" +
                                    year + " and month = " + month + " and CostCenter = '" + costcenter + "'";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public void updateAnlegenRnNr(int year, int month, string costcenter, int rnhi, int rnald)
        {
            if (con.State == ConnectionState.Closed)
                con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select count(*) from InvoiceInternalMap where Year = " + year + " and month = " + month + " and costcenter = '" + costcenter + "'";
            int rows = (int)myCommand.ExecuteScalar();
            if (rows == 0)
            {
                if (costcenter.Equals("ALD"))
                {
                    myCommand.CommandText =
                        "insert into InvoiceInternalMap([Year], [Month], CostCenter, RechnungNrHI, RechnungNrALD) values (" +
                        year + "," + month + ",'" + costcenter + "'," + rnhi + "," + rnald + ")";

                }
                else
                {
                    myCommand.CommandText =
                       "insert into InvoiceInternalMap([Year], [Month], CostCenter, RechnungNrHI) values (" +
                       year + "," + month + ",'" + costcenter + "'," + rnhi + ")";
                }
                myCommand.ExecuteNonQuery();
            }
            else
            {
                if (costcenter.Equals("ALD"))
                {
                    myCommand.CommandText =
                        "update InvoiceInternalMap set RechnungNrHI = " + rnhi + ", RechnungNrALD = " + rnald +
                        " where [Year] = " + year + " and [Month] = " + month + " and costcenter = '" + costcenter + "'";

                }
                else
                {
                    myCommand.CommandText =
                        "update InvoiceInternalMap set RechnungNrHI = " + rnhi + " where [Year] = " + year +
                        " and [Month] = " + month + " and costcenter = '" + costcenter + "'";
                }
                myCommand.ExecuteNonQuery();
            }
            con.Close();
        }

        public DataTable getBuchhaltungsForDates(DateTime startDate, DateTime endDate)
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;
            myCommand.CommandText = "Select RechNrHI as RechnungNrHI  , Round(sum(NettoSumme),2) as NettoSumme, Round(sum(NettoSumme * 1.19),2) as BruttoSumme  from InvoiceAnlegenNrView where Kontoauszug >= #" + startDate.ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and Kontoauszug < #" + endDate.AddDays(1).ToString("MM/dd/yyyy", CultureInfo.InvariantCulture) + "# and Kontoauszug is not null group by RechNrHi order by RechNrHi";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }

        public DataTable getInvoiceBookingVariance()
        {
            con.Open();
            OleDbCommand myCommand = new OleDbCommand();
            myCommand.Connection = con;

            //(Nettosumme Invoice)*1,19 - Bruttosumme Avis*(1-(discount/100))
            myCommand.CommandText =
                @"Select RechnungsNummer,Bestellnummer,Datum,Aviswert,Round(BruttoSumme,2) as BruttoSumme,Avisnummer, Abs(Round(BruttoSumme - (Aviswert * (1 - (Discount/100.0))),2)) - Round((Aviswert * (Discount/100.0)),2) as Difference from InvoicesCalc 
                  where Avisnummer is not null and Abs(Round(BruttoSumme - (Aviswert * (1 - (Discount/100.0))),2)) - Round((Aviswert * (Discount/100.0)),2) > 0.02 order by datum,Avisnummer";
                //"Select RechnungsNummer,Bestellnummer,Datum,Aviswert,Round(BruttoSumme,2) as BruttoSumme,Avisnummer from InvoicesCalc where Avisnummer is not null and Abs(Round(BruttoSumme - Aviswert,2)) > 0.02 order by datum,Avisnummer";
            OleDbDataAdapter adapter = new OleDbDataAdapter(myCommand);
            DataTable result = new DataTable();
            adapter.Fill(result);
            con.Close();
            return result;
        }
    }
}
