﻿using Cyotek.GhostScript.PdfConversion;
using System;
using System.Collections.Generic;
using System.Data;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using Tesseract;

namespace NilaOCR
{
    public class AvisDocumentModel
    {
        public string PDFFilePath { get; set; }
        public OCRStatus OCRRecognition { get; set; }
        public string AvisNumber { get; set; }
        public string AvisDate { get; set; }
        public DataTable AvisTable { get; set; }
        public bool validateTable { get; set; }
        public int pageCount { get; set; }

        public List<String> textFiles { get; set; }

        public Boolean ValidDocument { get; set; }

        AccessDbConnector con;

        public double GesamtSumme = 0;
        public double GesamtSummeCalc = 0;

        public string errorMsg = "";

        public AvisDocumentModel()
        {
            OCRSettings.LoadSettings();
            con = new AccessDbConnector();
            con.ConnectToDatabase();
            validateTable = true;
        }

        public AvisDocumentModel(DataRow row)
        {
            PDFFilePath = row["SourceFilePath"].ToString();
            AvisNumber = row["RefNummer"].ToString();
            AvisDate = row["Datum"].ToString();
            OCRSettings.LoadSettings();
            con = new AccessDbConnector();
            con.ConnectToDatabase();
            validateTable = false;
        }

        public void Validate()
        {
            errorMsg = "";
            GesamtSummeCalc = 0;
            bool isValid = true;
            
            if(AvisNumber == null || AvisNumber.Trim().Equals(""))
            {
                isValid = false;
                errorMsg = "Invalid Avis number";
            }
            if(isValid && con.IsAvisNumberAlreadyExsists(AvisNumber))
            {
                isValid = false;
                errorMsg = "Duplicate Avis number";
            }
            if (AvisTable.Rows.Count == 0)
            {
                isValid = false;
                errorMsg = "Invalid Avis entries";
            }

            if (validateTable)
            {
                for (int i = 0; i < AvisTable.Rows.Count; i++)
                {
                    bool valid = ValidateRow(i);
                    AvisTable.Rows[i]["isvalid"] = valid;
                    isValid = isValid && valid;
                    /* isValid = ValidateRow(i);
                     if (!isValid)
                         break;*/

                }
            }
            else
            {
                for (int i = 0; i < AvisTable.Rows.Count; i++)
                {
                    DataRow row = AvisTable.Rows[i];
                    if (row != null && row.RowState != DataRowState.Deleted)
                    {
                        bool valid = bool.Parse(AvisTable.Rows[i]["isvalid"].ToString());

                        isValid = isValid && valid;
                        
                    }
                    /* isValid = ValidateRow(i);
                     if (!isValid)
                         break;*/

                }
            }

            if(GesamtSumme != Math.Round(GesamtSummeCalc,2))
            {
                isValid = false;
                if (errorMsg.Length > 0)
                    errorMsg += Environment.NewLine;
                if(!errorMsg.Contains("Gesamt"))
                    errorMsg += "Gesamt Summe not recognised or mismatch with Avis Total." + Environment.NewLine + "Gesamt Summe: " + GesamtSumme + Environment.NewLine  + "Avis Total: " + GesamtSummeCalc;
            }

            if (AvisNumber == null)
                isValid = false;

            ValidDocument = isValid;
        }

        private bool ValidateRow(int i)
        {
            bool isValid = true;
            String invNumber = AvisTable.Rows[i].ItemArray[0].ToString();

            if (!Regex.IsMatch(invNumber, "^[0-9]*$"))
            {
                isValid = false;
            }
            String cost = fixDots(AvisTable.Rows[i].ItemArray[1].ToString()).Replace(".","").Replace(",", ".");

            if (!Regex.IsMatch(cost, @"^\d*\.?\d*"))
            {
                isValid = false;
            }
            double costValue = 0;
            if (!double.TryParse(cost, System.Globalization.NumberStyles.Any, CultureInfo.InvariantCulture, out costValue))
            {
                
                isValid = false;
            }
            GesamtSummeCalc += costValue;
            double costValue1 = 0;
            String cost1 = fixDots(AvisTable.Rows[i]["amount1"].ToString()).Replace(".", "").Replace(",", ".");
            if (double.TryParse(cost1, System.Globalization.NumberStyles.Any, CultureInfo.InvariantCulture, out costValue1))
            {
                //isValid = false;
                if (costValue != costValue1 && costValue1 != 0)
                    isValid = false;
            }

            if (costValue == 0 || costValue > 10000)
            {
                isValid = false;
            }
            if(!isValid)
                errorMsg = "Invalid Avis entries";
            return isValid;
        }

        public void Process(String filePath)
        {
            this.PDFFilePath = filePath;
            string pdfname = Path.GetFileName(filePath);
            string pdfnamewithoutextension = Path.GetFileNameWithoutExtension(filePath);

            Pdf2Image pdfimage = new Pdf2Image(filePath);
            pageCount = pdfimage.PageCount;

            string avisnumber = "";
            string avisdate = "";
            this.AvisTable  = new DataTable("avis");
            this.AvisTable.Columns.Add("invoicenumber");
            this.AvisTable.Columns.Add("amount");
            this.AvisTable.Columns.Add("pagenumber");
            this.AvisTable.Columns.Add("isvalid");
            this.AvisTable.Columns.Add("amount1");
            bool prevPageProcessed = true;
            for (int i = 0; i < pageCount; i++)
            {               
                string outputimagename = OCRSettings.settings.OutputDocPath + "\\" + pdfnamewithoutextension + "_Page" + (i + 1) + ".png";
                pdfimage.ConvertPdfPageToImage(outputimagename, i + 1);
                if (File.Exists(outputimagename))
                {
                    using (var engine = new TesseractEngine(@"tessdata", "eng", EngineMode.Default))
                    {
                        using (var img = Pix.LoadFromFile(outputimagename))
                        {
                            using (var page = engine.Process(img))
                            {
                                String text = page.GetText();
                                text = CleanText(text);
                                if(!prevPageProcessed)
                                {
                                    int missedPage = i;
                                }
                                prevPageProcessed = false;
                                if (avisnumber.Equals(""))
                                {
                                    string belegnr = GetBelegNumber(text);

                                    if (belegnr != null)
                                    {
                                        belegnr = belegnr.Replace(". ", " ").Replace(" .", " ");
                                        string[] tokens = belegnr.Split(" .".ToCharArray());
                                        if (tokens.Length > 1)
                                        {
                                            if (trimInner(tokens[1]).Length == OCRSettings.settings.numDigitsAvis)
                                            {
                                                avisnumber = tokens[1];
                                                this.AvisNumber = avisnumber;
                                            }
                                        }
                                    }
                                }

                                if(avisdate.Equals(""))
                                {
                                    if (i == 0)
                                    {
                                        string avisdateline = GetAvisDatePage1(text);
                                        if (avisdateline != null)
                                        {
                                            string[] toks = avisdateline.Trim().Split(" ".ToCharArray());
                                            avisdate = toks[toks.Length - 1];
                                            this.AvisDate = CleanDate(avisdate);
                                        }
                                    }
                                    else
                                    {
                                        string avisdateline = GetAvisDatePageN(text);
                                        if(avisdateline != null)
                                        {
                                            string[] toks = avisdateline.Trim().Split("/".ToCharArray());
                                            if (toks.Length >= 2)
                                            {
                                                avisdate = toks[1];
                                                this.AvisDate = CleanDate(avisdate);
                                            }
                                        }
                                    }
                                }

                                int pageitemcount = 0;
                                using (StringReader reader = new StringReader(text))
                                {
                                    String line = String.Empty;
                                   // string[] parray = { "beleg ihr", "beleg 1hr", "beleg lhr", "beleg {hr", "be-leg—nr", "beteg-nr", "beteg nr","be-leg—nr","lhr beleg","beteg lhr" };
                                    string[] parray = { "beleg datum", "be1eg datum", "beteg datum","be-leg datum" };
                                    do
                                    {
                                        line = reader.ReadLine();
                                        if (line == null)
                                            break;
                                        line = line.Trim();
                                        line = line.ToLowerInvariant();
                                        int index = -1;
                                        if (Regex.IsMatch(line, @"\bbe\w+g\s\S+m") || Regex.IsMatch(line, @"\bbe-\w+g\s\S+m"))
                                        {
                                            Match m = Regex.Match(line, @"\bbe\w+g\s\S+m");
                                            index = m.Index;
                                        }
                                        else
                                        {
                                            index = findIndexOf(parray, line);
                                        }
                                        if (index >= 0)
                                        {
                                            prevPageProcessed = true;
                                            line = reader.ReadLine();
                                            bool started = false;
                                            while (line != null)
                                            {
                                                string[] tokens = line.Split(" ".ToCharArray());
                                                string lastamount = "";
                                                int lastrowindex = -1;
                                                if (tokens.Length >= 6)
                                                {
                                                    started = true;
                                                    if (trimInner(tokens[0]).Length == OCRSettings.settings.numDigitsInvoice && !tokens[0].ToLower().Contains("steuemr"))
                                                    {

                                                        DataRow row = this.AvisTable.NewRow();
                                                        row["invoicenumber"] = trimInner(tokens[0]);
                                                        row["amount"] = fixDots(trimInner(tokens[tokens.Length - 2])).Replace(",", ".");
                                                        lastamount = row["amount"].ToString();
                                                        row["pagenumber"] = (i + 1);
                                                        this.AvisTable.Rows.Add(row);
                                                        lastrowindex = AvisTable.Rows.Count - 1;
                                                        pageitemcount++;

                                                        line = reader.ReadLine();
                                                        if(line != null)
                                                        {
                                                            string[] dtok = line.Split("/".ToCharArray());
                                                            if(dtok.Length == 2)
                                                            {
                                                                string dsum = fixDots(dtok[1].Replace(" ", "").Replace("EUR", ""));
                                                                row["amount1"] = dsum;
                                                            }
                                                        }
                                                    }
                                                }
                                                line = reader.ReadLine();
                                                if (line == null || (line.Contains("Übertrag") || line.Contains("Ubertrag")) || line.Contains("Gesamt-Summe") || line.Contains("Gesamt—Summe") || line.Contains("Gesamt~Summe") && started)
                                                {
                                                    if (line != null && line.Contains("Gesamt"))
                                                    {
                                                        string textpath = OCRSettings.settings.OutputDocPath + "\\Summary.txt";
                                                        while (line.Contains("  "))
                                                        {
                                                            line = line.Replace("  ", " ");
                                                        }
                                                       // line = trimInner(line);
                                                        string[] sumtoks = line.Split(" ".ToCharArray());
                                                        for (int ii = 0; ii < sumtoks.Length;ii++ )
                                                        {
                                                            if(sumtoks[ii].ToLower().Equals("eur"))
                                                            {
                                                                if(ii-1 >=0)
                                                                {
                                                                    string gesamt = fixDots(sumtoks[ii - 1]);
                                                                    gesamt = toInvariant(gesamt);
                                                                    double.TryParse(gesamt, NumberStyles.Number, CultureInfo.InvariantCulture, out GesamtSumme);
                                                                }
                                                            }
                                                        }
                                                            using (StreamWriter writer = File.AppendText(textpath))
                                                            {
                                                                writer.WriteLine(avisnumber + "\t" + line);
                                                                writer.Flush();
                                                            }
                                                        line = null;
                                                    }
                                                    //  File.WriteAllText(textpath, text);
                                                    break;
                                                }
                                                else
                                                {
                                                    double lastamt = 0;
                                                    if (double.TryParse(lastamount, NumberStyles.Any, CultureInfo.InvariantCulture, out lastamt))
                                                    {

                                                        if (lastamt > 10000)
                                                        {
                                                            string[] toks = line.Split("/".ToCharArray());
                                                            if (toks.Length >= 2)
                                                            {
                                                                string amt = toks[1].Trim();
                                                                if (amt.Contains("EUR"))
                                                                {
                                                                    amt = amt.Replace("EUR", "");
                                                                    amt = fixDots(trimInner(amt)).Replace(",",".");
                                                                    double val = 0;
                                                                    if (double.TryParse(amt, NumberStyles.Any, CultureInfo.InvariantCulture, out val))
                                                                    {
                                                                        if(val > 0 && val < lastamt)
                                                                        {
                                                                            if(lastrowindex >= 0)
                                                                            {
                                                                                AvisTable.Rows[lastrowindex]["amount"] = val.ToString();
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        

                                    } while (line != null);
                                }

                                if(AvisNumber == null || AvisNumber.Equals(""))
                                {
                                    int a = 0;
                                }
                                //if (pageitemcount == 0)
                               // {
                                //string textpath1 = OCRSettings.settings.OutputDocPath + "\\" + pdfnamewithoutextension + "_Page" + (i + 1) + ".txt";
                                //File.WriteAllText(textpath1, text);
                               // }
                            }
                        }
                    }
                }

                try
                {
                    File.Delete(outputimagename);
                }
                catch(Exception ex)
                {

                }
            }

            Validate();
        }

        private string fixDots(string amt)
        {
            if(amt.Contains("."))
            {
                int len = amt.Length;
                int ind = amt.LastIndexOf('.');
                if(len - (ind+1) == 2)
                {
                    amt = amt.Remove(ind, 1);
                    amt = amt.Insert(ind, ",");
                    amt = amt.Replace(".", "");
                }
            }
            return amt;
        }

        private string toInvariant(string amt)
        {
            string result = amt.Replace(".", "").Replace(",",".");
            return result;
        }

        private string CleanDate(string avisdate)
        {
            avisdate = avisdate.Replace("vom", "").Replace(",",".");

            string[] toks = avisdate.Split(".".ToCharArray());
            if (toks.Length == 3)
                return avisdate;

            avisdate = avisdate.Replace(".", "");
            if(avisdate.Length == 8)
            {
                avisdate = avisdate.Substring(0, 2) + "." + avisdate.Substring(2, 2) + "." + avisdate.Substring(4, 4);
            }
            return avisdate;
        }

        private string GetAvisDatePageN(string text)
        {
            String lcase = text.ToLowerInvariant();
            string[] parray = { "beleg—nr", "beleg-nr", "be1eg—nr", "be1eg-nr", "beteg—nr", "be.-leg—nr" };
            int index = findIndexOf(parray, lcase);
            if (index >= 0)
            {
                string line = "";
                while (index < lcase.Length)
                {
                    String ch = lcase.Substring(index++, 1);
                    if (ch == Environment.NewLine || ch.Equals("\n"))
                    {
                        return line;
                    }
                    line += ch;
                }
                return line;
            }

            return null;
        }

        private string GetAvisDatePage1(string text)
        {
            String lcase = text.ToLowerInvariant();
            string[] parray = { "zahtungsavis", "zahlungsavis", "vom" };
            int index = findIndexOf(parray, lcase);
            if (index >= 0)
            {
                string line = "";
                while (index < lcase.Length)
                {
                    String ch = lcase.Substring(index++, 1);
                    if (ch == Environment.NewLine || ch.Equals("\n"))
                    {
                        return line;
                    }
                    line += ch;
                }
                return line;
            }

            return null;
        }

        public List<BookingData> GetBookingData()
        {
            List<BookingData> bdList = new List<BookingData>();
            for (int i = 0; i < AvisTable.Rows.Count; i++)
            {
                DataRow row = AvisTable.Rows[i];
                if (row!=null && row.RowState != DataRowState.Deleted)
                {
                    String invNumber = AvisTable.Rows[i].ItemArray[0].ToString();
                    String cost = fixDots(AvisTable.Rows[i].ItemArray[1].ToString()).Replace(".", "").Replace(",", "."); // AvisTable.Rows[i].ItemArray[1].ToString();
                    String date1 = DateTime.Parse(AvisDate,new CultureInfo("de-DE")).ToString("yyyy-MM-dd");
                    BookingData bData = new BookingData();
                    bData.RefNummer = this.AvisNumber;
                    bData.RechnungsNummerHI = invNumber;
                    bData.Transfersumme = cost;
                    bData.DatumAccessFormat = date1;

                    bdList.Add(bData);
                }

            }
            return bdList;

        }

        public List<BookingTempData> GetBookingTempData()
        {
            List<BookingTempData> bdList = new List<BookingTempData>();
            for (int i = 0; i < AvisTable.Rows.Count; i++)
            {
                String invNumber = AvisTable.Rows[i].ItemArray[0].ToString();
                String cost = fixDots(AvisTable.Rows[i].ItemArray[1].ToString()).Replace(".", "").Replace(",", ".");
                
                String date1 = "";
                try
                {
                    date1 = DateTime.Parse(AvisDate, new CultureInfo("de-DE")).ToString("yyyy-MM-dd");
                }
                catch
                {
                    date1 = AvisDate;
                }
                BookingTempData bData = new BookingTempData();
                bData.RefNummer = this.AvisNumber;
                bData.RechnungsNummerHI = invNumber;
                bData.Transfersumme = cost;
                bData.DatumAccessFormat = date1;
                bData.pdfPath = PDFFilePath;
                bData.pageNumber = int.Parse(AvisTable.Rows[i]["pagenumber"].ToString());
                bData.isValid = ValidateRow(i);
                bdList.Add(bData);

            }
            return bdList;

        }

        private string GetBelegNumber(string text)
        {
            String lcase = text.ToLowerInvariant();
            string[] parray = { "beleg—nr", "beleg-nr", "be1eg—nr", "be1eg-nr", "beteg—nr", "be.-leg—nr", "be-leg—nr", "beteg-nr", "beteg nr", "be-leg—nr", "beleg~nr", "be1eg—nr", "be1eg~nr", "be1eg—nr" };
            int index = findIndexOf(parray, lcase);
            if (index >= 0)
            {
                string line = "";
                while (index < lcase.Length)
                {
                    String ch = lcase.Substring(index++, 1);
                    if (ch == Environment.NewLine || ch.Equals("\n"))
                    {
                        return line;
                    }
                    line += ch;
                }
                return line;
            }

            return null;
        }

        private string CleanText(string text)
        {
            string result = text;
            while (result.IndexOf("\n\n") >= 0)
            {
                result = result.Replace("\n\n", "\n");
            }
            // double space to single space
            while (result.IndexOf("  ") >= 0)
            {
                result = result.Replace("  ", " ");
            }
            return result.Trim();
        }

        private string trimInner(string text)
        {
            text = text.Trim();
            string result = "";
            foreach (char ch in text.ToCharArray())
            {
                if (!ch.Equals(' '))
                {
                    result += ch;
                }
            }
            return result;
        }

        private int findIndexOf(string[] parray, string text)
        {
            foreach (string word in parray)
            {
                if (text.Contains(word))
                    return text.IndexOf(word);
            }
            return -1;
        }

    }
}
