﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Tesseract;

namespace NilaOCR
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            var testImagePath = @"D:\Work\Raju\langer\img\test600.jpg";

            try
            {
                using (var engine = new TesseractEngine(@"tessdata", "deu", EngineMode.Default))
                {
                    using (var img = Pix.LoadFromFile(testImagePath))
                    {

                            var i = 1;
                            using (var page = engine.Process(img))
                            {
                                var text = page.GetText();

                                txtResult.Text = text;

                                using (var iter = page.GetIterator())
                                {
                                    iter.Begin();
                                    do
                                    {
                                        if (i % 2 == 0)
                                        {
                                                do
                                                {
                                                    //using (logger.Begin("Word Iteration"))
                                                   // {
                                                    
                                                        if (iter.IsAtBeginningOf(PageIteratorLevel.Block))
                                                        {
                                                            txtResult.Text += "New Block:\n";
                                                        }
                                                        if (iter.IsAtBeginningOf(PageIteratorLevel.Para))
                                                        {
                                                            txtResult.Text += "New Paragraph:\n";
                                                        }
                                                        if (iter.IsAtBeginningOf(PageIteratorLevel.TextLine))
                                                        {
                                                            txtResult.Text += "New Line:\n";
                                                        }
                                                    txtResult.Text += iter.GetText(PageIteratorLevel.Word) + " ";
                                                      //  logger.Log("word: " + iter.GetText(PageIteratorLevel.Word));
                                                   // }
                                                } while (iter.Next(PageIteratorLevel.TextLine, PageIteratorLevel.Word));

                                        }
                                        

                                        i++;
                                    } while (iter.Next(PageIteratorLevel.Para, PageIteratorLevel.TextLine));
                                }
                            }
                        
                    }
                }
            }
            catch (Exception ex)
            {
               // Trace.TraceError(ex.ToString());
                Console.WriteLine("Unexpected Error: " + ex.Message);
                //Console.WriteLine("Details: ");
               // Console.WriteLine(e.ToString());
            }
            //Console.Write("Press any key to continue . . . ");
            //Console.ReadKey(true);

        }
    }
}
