﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NilaOCR
{
    public partial class MainForm : Form
    {
        AccessDbConnector con;
        public MainForm()
        {
            InitializeComponent();
            OCRSettings.LoadSettings();
            con = new AccessDbConnector();
            con.ConnectToDatabase();
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnGutschrift_Click(object sender, EventArgs e)
        {
            
            if (con.getNumInvoiceTempRecords() == 0)
            {
                OCRForm ocrForm = new OCRForm();
                ocrForm.Show();
            }
            else
            {
                if (MessageBox.Show("In der Gutschriftentemporärtabelle sind noch Werte aus vorigen Sessions. Sollen diese gesichtet und bearbeitet werden?", "confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
                {
                    OCRForm ocrForm = new OCRForm();
                    ocrForm.gutschriftDocList = con.getInvoiceTempDocumentsOld();
                    ocrForm.allDocList = new List<GutschriftDocumentModel>();
                    ocrForm.Show();
                    ocrForm.UpdateDocList();
                }
                else
                {
                    OCRForm ocrForm = new OCRForm();
                    ocrForm.Show();
                }
            }
        }

        private void btnAvis_Click(object sender, EventArgs e)
        {
            if (con.getNumAvisTempRecords() == 0)
            {
                OCRFormAvis ocrFormAvis = new OCRFormAvis();
                ocrFormAvis.Show();
            }
            else
            {
                if (MessageBox.Show("In der Buchungstemporärtabelle sind noch Werte aus vorigen Sessions. Sollen diese gesichtet und bearbeitet werden?", "confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
                {
                    OCRFormAvis ocrFormAvis = new OCRFormAvis();
                    ocrFormAvis.avisDocList = con.getAvisTempDocuments();
                    ocrFormAvis.allDocList = new List<AvisDocumentModel>();
                    ocrFormAvis.Show();
                    ocrFormAvis.UpdateDocList();
                }
                else
                {
                    OCRFormAvis ocrFormAvis = new OCRFormAvis();
                    ocrFormAvis.Show();
                }
            }
        }

        private void cmdReport_Click(object sender, EventArgs e)
        {
            frmReport rpt = new frmReport();
            rpt.ShowDialog();
        }

        private void cmdEditInvoice_Click(object sender, EventArgs e)
        {
            frmEditInvoice invEdit = new frmEditInvoice();
            invEdit.ShowDialog();
        }

        private void cmdEditBooking_Click(object sender, EventArgs e)
        {
            frmAvisEdit avisEdit = new frmAvisEdit();
            avisEdit.ShowDialog();
        }

        private void cmdUpdateInvoice_Click(object sender, EventArgs e)
        {
            if(con.getNumBookingsNotSyncInvoice() == 0)
            {
                MessageBox.Show("Alle Aviseinträge haben Gutschirftswerte.", "Info");
            }
            else
            {
                con.SyncBookingsWithInvoice();
                int pending = con.getNumBookingsNotSyncInvoice();
                if(pending == 0)
                {
                    MessageBox.Show("Alle Aviseinträge haben Gutschirftswerte.", "Info");
                    return;
                }
                else
                {
                    if (MessageBox.Show("Es existieren noch immer " + pending + " Aviseinträge für Gutschriften ohne entsprechende Gutschrift. Sollen diese angezeigt werden?", "Confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
                    {
                        frmTableView tabView = new frmTableView();
                        tabView.ShowRecords(con.getBookingsNotSyncInvoice());
                        tabView.Show();
                    }
                }
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            frmKontauszugAvis kavis = new frmKontauszugAvis();
            kavis.ShowDialog();
        }

        private void cmdIBLBuchung_Click(object sender, EventArgs e)
        {
            frmIBLBuchung ibl = new frmIBLBuchung();
            ibl.ShowDialog();
        }

        private void cmdIBLReport_Click(object sender, EventArgs e)
        {
            frmIBLReport iblRpt = new frmIBLReport();
            iblRpt.ShowDialog();
        }

        private void cmdRptRechnungstellung_Click(object sender, EventArgs e)
        {
            frmReportRechnungsstellung rptrech = new frmReportRechnungsstellung();
            rptrech.ShowDialog();
        }

        private void cmdAnlegenRNnr_Click(object sender, EventArgs e)
        {
            frmAnlegenRNnr rnr = new frmAnlegenRNnr();
            rnr.ShowDialog();
        }

        private void cmdBuchhaltung_Click(object sender, EventArgs e)
        {
            frmBuchhaltung bh = new frmBuchhaltung();
            bh.ShowDialog();
        }

        private void cmdReportMismatches_Click(object sender, EventArgs e)
        {
            frmReportVariance rv = new frmReportVariance();
            rv.ShowDialog();
        }

        private void cmdNewGutschrift_Click(object sender, EventArgs e)
        {

            if (con.getNumInvoiceTempRecords() == 0)
            {
                OCRNewForm ocrForm = new OCRNewForm();
                ocrForm.Show();
            }
            else
            {
                if (MessageBox.Show("In der Gutschriftentemporärtabelle sind noch Werte aus vorigen Sessions. Sollen diese gesichtet und bearbeitet werden?", "confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
                {
                    OCRNewForm ocrForm = new OCRNewForm();
                    ocrForm.gutschriftDocList = con.getInvoiceTempDocuments();
                    ocrForm.allDocList = new List<GutschriftNewDocumentModel>();
                    ocrForm.Show();
                    ocrForm.UpdateDocList();
                }
                else
                {
                    OCRNewForm ocrForm = new OCRNewForm();
                    ocrForm.Show();
                }
            }
        }

        private void cmdNewAvis_Click(object sender, EventArgs e)
        {
            if (con.getNumAvisTempRecords() == 0)
            {
                OCRFormAvisNew ocrFormAvis = new OCRFormAvisNew();
                ocrFormAvis.Show();
            }
            else
            {
                if (MessageBox.Show("In der Buchungstemporärtabelle sind noch Werte aus vorigen Sessions. Sollen diese gesichtet und bearbeitet werden?", "confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
                {
                    OCRFormAvisNew ocrFormAvis = new OCRFormAvisNew();
                    ocrFormAvis.avisDocList = con.getAvisTempDocumentsNew();
                    ocrFormAvis.allDocList = new List<AvisDocumentModelNew>();
                    ocrFormAvis.Show();
                    ocrFormAvis.UpdateDocList();
                }
                else
                {
                    OCRFormAvisNew ocrFormAvis = new OCRFormAvisNew();
                    ocrFormAvis.Show();
                }
            }
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            try
            {
                if (con != null)
                {
                    DataTable tbl = con.getTrackerUnsyncInvoices();
                    //TODO: Export the Datatable as CSV
                    if (tbl != null && tbl.Rows.Count > 0)
                    {
                        string outPath = OCRSettings.settings.tempPath + "\\trackersync\\";
                        string filename = "sync_" + DateTime.Now.ToString("yyyyMMddTHHmmss") + ".csv";
                        try
                        {
                            if (!Directory.Exists(outPath))
                            {
                                Directory.CreateDirectory(outPath);
                            }
                            using (StreamWriter writer = new StreamWriter(outPath + filename))
                            {
                                WriteDataTable(tbl, writer, false);
                            }

                        }
                        catch (Exception ex)
                        {
                            MessageBox.Show("Unable to create Tracker sync file.\n" + ex.Message, "Warning", MessageBoxButtons.OK);
                            return;
                        }
                        if (CheckForInternetConnection())
                        {
                            if (HttpUploadFile("http://onlineplatform.info/netze/ocr/sync", outPath + filename, "ocr", "application/octet-stream", new NameValueCollection()))
                            {
                                con.resetTrackerSyncColumn();
                                File.Delete(outPath + filename);
                            }
                            else
                            {
                                File.Delete(outPath + filename);
                            }
                        }
                    }
                }
            }
            catch(Exception ex)
            {
                MessageBox.Show("There is a problem in syncing invoice details with Netze Tracker.\n" + ex.Message, "Warning", MessageBoxButtons.OK);
                return;
            }
        }

        public static void WriteDataTable(DataTable sourceTable, TextWriter writer, bool includeHeaders)
        {
            if (includeHeaders)
            {
                IEnumerable<String> headerValues = sourceTable.Columns
                    .OfType<DataColumn>()
                    .Select(column => column.ColumnName);

                writer.WriteLine(String.Join("\t", headerValues));
               
            }

            IEnumerable<String> items = null;

            foreach (DataRow row in sourceTable.Rows)
            {
                items = row.ItemArray.Select(o => o?.ToString() ?? String.Empty);
                writer.WriteLine(String.Join("\t", items));
                
            }

            writer.Flush();
        }

        private static string QuoteValue(string value)
        {
            return String.Concat("\"",
            value.Replace("\"", "\"\""), "\"");
        }

        public static bool CheckForInternetConnection()
        {
            try
            {
                using (var client = new WebClient())
                {
                    using (client.OpenRead("http://clients3.google.com/generate_204"))
                    {
                        return true;
                    }
                }
            }
            catch
            {
                return false;
            }
        }

        public static bool HttpUploadFile(string url, string file, string paramName, string contentType, NameValueCollection nvc)
        {
            string boundary = "---------------------------" + DateTime.Now.Ticks.ToString("x");
            byte[] boundarybytes = System.Text.Encoding.ASCII.GetBytes("\r\n--" + boundary + "\r\n");

            HttpWebRequest wr = (HttpWebRequest)WebRequest.Create(url);
            wr.ContentType = "multipart/form-data; boundary=" + boundary;
            wr.Method = "POST";
            wr.KeepAlive = true;
            wr.Credentials = System.Net.CredentialCache.DefaultCredentials;

            Stream rs = wr.GetRequestStream();

            string formdataTemplate = "Content-Disposition: form-data; name=\"{0}\"\r\n\r\n{1}";
            foreach (string key in nvc.Keys)
            {
                rs.Write(boundarybytes, 0, boundarybytes.Length);
                string formitem = string.Format(formdataTemplate, key, nvc[key]);
                byte[] formitembytes = System.Text.Encoding.UTF8.GetBytes(formitem);
                rs.Write(formitembytes, 0, formitembytes.Length);
            }
            rs.Write(boundarybytes, 0, boundarybytes.Length);

            string headerTemplate = "Content-Disposition: form-data; name=\"{0}\"; filename=\"{1}\"\r\nContent-Type: {2}\r\n\r\n";
            string header = string.Format(headerTemplate, paramName, file, contentType);
            byte[] headerbytes = System.Text.Encoding.UTF8.GetBytes(header);
            rs.Write(headerbytes, 0, headerbytes.Length);

            FileStream fileStream = new FileStream(file, FileMode.Open, FileAccess.Read);
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = fileStream.Read(buffer, 0, buffer.Length)) != 0)
            {
                rs.Write(buffer, 0, bytesRead);
            }
            fileStream.Close();

            byte[] trailer = System.Text.Encoding.ASCII.GetBytes("\r\n--" + boundary + "--\r\n");
            rs.Write(trailer, 0, trailer.Length);
            rs.Close();

            WebResponse wresp = null;
            try
            {
                using (wresp = wr.GetResponse())
                {
                    Stream stream2 = wresp.GetResponseStream();
                    StreamReader reader2 = new StreamReader(stream2);
                }
            }
            catch (Exception ex)
            {

                if (wresp != null)
                {
                    wresp.Close();
                    wresp = null;
                }
                return true;
            }
            finally
            {
                wr = null;
            }
            return true;
        }
    }
}
