﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NilaOCR
{
    public partial class OCRFormAvis : Form
    {
        public List<AvisDocumentModel> avisDocList = null;
        public List<AvisDocumentModel> allDocList = null;
        private int completedDocCount = 0;
        private int pendingDocCount = 0;
        public OCRFormAvis()
        {
            InitializeComponent();
            btnStop.Enabled = false;
            OCRSettings.LoadSettings();

            if (!Directory.Exists(OCRSettings.settings.OutputDocPath))
            {
                Directory.CreateDirectory(OCRSettings.settings.OutputDocPath);
            }
            ResetProgressBar();
            txtRefNummer.Text = "";
          
              btnUpdate.Enabled = false;
        }

        private void btnStart_Click(object sender, EventArgs e)
        {

            btnStop.Enabled = true;
            btnStart.Enabled = false;

            lstDocFiles.Items.Clear();

            completedDocCount = 0;
            pendingDocCount = 0;

            SetStatus("Processing OCR.. Please Wait..");
            string[] pdfFfiles = Directory.GetFiles(OCRSettings.settings.AvisDocPath, "*.pdf");
            prgBarOcr.Maximum = pdfFfiles.Length;
            prgBarOcr.Visible = true;
            prgBarOcr.Update();
            BackgroundWorker myWorker = new BackgroundWorker();

            myWorker.DoWork += myWorker_DoWork;
            myWorker.RunWorkerCompleted += myWorker_RunWorkerCompleted;
            myWorker.ProgressChanged += myWorker_ProgressChanged;
            myWorker.WorkerReportsProgress = true;
            myWorker.RunWorkerAsync();


           // UpdateDocList();

           

        }

        private void myWorker_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            UpdateProgressBar();
        }

        private void myWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            UpdateDocList();
            ResetProgressBar();
            SetStatus("OCR Process completed");

            btnStop.Enabled = false;
            btnStart.Enabled = true;
        }

        private void myWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            BackgroundWorker sendingWorker = (BackgroundWorker)sender;//Capture the BackgroundWorker that fired the event
            ProcessOCR(sendingWorker);
        }

        public void UpdateDocList()
        {
            if(avisDocList.Count == 0)
            {
                MessageBox.Show("Alle Avis Dokumente verarbeitet. Keine Auffälligkeiten gefunden.");
                this.Close();
                ShowCompletedRecords();
               
                return;
            }
            lstDocFiles.Items.Clear();
            for (int i = 0; i < avisDocList.Count; i++)
            {
                if (avisDocList[i].AvisNumber!=null)
                    lstDocFiles.Items.Add(avisDocList[i].AvisNumber);
                else
                    lstDocFiles.Items.Add("0");
            }
            txtRefNummer.Text = "";
            lblErrMsg.Visible = false;
            txtRefNummer.BackColor = Color.White;
            txtRefNummer.ForeColor = Color.Black;
            dgAvis.DataSource = null;
            btnUpdate.Enabled = false;
        }

        private void ProcessOCR(BackgroundWorker sendingWorker)
        {
            avisDocList = new List<AvisDocumentModel>();
            allDocList = new List<AvisDocumentModel>();
            string[] pdfFfiles = Directory.GetFiles(OCRSettings.settings.AvisDocPath, "*.pdf");

            if (pdfFfiles.Length == 0)
            {
                MessageBox.Show("Keine Daten zur Verarbeitung verfügbar");
                return;
            }

           

            AccessDbConnector adCon = new AccessDbConnector();
            adCon.ConnectToDatabase();

            ArrayList invDocs = new ArrayList();
            for (int i = 0; i < pdfFfiles.Length; i++)
            {
                sendingWorker.ReportProgress(i);
                AvisDocumentModel gDoc = new AvisDocumentModel();
                try
                {
                    gDoc.Process(pdfFfiles[i]);
                    gDoc.Validate();
                    if (!gDoc.ValidDocument)
                    {
                        adCon.InsertBookingTempRecord(gDoc.GetBookingTempData());
                        avisDocList.Add(gDoc);
                    }
                    else
                    {
                        adCon.InsertBookingRecord(gDoc.GetBookingData());
                        MoveFilesToUpdated(gDoc);
                        allDocList.Add(gDoc);
                    }
                }
                catch(Exception ex)
                {
                    invDocs.Add(pdfFfiles[i]);
                }

            }
            if(invDocs.Count > 0)
            {
                string docs = "";
                foreach(string docname in invDocs)
                {
                    docs = docs + docname + Environment.NewLine;
                }
                MessageBox.Show("Die folgenden Dokumente können nicht verarbeitet werden:\n" + docs, "Info", MessageBoxButtons.OK);
            }

            

            adCon.CloseDatabase();

           
        }

        private void MoveFilesToUpdated(AvisDocumentModel gDoc)
        {
            string sortableDate = gDoc.AvisDate; //DateTime.Now.ToString("yyyy_MM_dd");
            String[] dateTokens = gDoc.AvisDate.Split(".".ToCharArray());
             sortableDate = gDoc.AvisDate;
            if (dateTokens.Length >= 3)
            {
                sortableDate = dateTokens[2] + "_" + dateTokens[1] + "_" + dateTokens[0];
            }
            

            try
            {
                if (gDoc.AvisNumber != null)
                    Directory.Move(gDoc.PDFFilePath, OCRSettings.settings.OutputDocPath + sortableDate + "_Avis_" + gDoc.AvisNumber + ".pdf");
            }
            catch(Exception ex)
            {
                MessageBox.Show("Die Datei kann nicht verschoben werden '" + OCRSettings.settings.OutputDocPath + sortableDate + "_Avis_" + gDoc.AvisNumber + ".pdf" + "'");
            }
        }

        private void ResetProgressBar()
        {
            prgBarOcr.Value = 0;
            prgBarOcr.Visible = false;
            SetPrgStatus("");
        }

        private void UpdateProgressBar()
        {
            prgBarOcr.Increment(1);
            SetPrgStatus("Processing " + prgBarOcr.Value.ToString() + " of " + prgBarOcr.Maximum.ToString() );
       }

        private void SetPrgStatus(String str1)
        {
            lblPrgStatus.Text = str1;
            lblPrgStatus.Update();

        }

        private void SetStatus(String str1)
        {
            lblStatus.Text = str1;
            lblStatus.Update();
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            btnStop.Enabled = false;
            btnStart.Enabled = true;
        }

        private void prgBarOcr_Click(object sender, EventArgs e)
        {

        }

        private void OCRForm_Load(object sender, EventArgs e)
        {

        }

        private void grpDoc_Enter(object sender, EventArgs e)
        {

        }

        private void lstDocFiles_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (lstDocFiles.SelectedIndex < 0) return;

            AvisDocumentModel gDoc= avisDocList[lstDocFiles.SelectedIndex];

            txtRefNummer.Text = gDoc.AvisNumber;
            txtGesamtSumme.Text = gDoc.GesamtSumme.ToString();
            dgAvis.DataSource = gDoc.AvisTable;
            dgAvis.Update();
            bool tableValid = true;
            foreach (DataGridViewRow row in dgAvis.Rows)
            {
                if (row.Cells[3].Value != null)
                {
                    bool isValid = bool.Parse(row.Cells[3].Value.ToString());

                    if (!isValid)
                    {
                        row.DefaultCellStyle.BackColor = Color.Red;
                        row.DefaultCellStyle.ForeColor = Color.White;
                        tableValid = false;
                    }
                }
                
            }
            if(tableValid)
            {
                txtRefNummer.BackColor = Color.Red;
                txtRefNummer.ForeColor = Color.White;
                lblErrMsg.Visible = true;
                
            }
            else
            {
                txtRefNummer.BackColor = Color.Red;
                txtRefNummer.ForeColor = Color.White;
                lblErrMsg.Visible = true;
            }
            lblErrMsg.Text = gDoc.errorMsg;
           // UpdateControlsForValidation(gDoc);

            if (File.Exists(gDoc.PDFFilePath))
            {
                pdfImageBox.OpenPDF(gDoc.PDFFilePath, string.Empty);

                pdfImageBox.Update();
                UpdateUI();
            }
            btnUpdate.Enabled = true;

        }

        private void UpdateUI()
        {
            //positionToolStripStatusLabel.Text = pdfImageBox.AutoScrollPosition.ToString();
            //imageSizeToolStripStatusLabel.Text = pdfImageBox.GetImageViewPort().ToString();
            //zoomToolStripStatusLabel.Text = string.Format("{0}%", pdfImageBox.Zoom);

            firstPageToolStripButton.Enabled = pdfImageBox.CanMoveFirst;
            previousPageToolStripButton.Enabled = pdfImageBox.CanMovePrevious;
            nextPageToolStripButton.Enabled = pdfImageBox.CanMoveNext;
            lastPageToolStripButton.Enabled = pdfImageBox.CanMoveLast;
            pageToolStripTextBox.Text = pdfImageBox.CurrentPage.ToString();
            pageCountToolStripLabel.Text = pdfImageBox.PageCount.ToString();

            sizeToFitToolStripButton.Checked = pdfImageBox.SizeToFit;
            actualSizeToolStripButton.Checked = (pdfImageBox.Zoom == 100);
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            if (lstDocFiles.SelectedIndex <0) return;

            AvisDocumentModel gDoc = avisDocList[lstDocFiles.SelectedIndex];

            double gesamt = 0;
            string txt = txtGesamtSumme.Text.Replace(",", ".");
            if(!double.TryParse(txt,System.Globalization.NumberStyles.Number,CultureInfo.InvariantCulture,out gesamt))
            {
                txtGesamtSumme.Focus();
                MessageBox.Show("Invalid Gesamt Summe.");
                return;
            }

            gDoc.AvisNumber = txtRefNummer.Text;
            gDoc.validateTable = true;
            gDoc.GesamtSumme = gesamt;
            gDoc.Validate();
            lblErrMsg.Text = gDoc.errorMsg;
            if (gDoc.ValidDocument)
            {
                AccessDbConnector adCon = new AccessDbConnector();
                adCon.ConnectToDatabase();
                adCon.InsertBookingRecord(gDoc.GetBookingData());
                adCon.deleteTempAvisbyAvisNummer(gDoc.AvisNumber, gDoc.PDFFilePath);
                adCon.CloseDatabase();
                MoveFilesToUpdated(gDoc);
                avisDocList.Remove(gDoc);
                allDocList.Add(gDoc);
                AutoClosingMessageBox.Show("Document updated successfully","Info",1000);
                UpdateDocList();
                if (lstDocFiles.Items.Count > 0)
                    lstDocFiles.SelectedIndex = 0;
            }

           
        }

        private void ShowCompletedRecords()
        {
            string idlist = "";
            foreach (AvisDocumentModel gDoc in allDocList)
            {
                idlist += gDoc.AvisNumber.ToString() + ",";
            }
            AccessDbConnector adCon = new AccessDbConnector();
            adCon.ConnectToDatabase();
            idlist = idlist.Trim(",".ToCharArray());
            if (!idlist.Trim().Equals(""))
            {
                DataTable tbl = adCon.getBookingRecords(idlist);
                frmTableView tview = new frmTableView();
                tview.ShowRecords(tbl);
                tview.Show();

                DataTable tblsum = adCon.getBookingRecordsSummary(idlist);
                frmTableView tview1 = new frmTableView("Summary");
                tview1.ShowRecords(tblsum);
                tview1.Show();
            }
            adCon.CloseDatabase();
        }

        private void panel3_Paint(object sender, PaintEventArgs e)
        {

        }

        private void showImageRegionToolStripButton_Click(object sender, EventArgs e)
        {
            pdfImageBox.Invalidate();
        }

        private void showSourceImageRegionToolStripButton_Click(object sender, EventArgs e)
        {
            pdfImageBox.Invalidate();
        }

        private void actualSizeToolStripButton_Click(object sender, EventArgs e)
        {
            pdfImageBox.ActualSize();
        }

        private void sizeToFitToolStripButton_Click(object sender, EventArgs e)
        {
            pdfImageBox.SizeToFit = true;
        }

        private void zoomInToolStripButton_Click(object sender, EventArgs e)
        {
            pdfImageBox.ZoomIn();
        }

        private void zoomOutToolStripButton_Click(object sender, EventArgs e)
        {
            pdfImageBox.ZoomOut();
        }

        private void firstPageToolStripButton_Click(object sender, EventArgs e)
        {
            pdfImageBox.FirstPage();
            UpdateUI();
        }

        private void previousPageToolStripButton_Click(object sender, EventArgs e)
        {
            pdfImageBox.PreviousPage();
            UpdateUI();
        }

        private void nextPageToolStripButton_Click(object sender, EventArgs e)
        {
            pdfImageBox.NextPage();
            UpdateUI();
        }

        private void lastPageToolStripButton_Click(object sender, EventArgs e)
        {
            pdfImageBox.LastPage();
            UpdateUI();
        }

        private void UpdateUIHandler(object sender, ScrollEventArgs e)
        {
            this.UpdateUI();
        }

        private void pageToolStripTextBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                int pageNumber;

                e.Handled = true;

                if (int.TryParse(pageToolStripTextBox.Text, out pageNumber) && pageNumber > 0 && pageNumber <= pdfImageBox.PageCount)
                    pdfImageBox.CurrentPage = pageNumber;
                else
                    pageToolStripTextBox.Text = pdfImageBox.CurrentPage.ToString();
            }
        }

        private void cmdDeleteAvis_Click(object sender, EventArgs e)
        {

            AvisDocumentModel gDoc = avisDocList[lstDocFiles.SelectedIndex];
            if (MessageBox.Show("Avis '" + gDoc.AvisNumber + "' wirklich von den temporären Daten löschen?", "confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
            {
                AccessDbConnector adCon = new AccessDbConnector();
                adCon.ConnectToDatabase();
                adCon.deleteTempAvisbyAvisNummer(gDoc.AvisNumber, gDoc.PDFFilePath);
                adCon.CloseDatabase();
                avisDocList.Remove(gDoc);
                UpdateDocList();
            }
        }


    }
}
