﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NilaOCR
{
    public class OCRSettings
    {
        public static Settings settings = null;
        public static void LoadSettings()
        {
            settings = new Settings();

            settings.DBPath = ConfigurationManager.AppSettings["DBPath"];
            settings.AvisDocPath = ConfigurationManager.AppSettings["AvisDocumentsPath"];
            settings.GutschriftDocPath = ConfigurationManager.AppSettings["GutschriftDocumentsPath"];
            settings.OutputDocPath = ConfigurationManager.AppSettings["OutputDocumentsPath"];
            settings.numDigitsInvoice = int.Parse(ConfigurationManager.AppSettings["invoicenumdigits"]);
            settings.numDigitsOrder = int.Parse(ConfigurationManager.AppSettings["ordernumdigits"]);
            settings.numDigitsSAP = int.Parse(ConfigurationManager.AppSettings["sapnumdigits"]);
            settings.numDigitsCostCenter = int.Parse(ConfigurationManager.AppSettings["costcenternumdigits"]);
            settings.numDigitsNewInvoice = int.Parse(ConfigurationManager.AppSettings["newinvoicenumdigits"]);

            string costcenters = ConfigurationManager.AppSettings["CostCenters"];
            string[] centers = costcenters.Split(",".ToCharArray());

            settings.CostCenters = new System.Collections.ArrayList();
            foreach (string cc in centers)
            {
                settings.CostCenters.Add(cc);
            }

            settings.tempPath = ConfigurationManager.AppSettings["tempPath"];
            settings.numDigitsAvis = int.Parse(ConfigurationManager.AppSettings["avisnumdigits"]);

            try
            {
                settings.discounts = (ConfigurationManager.GetSection("Discounts") as System.Collections.Hashtable)
                     .Cast<System.Collections.DictionaryEntry>()
                     .ToDictionary(n => n.Key.ToString(), n => float.Parse(n.Value.ToString()));

            }
            catch
            {
                
            }


        }
    }
}
