﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NilaOCR
{
    public partial class frmAnlegenRNnr : Form
    {
        AccessDbConnector con;
        public frmAnlegenRNnr()
        {
            InitializeComponent();
            OCRSettings.LoadSettings();
            con = new AccessDbConnector();
            con.ConnectToDatabase();
        }

        private void cmdClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void frmAnlegenRNnr_Load(object sender, EventArgs e)
        {
            InitValues();
        }

        private void InitValues()
        {
            updYear.Value = DateTime.Now.Year;
            updYear.Maximum = DateTime.Now.Year;

            cmbMonth.SelectedIndex = DateTime.Now.Month - 1;

            cmbCostCenter.DataSource = GetShrinkedCostCenters();
            cmbCostCenter.SelectedIndex = -1;
        }

        private ArrayList GetShrinkedCostCenters()
        {
            ArrayList lst = OCRSettings.settings.CostCenters;
            ArrayList result = new ArrayList();
            result.Add("ALD");
            foreach (string cc in lst)
            {
                int center = int.Parse(cc);
                if (center > 200)
                    result.Add(cc);
            }
            return result;
        }

        private void cmbCostCenter_SelectedIndexChanged(object sender, EventArgs e)
        {
            RefreshData();
        }

        private void RefreshData()
        {
            if (cmbCostCenter.SelectedIndex == -1)
            {
                txtRNRALD.Text = "";
                txtRNRHI.Text = "";
                return;
            }

            DataTable data =  con.getRechnungsNummersForYearMonthCC((int) updYear.Value,cmbMonth.SelectedIndex+1,cmbCostCenter.SelectedValue.ToString());
            if (data != null && data.Rows.Count > 0)
            {
                DataRow row = data.Rows[0];
                txtRNRHI.Text = row[0].ToString();
                if (row[1] != null || row[1] != DBNull.Value)
                {
                    txtRNRALD.Text = row[1].ToString();
                }
                else
                {
                    txtRNRALD.Text = "";
                }
            }
            else
            {
                txtRNRHI.Text = "";
                txtRNRALD.Text = "";
            }
            if (!cmbCostCenter.SelectedItem.ToString().Equals("ALD"))
            {
                txtRNRALD.Enabled = false;
            }
            else
            {
                txtRNRALD.Enabled = true;
            }

        }

        private void cmbMonth_SelectedIndexChanged(object sender, EventArgs e)
        {
            RefreshData();
        }

        private void updYear_ValueChanged(object sender, EventArgs e)
        {
            RefreshData();
        }

        private void cmdSave_Click(object sender, EventArgs e)
        {
            if (ValidateAll())
            {
                int rnhi = 0;
                int rnald = 0;
                rnhi = int.Parse(txtRNRHI.Text.Trim());
                int.TryParse(txtRNRALD.Text.Trim(), out rnald);
                try
                {
                   con.updateAnlegenRnNr((int)updYear.Value, (int)(cmbMonth.SelectedIndex + 1),
                   cmbCostCenter.SelectedItem.ToString(), rnhi, rnald);
                   MessageBox.Show("Werte erfolgreich ugedated", "Info", MessageBoxButtons.OK);
                }
                catch (Exception)
                {

                    MessageBox.Show("Update fehlgeschlagen", "Fehler", MessageBoxButtons.OK);
                }
               
            }
        }

        private bool ValidateAll()
        {
            if (!(updYear.Value >= 2000 && updYear.Value <= DateTime.Now.Year))
            {
                MessageBox.Show("ungültige Jahr", "Fehler");
                updYear.Focus();
                return false;
            }
            if (cmbMonth.SelectedIndex == -1)
            {
                MessageBox.Show("ungültige Monat", "Fehler");
                cmbMonth.Focus();
                return false;
            }
            if (cmbCostCenter.SelectedIndex == -1)
            {
                MessageBox.Show("ungültige Kostenstelle", "Fehler");
                cmbCostCenter.Focus();
                return false;
            }
            int val = 0;
            if (txtRNRHI.Text.Trim().Equals("") || txtRNRHI.Text.Trim().Length != 6 || !int.TryParse(txtRNRHI.Text.Trim(),out val))
            {
                MessageBox.Show("ungültige RechnungNR HI", "Fehler");
                txtRNRHI.Focus();
                return false;
            }

            int costcenter = 0;
            if (int.TryParse(cmbCostCenter.SelectedItem.ToString(), out costcenter))
            {
                if (costcenter < 200 && (txtRNRALD.Text.Trim().Equals("") || txtRNRALD.Text.Trim().Length != 6 || !int.TryParse(txtRNRALD.Text.Trim(),out val)))
                {
                    MessageBox.Show("ungültige RechnungNR ALD", "Fehler");
                    txtRNRALD.Focus();
                    return false;
                }
            }

            return true;
        }
    }

}
