﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NilaOCR
{
    public partial class frmAvisEdit : Form
    {
        bool dirty = false;
        AccessDbConnector con;
        public frmAvisEdit()
        {
            InitializeComponent();
            OCRSettings.LoadSettings();
            con = new AccessDbConnector();
            con.ConnectToDatabase();
        }

        private void cmdClose_Click(object sender, EventArgs e)
        {
            if(dirty)
            {
                if (MessageBox.Show("Änderungen verwerfen?", "confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
                {
                    this.Close();
                }
            }
        }

        private void frmAvisEdit_Load(object sender, EventArgs e)
        {
            cmbAvisNumber.DataSource = con.getUniqueAvisNumbers();
        }

        private void cmbAvisNumber_SelectedIndexChanged(object sender, EventArgs e)
        {
             string sel = cmbAvisNumber.SelectedItem.ToString();
             DataTable tbl = new DataTable();
             tbl.Columns.Add(new DataColumn("RechnungsNummer", typeof(long)));
             tbl.Columns.Add(new DataColumn("Avissumme", typeof(double)));
             if (!sel.Equals(""))
             {
                 tbl = con.getAvisByNumber(sel);
                 dgMain.DataSource = tbl;
                 if(tbl.Rows.Count > 0)
                 {
                     dtAvisDate.Value = (DateTime)tbl.Rows[0]["Datum"];
                 }
                 dtAvisDate.Enabled = true;
             }
             else
             {
                 dgMain.DataSource = tbl;
                // dtAvisDate.Enabled = false;
                 dtAvisDate.Enabled = true;
                 dtAvisDate.Value = DateTime.Now;
             }
        }

        private void dgMain_CellEndEdit(object sender, DataGridViewCellEventArgs e)
        {
            dirty = true;
        }

        private void dtAvisDate_ValueChanged(object sender, EventArgs e)
        {
            dirty = true;
        }

        private void cmdSave_Click(object sender, EventArgs e)
        {
            if (ValidateAll())
            {
                if (cmbAvisNumber.Text.Trim().Equals(""))
                {
                    DataTable tbl = (DataTable)dgMain.DataSource;
                    DateTime date = dtAvisDate.Value;
                    con.InsertNewAvisRecords("",date, tbl);
                    MessageBox.Show("Werte erfolgreich ugedated.", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    dgMain.DataSource = null;
                    cmbAvisNumber.DataSource = con.getUniqueAvisNumbers();
                    dirty = false;
                }
                else
                {
                    int numAvis = con.getNumAvisRecords(cmbAvisNumber.Text);
                    if (numAvis > 0)
                    {
                        DataTable tbl = (DataTable)dgMain.DataSource;
                        DateTime date = dtAvisDate.Value;
                        con.UpdateAvisRecords(date, tbl, cmbAvisNumber.SelectedItem.ToString());
                        MessageBox.Show("Werte erfolgreich ugedated.", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        dgMain.DataSource = null;
                        cmbAvisNumber.DataSource = con.getUniqueAvisNumbers();
                        dirty = false;
                    }
                    else
                    {
                        DataTable tbl = (DataTable)dgMain.DataSource;
                        DateTime date = dtAvisDate.Value;
                        con.InsertNewAvisRecords(cmbAvisNumber.Text,date, tbl);
                        MessageBox.Show("Werte erfolgreich ugedated.", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                        dgMain.DataSource = null;
                        cmbAvisNumber.DataSource = con.getUniqueAvisNumbers();
                        dirty = false;
                    }
                }
            }
        }

        private bool ValidateAll()
        {
            bool result = true;
            DataTable tbl = (DataTable)dgMain.DataSource;
            if (tbl == null || tbl.Rows.Count == 0)
            {
                MessageBox.Show("Es gibt nichts zu speichern.");
                return false;
            }
            else
            {
                int i = 0;
                if (!cmbAvisNumber.Text.Trim().Equals(""))
                {
                    if(cmbAvisNumber.Text.Trim().Length != OCRSettings.settings.numDigitsAvis)
                    {
                        MessageBox.Show("ungültige Avis Nummer");
                        cmbAvisNumber.Focus();
                        return false;
                    }
                }
                    foreach (DataRow row in tbl.Rows)
                    {
                        if (cmbAvisNumber.Text.Trim().Equals("") || con.getNumAvisRecords(cmbAvisNumber.Text.Trim()) == 0)
                        {
                            if (con.getNumAvisRecordsByInvoiceNumber(row["RechnungsNummer"].ToString()) != 0)
                            {
                                dgMain.Rows[i].DefaultCellStyle.BackColor = Color.Red;
                                dgMain.Rows[i].DefaultCellStyle.ForeColor = Color.White;
                                result = false;
                            }
                            else
                            {
                                dgMain.Rows[i].DefaultCellStyle.BackColor = Color.White;
                                dgMain.Rows[i].DefaultCellStyle.ForeColor = Color.Black;
                            }
                        }

                        double sum = 0;
                        if (!double.TryParse(row["AvisSumme"].ToString(), System.Globalization.NumberStyles.Any, CultureInfo.InvariantCulture, out sum))
                        {
                            dgMain.Rows[i].DefaultCellStyle.BackColor = Color.Red;
                            dgMain.Rows[i].DefaultCellStyle.ForeColor = Color.White;
                            result = false;
                        }

                        i++;
                    }
                }
            

            if(!result)
            {
                MessageBox.Show("Gutschriftsnummer existiert bereits in der Avistabelle. Bitte die markierten Daten prüfen.");
            }

            return result;
        }
    }
}
