﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NilaOCR
{
    public partial class frmBuchhaltung : Form
    {
        AccessDbConnector con;
        public frmBuchhaltung()
        {
            InitializeComponent();
            OCRSettings.LoadSettings();
            con = new AccessDbConnector();
            con.ConnectToDatabase();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void cmdGetData_Click(object sender, EventArgs e)
        {
            DataTable tbl = con.getBuchhaltungsForDates(dtStartDate.Value, dtEndDate.Value);
            grdReportView.DataSource = tbl;
            if(tbl != null)
            {
                cmdGenerate.Enabled = true;
            }
           
        }

        private void cmdGenerate_Click(object sender, EventArgs e)
        {
            DataTable tbl = grdReportView.DataSource as DataTable;
            if (tbl != null)
            {
                if (fldOutputPath.ShowDialog() == System.Windows.Forms.DialogResult.OK)
                {
                    string path = fldOutputPath.SelectedPath + "\\Buchhaltung_" + DateTime.Now.ToString("yyyy-MM-dd") +
                           "_period_" + dtStartDate.Value.ToString("yyyy-MM-dd") + "_" +
                           dtEndDate.Value.ToString("yyyy-MM-dd") + ".txt";

                    using (StreamWriter writer = File.CreateText(path))
                    {
                        string line = "";
                        foreach (DataColumn col in tbl.Columns)
                        {
                            line += col.ColumnName + "\t";
                        }
                        writer.WriteLine(line.Trim("\t ".ToCharArray()));
                        foreach (DataRow row in tbl.Rows)
                        {
                            line = "";
                            foreach (DataColumn col in tbl.Columns)
                            {
                                if (col.ColumnName.Equals("Datum"))
                                    line += ((DateTime)row[col]).ToString("dd.MM.yyyy") + "\t";
                                else
                                    line += row[col].ToString() + "\t";
                            }
                            writer.WriteLine(line.Trim("\t ".ToCharArray()));
                        }
                        writer.Flush();
                    }

                    MessageBox.Show("Report Erzeugung abgeschlossen");
                    this.Close();
                }
            }
        }

        private bool ValidateGrid()
        {
            if(grdReportView.DataSource == null || grdReportView.Rows == null || grdReportView.Rows.Count == 0)
            {
                MessageBox.Show("Keine Daten im selektierten Zeitraum verfügbar. Report kann nicht erzeugt werden.", "Error", MessageBoxButtons.OK);
                return false;
            }
            bool result = true;
           /* foreach(DataGridViewRow row in grdReportView.Rows)
            {
                if(row.Cells["InvoiceNumber"].Value.ToString().Trim().Equals(""))
                {
                    row.Cells["InvoiceNumber"].ErrorText = "Invoice number cannot be empty";
                    result = false;
                }
                else
                {
                    row.Cells["InvoiceNumber"].ErrorText = null;
                }
            }*/
            return result;
        }
    }
}
