﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NilaOCR
{
    public partial class frmEditInvoice : Form
    {
        AccessDbConnector con;
        int id = -1;
        bool discountApplied = false;
        double nettosummedoc = 0.0;
        public frmEditInvoice()
        {
            InitializeComponent();
            OCRSettings.LoadSettings();
            con = new AccessDbConnector();
            con.ConnectToDatabase();
        }

        private void frmEditInvoice_Load(object sender, EventArgs e)
        {
            cmbInvoiceNumber.DataSource = con.getUniqueInvoiceNumbers();
            cmbCostCenter.DataSource = OCRSettings.settings.CostCenters;
        }

        private void cmbInvoiceNumber_SelectedIndexChanged(object sender, EventArgs e)
        {
            discountApplied = false;
            String sel = cmbInvoiceNumber.SelectedItem.ToString();
            txtRechnungsNummer.Text = sel;
            if (!sel.Equals(""))
            {
                DataTable tbl = con.getInvoiceByNumber(sel);
                if (tbl.Rows.Count == 1)
                {
                    DataRow row = tbl.Rows[0];
                    id = (int)row["ID"];
                    txtSAPNumber.Text = row["SAPNummer"].ToString();
                    dtDatum.Value = (DateTime)row["Datum"];
                    txtBestell.Text = row["Bestellnummer"].ToString();
                    SetCostCenter(row["Kostenstelle"].ToString());
                    if (row["Avisnummer"] != DBNull.Value && row["Avisnummer"] != null)
                        txtAvisNummer.Text = row["Avisnummer"].ToString();
                    else
                        txtAvisNummer.Text = "";
                    txtNetSum.Text = row["NettoSumme"].ToString();
                    if (row["Kontoauszug"] != DBNull.Value && row["Kontoauszug"] != null)
                    {
                        dtKontoauszug.Format = DateTimePickerFormat.Short;
                        dtKontoauszug.Value = (DateTime)row["Kontoauszug"];
                    }
                    else
                    {
                        dtKontoauszug.Format = DateTimePickerFormat.Custom;
                        dtKontoauszug.CustomFormat = " ";
                    }
                    txtAvisVert.Text = row["Aviswert"].ToString();
                    if (row["RechnungNrHI"] != DBNull.Value && row["RechnungNrHI"] != null)
                        txtRechnungsNrHI.Text = row["RechnungNrHI"].ToString();
                    else
                        txtRechnungsNrHI.Text = "";

                }
                else
                {
                    ClearControls();
                }
            }
            else
            {
                ClearControls();
            }
        }

        private void ClearControls()
        {
            txtSAPNumber.Text = "";
            dtDatum.Value = DateTime.Now;
            txtBestell.Text = "";
            cmbCostCenter.SelectedIndex = -1;
            txtAvisNummer.Text = "";
            txtNetSum.Text = "";
            dtKontoauszug.Format = DateTimePickerFormat.Custom;
            dtKontoauszug.CustomFormat = " ";
            txtAvisVert.Text = "";
            txtRechnungsNrHI.Text = "";
            txtRechnungsNummer.Text = "";
            discountApplied = false;
        }

        private void SetCostCenter(string cc)
        {
            int i = 0;
            if (cmbCostCenter.DataSource != null)
            {
                foreach (String item in (ArrayList)cmbCostCenter.DataSource)
                {
                    if (item.ToString().Equals(cc))
                    {
                        cmbCostCenter.SelectedIndex = i;
                    }
                    i++;
                }
            }
        }

        private void cmdClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void cmdSave_Click(object sender, EventArgs e)
        {
            if(ValidateAll())
            {
                long SAPNumber = long.Parse(txtSAPNumber.Text);
                long OrderNumber = long.Parse(txtBestell.Text);
                DateTime datum = dtDatum.Value;
                int costcenter = int.Parse(cmbCostCenter.SelectedItem.ToString());
                double netsum = double.Parse(txtNetSum.Text, NumberStyles.Any, CultureInfo.CurrentUICulture);
                long? avisnumber = null;
                if (!txtAvisNummer.Text.Trim().Equals(""))
                    avisnumber = long.Parse(txtAvisNummer.Text);
                DateTime? kont = null;
                if (dtKontoauszug.Format != DateTimePickerFormat.Custom)
                    kont = dtKontoauszug.Value;
                double? aviswert = null;
                if (!txtAvisVert.Text.Trim().Equals(""))
                    aviswert = double.Parse(txtAvisVert.Text, NumberStyles.Any, CultureInfo.CurrentUICulture);
                string rechhi = txtRechnungsNrHI.Text;

                double discount = 0.0;
                if (OCRSettings.settings.discounts.ContainsKey(txtBestell.Text.Trim()))
                {
                    discount = OCRSettings.settings.discounts[txtBestell.Text.Trim()];
                    discountApplied = true;
                    nettosummedoc = netsum / (1 - (discount / 100.0));
                }

                if(!discountApplied)
                    con.UpdateInvoice(id, SAPNumber, OrderNumber, datum, costcenter, netsum, avisnumber, kont, aviswert, rechhi,cmbInvoiceNumber.Text,txtRechnungsNummer.Text);
                else
                    con.UpdateInvoiceWithDiscount(id, SAPNumber, OrderNumber, datum, costcenter, netsum, avisnumber, kont, aviswert, rechhi, cmbInvoiceNumber.Text,discount,nettosummedoc,txtRechnungsNummer.Text);

                MessageBox.Show("Werte erfolgreich ugedated.");
                cmbInvoiceNumber.DataSource = con.getUniqueInvoiceNumbers();
            }
        }

        private bool ValidateAll()
        {
            if ((cmbInvoiceNumber.SelectedIndex == -1 && (cmbInvoiceNumber.SelectedItem != null && cmbInvoiceNumber.SelectedItem.ToString().Equals("") && txtRechnungsNummer.Text.Trim().Equals(""))) || (cmbInvoiceNumber.Text.Trim().Length != OCRSettings.settings.numDigitsInvoice && cmbInvoiceNumber.Text.Trim().Length != OCRSettings.settings.numDigitsNewInvoice && txtRechnungsNummer.Text.Trim().Equals("")))
            {
                MessageBox.Show("Ungültige Gutschriftnummer");
                cmbInvoiceNumber.Focus();
                return false;
            }
            if (((txtRechnungsNummer.Text.Equals(""))) || (txtRechnungsNummer.Text.Trim().Length != OCRSettings.settings.numDigitsInvoice && txtRechnungsNummer.Text.Trim().Length != OCRSettings.settings.numDigitsNewInvoice))
            {
                MessageBox.Show("Ungültige Gutschriftnummer");
                txtRechnungsNummer.Focus();
                return false;
            }
            if (txtSAPNumber.Text.Trim().Equals("") || txtSAPNumber.Text.Trim().Length != OCRSettings.settings.numDigitsSAP)
            {
                MessageBox.Show("Ungültige SAP Nummer");
                txtSAPNumber.Focus();
                return false;
            }
            else
            {
                long SAPNumber = 0;
                if(!long.TryParse(txtSAPNumber.Text,out SAPNumber))
                {
                    MessageBox.Show("Ungültige SAP Nummer");
                    txtSAPNumber.Focus();
                    return false;
                }
            }
            if (txtBestell.Text.Trim().Equals("") || txtBestell.Text.Trim().Length != OCRSettings.settings.numDigitsOrder)
            {
                MessageBox.Show("Ungültige Bestellnummer");
                txtBestell.Focus();
                return false;
            }
            else
            {
                long OrderNumber = 0;
                if (!long.TryParse(txtBestell.Text, out OrderNumber))
                {
                    MessageBox.Show("Ungültige Bestellnummer");
                    txtBestell.Focus();
                    return false;
                }
            }

            if(cmbCostCenter.SelectedIndex == -1 || cmbCostCenter.SelectedItem.ToString().Length != OCRSettings.settings.numDigitsCostCenter || OCRSettings.settings.CostCenters.IndexOf(cmbCostCenter.SelectedItem.ToString()) == -1)
            {
                MessageBox.Show("Ungültige Kostenstelle oder Kostenstelle existiert nicht in der Einstellungsdatei");
                cmbCostCenter.Focus();
                return false;
            }
            double sum = 0;
            if(txtNetSum.Text.Trim().Equals("") || !double.TryParse(txtNetSum.Text,NumberStyles.Any, CultureInfo.CurrentCulture,out sum))
            {
                MessageBox.Show("ungültige Nettosumme");
                txtNetSum.Focus();
                return false;
            }

            if (!txtAvisNummer.Text.Trim().Equals("") && txtAvisNummer.Text.Trim().Length != OCRSettings.settings.numDigitsAvis)
            {
                MessageBox.Show("ungültige Avis Nummer");
                txtAvisNummer.Focus();
                return false;
            }

            return true;
        }

        private void dtKontoauszug_ValueChanged(object sender, EventArgs e)
        {
            dtKontoauszug.Format = DateTimePickerFormat.Long;
        }

        private void cmbInvoiceNumber_TextChanged(object sender, EventArgs e)
        {
            if(cmbInvoiceNumber.Text.Trim().Equals("") || cmbInvoiceNumber.Text.Trim().Length != OCRSettings.settings.numDigitsInvoice)
            {
                id = -1;
                ClearControls();
            }
        }

        private void txtBestell_TextChanged(object sender, EventArgs e)
        {
            checkAndEnableDiscount();
        }

        private void checkAndEnableDiscount()
        {
            double discount = 0.0;
            if (OCRSettings.settings.discounts.ContainsKey(txtBestell.Text.Trim()))
            {
                discount = OCRSettings.settings.discounts[txtBestell.Text.Trim()];
            }
            if(discount > 0)
            {
                cmdDiscount.Enabled = true;
            }
            else
            {
                cmdDiscount.Enabled = false;
            }
        }

        private void cmdDiscount_Click(object sender, EventArgs e)
        {
            double sum = 0;
            double discount = 0.0;
            if (OCRSettings.settings.discounts.ContainsKey(txtBestell.Text.Trim()))
            {
                discount = OCRSettings.settings.discounts[txtBestell.Text.Trim()];
            }
            if (txtNetSum.Text.Trim().Equals("") || !double.TryParse(txtNetSum.Text, NumberStyles.Any, CultureInfo.CurrentCulture, out sum))
            {
                MessageBox.Show("ungültige Nettosumme");
                txtNetSum.Focus();
                return;
            }
            else
            {
                double net1 = double.Parse(txtNetSum.Text, NumberStyles.Number, CultureInfo.CurrentCulture);
                nettosummedoc = net1;
                txtNetSum.Text = (net1 * (1 - discount / 100.0)).ToString(CultureInfo.CurrentCulture);
                cmdDiscount.Enabled = false;
                discountApplied = true;
            }
        }
    }
}
