﻿using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.IO;
using System.Windows.Forms;
using Cyotek.Windows.Forms;
using NilaOCR;

namespace NilaOCR
{
  // ImageBox sample project
  // http://cyotek.com/blog/creating-a-scrollable-and-zoomable-image-viewer-in-csharp-part-1
  // http://cyotek.com/blog/creating-a-scrollable-and-zoomable-image-viewer-in-csharp-part-2
  // http://cyotek.com/blog/creating-a-scrollable-and-zoomable-image-viewer-in-csharp-part-3
  // http://cyotek.com/blog/creating-a-scrollable-and-zoomable-image-viewer-in-csharp-part-4
  // http://cyotek.com/blog/extending-the-imagebox-component-to-display-the-contents-of-a-pdf-file-using-csharp

  // If you use this source in your applications, attribution or donations are welcome.

  // Toolbar icons from Fugue Icons - http://p.yusukekamiyamane.com/

  public partial class frmGutschriftReview : Form
  {
  #region  Public Constructors  

    public frmGutschriftReview()
    {
      InitializeComponent();
    }

  #endregion  Public Constructors  

  #region  Event Handlers  

    private void actualSizeToolStripButton_Click(object sender, EventArgs e)
    {
      pdfImageBox.ActualSize();
    }

    private void exitToolStripMenuItem_Click(object sender, EventArgs e)
    {
      this.Close();
    }

    private void firstPageToolStripButton_Click(object sender, EventArgs e)
    {
      pdfImageBox.FirstPage();
    }

    private void imageBox_MouseLeave(object sender, EventArgs e)
    {
      cursorToolStripStatusLabel.Text = string.Empty;
    }

    private void imageBox_MouseMove(object sender, MouseEventArgs e)
    {
      Point point;

      point = ((ImageBox)sender).PointToImage(e.Location);

      if (point != null)
        cursorToolStripStatusLabel.Text = point.ToString();
      else
        cursorToolStripStatusLabel.Text = string.Empty;
    }

    private void imageBox_Paint(object sender, PaintEventArgs e)
    {
      // highlight the image
      if (showImageRegionToolStripButton.Checked)
        this.DrawBox(e.Graphics, Color.CornflowerBlue, ((ImageBox)sender).GetImageViewPort());

      // show the region that will be drawn from the source image
      if (showSourceImageRegionToolStripButton.Checked)
        this.DrawBox(e.Graphics, Color.Firebrick, new Rectangle(((ImageBox)sender).GetImageViewPort().Location, ((ImageBox)sender).GetSourceImageRegion().Size));
    }

    private void lastPageToolStripButton_Click(object sender, EventArgs e)
    {
      pdfImageBox.LastPage();
    }

    private void MainForm_Load(object sender, EventArgs e)
    {
     // propertyGrid.SelectedGridItem.Expanded = true;                                      // expand the default property
      
      //this.OpenPDF(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "sample.pdf"));    // open a sample document

        if(this.Document != null)
        {
            this.pnlAvis.Visible = false;
            this.OpenPDF(Document.PDFFilePath);

            txtCostCenter.Text = Document.CostCenter;
            txtDate.Text = Document.DocumentDate;
            txtInvoiceNumber.Text = Document.InvoiceNumber;
            txtOrderNumber.Text = Document.OrderNumber;
            txtSAPNumber.Text = Document.SAPNumber;
            txtSummeNetto.Text = Document.SummeNetto;

            switch(Document.OCRRecognition)
            {
                case OCRStatus.Good:
                    lblOCRStatus.Text = "Good";
                    lblOCRStatus.ForeColor = Color.DarkGreen;
                    break;
                case OCRStatus.FieldError:
                    lblOCRStatus.Text = "Field Error";
                    lblOCRStatus.ForeColor = Color.DarkOrange;
                    break;
                case OCRStatus.FatalError:
                    lblOCRStatus.Text = "OCR Failed";
                    lblOCRStatus.ForeColor = Color.Red;
                    break;
            }

            lblPDFName.Text = Path.GetFileName(Document.PDFFilePath);

            pdfImageBox.ZoomIn();

            this.UpdateUI();

           
        }
        if(this.AvisDocument != null)
        {
            this.pnlAvis.Visible = true;
            this.OpenPDF(AvisDocument.PDFFilePath);
            lblAvisDocumentName.Text = Path.GetFileName(AvisDocument.PDFFilePath);
            txtAvisNumber.Text = AvisDocument.AvisNumber;
            dgAvisTable.DataSource = AvisDocument.AvisTable;
            this.UpdateUI();
        }

    }

    private void nextPageToolStripButton_Click(object sender, EventArgs e)
    {
      pdfImageBox.NextPage();
    }

    private void openPDFToolStripMenuItem_Click(object sender, EventArgs e)
    {
      if (openPdfFileDialog.ShowDialog(this) == System.Windows.Forms.DialogResult.OK)
        this.OpenPDF(openPdfFileDialog.FileName);
    }

    private void pageToolStripTextBox_KeyPress(object sender, KeyPressEventArgs e)
    {
      if (e.KeyChar == '\r')
      {
        int pageNumber;

        e.Handled = true;

        if (int.TryParse(pageToolStripTextBox.Text, out pageNumber) && pageNumber > 0 && pageNumber <= pdfImageBox.PageCount)
          pdfImageBox.CurrentPage = pageNumber;
        else
          pageToolStripTextBox.Text = pdfImageBox.CurrentPage.ToString();
      }
    }

    private void pdfImageBox_LoadedPage(object sender, EventArgs e)
    {
      toolStripStatusLabel.Text = string.Empty;
      Cursor.Current = Cursors.Default;
    }

    private void pdfImageBox_LoadingPage(object sender, EventArgs e)
    {
      toolStripStatusLabel.Text = "Loading page...";
      Cursor.Current = Cursors.WaitCursor;
      statusStrip.Refresh();// Running on same thread, so need to force a refresh
    }

    private void previousPageToolStripButton_Click(object sender, EventArgs e)
    {
      pdfImageBox.PreviousPage();
    }

    private void showImageRegionToolStripButton_Click(object sender, EventArgs e)
    {
      pdfImageBox.Invalidate();
    }

    private void sizeToFitToolStripButton_Click(object sender, EventArgs e)
    {
      pdfImageBox.SizeToFit = true;
    }

    private void zoomInToolStripButton_Click(object sender, EventArgs e)
    {
      pdfImageBox.ZoomIn();
    }

    private void zoomOutToolStripButton_Click(object sender, EventArgs e)
    {
      pdfImageBox.ZoomOut();
    }

  #endregion  Event Handlers  

  #region  Private Methods  

    private void DrawBox(Graphics graphics, Color color, Rectangle rectangle)
    {
      int offset;
      int penWidth;

      offset = 9;
      penWidth = 2;

      using (SolidBrush brush = new SolidBrush(Color.FromArgb(64, color)))
        graphics.FillRectangle(brush, rectangle);

      using (Pen pen = new Pen(color, penWidth))
      {
        pen.DashStyle = DashStyle.Dot;
        graphics.DrawLine(pen, rectangle.Left, rectangle.Top - offset, rectangle.Left, rectangle.Bottom + offset);
        graphics.DrawLine(pen, rectangle.Left + rectangle.Width, rectangle.Top - offset, rectangle.Left + rectangle.Width, rectangle.Bottom + offset);
        graphics.DrawLine(pen, rectangle.Left - offset, rectangle.Top, rectangle.Right + offset, rectangle.Top);
        graphics.DrawLine(pen, rectangle.Left - offset, rectangle.Bottom, rectangle.Right + offset, rectangle.Bottom);
      }
    }

    private void OpenPDF(string fileName)
    {
      pdfImageBox.OpenPDF(fileName, string.Empty);
      pageCountToolStripLabel.Text = " of " + pdfImageBox.PageCount.ToString();
      this.UpdateUI();
    }

    private void UpdateUI()
    {
      positionToolStripStatusLabel.Text = pdfImageBox.AutoScrollPosition.ToString();
      imageSizeToolStripStatusLabel.Text = pdfImageBox.GetImageViewPort().ToString();
      zoomToolStripStatusLabel.Text = string.Format("{0}%", pdfImageBox.Zoom);

      firstPageToolStripButton.Enabled = pdfImageBox.CanMoveFirst;
      previousPageToolStripButton.Enabled = pdfImageBox.CanMovePrevious;
      nextPageToolStripButton.Enabled = pdfImageBox.CanMoveNext;
      lastPageToolStripButton.Enabled = pdfImageBox.CanMoveLast;
      pageToolStripTextBox.Text = pdfImageBox.CurrentPage.ToString();

      sizeToFitToolStripButton.Checked = pdfImageBox.SizeToFit;
      actualSizeToolStripButton.Checked = (pdfImageBox.Zoom == 100);
    }

    private void UpdateUIHandler(object sender, EventArgs e)
    {
      this.UpdateUI();
    }

    private void UpdateUIHandler(object sender, ScrollEventArgs e)
    {
      this.UpdateUI();
    }

  #endregion  Private Methods  

    private GutschriftDocumentModel Document
    {
        get;
        set;
    }

    private AvisDocumentModel AvisDocument
    {
        get;
        set;
    }

      public void setDocument(GutschriftDocumentModel model)
      {
          this.Document = model;

      }

      public void setAvisDocument(AvisDocumentModel model)
      {
          this.AvisDocument = model;

      }

      private void cmdCancel_Click(object sender, EventArgs e)
      {
          if (MessageBox.Show("Eingabe verwerfen?", "Confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
          {
              this.Close();
          }
      }

      private void cmdSave_Click(object sender, EventArgs e)
      {
          //TODO: Save to DB;

          this.Close();
      }

      private void cmdAvisSave_Click(object sender, EventArgs e)
      {
          //TODO: Save to DB;

          this.Close();
      }

      private void cmdAvisCancel_Click(object sender, EventArgs e)
      {
          if (MessageBox.Show("Eingabe verwerfen?", "Confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
          {
              this.Close();
          }
      }
  }
}
