﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;


namespace NilaOCR
{
    public partial class frmIBLBuchung : Form
    {
        AccessDbConnector con;
        int id = -1;
        DateTime? invoiceDate = null;
        public frmIBLBuchung()
        {
            InitializeComponent();
            OCRSettings.LoadSettings();
            con = new AccessDbConnector();
            con.ConnectToDatabase();
        }

        private void cmdCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void frmIBLBuchung_Load(object sender, EventArgs e)
        {
            cmbInvoiceNumber.DataSource = con.getUniqueInvoiceNumbers();
            cmbCostCenterFrom.DataSource = OCRSettings.settings.CostCenters;
            cmbCostCenterTo.DataSource = new ArrayList(OCRSettings.settings.CostCenters);

            cmbCostCenterFrom.SelectedIndex = -1;
            cmbCostCenterTo.SelectedIndex = -1;
            cmbInvoiceNumber.SelectedIndex = -1;
        }

        private void cmbInvoiceNumber_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cmbInvoiceNumber.Text.Trim().Equals("") || cmbInvoiceNumber.Text.Trim().Length != OCRSettings.settings.numDigitsInvoice)
            {
                id = -1;
                ClearControls();
            }
            else
            {
                DataTable tbl = con.getIBLBookingByRechnungsNummer(cmbInvoiceNumber.Text.Trim());
                if(tbl.Rows.Count > 0)
                {
                    DataRow row = tbl.Rows[0];
                    id = (int)row["ID"];
                    SetCostCenterFrom(row["SchuldnerKS"].ToString());
                    SetCostCenterTo(row["EmpfaengerKS"].ToString());
                    txtNetSum.Text = row["Amount"].ToString();
                }
                else
                {
                    tbl = con.getInvoiceByNumber(cmbInvoiceNumber.Text.Trim());
                    if (tbl.Rows.Count > 0)
                    {
                        DataRow row = tbl.Rows[0];
                        invoiceDate = row["Datum"] as DateTime?;
                        //SetCostCenterFrom(row["Kostenstelle"].ToString());
                    }
                    cmbCostCenterFrom.SelectedIndex = -1;
                    cmbCostCenterTo.SelectedIndex = -1;
                    txtNetSum.Text = "";
                }

            }
        }

        private void SetCostCenterFrom(string cc)
        {
            int i = 0;
            if (cmbCostCenterFrom.DataSource != null)
            {
                foreach (String item in (ArrayList)cmbCostCenterFrom.DataSource)
                {
                    if (item.ToString().Equals(cc))
                    {
                        cmbCostCenterFrom.SelectedIndex = i;
                    }
                    i++;
                }
            }
        }

        private void SetCostCenterTo(string cc)
        {
            int i = 0;
            if (cmbCostCenterTo.DataSource != null)
            {
                foreach (String item in (ArrayList)cmbCostCenterTo.DataSource)
                {
                    if (item.ToString().Equals(cc))
                    {
                        cmbCostCenterTo.SelectedIndex = i;
                    }
                    i++;
                }
            }
        }

        private void ClearControls()
        {
            cmbCostCenterFrom.SelectedIndex = -1;
            cmbCostCenterTo.SelectedIndex = -1;
            txtNetSum.Text = "";
        }

        private void cmdSave_Click(object sender, EventArgs e)
        {
            if(ValidateAll())
            {
                double sum = 0.0;
                double.TryParse(txtNetSum.Text.Trim(), System.Globalization.NumberStyles.Any, CultureInfo.CurrentUICulture, out sum);
               con.updateIBLBooking( id,cmbInvoiceNumber.Text.Trim(),  int.Parse(cmbCostCenterFrom.SelectedItem.ToString()), int.Parse(cmbCostCenterTo.SelectedItem.ToString()),  sum, invoiceDate);
               MessageBox.Show("IBL erfolgreich gebucht.", "Info");
               this.Close();
            }
        }

        private bool ValidateAll()
        {
            if (cmbInvoiceNumber.Text.Trim().Equals("") || (cmbInvoiceNumber.Text.Trim().Length != OCRSettings.settings.numDigitsInvoice && cmbInvoiceNumber.Text.Trim().Length != OCRSettings.settings.numDigitsNewInvoice))
            {
                MessageBox.Show("Ungültige Rechnungsnummer.", "Error");
                cmbInvoiceNumber.Focus();
                return false;
            }
            else 
            {
                DataTable tbl = con.getInvoiceByNumber(cmbInvoiceNumber.Text.Trim());
                if(tbl == null || tbl.Rows.Count == 0)
                {
                    MessageBox.Show("Rechnungsnummer '" + cmbInvoiceNumber.Text.Trim() + "' existiert nicht in Datenbank.", "Error");
                    cmbInvoiceNumber.Focus();
                    return false;
                }
                else
                {
                    DataRow row = tbl.Rows[0];
                    invoiceDate = row["Datum"] as DateTime?;
                }
            }
            if(cmbCostCenterFrom.SelectedIndex < 0)
            {
                MessageBox.Show("Ungültige Kostenstelle.", "Error");
                cmbCostCenterFrom.Focus();
                return false;
            }

            if(cmbCostCenterTo.SelectedIndex < 0)
            {
                MessageBox.Show("Ungültige Kostenstelle.", "Error");
                cmbCostCenterTo.Focus();
                return false;
            }
            double sum = 0;
            if(txtNetSum.Text.Trim().Equals("") || !double.TryParse(txtNetSum.Text.Trim(),System.Globalization.NumberStyles.Any,CultureInfo.CurrentUICulture,out sum))
            {
                MessageBox.Show("ungültige Nettosumme.", "Error");
                txtNetSum.Focus();
                return false;
            }
            return true;
        }

        private void cmbCostCenterFrom_SelectedIndexChanged(object sender, EventArgs e)
        {

        }
    }
}
