﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NilaOCR
{
    public partial class frmKontauszugAvis : Form
    {
        bool dirty = false;
        AccessDbConnector con;
        public frmKontauszugAvis()
        {
            InitializeComponent();
            OCRSettings.LoadSettings();
            con = new AccessDbConnector();
            con.ConnectToDatabase();
        }

        private void cmdClose_Click(object sender, EventArgs e)
        {
            if(dirty)
            {
                if (MessageBox.Show("Änderungen verwerfen?", "confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == System.Windows.Forms.DialogResult.Yes)
                {
                    this.Close();
                }
            }
        }

        private void frmAvisEdit_Load(object sender, EventArgs e)
        {
            cmbAvisNumber.DataSource = con.getUniqueAvisNumbers();
        }

        private void cmbAvisNumber_SelectedIndexChanged(object sender, EventArgs e)
        {
             string sel = cmbAvisNumber.SelectedItem.ToString();
           
        }

       

        private void dtAvisDate_ValueChanged(object sender, EventArgs e)
        {
            dirty = true;
        }

        private void cmdSave_Click(object sender, EventArgs e)
        {
            if (ValidateAll())
            {
                
                    DateTime date = dtAvisDate.Value;
                    con.UpdateKontauszug(date, cmbAvisNumber.SelectedItem.ToString());
                    MessageBox.Show("Werte erfolgreich ugedated.", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    dirty = false;

            }
        }

        private bool ValidateAll()
        {
            bool result = true;
            if(cmbAvisNumber.SelectedItem.ToString().Equals(""))
            {
                MessageBox.Show("Bitte eine Avisnummer auswählen.");
                return false;
            }
            return result;
        }
    }
}
