﻿using Cyotek.GhostScript.PdfConversion;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Tesseract;

namespace NilaOCR
{
    public partial class frmProcess : Form
    {
        public frmProcess()
        {
            InitializeComponent();
        }

        private void cmdBrowse_Click(object sender, EventArgs e)
        {
            if(dlgFolderBrowse.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                txtPDFPath.Text = dlgFolderBrowse.SelectedPath;
            }
        }

        private void cmdProcess_Click(object sender, EventArgs e)
        {
            bool Gutschrift = rdGutschrift.Checked;

            if(!Directory.Exists(txtPDFPath.Text))
            {
                MessageBox.Show("Der gewählte Ordner '" + txtPDFPath.Text + "' existiert nicht .", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }


            string[] pdfFfiles = Directory.GetFiles(txtPDFPath.Text, "*.pdf");
            if(pdfFfiles.Length == 0)
            {
                MessageBox.Show("Kein PDF im spezifizierten Ordner gefunden '" + txtPDFPath.Text + "'.", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            string outpath = frmMain.settings.tempPath + "ocr\\";

            foreach(string pdfpath in pdfFfiles)
            {
                string pdfname = Path.GetFileName(pdfpath);
                string pdfnamewithoutextension = Path.GetFileNameWithoutExtension(pdfpath);

                string outfolderpath = outpath + pdfnamewithoutextension;

                if(Directory.Exists(outfolderpath))
                {
                    Directory.Delete(outfolderpath, true);
                }

                Directory.CreateDirectory(outfolderpath);

                Pdf2Image pdfimage = new Pdf2Image(pdfpath);
                int numPages = pdfimage.PageCount;

                // TODO: if the document type is Gutschrift and if the number of pages is 0 or > 1 then log it as an error.
                
                if(Gutschrift)
                {
                    if (numPages == 1)
                    {
                        string outputimagename = outfolderpath + "\\" + pdfnamewithoutextension + ".png";
                        pdfimage.ConvertPdfPageToImage(outputimagename, 1);

                        if (File.Exists(outputimagename))
                        {
                            using (var engine = new TesseractEngine(@"tessdata", "eng", EngineMode.Default))
                            {
                                using (var img = Pix.LoadFromFile(outputimagename))
                                {

                                    var i = 1;
                                    String bestellnumber = "";
                                    using (var page = engine.Process(img))
                                    {
                                        String text = page.GetText();
                                        text = CleanText(text);
                                        string bestell = GetBestellNumber(text);
                                        string rechnungsnumber = "";
                                        string rechnungsdatum = "";

                                        if (bestell != null)
                                        {
                                            string[] tokens = bestell.Trim().Split(":;".ToCharArray());
                                            if (tokens.Length == 2)
                                            {
                                                if (trimInner(tokens[1]).Length == frmMain.settings.numDigitsOrder)
                                                {
                                                    bestellnumber = trimInner(tokens[1]);
                                                }

                                            }
                                        }

                                        string rechnungs = GetRechnungsNumber(text);
                                        if (rechnungs != null)
                                        {
                                            string[] tokens = rechnungs.Trim().Split(":;".ToCharArray());
                                            if (tokens.Length == 2)
                                            {
                                                if (trimInner(tokens[1]).Length == frmMain.settings.numDigitsInvoice)
                                                {
                                                    rechnungsnumber = trimInner(tokens[1]);
                                                }

                                            }
                                        }

                                        string rechnungsdate = GetRechnungsDatum(text);
                                        if (rechnungsdate != null)
                                        {
                                            string[] tokens = rechnungsdate.Trim().Split(":;".ToCharArray());
                                            if (tokens.Length == 2)
                                            {
                                                //if (trimInner(tokens[1]).Length == frmMain.settings.num)
                                                //{
                                                rechnungsdatum = tokens[1];
                                                //}

                                            }
                                        }

                                        string sap = GetSAPNumber(text);
                                        string[] saplines = sap.Split("\n".ToCharArray());
                                        string sapnumber = "";
                                        string costcenter = "";
                                        string summenetto = "";
                                        if (saplines.Length >= 3)
                                        {
                                            string[] tokens = saplines[1].Split(" ".ToCharArray());
                                            if (tokens[0].Trim().Length == frmMain.settings.numDigitsSAP)
                                            {
                                                sapnumber = tokens[0].Trim();
                                            }

                                            tokens = saplines[2].Split("-—".ToCharArray());
                                            if (trimInner(tokens[0]).Length == frmMain.settings.numDigitsCostCenter)
                                            {
                                                costcenter = trimInner(tokens[0]);
                                            }
                                            else
                                            {
                                                tokens = saplines[3].Split("-—".ToCharArray());
                                                if (trimInner(tokens[0]).Length == frmMain.settings.numDigitsCostCenter)
                                                {
                                                    costcenter = trimInner(tokens[0]);
                                                }
                                                else
                                                {
                                                    tokens = saplines[4].Split("-—".ToCharArray());
                                                    if (trimInner(tokens[0]).Length == frmMain.settings.numDigitsCostCenter)
                                                    {
                                                        costcenter = trimInner(tokens[0]);
                                                    }
                                                }
                                            }
                                        }

                                        string sum = GetSummeNetto(text);

                                        if (sum != null)
                                        {
                                            string[] tokens = sum.Split(" ".ToCharArray());
                                            summenetto = tokens[tokens.Length - 1];
                                        }

                                        /*string msg = "Order Number:" + bestellnumber + "\n" +
                                                     "Invoice Number:" + rechnungsnumber + "\n" +
                                                     "Date:" + rechnungsdatum + "\n" +
                                                     "SAP:" + sapnumber + "\n" +
                                                     "Cost Center:" + costcenter + "\n" +
                                                        "Summe Netto:" + summenetto + "\n";
                                        MessageBox.Show(msg, pdfnamewithoutextension);*/

                                       /* GutschriftDocumentModel model = new GutschriftDocumentModel(pdfpath, OCRStatus.Good, bestellnumber, rechnungsnumber, rechnungsdatum, sapnumber, costcenter, summenetto);

                                        frmGutschriftReview reviewForm = new frmGutschriftReview();
                                        reviewForm.setDocument(model);

                                        reviewForm.ShowDialog();*/

                                        string textpath = outfolderpath + "\\" + pdfnamewithoutextension + ".txt";
                                        File.WriteAllText(textpath, text);
                                    }
                                }
                            }
                        }
                        else
                        {
                            // TODO: something weird happened, mark this document as fatal error
                        }
                    }
                    else
                    {
                        // TODO: Gutschrift document has more than 1 page. report error
                    }
                }
                else
                {
                    // Process Avis Document
                    string avisnumber = "";
                    DataTable avisTable = new DataTable("avis");
                    avisTable.Columns.Add("invoicenumber");
                    avisTable.Columns.Add("amount");
                    avisTable.Columns.Add("pagenumber");
                    for(int i=0;i<numPages;i++)
                    {
                        string outputimagename = outfolderpath + "\\" + pdfnamewithoutextension + "_Page" + (i+1) + ".png";
                        pdfimage.ConvertPdfPageToImage(outputimagename, i+1);
                        if (File.Exists(outputimagename))
                        {
                            using (var engine = new TesseractEngine(@"tessdata", "eng", EngineMode.Default))
                            {
                                using (var img = Pix.LoadFromFile(outputimagename))
                                {
                                    using (var page = engine.Process(img))
                                    {
                                        String text = page.GetText();
                                        text = CleanText(text);

                                        if (avisnumber.Equals(""))
                                        {
                                            string belegnr = GetBelegNumber(text);

                                            if (belegnr != null)
                                            {
                                                string[] tokens = belegnr.Split(" ".ToCharArray());
                                                if (tokens.Length > 1)
                                                {
                                                    if (trimInner(tokens[1]).Length == frmMain.settings.numDigitsAvis)
                                                    {
                                                        avisnumber = tokens[1];
                                                    }
                                                }
                                            }
                                        }


                                        using(StringReader reader = new StringReader(text))
                                        {
                                            String line = String.Empty;
                                            string[] parray = {"beleg ihr","beleg 1hr"};
                                            do
                                            {
                                                line = reader.ReadLine();
                                                if (line == null)
                                                    break;
                                                line = line.ToLowerInvariant();
                                                int index = findIndexOf(parray,line);
                                                if(index >= 0)
                                                {
                                                    line = reader.ReadLine();
                                                    bool started = false;
                                                    while(line != null)
                                                    {
                                                        string[] tokens = line.Split(" ".ToCharArray());
                                                        if(tokens.Length >= 6)
                                                        {
                                                            started = true;
                                                            if (trimInner(tokens[0]).Length == frmMain.settings.numDigitsInvoice)
                                                            {
                                                                DataRow row = avisTable.NewRow();
                                                                row["invoicenumber"] = trimInner(tokens[0]);
                                                                row["amount"] = trimInner(tokens[4]);
                                                                row["pagenumber"] = (i + 1);
                                                                avisTable.Rows.Add(row);
                                                            }
                                                        }
                                                        line = reader.ReadLine();
                                                        if(line!=null && line.Contains("Übertrag") && started)
                                                        {
                                                            break;
                                                        }
                                                    }
                                                }

                                            } while (line != null);
                                        }
                                        
                                        string textpath = outfolderpath + "\\" + pdfnamewithoutextension + "_Page" + (i + 1) + ".txt";
                                        File.WriteAllText(textpath, text);
                                    }
                                }
                            }
                        }
                    }

                    //AvisDocumentModel model = new AvisDocumentModel(pdfpath, OCRStatus.Good, avisnumber, avisTable);
                    //frmGutschriftReview review = new frmGutschriftReview();
                    //review.setAvisDocument(model);
                    //review.ShowDialog();
                }

            }

            MessageBox.Show("Process Completed.");

        }

        private string GetBelegNumber(string text)
        {
            String lcase = text.ToLowerInvariant();
            string[] parray = { "beleg—nr", "beleg-nr", "be1eg—nr", "be1eg-nr" };
            int index = findIndexOf(parray, lcase);
            if (index >= 0)
            {
                string line = "";
                while (index < lcase.Length)
                {
                    String ch = lcase.Substring(index++, 1);
                    if (ch == Environment.NewLine || ch.Equals("\n"))
                    {
                        return line;
                    }
                    line += ch;
                }
                return line;
            }

            return null;
        }

        private string GetSummeNetto(string text)
        {
            String lcase = text.ToLowerInvariant();
            string[] parray = { "summe netto", "summe nett0" };
            lcase = CleanText(lcase);

            int index = findIndexOf(parray, lcase);
            if(index >= 0)
            {
                string line = "";
                while (index < lcase.Length)
                {
                    String ch = lcase.Substring(index++, 1);
                    if (ch == Environment.NewLine || ch.Equals("\n"))
                    {
                        return line;
                    }
                    line += ch;
                }
                return line;
            }

            return null;
        }

        private string CleanText(string text)
        {
            string result = text;
            while(result.IndexOf("\n\n") >=0)
            {
                result = result.Replace("\n\n", "\n");
            }
            // double space to single space
            while (result.IndexOf("  ") >= 0)
            {
                result = result.Replace("  ", " ");
            }
            return result.Trim();
        }

        private string trimInner(string text)
        {
            text = text.Trim();
            string result = "";
            foreach(char ch in text.ToCharArray())
            {
                if(!ch.Equals(' '))
                {
                    result += ch;
                }
            }
            return result;
        }

        private string GetSAPNumber(string text)
        {
            String lcase = text.ToLowerInvariant();
            string[] parray = { "blatt", "b1att", "biatt" };
           // if (lcase.Contains("blatt") || lcase.Contains("b1att"))
           // {
            int index = findIndexOf(parray, lcase); //lcase.IndexOf("blatt");
            if (index >= 0)
            {
                string line = "";
                int lcount = 0;
                while (index < lcase.Length)
                {
                    String ch = lcase.Substring(index++, 1);
                    if (ch == Environment.NewLine || ch.Equals("\n"))
                    {
                        if (lcount == 4)
                            return line;
                        lcount++;
                    }
                    line += ch;
                }
                return line;
            }
           // }
            return null;
        }

        private string GetRechnungsNumber(string text)
        {
            String lcase = text.ToLowerInvariant();
            string[] parray = { "rechnungs-", "rechnungs—", "rechnungsn" };

            //if (lcase.Contains("rechnungs-") || lcase.Contains("rechnungs—"))
            //{
            int index = findIndexOf(parray, lcase); //lcase.IndexOf("rechnungs-");
            if (index >= 0)
            {
                string line = "";
                while (index < lcase.Length)
                {
                    String ch = lcase.Substring(index++, 1);
                    if (ch == Environment.NewLine || ch.Equals("\n"))
                    {
                        return line;
                    }
                    line += ch;
                }
                return line;
            }
            //}
            return null;
        }

        private int findIndexOf(string[] parray, string text)
        {
            foreach(string word in parray)
            {
                if (text.Contains(word))
                    return text.IndexOf(word);
            }
            return -1;
        }

        private string GetRechnungsDatum(string text)
        {
            String lcase = text.ToLowerInvariant();
            if (lcase.Contains("rechnungsda"))
            {
                int index = lcase.IndexOf("rechnungsda");
                string line = "";
                while (index < lcase.Length)
                {
                    String ch = lcase.Substring(index++, 1);
                    if (ch == Environment.NewLine || ch.Equals("\n"))
                    {
                        return line;
                    }
                    line += ch;
                }
                return line;
            }
            return null;
        }

        private string GetBestellNumber(string text)
        {
            String lcase = text.ToLowerInvariant();
            string[] parray = { "besten", "besteii", "besteli", "besteil", "beste1l", "beste11", "bestel1", "bestei1", "beste1i", "bestell" };
           // if(lcase.Contains("bestell"))
          //  {
            int index = findIndexOf(parray, lcase); //lcase.IndexOf("bestell");
                string line = "";
                while(index < lcase.Length)
                {
                    String ch = lcase.Substring(index++, 1);
                    if(ch == Environment.NewLine || ch.Equals("\n"))
                    {
                        if(line.Contains(":") || line.Contains(";"))
                            return line.Trim();
                        else
                        {                           
                                return null;
                        }
                    }
                    line += ch;
                }
                return line;
           // }
            return null;
        }

        private void cmdCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
