﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace NilaOCR
{
    public partial class frmReportVariance : Form
    {
        AccessDbConnector con;
        public frmReportVariance()
        {
            InitializeComponent();
            OCRSettings.LoadSettings();
            con = new AccessDbConnector();
            con.ConnectToDatabase();
        }

        private void cmdCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void frmReportVariance_Load(object sender, EventArgs e)
        {
            DataTable result = con.getInvoiceBookingVariance();
            if (result.Rows.Count > 0)
            {
                dgVariance.DataSource = result;
            }
        }

        private void cmdGenerate_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog fldOutputPath = new FolderBrowserDialog();
            if (fldOutputPath.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                string path = fldOutputPath.SelectedPath + "\\Vergleich_Avis-Gutschrift.txt";
                DataTable tbl = dgVariance.DataSource as DataTable;
                using (StreamWriter writer = File.CreateText(path))
                {
                    string line = "";
                    foreach (DataColumn col in tbl.Columns)
                    {
                        line += col.ColumnName + "\t";
                    }
                    writer.WriteLine(line.Trim("\t ".ToCharArray()));
                    foreach (DataRow row in tbl.Rows)
                    {
                        line = "";
                        foreach (DataColumn col in tbl.Columns)
                        {
                            if (col.ColumnName.Equals("Datum"))
                                line += ((DateTime) row[col]).ToString("dd.MM.yyyy") + "\t";
                            else
                                line += row[col].ToString() + "\t";
                        }
                        writer.WriteLine(line.Trim("\t ".ToCharArray()));
                    }
                    writer.Flush();

                    MessageBox.Show("Report Erzeugung abgeschlossen");
                    this.Close();
                }
            }
        }
    }
}
