<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\GanttTask;
use Illuminate\Support\Facades\Auth; // make sure this is at the top

use App\Models\GanttLink;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Models\User;
use App\Models\Customer;
use Illuminate\Support\Facades\Validator;

use App\Models\Project; 
class GanttController extends Controller
{
    public function index()
    {
        return view('gantt');
    }

    
    public function getData()
    {
        $projects = Project::with('gantt_tasks')->get();
    
        $ganttData = []; // Initialize an empty array to store task data
    
        foreach ($projects as $project) {
            foreach ($project->gantt_tasks ?? [] as $task) {
                // Append task data to the $ganttData array
                $ganttData[] = [
                    'id' => $task['id'],
                    'text' => $task['project_name'],
                    'start_date' => $task['start_date'], 
                    'end_date' => $task['end_date'], 
                    'progress' => $task['progress'] ?? 0,
                    'parent' => $task['parent'] ?? 0, // Handle parent-child relationships
                    'task_count' => $task['task_count'],
                    'status' => $task['status'],
                ];
            }
        }
    
        Log::info(json_encode($ganttData)); // Log the $ganttData for debugging
    
        // Return the view with the formatted ganttData
        return view('gantt', [
            'ganttData' => $ganttData
        ]);
    }
    
    
public function save(Request $request)
{
    $action = $request->input('!nativeeditor_status'); // inserted, updated, deleted
    $id = $request->input('id');
    $text = $request->input('text');
    $start_date = Carbon::createFromFormat('d-m-Y', $request->input('start_date'))->format('Y-m-d');
    $duration = $request->input('duration');
    $parent = $request->input('parent');
    $end_date = Carbon::parse($start_date)->addDays($duration)->format('Y-m-d');

    $response = ["action" => $action, "tid" => $id];

    try {
        if ($action === "inserted") {
            $newId = DB::table('task')->insertGetId([
                'task_name'   => $text,
                'start_date'  => $start_date,
                'end_date'    => $end_date,
                'duration'    => $duration,
                'parent'      => $parent,
                'status'      => 'new', // you can modify default
                'active'      => 1,
                'created_at'  => now(),
                'updated_at'  => now(),
            ]);
            $response["tid"] = $newId;

        } elseif ($action === "updated") {
            DB::table('task')->where('id', $id)->update([
                'task_name'   => $text,
                'start_date'  => $start_date,
                'end_date'    => $end_date,
                'duration'    => $duration,
                'parent'      => $parent,
                'updated_at'  => now(),
            ]);

        } elseif ($action === "deleted") {
            DB::table('task')->where('id', $id)->delete();
        }
    } catch (\Exception $e) {
        return response()->json(["action" => "error", "message" => $e->getMessage()]);
    }

    return response()->json($response);
}

//     public function store(Request $request)
//     {
//     $task = GanttTask::create([
//         'text' => $request->text,
//         'start_date' => $request->start_date,
//         'duration' => $request->duration,
//         'progress' => $request->progress,
//         'parent' => $request->parent,
//         'project_name' => $request->project_name,  // Added fields
//         'project_code' => $request->project_code,
//         'task_count' => $request->task_count,
//         'status' => $request->status,
//         'customer_id' => $request->customer_id,
//         'project_type' => $request->project_type,
//         'section_id' => $request->section_id
//     ]);

//     return response()->json(['action' => 'inserted', 'tid' => $task->id]);
// }

 
// public function getProjects()
// {
//     $projects = Project::with('gantt_tasks')->get();

//     $ganttData = [];

//     foreach ($projects as $project) {
//         foreach ($project->gantt_tasks ?? [] as $task) {
//             // Ensure text is populated
//             $ganttData[] = [
//                 'id' => $task->id,
//                 'text' => $task->text ?? 'Task ' . $task->id,  // Default to "Task [ID]" if text is missing
//                 'start_date' => $task->start_date ? $task->start_date->toIso8601String() : null, // Ensure correct format
//                 'end_date' => $task->end_date ? $task->end_date->toIso8601String() : null,  // Ensure correct format
//                 'duration' => $task->start_date && $task->end_date ? $task->start_date->diffInDays($task->end_date) : 0, // Calculate duration in days
//                 'progress' => $task->progress ?? 0,
//                 'parent' => $task->parent ?? 0, // If there is a parent task
//                 'project_name' => $project->project_name,
//                 'project_code' => $project->project_code,
//                 'status' => $project->status,
//                 'task_count' => $project->task_count,
//                 'created_at' => $project->created_at,
//                 'updated_at' => $project->updated_at,
//             ];
//         }
//     }

//     Log::info(json_encode($ganttData));  // Log data for debugging

//     return view('gantt.index', compact('ganttData'));
// }


// public function getProjects()
// {
//     $projects = Project::with('gantt_tasks')->get();
//     $ganttData = [];

//     foreach ($projects as $project) {
//         foreach ($project->gantt_tasks ?? [] as $task) {
//             $start = $task->start_date ? Carbon::parse($task->start_date) : null;
//             $end = $task->end_date ? Carbon::parse($task->end_date) : null;

//             $start_date = $start?->toIso8601String();
//             $end_date = $end?->toIso8601String();
//             $duration = $start && $end ? $start->diffInDays($end) : 0;

//             $ganttData[] = [
//                 'id' => $task->id,
//                 'text' => $task->text ?? 'Task ' . $task->id,  
//                 'start_date' => $start_date,
//                 'end_date' => $end_date,
//                 'duration' => (int) $duration,
//                 'progress' => (float) ($task->progress ?? 0),
//                 'parent' => $task->parent ?? 0,
//                 'project_id' => $project->id,
//                 'project_name' => $project->project_name,
//                 'project_code' => $project->project_code,
//                 'status' => $project->status,
//                 'task_count' => $project->task_count,
//                 'created_at' => $project->created_at->toIso8601String(),
//                 'updated_at' => $project->updated_at->toIso8601String(),
//             ];
//         }
//     }

//     Log::info('Gantt Data: ' . json_encode($ganttData, JSON_PRETTY_PRINT));

//     return view('gantt.index', compact('ganttData'));
// }
public function getProjects()
{
    // $projects = Project::with('gantt_tasks')->get();
    $projects = Project::with(['gantt_tasks.user', 'customer', 'section'])->get();

    $ganttData = [];
    $users = User::all(); // Or add orderBy('name') if you want sorted names
        $customers = Customer::all(); // Or add orderBy('name') if you want sorted names
        $section =  DB::table('project_section')->get();
        // Or add orderBy('name') if you want sorted names
    
    foreach ($projects as $project) {
        $ganttData[] = [
            'id' => 'project_' . $project->id,
            'text' => $project->project_name,
         'start_date' => Carbon::parse($project->start_date)->format('Y-m-d H:i:s'),
'end_date' => Carbon::parse($project->end_date)->format('Y-m-d H:i:s'),
'duration' => Carbon::parse($project->start_date)->diffInDays(Carbon::parse($project->end_date)) + 1, // +1 to include both start and end days
            'progress' => 0,
            'parent' => 0,
            'open' => true,
    
            // Include extra fields
            //'section_type' => $project->section->section_type,
            'project_type' => $project->project_type == 0 ? 'Internal' : 'External',

            'project_code' => $project->project_code,
            'customer_id' => $project->customer_id,
            'customer_name' => $project->customer->customer_name ?? 'N/A',
        ];
    
        foreach ($project->gantt_tasks as $task) {
            $start = $task->start_date ? Carbon::parse($task->start_date) : null;
            $end = $task->end_date ? Carbon::parse($task->end_date) : null;
    
            $ganttData[] = [
                'id' => $task->id,
                'text' => $task->task_name ?? 'Task ' . $task->id,
                'start_date' => $start?->format('Y-m-d'),
                'end_date' => $end?->format('Y-m-d'),
                'duration' => $start && $end ? $start->diffInDays($end) : 1,
                'progress' => (float) ($task->progress ?? 0),
                'parent' => 'project_' . $project->id,
                'user_id' => $task->user_id,
                'project_code' => $task->project_task_code,
                'user_name' => $task->user->firstname ?? 'Unassigned',
            ];
        }
    }

    Log::info(json_encode($ganttData, JSON_PRETTY_PRINT));
    return view('gantt.indexbackup', compact('ganttData', 'projects','users','customers','section'));
}
public function generateProjectCode(Request $request)
{
    $sectionId = $request->section_id;

    // Get section type from project_section table
    $section = DB::table('project_section')->where('id', $sectionId)->first();
    if (!$section) {
        return response()->json(['error' => 'Invalid section'], 400);
    }

    // Generate prefix and date part
    $prefix = strtoupper(substr($section->section_type, 0, 3)); // e.g. "SOF", "EMB"
    $yearMonth = Carbon::now()->format('ym'); // e.g. "2504"
    $dateCode = "{$prefix}_{$yearMonth}_"; // e.g. "SOF_2504_"

    // Get highest suffix (last 4 digits) globally across all project_code values
    $lastNumber = DB::table('gantt_projects')
        ->select(DB::raw("MAX(CAST(RIGHT(project_code, 4) AS UNSIGNED)) AS max_code"))
        ->first();

    $nextNumber = $lastNumber && $lastNumber->max_code ? $lastNumber->max_code + 1 : 1;
    $formattedNumber = str_pad($nextNumber, 4, '0', STR_PAD_LEFT); // e.g. "0058"

    // Combine to generate new project code
    $newProjectCode = $dateCode . $formattedNumber;

    return response()->json(['project_code' => $newProjectCode]);
}
// public function updateGanttTask(Request $request)
// {
//     Log::info($request);
//     $data = $request->all();
    
//     // $task = GanttTask::find($data['id']);
    
//     // Extract the numeric part from 'project_2'
//     $projectid = str_replace('project_', '', $data['id']);

//     $task = GanttTask::find( $projectid);
//     if (!$task) {
//         return response()->json(['success' => false, 'message' => 'Task not found']);
//     }

//     // Update only allowed fields
        
//         $task->text = Arr::get($data, 'text');
//         $task->project_code = Arr::get($data, 'project_code');
//         $task->customer_name = Arr::get($data, 'customer_name');
//         $task->user_name = Arr::get($data, 'user_name'); // This won't throw an error if 'user_name' is missing
//         $task->start_date = Arr::get($data, 'start_date');
//         $task->duration = Arr::get($data, 'duration');
            
//             $task->save();

//     return response()->json(['success' => true]);
// }

public function updateGanttTask(Request $request)
{
    Log::info($request);
    $data = $request->all();

    $id = $data['id'];

    // Get user_id and customer_id from their respective names
    $user = User::where('firstname', $data['user_name'] ?? '')->first();
    Log::info($user."-------");
    $customer = Customer::where('customer_name', $data['customer_name'] ?? '')->first();

    $userId = $user ? $user->id : null;
    $customerId = $customer ? $customer->id : null;

    if (str_starts_with($id, 'project_')) {
        $projectId = str_replace('project_', '', $id);
        $project = Project::find($projectId);

        if (!$project) {
            return response()->json(['success' => false, 'message' => 'Project not found']);
        }

        // Update allowed project fields
        $project->project_name = Arr::get($data, 'text');
        $project->project_code = Arr::get($data, 'project_code');
        // $project->customer_name = Arr::get($data, 'customer_name');
        $project->customer_id = $customerId;
        // $project->user_name = Arr::get($data, 'user_name');
        // $project->user_id = $userId;
        $rawStartDate = Arr::get($data, 'start_date');
$formattedStartDate = $rawStartDate ? date('Y-m-d', strtotime($rawStartDate)) : null;

$project->start_date = $formattedStartDate;

$rawEndDate = Arr::get($data, 'end_date');
$formattedEndDate = $rawEndDate ? date('Y-m-d', strtotime($rawEndDate)) : null;

$project->start_date = $formattedStartDate;
$project->end_date = $formattedEndDate;
        // $project->start_date = Arr::get($data, 'start_date');
        $project->duration = Arr::get($data, 'duration');

        $project->save();
    } elseif (str_starts_with($id, 'task_')) {
        $taskId = str_replace('task_', '', $id);
        $task = GanttTask::find($taskId);

        if (!$task) {
            return response()->json(['success' => false, 'message' => 'Task not found']);
        }

        // Update allowed task fields
        $task->task_name = Arr::get($data, 'text');
        $task->project_task_code = Arr::get($data, 'project_code');
        $task->user_name = Arr::get($data, 'user_name');
        $task->user_id = $userId;
        // $task->start_date = Arr::get($data, 'start_date');
        $rawStartDate = Arr::get($data, 'start_date');
$formattedStartDate = $rawStartDate ? date('Y-m-d', strtotime($rawStartDate)) : null;

$project->start_date = $formattedStartDate;
        $task->duration = Arr::get($data, 'duration');

        $task->save();
    } else {
        return response()->json(['success' => false, 'message' => 'Invalid ID format']);
    }

    return response()->json(['success' => true]);
}

 
public function update(Request $request, $id)
{
    Log::info($request);
    Log::info($id);
    $data = $request->all();

    // $id = $data['id'];

    $user = User::where('firstname', $data['user_name'] ?? '')->first();
    Log::info($user."-------");
    $customer = Customer::where('customer_name', $data['customer_name'] ?? '')->first();

    $userId = $user ? $user->id : null;
    $customerId = $customer ? $customer->id : null;

    if (str_starts_with($id, 'project_')) {
        $projectId = str_replace('project_', '', $id);
        $project = Project::find($projectId);

        if (!$project) {
            return response()->json(['success' => false, 'message' => 'Project not found']);
        }

        // Update allowed project fields
        $project->project_name = Arr::get($data, 'text');
        $project->project_code = Arr::get($data, 'project_code');
        // $project->customer_name = Arr::get($data, 'customer_name');
        $project->customer_id = $customerId;
        // $project->user_name = Arr::get($data, 'user_name');
        // $project->user_id = $userId;
        $rawStartDate = Arr::get($data, 'start_date');
$formattedStartDate = $rawStartDate ? date('Y-m-d', strtotime($rawStartDate)) : null;

$project->start_date = $formattedStartDate;

$rawEndDate = Arr::get($data, 'end_date');
$formattedEndDate = $rawEndDate ? date('Y-m-d', strtotime($rawEndDate)) : null;

$project->start_date = $formattedStartDate;
$project->end_date = $formattedEndDate;
        // $project->start_date = Arr::get($data, 'start_date');
        // $project->duration = Arr::get($data, 'duration');

        $project->save();
    } elseif (str_starts_with($id, '')) {
        $taskId = str_replace('', '', $id);
        $task = GanttTask::find($taskId);

        if (!$task) {
            return response()->json(['success' => false, 'message' => 'Task not found']);
        }

        // Update allowed task fields
        $task->task_name = Arr::get($data, 'text');
        $task->project_task_code = Arr::get($data, 'project_code');
        // $task->user_name = Arr::get($data, 'user_name');
        $task->user_id = $userId;
        // $task->start_date = Arr::get($data, 'start_date');
        $rawStartDate = Arr::get($data, 'start_date');
        $formattedStartDate = $rawStartDate ? date('Y-m-d', strtotime($rawStartDate)) : null;
        
        $task->start_date = $formattedStartDate;
        
        $rawEndDate = Arr::get($data, 'end_date');
        $formattedEndDate = $rawEndDate ? date('Y-m-d', strtotime($rawEndDate)) : null;
        
        $task->start_date = $formattedStartDate;
        $task->end_date = $formattedEndDate;
        $task->duration = Arr::get($data, 'duration');

        $task->save();
    } else {
        return response()->json(['success' => false, 'message' => 'Invalid ID format']);
    }

    return response()->json(['success' => true]);
}

    public function destroy($id)
    {
        GanttTask::destroy($id);
        return response()->json(["action" => "deleted"]);
    }
    public function stores(Request $request)
    {
        // Validate inputs
        $validated = $request->validate([
            'project_name' => 'required|string|max:255',
            'project_code' => 'required|string|max:100',
            'customer_name' => 'required|string|max:255',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
        ]);

        // Save to DB
        Project::create($validated);

        return redirect()->back()->with('success', 'Project added successfully.');
    }
//     public function store(Request $request)
//     {
//         $task = GanttTask::create([
//                     'text' => $request->text,
//                     'start_date' => $request->start_date,
//                     'duration' => $request->duration,
//                     'progress' => $request->progress,
//                     'parent' => $request->parent,
//                     'project_name' => $request->project_name,  // Added fields
//                     'project_code' => $request->project_code,
//                     'task_count' => $request->task_count,
//                     'status' => $request->status,
//                     'customer_id' => $request->customer_id,
//                     'project_type' => $request->project_type,
//                     'section_id' => $request->section_id
//                 ]);
            
//                 return response()->json(['action' => 'inserted', 'tid' => $task->id]);
// }


public function store(Request $request)
{
    $validator = Validator::make($request->all(), [
        'project_name' => 'required|string|max:255',
        'project_code' => 'required|string|max:100',
        'task_count' => 'nullable|integer',
        'status' => 'nullable|integer|in:0,1',
        'active' => 'nullable|integer|in:0,1',
        'customer_id' => 'nullable|integer',
        'project_type' => 'nullable|string|max:100',
        'estimation_cost' => 'nullable|numeric',
        'taken_cost' => 'nullable|numeric',
        'start_date' => 'required|date',
        'end_date' => 'nullable|date|after_or_equal:start_date',
        'section_id' => 'nullable|integer',
        'created_by' => 'nullable|integer',
        'updated_by' => 'nullable|integer',
        'duration' => 'nullable|integer',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'success' => false,
            'errors' => $validator->errors()
        ], 422);
    }

    DB::table('gantt_projects')->insert([
        'project_name' => $request->project_name,
        'project_code' => $request->project_code,
        'task_count' => $request->task_count,
        'status' => 0,
        'active' => 0,
        'customer_id' => $request->customer_id,
        'project_type' => $request->project_type,
        'estimation_cost' => $request->estimation_cost ?? 0,
        'taken_cost' => $request->taken_cost ?? 0,
        'start_date' => $request->start_date,
        'end_date' => $request->end_date,
        'section_id' => $request->section_id,
        'created_by' => Auth::id(),
        'updated_by' =>Auth::id(),
        'duration' => $request->duration,
        'created_at' => now(),
        'updated_at' => now(),
    ]);

    return response()->json(['success' => true]);
}
public function taskstore(Request $request)
{
Log::info($request);
    $validator = Validator::make($request->all(), [
        'task_name' => 'required|string|max:255',
        'project_id' => 'required|string|max:100',
        'user_id' => 'required|integer',
        'status' => 'nullable|integer|in:0,1',
        'created_at' => 'nullable|integer|in:0,1',
        'updated_at' => 'nullable|integer',
        'duration' => 'nullable|string|max:100',
        'active' => 'nullable|numeric',
        'parent_id' => 'nullable|numeric',
        'start_date' => 'required|date',
        'end_date' => 'required|date|after_or_equal:start_date',
        'project_task_code' => 'nullable|integer',
       
    ]);

    if ($validator->fails()) {
        return response()->json([
            'success' => false,
            'errors' => $validator->errors()
        ], 422);
    }
    $proj_ic=$request->project_id;
    $project_code_id = $request->project_code;
    // Log::info($project_code_id."project_code_id");
    // $start_date = $request->start_date;
    $project = Project::where('id', $proj_ic)->first();
    Log::info($project."project");
    if ($project) {
        $project->task_count = $project->task_count + 1; 
        $project->save();
    }
    $taskCount=$project->task_count ;
    
if ($project) {
    // If task_count is null, treat as 0
    $currentTaskCount = $project->task_count ?? 0;

    // Increment task count
    $newTaskCount = $currentTaskCount + 1;
    $project->task_count = $newTaskCount;
    $project->save();
    DB::table('gantt_projects')
    ->where('id', $proj_ic)
    ->update(['task_count' => 1]);

    // Pad to 3 digits
    $subTaskCode = str_pad($newTaskCount, 3, '0', STR_PAD_LEFT);

    // Final project task code
    $projectTaskCode = $project_code_id . '_' . $subTaskCode;

    Log::info($projectTaskCode . " project_task_code");
}
    Log::info($projectTaskCode."projectTaskCode");
    DB::table('gantt_tasks')->insert([
        'task_name' => $request->task_name,
        'project_id' => $request->project_id,
        'user_id' => $request->user_id,
        'status' =>0,
       'created_at' => now(),
        'updated_at' => now(),
        'duration' => $request->project_type,
        'active' =>0,
        'parent_id' => $request->taken_cost ?? 0,
        'start_date' => $request->start_date,
        'end_date' => $request->end_date,
        'project_task_code' => $projectTaskCode,
       
        
    ]);

    return response()->json(['success' => true]);
}
public function getDetails($id)
{
    $project = Project::where('id', $id)->first(); // Adjust column if necessary

    if (!$project) {
        return response()->json(['error' => 'Project not found'], 404);
    }

    return response()->json([
        'code' => $project->project_code,
        'name' => $project->project_name,
        'id' => $project->id,
    ]);
}
// public function create() {
//     $users = User::all(); // Or add orderBy('name') if you want sorted names
//     return view('gantt.index', compact('users'));
// }
}
