<?php
namespace App\Models;
use App\Models\GanttTask;

use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    protected $table = 'gantt_projects'; 
    // public function gantt_tasks()
    // {
    //     return $this->hasMany(GanttTask::class, 'project_id');
    // }
    // App\Models\Project.php
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
    
    public function section()
    {
        return $this->belongsTo(ProjectSection::class, 'section_id');
    }
public function gantt_tasks()
{
    return $this->hasMany(Task::class, 'project_id');
}
protected $fillable = [
    'project_name',
    'project_code',
    'task_count',
    'start_date',
    'end_date',
    'duration',
    'status',
    'active',
    'customer_id',
    'project_type',
    'estimation_cost',
    'taken_cost',
    'section_id',
    'created_by',
    'updated_by',
];
}