<?php 
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTasksTable extends Migration
{
    public function up()
    {
        Schema::create('gantt_tasks', function (Blueprint $table) {
            $table->id();
            $table->string('text');
            $table->dateTime('start_date');
            $table->integer('duration');
            $table->float('progress')->default(0);
            $table->bigInteger('parent')->default(0);
        });

        Schema::create('gantt_links', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('source');
            $table->bigInteger('target');
            $table->string('type');
        });
    }

    public function down()
    {
        Schema::dropIfExists('gantt_links');
        Schema::dropIfExists('gantt_tasks');
    }
}
