<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddProjectColumnsToGanttTasksTable extends Migration
{
    public function up()
    {
        Schema::table('gantt_tasks', function (Blueprint $table) {
            $table->string('project_name')->nullable();
            $table->string('project_code')->nullable();
            $table->integer('task_count')->nullable();
            $table->string('status')->nullable();
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->string('project_type')->nullable();
            $table->unsignedBigInteger('section_id')->nullable();
        });
    }

    public function down()
    {
        Schema::table('gantt_tasks', function (Blueprint $table) {
            $table->dropColumn([
                'project_name', 
                'project_code', 
                'task_count', 
                'status', 
                'customer_id', 
                'project_type', 
                'section_id'
            ]);
        });
    }
}
