<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddProjectIdToGanttTasks extends Migration
{
    public function up()
    {
        Schema::table('gantt_tasks', function (Blueprint $table) {
            $table->unsignedBigInteger('project_id')->after('id'); // Ensure the column is added after the 'id' column

            // Add a foreign key constraint if needed
            $table->foreign('project_id')->references('id')->on('projects')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::table('gantt_tasks', function (Blueprint $table) {
            $table->dropForeign(['project_id']); // Drop the foreign key
            $table->dropColumn('project_id'); // Drop the column
        });
    }
}
