<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Project Gantt View</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- DHTMLX Gantt CSS -->
    <link rel="stylesheet" href="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.css">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            padding-top: 70px;
        }

        .navbar {
            position: fixed;
            top: 0;
            width: 100%;
            height: 60px;
            background-color: #2dce89;
            color: white;
            display: flex;
            align-items: center;
            padding: 0 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            z-index: 1030;
            justify-content: space-between;
        }

        .navbar h1 {
            margin: 0;
            font-size: 20px;
        }

        #gantt_here {
            width: 100%;
            height: calc(100vh - 150px);
            border: 1px solid #ccc;
            overflow: auto;
        }

        .gantt_tooltip {
            max-width: 300px;
            white-space: normal;
            word-wrap: break-word;
        }

        .modal-lg {
            max-width: 800px !important;
        }
    </style>
</head>
<body>

<div class="navbar">
    <h1>Project Gantt View</h1>
    <div class="dropdown">
        <a class="btn dropdown-toggle <?php echo e(Route::currentRouteName() == 'projectsessionview' || Route::currentRouteName() == 'projectcustomer' ? 'active' : ''); ?>"
           href="#" role="button" id="projectDropdown" data-bs-toggle="dropdown" aria-expanded="false"
           style="background-color:rgb(10, 10, 10); color: white;">
           Project Menu
        </a>
        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="projectDropdown">
            <li><a class="dropdown-item <?php echo e(Route::currentRouteName() == 'projectsessionview' ? 'active' : ''); ?>" href="<?php echo e(route('projectsessionview')); ?>">Project Section</a></li>
            <li><a class="dropdown-item <?php echo e(Route::currentRouteName() == 'projectcustomer' ? 'active' : ''); ?>" href="<?php echo e(route('projectcustomer')); ?>">Customer</a></li>
        </ul>
    </div>
</div>

<div class="d-flex justify-content-between align-items-center mb-3 mt-2 px-3">
    <div class="d-flex gap-2">
        <div class="dropdown">
            <button class="btn dropdown-toggle" style="background-color:rgb(2, 2, 2); color: white;" type="button" id="columnSelectorDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                Column Selector
            </button>
            <ul class="dropdown-menu p-3" aria-labelledby="columnSelectorDropdown" style="width: 250px;">
                <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="text" checked disabled> Task / Project Name</label></li>
                <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="project_code" checked> Project Code</label></li>
                <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="customer_name" checked> Customer Name</label></li>
                <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="user_name" checked> Assigned User Name</label></li>
                <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="start_date" checked> Start Date</label></li>
                <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="end_date" checked> End Date</label></li>
                <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="duration" checked> Duration</label></li>
                <li><hr class="dropdown-divider"></li>
                <li>
                    <button type="button" class="btn btn-sm btn-dark w-100" onclick="openAddProjectModal()">+ Add Project</button>
                </li>
                <li>
                    <button type="button" class="btn btn-sm btn-dark w-100" onclick="openAddtaskModal()">+ Add Task</button>
                </li>
            </ul>
        </div>

        <button onclick="exportGanttData()" class="btn" style="background-color:rgb(2, 2, 2); color: white;">Download Excel</button>
    </div>

    <div class="mb-3">
        <label for="scaleSelect" class="form-label"><strong>Select Time Scale:</strong></label>
        <select id="scaleSelect" class="form-select">
            <option value="week">Week</option>
            <option value="month">Month</option>
            <option value="day">Day</option>
        </select>
    </div>
</div>

<!-- Add Project Modal -->
<div class="modal fade" id="addProjectModal" tabindex="-1" aria-labelledby="addProjectModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg"> <!-- Larger modal -->
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addProjectModalLabel">Add New Project</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="addProjectForm">
          <?php echo csrf_field(); ?> <!-- CSRF token -->

          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Project Name</label>
              <input type="text" class="form-control" name="project_name" required>
            </div>

            <div class="col-md-6">
              <label class="form-label">Project Code</label>
              <input type="text" class="form-control" name="project_code" required>
            </div>

            <div class="col-md-6">
              <label class="form-label">Task Count</label>
              <input type="number" class="form-control" name="task_count" required>
            </div>

            <div class="col-md-6">
              <label class="form-label">Status</label>
              <select class="form-select" name="status" required>
                <option value="1">Active</option>
                <option value="0">Inactive</option>
              </select>
            </div>

            <div class="col-md-6">
              <label class="form-label">Active</label>
              <select class="form-select" name="active" required>
                <option value="1">Yes</option>
                <option value="0">No</option>
              </select>
            </div>

            <div class="col-md-6">
              <label class="form-label">Customer ID</label>
              <input type="number" class="form-control" name="customer_id">
            </div>

            <div class="col-md-6">
              <label class="form-label">Project Type</label>
              <input type="text" class="form-control" name="project_type">
            </div>

            <div class="col-md-6">
              <label class="form-label">Estimation Cost</label>
              <input type="number" class="form-control" name="estimation_cost" value="0">
            </div>

            <div class="col-md-6">
              <label class="form-label">Taken Cost</label>
              <input type="number" class="form-control" name="taken_cost" value="0">
            </div>

            <div class="col-md-6">
              <label class="form-label">Start Date</label>
              <input type="date" class="form-control" name="start_date" required>
            </div>

            <div class="col-md-6">
              <label class="form-label">End Date</label>
              <input type="date" class="form-control" name="end_date" required>
            </div>

            <div class="col-md-6">
              <label class="form-label">Section ID</label>
              <input type="number" class="form-control" name="section_id">
            </div>

            <div class="col-md-6">
              <label class="form-label">Created By (User ID)</label>
              <input type="number" class="form-control" name="created_by">
            </div>

            <div class="col-md-6">
              <label class="form-label">Updated By (User ID)</label>
              <input type="number" class="form-control" name="updated_by">
            </div>

            <div class="col-md-6">
              <label class="form-label">Duration (in days)</label>
              <input type="number" class="form-control" name="duration" required>
            </div>

          </div>

          <div class="mt-4 text-end">
            <button type="submit" class="btn btn-primary">Save Project</button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>


<!-- Add task Modal -->
<!-- <div class="modal fade" id="addtaskModal" tabindex="-1" aria-labelledby="addtaskModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addProjecaddtaskModaltModalLabel">Add New Task</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Your form fields go here 
                <form id="addtaskForm">
                    <div class="mb-3">
                        <label for="projectName" class="form-label">Task Name</label>
                        <input type="text" class="form-control" id="taskName" name="taskName" required>
                    </div>
                    <div class="mb-3">
                        <label for="taskCode" class="form-label">Task Code</label>
                        <input type="text" class="form-control" id="taskCode" name="taskCode" required>
                    </div>
                    <!-- Add other fields as needed 
                    <button type="submit" class="btn btn-primary">Save Project</button>
                </form>
            </div>
        </div>
    </div>
</div> -->
<div class="modal fade" id="addTaskModal" tabindex="-1" aria-labelledby="addtaskModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg"> <!-- Larger modal -->
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addtaskModalLabel">Add New Task</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
      <form id="addtaskForm">
<?php echo csrf_field(); ?>

<div class="row g-3">

<div class="col-md-6">
  <label class="form-label">Task Name</label>
  <input type="text" class="form-control" name="task_name" required>
</div>

<div class="col-md-6">
  <label class="form-label">Project ID</label>
  <input type="number" class="form-control" name="project_id" required>
</div>

<div class="col-md-6">
  <label class="form-label">User</label>
  <select class="form-select" name="user_id" required>
    <option value="">-- Select User --</option>
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </select>
</div>

<div class="col-md-6">
  <label class="form-label">Status</label>
  <select class="form-select" name="status" required>
    <option value="">-- Select Status --</option>
    <option value="1">Active</option>
    <option value="0">Inactive</option>
  </select>
</div>

<div class="col-md-6">
  <label class="form-label">Start Date</label>
  <input type="date" class="form-control" name="start_date" required>
</div>

<div class="col-md-6">
  <label class="form-label">End Date</label>
  <input type="date" class="form-control" name="end_date" required>
</div>

<div class="col-md-6">
  <label class="form-label">Updated By</label>
  <input type="number" class="form-control" name="updated_by">
</div>

<div class="col-md-6">
  <label class="form-label">Duration (in days)</label>
  <input type="number" class="form-control" name="duration" required>
</div>

<div class="col-md-6">
  <label class="form-label">Parent ID</label>
  <input type="number" class="form-control" name="parent_id">
</div>

<div class="col-md-6">
  <label class="form-label">Section ID</label>
  <input type="number" class="form-control" name="section_id">
</div>

</div>

<div class="mt-4 text-end">
  <button type="submit" class="btn btn-primary">Save Task</button>
</div>

</form>

      </div>
    </div>
  </div>
</div>

<div id="gantt_here"></div>
<!-- Modal -->
<div class="modal fade" id="ganttModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Create Task (Gantt View)</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div id="gantt_heres" style="width:100%; height:400px;"></div>
      </div>
    </div>
  </div>
</div>

<!-- Task Status Modal -->
<div class="modal fade" id="taskStatusModal" tabindex="-1" aria-labelledby="taskStatusModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title" id="taskStatusModalLabel">Task Status</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div id="taskStatusContent">
          <!-- Dynamic task details will be loaded here -->
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.js"></script>
+
<script src="https://cdn.jsdelivr.net/npm/exceljs/dist/exceljs.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/FileSaver.js/2.0.5/FileSaver.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/exceljs/dist/exceljs.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/FileSaver.js/2.0.5/FileSaver.min.js"></script>


<!-- Scripts -->
<script src="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.sheetjs.com/xlsx-latest/package/dist/xlsx.full.min.js"></script>

<script>
    // Get the select dropdown element
    const scaleSelect = document.getElementById('scaleSelect');

    // Function to update Gantt chart configuration based on the selected scale
    function updateGanttScale(scale) {
        switch (scale) {
            case 'week':
    gantt.config.scales = [
        {
            unit: "week",
            step: 1,
            format: function(date) {
                var start = gantt.date.week_start(date);
                var end = gantt.date.add(start, 6, "day");

                var format = gantt.date.date_to_str("%d %b"); // Ex: "01 Jan"
                var startText = format(start);
                var endText = format(end);

                var weekNumber = gantt.date.getWeek(start);

                return "Week " + weekNumber + " [" + startText + " - " + endText + "]";
            }
        }
    ];

    gantt.config.scale_height = 50;
    gantt.config.min_column_width = 120;
    break;

    case 'month':
    gantt.config.scale_unit = "month";
    gantt.config.date_scale = "%F"; // Full month name (e.g., "January", "February")
    gantt.config.subscales = [];    // No subscale (removes day details)
    gantt.config.scale_height = 50;
    gantt.config.min_column_width = 70;
    break;

            case 'day':
                gantt.config.scale_unit = "day";
                gantt.config.date_scale = "%d %M %Y";
                gantt.config.subscales = [];
                gantt.config.scale_height = 50;
                gantt.config.min_column_width = 50;
                break;
            default:
                break;
        }

        // Re-render the Gantt chart to apply the new configuration
        gantt.render();
    }

    // Listen for changes on the select dropdown and update Gantt chart accordingly
    scaleSelect.addEventListener('change', function() {
        updateGanttScale(scaleSelect.value);
    });

    // Initialize with the default scale
    updateGanttScale(scaleSelect.value);
</script>
<script>
  function getTextProgressBar(progress) {
    const totalBlocks = 10;
    const filledBlocks = Math.round(progress * totalBlocks);
    return "█".repeat(filledBlocks) + "░".repeat(totalBlocks - filledBlocks);
  }

  function formatDate(dateStr) {
    const date = new Date(dateStr);
    return date.toISOString().split("T")[0];
  }

  async function exportGanttData() {
    // const statusBar = document.getElementById("statusBar");
    const progressBar = document.getElementById("progressBar");
    const progressText = document.getElementById("progressText");

    const statusBar = document.getElementById("statusBar");
        if (statusBar) {
        statusBar.style.display = "block";
        }

        if (!progressBar || !progressText) {
            console.error("Progress elements not found");
            return;
        }

        progressBar.value = 5;
        progressText.innerText = "Collecting Gantt data...";
        await new Promise(r => setTimeout(r, 100));

    const workbook = new ExcelJS.Workbook();
    const sheet = workbook.addWorksheet("Gantt Chart");

    const tasks = gantt.serialize().data;

    // Find date range
    const allDates = tasks.flatMap(t => [new Date(t.start_date), new Date(t.end_date)]);
    const minDate = new Date(Math.min(...allDates));
    const maxDate = new Date(Math.max(...allDates));

    const dateRange = [];
    const dayInMs = 24 * 60 * 60 * 1000;
    for (let d = new Date(minDate); d <= maxDate; d = new Date(d.getTime() + dayInMs)) {
      dateRange.push(formatDate(d));
    }

    progressBar.value = 20;
    progressText.innerText = "Generating header...";
    await new Promise(r => setTimeout(r, 100));

    // Create headers
    const fixedHeaders = [
      "ID", "Task / Project Name", "Project Code", "Project Type", "Section Type",
      "Customer Name", "Assigned User", "Start Date", "End Date", "Duration",
      "Progress (%)", "Progress Bar", "Parent"
    ];
    const headers = [...fixedHeaders, ...dateRange];
    sheet.addRow(headers);

    progressBar.value = 40;
    progressText.innerText = "Writing tasks...";
    await new Promise(r => setTimeout(r, 100));

    tasks.forEach((task, index) => {
      const progressPercent = Math.round((task.progress || 0) * 100);
      const rowData = [
        task.id || '',
        task.text || '',
        task.project_code || '',
        task.project_type || '',
        task.section_type || '',
        task.customer_name || '',
        task.user_name || '',
        task.start_date || '',
        task.end_date || '',
        task.duration || '',
        progressPercent + '%',
        getTextProgressBar(task.progress || 0),
        task.parent || ''
      ];
      const progressColor = task.progress === 1 ? '#4CAF50' : // Green for complete
  task.progress > 0.5 ? '#FFEB3B' : // Yellow for in-progress
  task.progress === 0 ? '#2196F3' : // Blue for planned tasks
  '#F44336'; // Red for delayed tasks

      // Fill Gantt timeline (colored bars for progress)
      const taskStart = new Date(task.start_date);
      const taskEnd = new Date(task.end_date);
      const timeline = dateRange.map(dateStr => {
        const current = new Date(dateStr);
        if (current < taskStart) return "";  // Before start
        if (current > taskEnd) return "";    // After end
        return current >= taskStart && current <= taskEnd ? "█" : "";
      });

      const row = sheet.addRow([...rowData, ...timeline]);

      // Applying Data Bar for Duration (timeline)
      const startIndex = headers.length - dateRange.length;
      timeline.forEach((cell, i) => {
  const cellRef = row.getCell(startIndex + i + 1);
  if (cell === "█") {
    cellRef.fill = {
      type: 'pattern',
      pattern: 'solid',
      fgColor: { argb: progressColor.replace('#', '') }, // Color hex code in ARGB format
    };
 
          
          // Data Bar Style (for duration)
          cellRef.conditionalFormats = [{
            type: 'dataBar',
            priority: 1,
            dataBar: {
              color: 'FF00FF00',  // Green for duration progress
              showValue: true,
              minLength: 0,
              maxLength: 100,
              barDirection: 'rightToLeft',
            },
          }];
        }
      });

      // Optional: update progress and file status in progress bar
      if (index % 5 === 0) {
        progressBar.value = 40 + Math.floor((index / tasks.length) * 40);
        progressText.innerText = `Writing task ${index + 1} of ${tasks.length}...`;
      }
    });

    progressBar.value = 85;
    progressText.innerText = "Generating Excel file...";
    await new Promise(r => setTimeout(r, 100));

    const buffer = await workbook.xlsx.writeBuffer();
    const blob = new Blob([buffer], {
      type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
    });

    progressBar.value = 95;
    progressText.innerText = "Saving file...";
    saveAs(blob, "gantt_chart_with_databars.xlsx");

    progressBar.value = 100;
    progressText.innerText = "Download ready!";
    setTimeout(() => statusBar.style.display = "none", 3000);
  }
</script>
<script>
  gantt.plugins({
    quick_info: true
});

document.addEventListener('DOMContentLoaded', function () {
    gantt.config.show_task_buttons = true;
    gantt.config.root_id = 0;
    gantt.config.order_branch = true;
    gantt.config.order_branch_free = true;
    gantt.config.buttons_left = ["add"];
    gantt.config.buttons_right = [];
    gantt.config.xml_date = "%Y-%m-%d";
    gantt.config.grid_resize = true;

// // Inject the button into header after Gantt is ready
// gantt.attachEvent("onGanttReady", function() {
//     // Find the header cell of the "add_button" column
//     var headerCell = document.querySelector(".gantt_grid_head_add_button");

//     if (headerCell) {
//         // Create button element
//         var button = document.createElement("button");
//         button.className = "btn btn-sm btn-dark w-100";
//         button.textContent = "+ Add Project";
//         button.onclick = function() {
//             // Your custom action here
//             openAddProjectModal();  // You can change this function as needed
//         };

//         // Clear existing content and append button
//         headerCell.innerHTML = "";
//         headerCell.appendChild(button);
//     }
// });
    const allColumns = {
  //        add: {
  //   name: "add",
  //   label: "",
  //   width: 40,
  //   align: "center",
  //   formatter: function() {
  //     return `<button class="btn btn-sm btn-primary open-gantt"><i class="fa fa-plus"></i></button>`;
  //   }
  // },
  add:{ 
    
  name: "add_button",
  label: '<button class="btn btn-sm btn-dark w-100" onclick="onAddButtonHeaderClick()">+</button>',
  width: 100,
  template: function(task) {
      return '<button class="btn btn-sm btn-dark w-100" onclick="openAddProjectModal(\'' + task.id + '\')">+</button>';
  }
}
,
        text: { name: "text", label: "Task / Project Name", tree: true, width: 250, resize: true },
        project_code: { name: "project_code", label: "Project Code", align: "center", width: 150, resize: true },
        customer_name: { name: "customer_name", label: "Customer Name", align: "center", width: 150, resize: true },
        user_name: { name: "user_name", label: "Assigned User Name", align: "center", width: 150, resize: true },
        start_date: { name: "start_date", label: "Start Date", align: "center", width: 120, resize: true },
        end_date: { name: "end_date", label: "End Date", align: "center", width: 120, resize: true },
        duration: { name: "duration", label: "Duration", align: "center", width: 100, resize: true },
        // task_status: { name: "task_status", label: "Task Status", align: "center", width: 120, resize: true, template: function(task){
        //     return `<button class="btn btn-sm btn-dark" onclick="showTaskStatus(${task.project_id})">View Status</button>`;
        // }}
    };
    gantt.plugins({ tooltip: true });
//     function onAddButtonHeaderClick() {
//     console.log("Header + clicked");
//     openAddProjectModal('project_global');   // Or whatever you want to pass
// }
function onAddButtonHeaderClick() {
    console.log("Header + clicked");
    openAddProjectModal('projects_global');
}

// Expose it globally
window.onAddButtonHeaderClick = onAddButtonHeaderClick;
window.onAddButtonHeaderClick = function() {
    console.log("Header + clicked");
    openAddProjectModal('projects_global');
};
    gantt.templates.tooltip_text = function(start, end, task) {
        return `
            <b>Name:</b> ${task.text}<br/>
            <b>Start:</b> ${task.start_date}<br/>
            <b>Duration:</b> ${task.duration} days<br/>
            <b>Project Code:</b> ${task.project_code ?? 'N/A'}<br/>
            <b>Customer Name:</b> ${task.customer_name ?? 'N/A'}<br/>
            <b>Assigned User Name:</b> ${task.user_name ?? 'N/A'}<br/>
            <b>Customer ID:</b> ${task.customer_id ?? 'N/A'}
        `;
    };
    const tasks = { data: <?php echo json_encode($ganttData, 15, 512) ?> };

// Add color to tasks
tasks.data.forEach(task => {
    task.color = getRandomColor();
});

// const tasks = {
//     data: <?php echo json_encode($ganttData, 15, 512) ?>  // This will convert PHP array to JS object
// };

// Add color to tasks and format dates if needed
tasks.data.forEach(task => {
    // Ensure each task has a valid start_date, use fallback if missing
    if (!task.start_date) {
        task.start_date = new Date().toISOString().slice(0, 16).replace('T', ' '); // Fallback: current date
    }
    
    // Add random color for each task
    task.color = getRandomColor();
});

    // Configure the Gantt chart
    gantt.config.scale_unit = "week";
    gantt.config.date_scale = "Week #%W";
    gantt.config.subscales = [{ unit: "day", step: 1, date: "%D" }];
    gantt.config.scale_height = 50;
    gantt.config.min_column_width = 70;

    gantt.config.scale_unit = "month";  // Set scale to "month"
gantt.config.date_scale = "Month #%M";  // Use Month format for the date scale
gantt.config.subscales = [{ unit: "day", step: 1, date: "%D" }];  // Show days inside each month
gantt.config.scale_height = 50;  // Adjust scale height to fit month view
gantt.config.min_column_width = 70;  // Set column width


gantt.config.scale_unit = "day";  // Set scale to "day"
gantt.config.date_scale = "%d %M %Y";  // Display day, month, and year in the date scale
gantt.config.subscales = [];  // No subscales, as it's already day-wise
gantt.config.scale_height = 50;  // Adjust scale height for day view
gantt.config.min_column_width = 50;  // Set a smaller column width for day view


// Initialize Gantt chart
gantt.init("gantt_here");

// Parse and load task data
gantt.parse(tasks);
// Function to change Gantt scale
function setGanttScale(event) {
    // Get the selected scale value
    const scale = event.target.value;

    // Check which scale was selected and update Gantt config accordingly
    switch(scale) {
        case "week":
            gantt.config.scale_unit = "week";
            gantt.config.date_scale = "Week #%W";
            gantt.config.subscales = [{ unit: "day", step: 1, date: "%D" }];
            break;
        case "month":
            gantt.config.scale_unit = "month";
            gantt.config.date_scale = "Month #%M";
            gantt.config.subscales = [{ unit: "day", step: 1, date: "%D" }];
            break;
        case "day":
            gantt.config.scale_unit = "day";
            gantt.config.date_scale = "Day #%D";
            gantt.config.subscales = [];
            break;
        // Add other cases for additional scale units as needed
    }

    // Re-initialize the Gantt chart with the updated configuration
    gantt.render();
}

// Event listener for dropdown change
document.getElementById('scaleSelect').addEventListener('change', function() {
    setGanttScale(this.value);
});

// Random color generator
function getRandomColor() {
    const letters = '0123456789ABCDEF';
    let color = '#';
    for (let i = 0; i < 6; i++) {
        color += letters[Math.floor(Math.random() * 16)];
    }
    return color;
}

    // const tasks = { data: <?php echo json_encode($ganttData); ?> };
    tasks.data.forEach(task => { task.color = getRandomColor(); });

    gantt.templates.task_attr = function (start, end, task) {
        return `style="background-color: ${task.color}; border: 1px solid ${task.color};"`; 
    };
    gantt.templates.task_text = function(start, end, task){
        return `<div style="color: black;">${task.text}</div>`;
    };

    // function updateColumns() {
    //     const checkedValues = Array.from(document.querySelectorAll('.column-toggle:checked')).map(cb => cb.value);
    //     const selectedColumns = checkedValues.map(col => allColumns[col]).filter(Boolean);
    //     const columns = [...new Map(selectedColumns.map(col => [col.name, col])).values()];
    //     gantt.config.columns = columns;

    //     // Dynamically adjust grid width
    //     const totalWidth = columns.reduce((sum, col) => sum + (col.width || 100), 0);
    //     gantt.config.grid_width = totalWidth;
    //     gantt.render();
    // }

    // document.querySelectorAll('.column-toggle').forEach(cb => {
    //     cb.addEventListener('change', updateColumns);
    // });

    // Initialize with all columns
    gantt.config.columns = Object.values(allColumns);
    gantt.config.grid_width = gantt.config.columns.reduce((sum, col) => sum + (col.width || 100), 0);
    gantt.init("gantt_here");
    gantt.parse(tasks);

    gantt.attachEvent("onBeforeTaskUpdate", function(id, task) {
        const confirmed = confirm("Are you sure you want to update this task?");
        if (confirmed) {
            updateTaskOnServer(task);
            return true;
        } else {
            return false;
        }
    });
// Enable project/tasks types
gantt.config.types = {
    project: "project",
    task: "task"
};

// 1️⃣ Lightbox Sections — all fields

// 2️⃣ Lightbox Labels
gantt.locale.labels.section_description = "Name";
gantt.locale.labels.section_customer_name = "Customer Name";
gantt.locale.labels.section_project_code = "Project Code";
gantt.locale.labels.section_user_name = "User Name";
gantt.locale.labels.section_remarks = "Remarks";

// 3️⃣ Project Hierarchy Configuration
gantt.config.order_branch = true;
gantt.config.order_branch_free = true;
gantt.config.open_tree_initially = true;

// 4️⃣ Dynamically show/hide fields based on type
gantt.attachEvent("onBeforeLightbox", function(id){
    const task = gantt.getTask(id);
    const statusBar = document.getElementById("statusBar");
if (statusBar) {
  statusBar.style.display = "block";
}
const progressModal = new bootstrap.Modal(document.getElementById('progressModal'));
progressModal.show();
setTimeout(() => progressModal.hide(), 3000);
    // Reset lightbox fields visibility
    gantt.resetLightbox();

    // Get HTML elements of fields
    const customerNameBlock = gantt.getLightboxSection('customer_name').node;
    const projectCodeBlock  = gantt.getLightboxSection('project_code').node;
    const userNameBlock     = gantt.getLightboxSection('user_name').node;

    if(task.type === gantt.config.types.project){
        customerNameBlock.style.display = "";
        projectCodeBlock.style.display = "none";
        userNameBlock.style.display = "none";
    } else {
        customerNameBlock.style.display = "none";
        projectCodeBlock.style.display = "";
        userNameBlock.style.display = "";
    }

    return true;
});

// 5️⃣ Add Save + Cancel buttons in lightbox
gantt.config.buttons_left = ["save_btn"];
gantt.config.buttons_right = ["dhx_cancel_btn"];

// 6️⃣ Define button labels
gantt.locale.labels["save_btn"] = "Save";


gantt.attachEvent("onTaskCreated", function(task){
    // Detect if it's root → project OR child → task
    if(task.parent == gantt.config.root_id || task.parent == 0){
        task.type = gantt.config.types.project;
        task.customer_name = "";
        task.remarks = "";
    } else {
        task.type = gantt.config.types.task;
        task.project_code = "";
        task.user_name = "";
        task.remarks = "";
    }

    // Don’t auto-add task → just open lightbox
    tempTaskId = task.id;
    gantt.showLightbox(task.id);
    return false; // Prevent auto-adding
});

    function getRandomColor() {
        const hue = Math.floor(Math.random() * 360);
        return `hsl(${hue}, 70%, 80%)`;
    }

    function updateColumns() {
        const checkedValues = Array.from(document.querySelectorAll('.column-toggle:checked')).map(cb => cb.value);
        const selectedColumns = checkedValues.map(col => allColumns[col]).filter(Boolean);
        const columns = [...new Map(selectedColumns.map(col => [col.name, col])).values()];
        gantt.config.columns = columns;

        // Dynamically adjust grid width
        const totalWidth = columns.reduce((sum, col) => sum + (col.width || 100), 0);
        gantt.config.grid_width = totalWidth;
        gantt.render();
    }

    document.querySelectorAll('.column-toggle').forEach(cb => {
        cb.addEventListener('change', updateColumns);
    });

    // Initialize with all columns
    gantt.config.columns = Object.values(allColumns);
    gantt.config.grid_width = gantt.config.columns.reduce((sum, col) => sum + (col.width || 100), 0);
    gantt.init("gantt_here");
    gantt.parse(tasks);

    gantt.attachEvent("onBeforeTaskUpdate", function(id, task) {
        const confirmed = confirm("Are you sure you want to update this task?");
        if (confirmed) {
            updateTaskOnServer(task);
            return true;
        } else {
            return false;
        }
    });

    function updateTaskOnServer(task) {
        fetch('/update-gantt-task', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify(task)
        })
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                alert("Failed to update task on server");
            }
        })
        .catch(error => {
            console.error("Error updating task:", error);
            alert("An error occurred while updating");
        });
    }

    gantt.config.xml_date = "%Y-%m-%d";
});
gantt.attachEvent("onAfterTaskSelected", function(id) {
    setTimeout(function () {
        const qiBox = document.querySelector(".gantt_cal_quick_info");
        const editBtn = qiBox?.querySelector(".icon_edit");

        if (editBtn) {
            editBtn.onclick = function () {
                const task = gantt.getTask(id);
                openEditModal(task);
            };
        }
    }, 0);

});
    document.querySelectorAll('.column-toggle').forEach(cb => { cb.addEventListener('change', updateColumns); });

    gantt.config.columns = Object.values(allColumns);
    gantt.config.grid_width = gantt.config.columns.reduce((sum, col) => sum + (col.width || 100), 0);
    gantt.init("gantt_here");
    gantt.parse(tasks);
    gantt.attachEvent("onBeforeTaskUpdate", function(id, task) {
        const confirmed = confirm("Are you sure you want to update this task?");
        if (confirmed) {
            updateTaskOnServer(task);
            return true;
        } else {
            return false;
        }
    });

    function updateTaskOnServer(task) {
        fetch('/update-gantt-task', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify(task)
        })
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                alert("Failed to update task on server");
            }
        })
        .catch(error => {
            console.error("Error updating task:", error);
            alert("An error occurred while updating");
        });
    }

   

    // Task Status Modal Logic
    window.showTaskStatus = function(projectId){
        fetch(`/get-tasks-by-project/${projectId}`)
        .then(response => response.text())
        .then(html => {
            document.getElementById('taskStatusContent').innerHTML = html;
            new bootstrap.Modal(document.getElementById('taskStatusModal')).show();
        });
    }

// });

gantt.attachEvent("onAfterTaskSelected", function(id) {
    setTimeout(function () {
        const qiBox = document.querySelector(".gantt_cal_quick_info");
        const editBtn = qiBox?.querySelector(".icon_edit");

        if (editBtn) {
            editBtn.onclick = function () {
                const task = gantt.getTask(id);
                openEditModal(task);
            };
        }
    }, 0);
});
gantt.config.xml_date = "%Y-%m-%d";
</script>
<script>
gantt.config.lightbox.sections = [
    {name: "description", height: 38, map_to: "text", type: "textarea", focus: true},
    {name: "customer_name", height: 30, map_to: "customer_name", type: "textarea"},
    {name: "project_code", height: 30, map_to: "project_code", type: "textarea"},
    {name: "user_name", height: 30, map_to: "user_name", type: "textarea"},
    {name: "remarks", height: 50, map_to: "remarks", type: "textarea"},
    {name: "time", type: "duration", map_to: "auto"}
];

gantt.attachEvent("onLightboxButton", function(button_id, node, e){
    if(button_id === "save_btn"){
        var task = gantt.getTask(gantt.getState().lightbox);

        // ✅ Correct way to get values from lightbox fields
        var text = gantt.getLightboxSection("description").getValue();
        var customer_name = gantt.getLightboxSection("customer_name").getValue();
        var project_code = gantt.getLightboxSection("project_code").getValue();
        var user_name = gantt.getLightboxSection("user_name").getValue();
        var remarks = gantt.getLightboxSection("remarks").getValue();

        var timeValues = gantt.getLightboxSection("time").getValue();
        var duration = timeValues.duration;
        var start_date = timeValues.start_date;

        console.log({
            text, customer_name, project_code, user_name, remarks, duration, start_date
        });

        fetch(`/update-gantt-task/${task.id}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                text: text,
                start_date: start_date,
                duration: duration,
                customer_name: customer_name,
                project_code: project_code,
                user_name: user_name,
                progress: task.progress
                // remarks not sent
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update task object manually with new values
                task.text = text;
                task.start_date = start_date;
                task.duration = duration;
                task.customer_name = customer_name;
                task.project_code = project_code;
                task.user_name = user_name;
                // task.remarks = remarks; // optional

                gantt.hideLightbox();
                gantt.refreshTask(task.id);
                alert("Task updated successfully!");
            } else {
                alert("Error updating task.");
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert("Error updating task.");
        });

        return true;
    }
    return false;
});
</script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<script>
function openAddProjectModal(projectId) {
    if (projectId && projectId.startsWith("project_")) {
      var myModal = new bootstrap.Modal(document.getElementById('addTaskModal'));
        myModal.show();
    } else if(projectId="projects_global") {
      var myModal = new bootstrap.Modal(document.getElementById('addProjectModal'));
        myModal.show();
    }
    else{
      var myModal = new bootstrap.Modal(document.getElementById('addTaskModal'));
        myModal.show();
    }
}


 
document.getElementById('addProjectForm').addEventListener('submit', function (e) {
    e.preventDefault();

    const formData = new FormData(this);

    fetch("<?php echo e(route('projects.store')); ?>", {
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            alert(data.message);
            // Optionally, close modal & reload data
            var addProjectModal = bootstrap.Modal.getInstance(document.getElementById('addProjectModal'));
            addProjectModal.hide();
            location.reload(); // Or update your table dynamically
        } else {
            alert('Something went wrong');
        }
    })
    .catch(error => console.error('Error:', error));
});
document.getElementById('addtaskForm').addEventListener('submit', function(e) {
    e.preventDefault();

    let formData = new FormData(this);

    fetch("/gantt-tasks", {  // Make sure this route matches
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
        },
        body: formData
    })
    .then(response => {
        if (!response.ok) {
            return response.json().then(err => { throw err });
        }
        return response.json();
    })
    .then(data => {
        alert('Task saved successfully!');
        location.reload();
    })
    .catch(error => {
        if (error.errors) {
            let errors = Object.values(error.errors).flat().join("\n");
            // alert('Validation Error:\n' + errors);
        } else {
            alert('An unexpected error occurred.');
            console.error(error);
        }
    });
});




</script>
</body>
</html>
<?php /**PATH E:\ganttproject\manage\resources\views/gantt/index.blade.php ENDPATH**/ ?>