<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Project Gantt View</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- DHTMLX Gantt CSS -->
    <link rel="stylesheet" href="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.css">

    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
        }
        #gantt_here .gantt_grid, 
#gantt_here .gantt_data_area {
    overflow-x: auto;
    white-space: nowrap;
}

        .navbar {
            position: fixed;
            top: 0;
            width: 100%;
            height: 60px;
            background-color: #2dce89;
            color: white;
            display: flex;
            align-items: center;
            padding: 0 20px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            z-index: 999;
            justify-content: space-between;
        }

        .navbar h1 {
            margin: 0;
            font-size: 20px;
        }

        .navbar .btns {
            display: flex;
            gap: 10px;
        }

        .content {
            margin-top: 70px;
            padding: 20px;
        }

        #gantt_here {
            width: 100%;
            height: calc(100vh - 150px);
            border: 1px solid #ccc;
            overflow: auto;
        }

        .gantt_tooltip {
            max-width: 300px;
            white-space: normal;
            word-wrap: break-word;
        }
        #columnSelector {
    display: flex;
    gap: 10px;
    overflow-x: auto;
    white-space: nowrap;
    padding-bottom: 10px;
}

#columnSelector label {
    flex: 0 0 auto;
    min-width: 180px;
    white-space: nowrap;
}
#gantt_here ,
#gantt_here .gantt_data_area {
    overflow-x: auto;
    white-space: nowrap;
}
/* Style for WebKit-based browsers */
#gantt_here::-webkit-scrollbar {
    width: 12px;
    height: 12px;
}

#gantt_here::-webkit-scrollbar-thumb {
    background-color: #888; /* Gray color */
    border-radius: 6px;
}

#gantt_here::-webkit-scrollbar-track {
    background-color: #f1f1f1;
}


    </style>
      <style>
    .dropdown {
      position: relative;
      display: inline-block;
    }

    .dropdown-button {
      padding: 8px 12px;
      background-color: #f2f2f2;
      border: 1px solid #ccc;
      cursor: pointer;
      border-radius: 4px;
    }

    .dropdown-content {
      display: none;
      position: absolute;
      background-color: white;
      border: 1px solid #ddd;
      min-width: 250px;
      max-height: 300px;
      overflow-y: auto;
      z-index: 1;
      padding: 10px;
      box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }

    .dropdown-content label {
      display: block;
      padding: 4px 0;
    }

    .dropdown.show .dropdown-content {
      display: block;
    }
  </style>
</head>
<body>

    <div class="navbar">
        <h1>Project Gantt View</h1>
        <div class="btns">
  <button onclick="exportGanttData()">Download Excel</button>
</div>
    </div>
   

<div id="statusBar" style="margin-top: 10px; display: none;">
  <progress id="progressBar" value="0" max="100"></progress>
  <span id="progressText">Preparing download...</span>
</div>

    <div class="content">
        <!-- <div id="columnSelector" style="margin-bottom: 10px;">
            <label><input type="checkbox" class="column-toggle" value="text" checked disabled> Task / Project Name</label>
            <label><input type="checkbox" class="column-toggle" value="project_code" checked> Project Code</label>
            <label><input type="checkbox" class="column-toggle" value="project_type" checked> Project Type </label>
            <label><input type="checkbox" class="column-toggle" value="section_type" checked> Section Type </label>
            <label><input type="checkbox" class="column-toggle" value="customer_name" checked> Customer Name</label>
            <label><input type="checkbox" class="column-toggle" value="user_name" checked> Assigned User Name</label>
            <label><input type="checkbox" class="column-toggle" value="start_date" checked> Start Date</label>
            <label><input type="checkbox" class="column-toggle" value="start_date" checked> End Date</label>
            <label><input type="checkbox" class="column-toggle" value="duration" checked> Duration</label>
        </div> -->
        
<div class="dropdown" id="columnDropdown">
  <div class="dropdown-button" onclick="toggleDropdown()">Select Columns</div>
  <div class="dropdown-content">
    <label><input type="checkbox" value="text" checked disabled> Task / Project Name</label>
    <label><input type="checkbox" class="column-toggle"value="project_code" checked> Project Code</label>
    <label><input type="checkbox" class="column-toggle" value="project_type" checked> Project Type</label>
    <label><input type="checkbox" class="column-toggle" value="section_type" checked> Section Type</label>
    <label><input type="checkbox"class="column-toggle" value="customer_name" checked> Customer Name</label>
    <label><input type="checkbox"class="column-toggle" value="user_name" checked> Assigned User Name</label>
 +   <label><input type="checkbox" class="column-toggle"value="start_date" checked> Start Date</label>
    <label><input type="checkbox" class="column-toggle"value="end_date" checked> End Date</label>
    <label><input type="checkbox" class="column-toggle"value="duration" checked> Duration</label>
  </div>
</div>
        <!-- <button onclick="addNewTask()">➕ Add Task / Project</button> -->
        <div id="gantt_container" style="width: 100%; overflow: auto;">
    <div id="gantt_here" style="width: 2000px; min-height: 500px;"></div>
</div>

    </div>
    <div id="addTaskModal" style="display: none; position: fixed; top: 20%; left: 40%; background: #fff; padding: 20px; border: 1px solid #ccc; z-index: 1000;">
    <h3>Add New Task</h3>
    <label>Task Name: <input type="text" id="taskNameInput" /></label><br><br>
    <label>Start Date: <input type="date" id="taskStartInput" /></label><br><br>
    <label>Duration: <input type="number" id="taskDurationInput" value="1" min="1" /></label><br><br>
    <button onclick="saveNewTask()">Save</button>
    <button onclick="closeTaskModal()">Cancel</button>
</div>
    <!-- DHTMLX Gantt JS -->
    <script src="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.js"></script>
+
<script src="https://cdn.jsdelivr.net/npm/exceljs/dist/exceljs.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/FileSaver.js/2.0.5/FileSaver.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/exceljs/dist/exceljs.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/FileSaver.js/2.0.5/FileSaver.min.js"></script>


    <script>
  function toggleDropdown() {
    document.getElementById("columnDropdown").classList.toggle("show");
  }

  // Close dropdown when clicking outside
  window.addEventListener("click", function(event) {
    const dropdown = document.getElementById("columnDropdown");
    if (!dropdown.contains(event.target)) {
      dropdown.classList.remove("show");
    }
  });
</script>
<!-- <script>
  // Helper function to create a text-based progress bar
  function getTextProgressBar(progress) {
    const totalBlocks = 10;
    const filledBlocks = Math.round(progress * totalBlocks);
    return "█".repeat(filledBlocks) + "░".repeat(totalBlocks - filledBlocks);
  }

  async function exportGanttData() {
    const statusBar = document.getElementById("statusBar");
    const progressBar = document.getElementById("progressBar");
    const progressText = document.getElementById("progressText");

    statusBar.style.display = "block";
    progressBar.value = 10;
    progressText.innerText = "Collecting Gantt data...";

    const workbook = new ExcelJS.Workbook();
    const sheet = workbook.addWorksheet("Gantt Chart Data");

    const columns = [
      "ID",
      "Task / Project Name",
      "Project Code",
      "Project Type",
      "Section Type",
      "Customer Name",
      "Assigned User",
      "Start Date",
      "End Date",
      "Duration",
      "Progress (%)",
      "Progress Bar",
      "Parent"
    ];

    sheet.addRow(columns);

    progressBar.value = 30;
    progressText.innerText = "Parsing task data...";

    const tasks = gantt.serialize().data;

    tasks.forEach((task) => {
      const progressPercent = Math.round(task.progress * 100);
      const row = sheet.addRow([
        task.id || '',
        task.text || '',
        task.project_code || '',
        task.project_type || '',
        task.section_type || '',
        task.customer_name || '',
        task.user_name || '',
        task.start_date || '',
        task.end_date || '',
        task.duration || '',
        progressPercent + '%',
        getTextProgressBar(task.progress || 0),
        task.parent || ''
      ]);
    });

    progressBar.value = 70;
    progressText.innerText = "Generating Excel file...";

    const buffer = await workbook.xlsx.writeBuffer();
    const blob = new Blob([buffer], {
      type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
    });

    progressBar.value = 90;
    progressText.innerText = "Saving file...";

    saveAs(blob, "gantt_export.xlsx");

    progressBar.value = 100;
    progressText.innerText = "Download ready!";
    setTimeout(() => {
      statusBar.style.display = "none";
    }, 3000);
  }
</script> -->
<script>
  function getTextProgressBar(progress) {
    const totalBlocks = 10;
    const filledBlocks = Math.round(progress * totalBlocks);
    return "█".repeat(filledBlocks) + "░".repeat(totalBlocks - filledBlocks);
  }

  function formatDate(dateStr) {
    const date = new Date(dateStr);
    return date.toISOString().split("T")[0];
  }

  async function exportGanttData() {
    const statusBar = document.getElementById("statusBar");
    const progressBar = document.getElementById("progressBar");
    const progressText = document.getElementById("progressText");

    statusBar.style.display = "block";
    progressBar.value = 5;
    progressText.innerText = "Collecting Gantt data...";
    await new Promise(r => setTimeout(r, 100));

    const workbook = new ExcelJS.Workbook();
    const sheet = workbook.addWorksheet("Gantt Chart");

    const tasks = gantt.serialize().data;

    // Find date range
    const allDates = tasks.flatMap(t => [new Date(t.start_date), new Date(t.end_date)]);
    const minDate = new Date(Math.min(...allDates));
    const maxDate = new Date(Math.max(...allDates));

    const dateRange = [];
    const dayInMs = 24 * 60 * 60 * 1000;
    for (let d = new Date(minDate); d <= maxDate; d = new Date(d.getTime() + dayInMs)) {
      dateRange.push(formatDate(d));
    }

    progressBar.value = 20;
    progressText.innerText = "Generating header...";
    await new Promise(r => setTimeout(r, 100));

    // Create headers
    const fixedHeaders = [
      "ID", "Task / Project Name", "Project Code", "Project Type", "Section Type",
      "Customer Name", "Assigned User", "Start Date", "End Date", "Duration",
      "Progress (%)", "Progress Bar", "Parent"
    ];
    const headers = [...fixedHeaders, ...dateRange];
    sheet.addRow(headers);

    progressBar.value = 40;
    progressText.innerText = "Writing tasks...";
    await new Promise(r => setTimeout(r, 100));

    tasks.forEach((task, index) => {
      const progressPercent = Math.round((task.progress || 0) * 100);
      const rowData = [
        task.id || '',
        task.text || '',
        task.project_code || '',
        task.project_type || '',
        task.section_type || '',
        task.customer_name || '',
        task.user_name || '',
        task.start_date || '',
        task.end_date || '',
        task.duration || '',
        progressPercent + '%',
        getTextProgressBar(task.progress || 0),
        task.parent || ''
      ];
      const progressColor = task.progress === 1 ? '#4CAF50' : // Green for complete
  task.progress > 0.5 ? '#FFEB3B' : // Yellow for in-progress
  task.progress === 0 ? '#2196F3' : // Blue for planned tasks
  '#F44336'; // Red for delayed tasks

      // Fill Gantt timeline (colored bars for progress)
      const taskStart = new Date(task.start_date);
      const taskEnd = new Date(task.end_date);
      const timeline = dateRange.map(dateStr => {
        const current = new Date(dateStr);
        if (current < taskStart) return "";  // Before start
        if (current > taskEnd) return "";    // After end
        return current >= taskStart && current <= taskEnd ? "█" : "";
      });

      const row = sheet.addRow([...rowData, ...timeline]);

      // Applying Data Bar for Duration (timeline)
      const startIndex = headers.length - dateRange.length;
      timeline.forEach((cell, i) => {
  const cellRef = row.getCell(startIndex + i + 1);
  if (cell === "█") {
    cellRef.fill = {
      type: 'pattern',
      pattern: 'solid',
      fgColor: { argb: progressColor.replace('#', '') }, // Color hex code in ARGB format
    };
 
          
          // Data Bar Style (for duration)
          cellRef.conditionalFormats = [{
            type: 'dataBar',
            priority: 1,
            dataBar: {
              color: 'FF00FF00',  // Green for duration progress
              showValue: true,
              minLength: 0,
              maxLength: 100,
              barDirection: 'rightToLeft',
            },
          }];
        }
      });

      // Optional: update progress and file status in progress bar
      if (index % 5 === 0) {
        progressBar.value = 40 + Math.floor((index / tasks.length) * 40);
        progressText.innerText = `Writing task ${index + 1} of ${tasks.length}...`;
      }
    });

    progressBar.value = 85;
    progressText.innerText = "Generating Excel file...";
    await new Promise(r => setTimeout(r, 100));

    const buffer = await workbook.xlsx.writeBuffer();
    const blob = new Blob([buffer], {
      type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
    });

    progressBar.value = 95;
    progressText.innerText = "Saving file...";
    saveAs(blob, "gantt_chart_with_databars.xlsx");

    progressBar.value = 100;
    progressText.innerText = "Download ready!";
    setTimeout(() => statusBar.style.display = "none", 3000);
  }
</script>


    <script>
      gantt.config.autosize = false;
gantt.config.grid_resize = true;
gantt.config.scroll_size = 20;

        document.addEventListener('DOMContentLoaded', function () {
            gantt.config.show_task_buttons = true;      // Show the [+] add buttons
            gantt.config.root_id = 0;                   // Allow adding root-level tasks
            gantt.config.order_branch = true;           // Allow tasks to be moved
            gantt.config.order_branch_free = true;      // Allow tasks to be reordered
            gantt.config.buttons_left = ["add"];        // Show add button on the left
            gantt.config.buttons_right = [];    

            gantt.config.xml_date = "%Y-%m-%d";
            gantt.config.grid_resize = true;
//             gantt.config.layout = {
//     css: "gantt_container",
//     cols: [
//         {
//             width: gantt.config.grid_width,
//             min_width: 200,
//             max_width: 600,
//             rows: [
//                 {
//                     view: "grid",
//                     scrollX: "gridScroll",
//                     scrollable: true,
//                     scrollY: "scrollVer"
//                 },
//                 {
//                     view: "scrollbar",
//                     id: "gridScroll",
//                     group: "horizontal"
//                 }
//             ]
//         },
//         { resizer: true, width: 1 },
//         {
//             rows: [
//                 {
//                     view: "timeline",
//                     scrollX: "scrollHor",
//                     scrollY: "scrollVer"
//                 },
//                 {
//                     view: "scrollbar",
//                     id: "scrollHor",
//                     group: "horizontal"
//                 }
//             ]
//         },
//         {
//             view: "scrollbar",
//             id: "scrollVer"
//         }
//     ]
// };

gantt.config.layout = {
    css: "gantt_container",
    rows: [
        {
            cols: [
                {
                    view: "grid",
                    scrollX: "gridScroll",
                    scrollY: "scrollVer"
                },
                { resizer: true, width: 1 },
                {
                    view: "timeline",
                    scrollX: "scrollHor",
                    scrollY: "scrollVer"
                },
                {
                    view: "scrollbar",
                    id: "scrollVer"
                }
            ]
        },
        {
            view: "scrollbar",
            id: "scrollHor"
        }
    ]
};
gantt.config.grid_elastic_columns = true;

            const allColumns = {
                add: {
        name: "add",
        label: "",
        width: 40,
        align: "center"
    },
                text: { name: "text", label: "Task / Project Name", tree: true, width: 250, resize: true },
                project_code: { name: "project_code", label: "Project/Task Code", align: "center", width: 150, resize: true },
                project_type: { name: "project_type", label: "Project Type ", align: "center", width: 150, resize: true },
                section_type: { name: "section_type", label: "Section Type ", align: "center", width: 150, resize: true },
                customer_name: { name: "customer_name", label: "Customer Name", align: "center", width: 150, resize: true },
                user_name: { name: "user_name", label: "Assigned User Name", align: "center", width: 150, resize: true },
                start_date: { name: "start_date", label: "Start", align: "center", width: 120, resize: true },
                end_date: { name: "end_date", label: "End", align: "center", width: 120, resize: true },
                duration: { name: "duration", label: "Duration", align: "center", width: 100, resize: true }
            };

            gantt.templates.tooltip_text = function(start, end, task) {
                return `
                    <b>Name:</b> ${task.text}<br/>
                    <b>Start:</b> ${task.start_date}<br/>
                    <b>End:</b> ${task.end_date}<br/>
                    <b>Duration:</b> ${task.duration} days<br/>
                    <b>Project Code:</b> ${task.project_code ?? 'N/A'}<br/>
                     <b>Project Type:</b> ${task.project_type ?? 'N/A'}<br/>
                    <b>Section Type:</b> ${task.section_type ?? 'N/A'}<br/>
                    <b>Customer Name:</b> ${task.customer_name ?? 'N/A'}<br/>
                    <b>Assigned User Name:</b> ${task.user_name ?? 'N/A'}<br/>
                    <b>Customer ID:</b> ${task.customer_id ?? 'N/A'}
                `;
            };

            const tasks = {
                data: <?php echo json_encode($ganttData); ?>

            };

            // function updateColumns() {
            //     const checkedValues = Array.from(document.querySelectorAll('.column-toggle:checked'))
            //                                .map(cb => cb.value);

            //     const selectedColumns = checkedValues.map(col => allColumns[col]).filter(Boolean);

            //     // Always include 'text' column first
            //     selectedColumns.unshift(allColumns['text']);

            //     gantt.config.columns = [...new Map(selectedColumns.map(col => [col.name, col])).values()];
            //     gantt.render();
            // }
            function updateColumns() {
    const checkedValues = Array.from(document.querySelectorAll('.column-toggle:checked'))
                               .map(cb => cb.value);

    const selectedColumns = checkedValues.map(col => allColumns[col]).filter(Boolean);

    // Always include 'text' column first
    selectedColumns.unshift(allColumns['text']);

    gantt.config.columns = [...new Map(selectedColumns.map(col => [col.name, col])).values()];
    
    // Estimate and set chart width
    const estimatedWidth = selectedColumns.reduce((sum, col) => sum + (col.width || 150), 0);
    document.getElementById("gantt_here").style.width = (estimatedWidth + 300) + "px";

    gantt.render();
}

            document.querySelectorAll('.column-toggle').forEach(cb => {
                cb.addEventListener('change', updateColumns);
            });

            gantt.config.columns = Object.values(allColumns);
            gantt.init("gantt_here");
            gantt.parse(tasks);
        });

        gantt.attachEvent("onBeforeTaskUpdate", function(id, task) {
            const confirmed = confirm("Are you sure you want to update this task?");
            if (confirmed) {
                updateTaskOnServer(task);
                return true;
            } else {
                return false;
            }
        });

        function updateTaskOnServer(task) {
            fetch('/update-gantt-task', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify(task)
            })
            .then(response => response.json())
            .then(data => {
                if (!data.success) {
                    alert("Failed to update task on server");
                }
            })
            .catch(error => {
                console.error("Error updating task:", error);
                alert("An error occurred while updating");
            });
        }
        
    </script>

    <!-- DHTMLX Gantt Export to PDF -->
    <script src="https://cdn.dhtmlx.com/gantt/edge/ext/dhtmlxgantt_export.js"></script>
</body>
</html>
<?php /**PATH E:\manage\resources\views/gantt.blade.php ENDPATH**/ ?>