<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Project Gantt View</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- DHTMLX Gantt CSS -->
    <link rel="stylesheet" href="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.css">

    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            padding-top: 70px;
        }

        .navbar {
            position: fixed;
            top: 0;
            width: 100%;
            height: 60px;
            background-color: #2dce89;
            color: white;
            display: flex;
            align-items: center;
            padding: 0 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            z-index: 1030;
            justify-content: space-between;
        }

        .navbar h1 {
            margin: 0;
            font-size: 20px;
        }

        .content {
            margin-top: 70px;
            padding: 20px;
        }

        #gantt_here {
            width: 100%;
            height: calc(100vh - 150px);
            border: 1px solid #ccc;
            overflow: auto;
        }

        .gantt_tooltip {
            max-width: 300px;
            white-space: normal;
            word-wrap: break-word;
        }
    </style>
</head>
<body>

<div class="navbar">
        <h1>Project Gantt View</h1>
        <div class="btns">
  <button onclick="exportGanttData()">Download Excel</button>
</div>
    </div>
   
    <div id="statusBar" style="display: none;">
  <progress id="progressBar" value="0" max="100"></progress>
  <span id="progressText">Preparing download...</span>
</div>

    <div class="dropdown">
        <a class="btn dropdown-toggle <?php echo e(Route::currentRouteName() == 'projectsessionview' || Route::currentRouteName() == 'projectcustomer' ? 'active' : ''); ?>"
           href="#" role="button" id="projectDropdown" data-bs-toggle="dropdown" aria-expanded="false"
           style="background-color:rgb(10, 10, 10); color: white;">
           Project Menu
        </a>
        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="projectDropdown">
            <li><a class="dropdown-item <?php echo e(Route::currentRouteName() == 'projectsessionview' ? 'active' : ''); ?>" href="<?php echo e(route('projectsessionview')); ?>">Project Section</a></li>
            <li><a class="dropdown-item <?php echo e(Route::currentRouteName() == 'projectcustomer' ? 'active' : ''); ?>" href="<?php echo e(route('projectcustomer')); ?>">Customer</a></li>
        </ul>
    </div>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</div>

<div class="d-flex justify-content-between align-items-center mb-3 mt-2 px-3">
    <div class="dropdown">
        <button class="btn dropdown-toggle" style="background-color:rgb(2, 2, 2); color: white;" type="button" id="columnSelectorDropdown" data-bs-toggle="dropdown" aria-expanded="false">
            Column Selector
        </button>
        <ul class="dropdown-menu p-3" aria-labelledby="columnSelectorDropdown" style="width: 250px;">
            <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="text" checked disabled> Task / Project Name</label></li>
            <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="project_code" checked> Project Code</label></li>
            <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="customer_name" checked> Customer Name</label></li>
            <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="user_name" checked> Assigned User Name</label></li>
            <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="start_date" checked> Start Date</label></li>
            <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="end_date" checked> End Date</label></li>
            <li><label class="form-check-label"><input type="checkbox" class="form-check-input column-toggle" value="duration" checked> Duration</label></li>
        </ul>
    </div>

    <!-- <div class="btns">
  <button onclick="exportGanttData()">Download Excel</button>
</div> -->
</div>

<div id="gantt_here"></div>
<script src="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.js"></script>
+
<script src="https://cdn.jsdelivr.net/npm/exceljs/dist/exceljs.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/FileSaver.js/2.0.5/FileSaver.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/exceljs/dist/exceljs.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/FileSaver.js/2.0.5/FileSaver.min.js"></script>


<!-- Scripts -->
<script src="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.sheetjs.com/xlsx-latest/package/dist/xlsx.full.min.js"></script>
<script>
  function getTextProgressBar(progress) {
    const totalBlocks = 10;
    const filledBlocks = Math.round(progress * totalBlocks);
    return "█".repeat(filledBlocks) + "░".repeat(totalBlocks - filledBlocks);
  }

  function formatDate(dateStr) {
    const date = new Date(dateStr);
    return date.toISOString().split("T")[0];
  }

  async function exportGanttData() {
    // const statusBar = document.getElementById("statusBar");
    const progressBar = document.getElementById("progressBar");
    const progressText = document.getElementById("progressText");

    const statusBar = document.getElementById("statusBar");
        if (statusBar) {
        statusBar.style.display = "block";
        }

    progressBar.value = 5;
    progressText.innerText = "Collecting Gantt data...";
    await new Promise(r => setTimeout(r, 100));

    const workbook = new ExcelJS.Workbook();
    const sheet = workbook.addWorksheet("Gantt Chart");

    const tasks = gantt.serialize().data;

    // Find date range
    const allDates = tasks.flatMap(t => [new Date(t.start_date), new Date(t.end_date)]);
    const minDate = new Date(Math.min(...allDates));
    const maxDate = new Date(Math.max(...allDates));

    const dateRange = [];
    const dayInMs = 24 * 60 * 60 * 1000;
    for (let d = new Date(minDate); d <= maxDate; d = new Date(d.getTime() + dayInMs)) {
      dateRange.push(formatDate(d));
    }

    progressBar.value = 20;
    progressText.innerText = "Generating header...";
    await new Promise(r => setTimeout(r, 100));

    // Create headers
    const fixedHeaders = [
      "ID", "Task / Project Name", "Project Code", "Project Type", "Section Type",
      "Customer Name", "Assigned User", "Start Date", "End Date", "Duration",
      "Progress (%)", "Progress Bar", "Parent"
    ];
    const headers = [...fixedHeaders, ...dateRange];
    sheet.addRow(headers);

    progressBar.value = 40;
    progressText.innerText = "Writing tasks...";
    await new Promise(r => setTimeout(r, 100));

    tasks.forEach((task, index) => {
      const progressPercent = Math.round((task.progress || 0) * 100);
      const rowData = [
        task.id || '',
        task.text || '',
        task.project_code || '',
        task.project_type || '',
        task.section_type || '',
        task.customer_name || '',
        task.user_name || '',
        task.start_date || '',
        task.end_date || '',
        task.duration || '',
        progressPercent + '%',
        getTextProgressBar(task.progress || 0),
        task.parent || ''
      ];
      const progressColor = task.progress === 1 ? '#4CAF50' : // Green for complete
  task.progress > 0.5 ? '#FFEB3B' : // Yellow for in-progress
  task.progress === 0 ? '#2196F3' : // Blue for planned tasks
  '#F44336'; // Red for delayed tasks

      // Fill Gantt timeline (colored bars for progress)
      const taskStart = new Date(task.start_date);
      const taskEnd = new Date(task.end_date);
      const timeline = dateRange.map(dateStr => {
        const current = new Date(dateStr);
        if (current < taskStart) return "";  // Before start
        if (current > taskEnd) return "";    // After end
        return current >= taskStart && current <= taskEnd ? "█" : "";
      });

      const row = sheet.addRow([...rowData, ...timeline]);

      // Applying Data Bar for Duration (timeline)
      const startIndex = headers.length - dateRange.length;
      timeline.forEach((cell, i) => {
  const cellRef = row.getCell(startIndex + i + 1);
  if (cell === "█") {
    cellRef.fill = {
      type: 'pattern',
      pattern: 'solid',
      fgColor: { argb: progressColor.replace('#', '') }, // Color hex code in ARGB format
    };
 
          
          // Data Bar Style (for duration)
          cellRef.conditionalFormats = [{
            type: 'dataBar',
            priority: 1,
            dataBar: {
              color: 'FF00FF00',  // Green for duration progress
              showValue: true,
              minLength: 0,
              maxLength: 100,
              barDirection: 'rightToLeft',
            },
          }];
        }
      });

      // Optional: update progress and file status in progress bar
      if (index % 5 === 0) {
        progressBar.value = 40 + Math.floor((index / tasks.length) * 40);
        progressText.innerText = `Writing task ${index + 1} of ${tasks.length}...`;
      }
    });

    progressBar.value = 85;
    progressText.innerText = "Generating Excel file...";
    await new Promise(r => setTimeout(r, 100));

    const buffer = await workbook.xlsx.writeBuffer();
    const blob = new Blob([buffer], {
      type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
    });

    progressBar.value = 95;
    progressText.innerText = "Saving file...";
    saveAs(blob, "gantt_chart_with_databars.xlsx");

    progressBar.value = 100;
    progressText.innerText = "Download ready!";
    setTimeout(() => statusBar.style.display = "none", 3000);
  }
</script>

<script>
    gantt.plugins({
    quick_info: true
});
document.addEventListener('DOMContentLoaded', function () {
    gantt.config.show_task_buttons = true;
    gantt.config.root_id = 0;
    gantt.config.order_branch = true;
    gantt.config.order_branch_free = true;
    gantt.config.buttons_left = ["add"];
    gantt.config.xml_date = "%Y-%m-%d %H:%i:%s";

    gantt.config.buttons_right = [];

    gantt.config.grid_resize = true;

    const allColumns = {
        text: { name: "text", label: "Task / Project Name", tree: true, width: 250, resize: true },
        project_code: { name: "project_code", label: "Project Code", align: "center", width: 150, resize: true },
        customer_name: { name: "customer_name", label: "Customer Name", align: "center", width: 150, resize: true },
        user_name: { name: "user_name", label: "Assigned User Name", align: "center", width: 150, resize: true },
        start_date: { name: "start_date", label: "Start Date", align: "center", width: 120, resize: true },
        end_date: { name: "end_date", label: "End Date", align: "center", width: 120, resize: true },
        duration: { name: "duration", label: "Duration", align: "center", width: 100, resize: true }
    };
    gantt.plugins({ tooltip: true });

// gantt.templates.tooltip_text = function(start, end, task) {
//     return `
//         <b>Task Name:</b> ${task.text}<br/>
//         <b>Project Code:</b> ${task.project_code}<br/>
//         <b>Customer Name:</b> ${task.customer_name}<br/>
//         <b>Assigned User:</b> ${task.user_name}<br/>
//         <b>Start:</b> ${task.start_date}<br/>
//         <b>End:</b> ${task.end_date}<br/>
//         <b>Duration:</b> ${task.duration}
//     `;
// };

    // Tooltip template
    // gantt.templates.tooltip_text = function(start, end, task) {
    //     return `
    //         <b>Name:</b> ${task.text}<br/>
    //         <b>Start:</b> ${task.start_date}<br/>
    //         <b>Duration:</b> ${task.duration} days<br/>
    //         <b>Project Code:</b> ${task.project_code ?? 'N/A'}<br/>
    //         <b>Customer Name:</b> ${task.customer_name ?? 'N/A'}<br/>
    //         <b>Assigned User Name:</b> ${task.user_name ?? 'N/A'}<br/>
    //         <b>Customer ID:</b> ${task.customer_id ?? 'N/A'}
    //     `;
    // };

    function getRandomColor() {
        const hue = Math.floor(Math.random() * 360);
        return `hsl(${hue}, 70%, 80%)`;
    }

    const tasks = {
        data: <?php echo json_encode($ganttData); ?>

    };

    tasks.data.forEach(task => {
        task.color = getRandomColor();
    });

    gantt.attachEvent("onTaskCreated", function(task){
        task.color = getRandomColor();
        return true;
    });

    gantt.templates.task_class = function () { return ""; };
    gantt.templates.task_attr = function (start, end, task) {
        return `style="background-color: ${task.color}; border: 1px solid ${task.color};"`;
    };
    gantt.templates.task_text = function(start, end, task){
        return `<div style="color: black;">${task.text}</div>`;
    };

    // Dynamic column + grid width handler
    function updateColumns() {
        const checkedValues = Array.from(document.querySelectorAll('.column-toggle:checked')).map(cb => cb.value);
        const selectedColumns = checkedValues.map(col => allColumns[col]).filter(Boolean);
        const columns = [...new Map(selectedColumns.map(col => [col.name, col])).values()];
        gantt.config.columns = columns;

        // Dynamically adjust grid width
        const totalWidth = columns.reduce((sum, col) => sum + (col.width || 100), 0);
        gantt.config.grid_width = totalWidth;
        gantt.render();
    }

    document.querySelectorAll('.column-toggle').forEach(cb => {
        cb.addEventListener('change', updateColumns);
    });

    // Initialize with all columns
    gantt.config.columns = Object.values(allColumns);
    gantt.config.grid_width = gantt.config.columns.reduce((sum, col) => sum + (col.width || 100), 0);
    gantt.init("gantt_here");
    gantt.parse(tasks);

    gantt.attachEvent("onBeforeTaskUpdate", function(id, task) {
        const confirmed = confirm("Are you sure you want to update this task?");
        if (confirmed) {
            updateTaskOnServer(task);
            return true;
        } else {
            return false;
        }
    });

    function updateTaskOnServer(task) {
        fetch('/update-gantt-task', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify(task)
        })
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                alert("Failed to update task on server");
            }
        })
        .catch(error => {
            console.error("Error updating task:", error);
            alert("An error occurred while updating");
        });
    }

    gantt.config.xml_date = "%Y-%m-%d";
});
gantt.attachEvent("onAfterTaskSelected", function(id) {
    setTimeout(function () {
        const qiBox = document.querySelector(".gantt_cal_quick_info");
        const editBtn = qiBox?.querySelector(".icon_edit");

        if (editBtn) {
            editBtn.onclick = function () {
                const task = gantt.getTask(id);
                openEditModal(task);
            };
        }
    }, 0);
});
// function openEditModal(task) {
//     // Create modal HTML
//     const modal = document.createElement("div");
//     modal.className = "custom-modal";
//     modal.innerHTML = `
//         <div class="modal-content">
//             <h2>Edit Task</h2>
//             <label>Task Name:</label><input type="text" id="task_name" value="${task.text}"><br>
//             <label>Project Code:</label><input type="text" id="project_code" value="${task.project_code || ''}"><br>
//             <label>Customer Name:</label><input type="text" id="customer_name" value="${task.customer_name || ''}"><br>
//             <label>Assigned User:</label><input type="text" id="user_name" value="${task.user_name || ''}"><br>
//             <label>Start Date:</label><input type="date" id="start_date" value="${task.start_date}"><br>
//             <label>End Date:</label><input type="date" id="end_date" value="${task.end_date}"><br>
//             <label>Duration:</label><input type="number" id="duration" value="${task.duration || ''}"><br>
//             <button id="save_task">Save</button>
//             <button id="cancel_task">Cancel</button>
//         </div>
//     `;
//     document.body.appendChild(modal);

//     // Handle Save
//     document.getElementById("save_task").onclick = function () {
//         task.text = document.getElementById("task_name").value;
//         task.project_code = document.getElementById("project_code").value;
//         task.customer_name = document.getElementById("customer_name").value;
//         task.user_name = document.getElementById("user_name").value;
//         task.start_date = document.getElementById("start_date").value;
//         task.end_date = document.getElementById("end_date").value;
//         task.duration = +document.getElementById("duration").value;

//         gantt.updateTask(task.id);
//         document.body.removeChild(modal);
//     };

//     // Handle Cancel
//     document.getElementById("cancel_task").onclick = function () {
//         document.body.removeChild(modal);
//     };
// }
  
// Enable project/tasks types
gantt.config.types = {
    project: "project",
    task: "task"
};

// 1️⃣ Single Lightbox definition (all possible fields)
// gantt.config.lightbox.sections = [
//     {name: "description", height: 38, map_to: "text", type: "textarea", focus: true},
//     {name: "customer_name", height: 30, map_to: "customer_name", type: "textarea"},
//     {name: "project_code", height: 30, map_to: "project_code", type: "textarea"},
//     {name: "user_name", height: 30, map_to: "user_name", type: "textarea"},
//     {name: "remarks", height: 50, map_to: "remarks", type: "textarea"},
//     {name: "time", type: "duration", map_to: "auto"}
// ];

// 1️⃣ Lightbox Sections — all fields

// 2️⃣ Lightbox Labels
gantt.locale.labels.section_description = "Name";
gantt.locale.labels.section_customer_name = "Customer Name";
gantt.locale.labels.section_project_code = "Project Code";
gantt.locale.labels.section_user_name = "User Name";
gantt.locale.labels.section_remarks = "Remarks";

// 3️⃣ Project Hierarchy Configuration
gantt.config.order_branch = true;
gantt.config.order_branch_free = true;
gantt.config.open_tree_initially = true;

// 4️⃣ Dynamically show/hide fields based on type
gantt.attachEvent("onBeforeLightbox", function(id){
    const task = gantt.getTask(id);

    // Reset lightbox fields visibility
    gantt.resetLightbox();

    // Get HTML elements of fields
    const customerNameBlock = gantt.getLightboxSection('customer_name').node;
    const projectCodeBlock  = gantt.getLightboxSection('project_code').node;
    const userNameBlock     = gantt.getLightboxSection('user_name').node;

    if(task.type === gantt.config.types.project){
        customerNameBlock.style.display = "";
        projectCodeBlock.style.display = "none";
        userNameBlock.style.display = "none";
    } else {
        customerNameBlock.style.display = "none";
        projectCodeBlock.style.display = "";
        userNameBlock.style.display = "";
    }

    return true;
});


// gantt.attachEvent("onTaskCreated", function(task){
//     // Detect if it's root → project OR child → task
//     if(task.parent == gantt.config.root_id || task.parent == 0){
//         task.type = gantt.config.types.project;
//         task.customer_name = "";
//         task.remarks = "";
//     } else {
//         task.type = gantt.config.types.task;
//         task.project_code = "";
//         task.user_name = "";
//         task.remarks = "";
//     }

//     // Don’t auto-add task → just open lightbox
//     tempTaskId = task.id;
//     gantt.showLightbox(task.id);
//     return false; // Prevent auto-adding
// });

</script>
<script>
    
// ✅ Set custom buttons before initializing Gantt
gantt.config.buttons_left = ["save_btn"];
gantt.config.buttons_right = ["dhx_cancel_btn"];

// ✅ Set custom labels
gantt.locale.labels["save_btn"] = "Save";
gantt.locale.labels["dhx_cancel_btn"] = "Cancel";
gantt.attachEvent("onTaskCreated", function(task){
    // Detect if it's root → project OR child → task
    if(task.parent == gantt.config.root_id || task.parent == 0){
        task.type = gantt.config.types.project;
        task.customer_name = "";
        task.remarks = "";
    } else {
        task.type = gantt.config.types.task;
        task.project_code = "";
        task.user_name = "";
        task.remarks = "";
    }

    // Don’t auto-add task → just open lightbox
    tempTaskId = task.id;
    gantt.showLightbox(task.id);
    return false; // Prevent auto-adding
});
// 3️⃣ Handle Add button → Open Lightbox first (without creating task immediately)
let tempTaskId = null;

gantt.attachEvent("onLightboxSave", function(id, taskData, is_new){
    if (is_new && tempTaskId === id) {
        const task = gantt.getTask(id);

        // Fill required fields manually here if needed

        gantt.addTask(task, task.parent);
        tempTaskId = null; // reset
    }
    return true;
});
gantt.config.lightbox.sections = [
    {name: "description", height: 38, map_to: "text", type: "textarea", focus: true},
    {name: "customer_name", height: 30, map_to: "customer_name", type: "textarea"},
    {name: "project_code", height: 30, map_to: "project_code", type: "textarea"},
    {name: "user_name", height: 30, map_to: "user_name", type: "textarea"},
    {name: "remarks", height: 50, map_to: "remarks", type: "textarea"},
    {name: "time", type: "duration", map_to: "auto"}
];


gantt.attachEvent("onLightboxButton", function(button_id, node, e){
    if(button_id === "save_btn"){
        var task = gantt.getTask(gantt.getState().lightbox);

        // ✅ Correct way to get values from lightbox fields
        var text = gantt.getLightboxSection("description").getValue();
        var customer_name = gantt.getLightboxSection("customer_name").getValue();
        var project_code = gantt.getLightboxSection("project_code").getValue();
        var user_name = gantt.getLightboxSection("user_name").getValue();
        var remarks = gantt.getLightboxSection("remarks").getValue();

        var timeValues = gantt.getLightboxSection("time").getValue();
        var duration = timeValues.duration;
        var start_date = timeValues.start_date;

        console.log({
            text, customer_name, project_code, user_name, remarks, duration, start_date
        });

        fetch(`/update-gantt-task/${task.id}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                text: text,
                start_date: start_date,
                duration: duration,
                customer_name: customer_name,
                project_code: project_code,
                user_name: user_name,
                progress: task.progress
                // remarks not sent
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update task object manually with new values
                task.text = text;
                task.start_date = start_date;
                task.duration = duration;
                task.customer_name = customer_name;
                task.project_code = project_code;
                task.user_name = user_name;
                // task.remarks = remarks; // optional

                gantt.hideLightbox();
                gantt.refreshTask(task.id);
                alert("Task updated successfully!");
            } else {
                alert("Error updating task.");
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert("Error updating task.");
        });

        return true;
    }
    return false;
});
</script>
</body>
</html><?php /**PATH D:\ganttproject\manage\resources\views/gantt.blade.php ENDPATH**/ ?>