DHTMLX Connector for Yii2
========================

dhtmlxConnector is an extension for the DHTMLX library, which maps client-side 
components onto the server-side datasource. Supported components are:

  * [dhtmlxTree](http://dhtmlx.com/docs/products/dhtmlxTree/index.shtml)
  * [dhtmlxGrid](http://dhtmlx.com/docs/products/dhtmlxGrid/index.shtml)
  * [dhtmlxTreeGrid](http://dhtmlx.com/docs/products/dhtmlxTreeGrid/index.shtml)
  * [dhtmlxCombo](http://dhtmlx.com/docs/products/dhtmlxCombo/index.shtml)
  * [dhtmlxDataView](http://dhtmlx.com/docs/products/dhtmlxDataView/index.shtml)
  * [dhtmlxScheduler](http://dhtmlx.com/docs/products/dhtmlxScheduler/index.shtml)
  * [dhtmlx touch](http://dhtmlx.com/touch/)

You don't need to worry about data formats any more. dhtmlxConnector will handle
data connections between the server-side database and client-side components,
seamlessly loading content. When integrated with dhtmlxDataProcessor on the 
client side, dhtmlxConnector also takes care of update/insert/delete operations.

It organizes server-side functionality to support special modes for components 
working with large amounts of data (such as dynamic loading, Smart Rendering, 
and paging) as well as server-side sorting and filtering.

External links
--------------
  * Documentation  - http://docs.dhtmlx.com/doku.php?id=dhtmlxconnector:toc
  * Video introduction - http://dhtmlx.com/docs/products/dhtmlxConnector/index.shtml


Other languages
---------------
  * Java - [wiki](http://docs.dhtmlx.com/doku.php?id=dhtmlxconnectorjava:toc),
           [package](http://www.dhtmlx.com/x/download/regular/dhtmlxConnector_v09_java.zip)
  * .Net - [wiki](http://docs.dhtmlx.com/doku.php?id=dhtmlxconnectornet:toc), 
           [package](http://www.dhtmlx.com/x/download/regular/dhtmlxConnector_v09_net.zip)
  * ColdFustion - [wiki](http://docs.dhtmlx.com/doku.php?id=dhtmlxconnectorcf:toc), 
                  [package](http://www.dhtmlx.com/x/download/regular/dhtmlxConnector_v10_cfm.zip)
