<?php
namespace Dhtmlx\Connector\Data;

class DataUpdate {

    protected $table; //!< table , where actions are stored
    protected $url; //!< url for notification service, optional
    protected $sql; //!< DB wrapper object
    protected $config; //!< DBConfig object
    protected $request; //!< DBRequestConfig object
    protected $event;
    protected $item_class;
    protected $demu;

    //protected $config;//!< DataConfig instance
    //protected $request;//!< DataRequestConfig instance

    /*! constructor

      @param connector
         Connector object
      @param config
         DataConfig object
      @param request
         DataRequestConfig object
    */
    function __construct($sql, $config, $request, $table, $url, $options){
        $this->config= $config;
        $this->request= $request;
        $this->sql = $sql;
        $this->table=$table;
        $this->url=$url;
        $this->demu = false;
        $this->options = $options;
    }

    public function set_demultiplexor($path){
        $this->demu = $path;
    }

    public function set_event($master, $name){
        $this->event = $master;
        $this->item_class = $name;
    }

    protected function select_update($actions_table, $join_table, $id_field_name, $version, $user) {
        $sql = "SELECT $join_table.*, {$actions_table}.id, {$actions_table}.dataId, {$actions_table}.type as action_table_type, {$actions_table}.user FROM  {$actions_table}";
        $sql .= " LEFT OUTER JOIN {$join_table} ON ";
        $sql .= "{$actions_table}.DATAID = {$join_table}.{$id_field_name} ";
        $sql .= "WHERE {$actions_table}.ID > '{$version}' AND {$actions_table}.USER <> '{$user}'";
        return $sql;
    }

    protected function get_update_max_version() {
        $sql = "SELECT MAX(id) as VERSION FROM {$this->table}";
        $res = $this->sql->query($sql);
        $data = $this->sql->get_next($res);

        if ($data == false || $data['VERSION'] == false)
            return 1;
        else
            return $data['VERSION'];
    }

    private function log_update_action($actions_table, $dataId, $status, $user) {
        $sql = "INSERT INTO {$actions_table} (DATAID, TYPE, USER) VALUES ('{$dataId}', '{$status}', '{$user}')";
        $this->sql->query($sql);
        if ($this->demu)
            file_get_contents($this->demu);
    }

    public function get_table() {
        return $this->table;
    }



    /*! records operations in actions_table
        @param action
            DataAction object
    */
    public function log_operations($action) {
        $type = 	$this->sql->escape($action->get_status());
        $dataId = 	$this->sql->escape($action->get_new_id());
        $user = 	$this->sql->escape($this->request->get_user());
        if ($type!="error" && $type!="invalid" && $type !="collision") {
            $action_mode = $this->request->get_action_mode();
            if(!empty($action_mode))
                $type .= "#".$action_mode;

            $this->log_update_action($this->table, $dataId, $type, $user);
        }
    }


    /*! return action version in XMl format
    */
    public function get_version() {
        $version = $this->get_update_max_version();
        return "<userdata name='version'>".$version."</userdata>";
    }


    /*! adds action version in output XML as userdata
    */
    public function version_output($conn, $out) {
        $out->add($this->get_version());
    }


    /*! create update actions in XML-format and sends it to output
    */
    public function get_updates() {
        $sub_request = new DataRequestConfig($this->request);
        $version =	$this->request->get_version();
        $user = 	$this->request->get_user();

        $sub_request->parse_sql($this->select_update($this->table, $this->request->get_source(), $this->config->id['db_name'], $version, $user));
        $sub_request->set_relation(false);

        $output = $this->render_set($this->sql->select($sub_request), $this->item_class);

        ob_clean();
        header("Content-type:text/xml");

        echo $this->updates_start();
        echo $this->get_version();
        echo $output;
        echo $this->updates_end();
    }


    protected function render_set($res, $name){
        $output="";
        $index=0;
        while ($data=$this->sql->get_next($res)){
            $data = new DataItemUpdate($data,$this->config,$index, $name);
            $this->event->trigger("beforeRender",$data);
            $output.=$data->to_xml();
            $index++;
        }
        return $output;
    }

    /*! returns update start string
    */
    protected function updates_start() {
        $start = '<updates>';
        return $start;
    }

    /*! returns update end string
    */
    protected function updates_end() {
        $start = '</updates>';
        return $start;
    }

    /*! checks if action version given by client is deprecated
        @param action
            DataAction object
    */
    public function check_collision($action) {
        $version =	$this->sql->escape($this->request->get_version());
        //$user = 	$this->sql->escape($this->request->get_user());
        $last_version = $this->get_update_max_version();
        if (($last_version > $version)&&($action->get_status() == 'update')) {
            $action->error();
            $action->set_status('collision');
        }
    }
}