<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use File;
use App\Models\User;
use App\Models\Role;
use App\Models\Exercise;

class ExerciseController extends Controller
{ 

    public function store(Request $request)
    {
        Log::info('Incoming request:', $request->all());
        Log::info('Uploaded files:', $request->allFiles()); // Log all received files
    
        $request->validate([
            'ex_name' => 'required|string|max:255',
            'video' => 'required|file|mimes:mp4,mov,avi,wmv|max:102400' // Ensure video is uploaded
        ]);
    
        if (!$request->hasFile('video')) {
            Log::error('No video file received!');
            return response()->json(['success' => false, 'message' => 'No video file uploaded!'], 400);
        }
    
        // 🔹 Generate ex_path dynamically based on ex_name
        $baseDir = public_path("assets/exercise/" . $request->ex_name);
        $this->createDirectories($baseDir); // Create directory if not exists
    
        // Move uploaded video
        $videoFile = $request->file('video');
        $videoName = time() . '_' . $videoFile->getClientOriginalName();
        $videoFile->move($baseDir, $videoName);
        
        // 🔹 Store the correct relative path
        $videoPath = "assets/exercise/" . $request->ex_name . '/' . $videoName;
    
        // Log the generated ex_path
        Log::info('Generated ex_path:', ['ex_path' => $videoPath]);
    
        // Insert into database
        DB::table('exercise')->insert([
            'ex_name' => $request->ex_name,
            'ex_path' => $videoPath, // Store dynamically generated ex_path
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    
        return response()->json([
            'success' => true,
            'message' => 'Exercise and video saved successfully!',
            'ex_path' => $videoPath, // Send the ex_path in response
            'video_url' => asset($videoPath) // Send back full video URL
        ]);
    }
    
    /**
     * Create necessary directories for an exercise.
     */
    private function createDirectories($basePath)
    {
        if (!File::exists($basePath)) {
            File::makeDirectory($basePath, 0755, true);
        }
    }
    
/**
 * Create necessary directories for an exercise.
 */
// private function createDirectories($basePath)
// {
//     $directories = [
        
//         '/pilates_videos',
//     ];

//     foreach ($directories as $dir) {
//         $fullPath = $basePath . $dir;
//         if (!File::exists($fullPath)) {
//             File::makeDirectory($fullPath, 0755, true);
//         }
//     }
// }

    public function index()
    {
		return view('dashboards.exercise');
        
    }
	
    public function create()
    {
       
    }

   

    public function edit($id)
    {
       
    }

    public function update(Request $request, $id)
    {
        
    }
    public function indexfordownload()
    {
        $exercises = DB::table('exercise')->get();
        //Log::info($exercises);
        return view('laravel.users.exercise', compact('exercises'));
        
    }
    public function destroy($id)
    {
        
    }
}
    
  