<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;

class FileController extends Controller
{
    public function uploadForm()
    {
        return view('upload');
    }

    public function upload(Request $request)
    {
        // Validate the uploaded file
        $request->validate([
            'file' => 'required|file|mimes:txt',
        ]);

        $file = $request->file('file');
        $path = $file->getRealPath();
        $data = file_get_contents($path);

        // Process the file content
        $lines = explode("\n", $data);
        $parsedData = $this->parseData($lines);

        // Pass the parsed data to the view
        return view('data', ['data' => $parsedData]);
    }

    private function parseData($lines)
    {
        $parsed = [];
        $headers = [];
        $values = [];
        $isHeader = true;

        foreach ($lines as $line) {
            // Remove extra spaces and line breaks
            $line = trim($line);
            
            // Skip empty lines
            if (empty($line)) {
                continue;
            }

            // Extract values from the line
            if (preg_match_all('/"([^"]+)"/', $line, $matches)) {
                if ($isHeader) {
                    // First line is assumed to be headers
                    $headers = $matches[1];
                    $isHeader = false;
                } else {
                    // Subsequent lines are values
                    $values[] = $matches[1];
                }
            }
        }

        // Combine headers and values
        foreach ($values as $row) {
            // Ensure the number of headers and values match
            if (count($headers) === count($row)) {
                $parsed[] = array_combine($headers, $row);
            }
        }

        return $parsed;
    }
}