<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Role;
use App\Models\Groups; 
use App\Models\GroupChat;


class GroupSessionController extends Controller
{
   

    public function index()
    {
          $teachers = User::where('role_id', 2)->get();
        $students = User::where('role_id', 3)->get();
    
     
        return view('laravel.session.create_groupsession', compact('teachers', 'students'));
    }

    public function store(Request $request)
    {
        Log::info('Incoming request:', $request->all());
    
        // Check if student_ids exist
        if ($request->has('student_ids') && is_array($request->student_ids) && count($request->student_ids) > 0) {
            $studentData = [];
    
            // Insert a record for each student
            foreach ($request->student_ids as $studentId) {
                $studentData[] = [
                    'grp_name' => $request->group_name,
                    'date' => $request->date,
                    'starting_time' => $request->starting_time, 
                    'end_time' => $request->end_time,
                    'teacher_id' => $request->teacher_id,
                    'student_id' => $studentId,  // Assign student ID properly
                    'created_user' => Auth::id(),
                    'created_at' => now(),
                    'updated_at' => now()
                ];
            }
    
            // Insert all entries at once
            DB::table('group')->insert($studentData);
    
            return response()->json([
                'success' => true,
                'message' => 'Group session created successfully with students!',
            ]);
        } else {
            // If no students are provided, insert a single group entry without student_id
            DB::table('group')->insert([
                'grp_name' => $request->group_name,
                'date' => $request->date,
                'starting_time' => $request->starting_time, 
                'end_time' => $request->end_time,
                'teacher_id' => $request->teacher_id,
                'created_user' => Auth::id(),
                'created_at' => now(),
                'updated_at' => now()
            ]);
    
            return response()->json([
                'success' => true,
                'message' => 'Group session created successfully without students!',
            ]);
        }
    }
    
    public function stores_chat(Request $request)
    {
        $request->validate([
            'from_user_id' => 'required|exists:users,id',
            'grp_id' => 'required|exists:group_chat,id',
            'chat_message' => 'required|string|max:500'
        ]);

        $message = DB::table('group_chat')->insert([
            'from_user_id' => $request->from_user_id,
            'grp_id' => $request->grp_id,
            'chat_message' => $request->chat_message,
            'message_status' => 'sent', // You can change this logic as needed
            'date' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
        Log::info($message."___________");
        if ($message) {
            return response()->json(['success' => true, 'message' => 'Message sent successfully.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Failed to send message.'], 500);
        }
    }

}
