<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Role;

class HomeController extends Controller
{
    public function index()
    {
		return view('dashboards.home');
    }
    public function automotive()
    {
		return view('dashboards.automotive');
    }
        public function showDashboard()
    {
        // Get the authenticated student_id
        $student_id = Auth::id();
        $today = Carbon::today()->toDateString();

        // Fetch the group details (grp_name and starting_time) from the 'group' table
        $group = DB::table('group')
            ->where('student_id', $student_id)
            ->select('grp_name', 'starting_time','end_time','date')
            ->first(); // Fetch the first record's grp_name and starting_time

        // Check if a group is found, otherwise set default values
        $grp_name = $group ? $group->grp_name : 'No Group Available';
        $starting_time = $group ? $group->starting_time : null;
        $end_time = $group ? $group->end_time : null;
        $date = $group ? $group->date : null;

        // Log the group data for debugging purposes
        Log::info(json_encode($group));

        // Pass the grp_name and starting_time to the view
        return view('dashboards.automotive', compact('grp_name', 'starting_time','end_time','date'));
    }
    public function create()
    {
       
    }
    public function groupredirect()
    {
        return view('dashboards.homes');
    }
    // public function joinGroup($id)
    // {
    //     $groupName = DB::table('group')
    //         ->where('id', $id)
    //         ->select('grp_name')  // Select only the name
    //         ->distinct()  // Ensure unique names
    //         ->first(); // Fetch only one unique name
        
    //     if (!$groupName) {
    //         return redirect()->route('homes')->with('error', 'Group not found.');
    //     }
    
    //     return view('dashboards.homes', compact('groupName'));
    // }
    public function joinGroup($id)
    {
        $group = DB::table('group')->where('id', $id)->first(); // Fetch single group

        if (!$group) {
            return redirect()->route('homes')->with('error', 'Group not found.');
        }
        Log::info(json_encode($group));
        // Perform any logic needed to add the user to the group (e.g., saving to a pivot table)

        return view('dashboards.homes', compact('group'));
    }
    public function feedbackupdate(Request $request)
    {
        // Find the latest active session for the authenticated user
        $feedback = DB::table('camera_status')
            ->where('user_id', Auth::id())
            ->where('start_off', 1) // Check for active session
            ->orderBy('id', 'desc') // Get the latest entry
            ->first(); // Fetch the first record

        if ($feedback) {
            // Update the record using query builder
            DB::table('camera_status')
                ->where('id', $feedback->id)
                ->update(['start_off' => 0]); // Mark session as ended

            return response()->json(['message' => 'Call ended, feedback updated!']);
        }

        return response()->json(['error' => 'No active session found'], 404);
    }

    public function showStudents()
    {
        // // Fetch student_id and corresponding name from 'users' table
        // $students = DB::table('group')
        //     ->join('users', 'group.student_id', '=', 'users.id') // Assuming `users.id` is the primary key
        //     ->select('group.student_id', 'users.firstname')
        //     ->get();

        // // If no students found, return an array with `student_id: 0` and `name: "No User"`
        // if ($students->isEmpty()) {
        //     $students = collect([ (object) ['student_id' => 0, 'name' => 'No User'] ]);
        // }

        // return view('dashboards.home', compact('students'));



        $userId = Auth::id(); // Get the logged-in user's ID
        Log::info('User ID: ' . $userId);

        if (!$userId) {
            return redirect()->route('login')->with('error', 'You must be logged in.');
        }

        // Fetch groups where either student_id or teacher_id matches the authenticated user
        $groups = DB::table('group')
            ->where(function ($query) use ($userId) {
                $query->where('student_id', $userId)
                      ->orWhere('teacher_id', $userId);
            })
            ->select('grp_name', 'id')
            ->get();

        if ($groups->isEmpty()) {
            return redirect()->back()->with('error', 'No groups found.');
        }

        return view('dashboards.home', ['groups' => $groups]); // Pass the groups to the view
    }
    
    
    
    // public function getStudents()
    // {
    //     $students = DB::table('group')
    //     ->join('users', 'group.student_id', '=', 'users.id')
    //     ->join('camera_status', 'group.student_id', '=', 'camera_status.user_id')
    //     ->select(
    //         'group.student_id',
    //         'group.teacher_id',
    //         'users.firstname',
    //         DB::raw('MAX(IF(camera_status.start_off = 1, 1, 0)) as is_active') // Ensure we capture any 1 values
    //     )
    //     ->groupBy('group.student_id', 'users.firstname') // Group by student ID to get all records
    //     ->get();


    //     if ($students->isEmpty()) {
    //         return response()->json([['student_id' => 0, 'firstname' => 'No User', 'is_active' => 0]]);
    //     }

    //     return response()->json($students);
    // }
    public function getStudents()
    {
        $students = DB::table('group')
            ->join('users as students', 'group.student_id', '=', 'students.id')
            ->join('users as teachers', 'group.teacher_id', '=', 'teachers.id')
            ->leftJoin('camera_status as student_camera', 'group.student_id', '=', 'student_camera.user_id') // Check student camera status
            ->leftJoin('camera_status as teacher_camera', 'group.teacher_id', '=', 'teacher_camera.user_id') // Check teacher camera status
            ->select(
                'group.teacher_id',
                'teachers.firstname as teacher_name',
                'teachers.avatar as teacher_avatar',
                DB::raw("IF(teacher_camera.start_off = 1, 1, 0) as teacher_active"), // Check if teacher is active
                DB::raw("GROUP_CONCAT(CONCAT(students.id, ':', students.firstname, ':', IF(student_camera.start_off = 1, 1, 0)) SEPARATOR '|') as students_list")
            )
            ->groupBy('group.teacher_id', 'teachers.firstname', 'teachers.avatar', 'teacher_active')
            ->get();
    
        return response()->json($students);
    }
    

    
    

    public function chats()
    {
        $LoggedAdminInfo = User::find(session('LoggedAdminInfo'));
        if (!$LoggedAdminInfo) {
            return redirect()->route('admin.login')->with('fail', 'You must be logged in to access the dashboard');
        }
    
        // Fetch chats where the admin is either the sender or the receiver
        $chats = Chat::with(['senderProfilee', 'receiverProfilee', 'senderSellerProfile', 'receiverSellerProfile'])
            ->where('sender_id', $LoggedAdminInfo->id)
            ->orWhere('receiver_id', $LoggedAdminInfo->id)
            ->get();
    
        // Combine both results and remove duplicates
        $allChats = $chats->map(function($chat) use ($LoggedAdminInfo) {
            if ($chat->sender_id == $LoggedAdminInfo->id) {
                if ($chat->receiverProfilee) {
                    $chat->user_id = $chat->receiver_id;
                    $chat->profile = $chat->receiverProfilee;
                } else {
                    $chat->user_id = $chat->receiver_id;
                    $chat->profile = $chat->receiverSellerProfile;
                }
            } else {
                if ($chat->senderProfilee) {
                    $chat->user_id = $chat->sender_id;
                    $chat->profile = $chat->senderProfilee;
                } else {
                    $chat->user_id = $chat->sender_id;
                    $chat->profile = $chat->senderSellerProfile;
                }
            }
            return $chat;
        })->unique('user_id')->values();
    
        // Pass the logged-in admin's information and chats to the view
        return view('dashboards.chats', [
            'LoggedAdminInfo' => $LoggedAdminInfo,
            'chats' => $allChats
        ]);
    }
    public function store(Request $request)
    {
        // Validate incoming request data
        $validated = $request->validate([
            'user_id' => 'required|integer|exists:users,id', // Validate user ID exists
            'grp_id' => 'required|integer|exists:group,id', // Validate group ID exists
            'date' => 'required|date', // Ensure date is valid and provided
        ]);
    
        // Fetch the group and teacher_id based on grp_id
        $group = DB::table('group')->where('id', $validated['grp_id'])->first();
     $now=Carbon::now()->toDateString();
        // Ensure group exists and fetch the teacher_id
        if (!$group) {
            return response()->json(['error' => 'Group not found'], 404);
        }
    
        // Now, you have the teacher_id from the group
        $teacher_id = $group->teacher_id;
    
        // Insert into the feedback table manually using the DB facade
        DB::table('camera_status')->insert([
            'user_id' => $validated['user_id'],
            'grp_id' => $validated['grp_id'],
            // 'teacher_id' => $teacher_id, // Insert teacher_id
            'start_off' => true, // Assuming this field means the video and mic have started
            'date' => $now, // Insert the date from the request
            
        ]);
    
        // Return a success response
        return response()->json(['message' => 'Feedback inserted successfully']);
    }

    public function edit($id)
    {
       
    }

    public function update(Request $request, $id)
    {
        
    }

    public function destroy($id)
    {
        
    }
}
