<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Role;
use App\Models\Shape;
use App\Models\User_Shape;
use App\Models\GroupChat;
class IndividualSessionController extends Controller
{
	public function index()
    {
        $questions = DB::table('question_master as qm')
            ->leftJoin('qus_answer as qa', 'qm.id', '=', 'qa.q_id')
            ->leftJoin('answer_master as am', 'qa.ans_id', '=', 'am.id')
            ->where('qm.grp_id', 4)
            ->select('qm.id as question_id', 'qm.question', 'qa.ans_id', 'am.answer')
            ->get();
        // Log::info($questions);
        return view('laravel.session.individualsession', compact('questions'));
    }
    public function fetchShapes(Request $request)
    {
        $shapesList = Shape::all();

        $selectedShapesList = DB::table('user_shape')
                        ->where('user_id',$request->input('userId'))
                        ->get();

        return response()->json(array('success' => true,'shapes' => $shapesList,'selectedshapes' => $selectedShapesList),200);
    }
	public function saveshapes(Request $request)
    {
        $selectedShapes =  json_decode($request->input('selectedShapes'));
        $userId = $request->input('userId');

        $deleteShapes =  DB::table('user_shape')
                        ->where('user_id',$userId)
                        ->delete();

        foreach($selectedShapes as $shape)
        {
            $userShape = new User_Shape();

            $userShape->user_id = $userId;
            $userShape->shape_id = $shape->shape_id;
            $userShape->pain_level = $shape->pain_level;

            $userShape->save();
        }


        return response()->json(array('success' => true,'message' => 'Saved Successfully'),200);
    }
    public function individualsession_result()
{
    $teacherId = Auth::id(); // Get the logged-in teacher's ID

    // Retrieve unique groups where the teacher is assigned
    $groups = DB::table('group')
        ->where('teacher_id', $teacherId)
        ->select('groups as group_id', 'grp_name')
        ->distinct() // Ensure unique groups
        ->get();

    // Fetch students for each group
    foreach ($groups as $group) {
        $group->students = DB::table('users')
            ->whereIn('id', function ($query) use ($group) {
                $query->select('student_id')
                    ->from('group')
                    ->where('grp_name', $group->grp_name); // Group by grp_name
            })
            ->select('id as student_id', 'firstname', 'lastname')
            ->get();
    }

    return view('laravel.session.individualsessionresult',  compact('groups'));
}
// public function getStudentAnswers(Request $request) {
//     $userId = $request->input('user_id');
//     $grpId = $request->input('grp'); // Retrieve group ID
//     Log::info('Request received', ['userId' => $userId, 'grpId' => $grpId]);

//     // ✅ Fetch the group ID
//     $grp = DB::table('group')
//              ->where('groups', $grpId)
//              ->pluck('id');
//                // Convert collection to an array

//     Log::info('Fetched group IDs', ['group_ids' => $grp]);

//     // ✅ Fetch related question IDs
//     $questions = DB::table('question_master')
//                    ->whereIn('grp_id', $grp) 
//                    ->pluck('id')
//                    ->toArray();

//     Log::info('Fetched question IDs', ['question_ids' => $questions]);

//     // ✅ Fetch all user answers related to those questions
//     $userAnswers = DB::table('user_answer')
//                      ->whereIn('qs_id', $questions)
//                      ->get();

//     Log::info('Fetched user answers', ['user_answers' => $userAnswers]);

//     $answers = [];
//     foreach ($userAnswers as $answer) {
//         $answerData = DB::table('answer_master')
//                         ->select('id', 'answer') // Ensure correct fields are selected
//                         ->where('id', $answer->ans_id)
//                         ->first();
    
//         Log::info('Fetched user answerData', [
//             'id' => $answerData->id ?? 'N/A',
//             'answer' => $answerData->answer?? 'N/A',
            
//         ]);
    
//         // if ($answerData && isset($answerData->answer_type)) {
//         //     $answers[] = [
//         //         'question_id' => $answer->qs_id, 
//         //         'answer_id' => $answer->ans_id, 
//         //         'text' => $answerData->answer ?? '' 
//         //     ];
//         // }
//     }
//     return response()->json(array('success' => true,'answerData' => $answerData),200);
//     // Log::info('Processed answers', ['answers' => $answers]);
// }

public function getStudentAnswers(Request $request) {
    $userId = $request->input('user_id');
    $grpId = $request->input('grp'); // Retrieve group ID

    Log::info('Request received', ['userId' => $userId, 'grpId' => $grpId]);

    // Fetch group IDs
    $grp = DB::table('group')
             ->where('groups', $grpId)
             ->pluck('id');

    Log::info('Fetched group IDs', ['group_ids' => $grp]);

    // Fetch related question IDs
    $questions = DB::table('question_master')
                   ->whereIn('grp_id', $grp)
                   ->get(); // Get full question details

    Log::info('Fetched questions', ['questions' => $questions]);

    $questionAnswers = [];

    foreach ($questions as $question) {
        $userAnswer = DB::table('user_answer')
                        ->where('qs_id', $question->id)
                        ->where('std_id', $userId) // Fetch answers for the specific student
                        ->first();

        if ($userAnswer) {
            $answerData = DB::table('answer_master')
                            ->select('id', 'answer')
                            ->where('id', $userAnswer->ans_id)
                            ->first();

            Log::info('Fetched answer data', [
                'question_id' => $question->id,
                'question_text' => $question->question ?? '', // Ensure question text is returned
                'answer' => $answerData->answer ?? 'N/A',
            ]);

            $questionAnswers[] = [
                'question_id' => $question->id,
                'question_text' => $question->question ?? '',
                'answer' => $answerData->answer ?? 'N/A',
            ];
        }
    }

    Log::info('Final Response', ['response' => $questionAnswers]);
    return response()->json([
        'success' => true,
        'questions' => $questionAnswers,
    ], 200);
    
}
// public function store(Request $request)
// {
//     if ($request->expectsJson()) {  // Ensure it's an API request
//         return response()->json(['error' => 'Invalid request type'], 400);
//     }

//     $request->validate([
//         'from_user_id' => 'required|exists:users,id',
//         'grp_id' => 'required|exists:group,id',
//         'chat_message' => 'required|string|max:500'
//     ]);

 
//         $message = DB::table('group_chat')->insert([
//         'from_user_id' => $request->from_user_id,
//         'grp_id' => $request->grp_id,
//         'chat_message' => $request->chat_message,
//         'message_status' => 'sent',
//         'date' => now(),
//         'updated_at' => now()
//     ]);

//     return response()->json(['success' => true, 'message' => 'Message sent successfully.']);
// }
public function store(Request $request)
{
    $request->validate([
        'from_user_id' => 'required|exists:users,id',
        'grp_id' => 'required|exists:group,id',
        'chat_message' => 'required|string|max:500'
    ]);

    $message =    DB::table('group_chat')->insert([
        'from_user_id' => $request->from_user_id,
        'grp_id' => $request->grp_id,
        'chat_message' => $request->chat_message,
        'message_status' => 'sent',
        'date' => now(),
        'updated_at' => now()
    ]);

    return response()->json(['success' => true, 'message' => 'Message sent successfully.']);
}

public function fetchMessagesFromUserToGroup(Request $request)
{
    Log::info($request);
    $receiverId = $request->input('receiver_id');
    $sellerId =  Auth::id();
    Log::info($sellerId."===========");
    $messages = Chat::with([
        'sender:id,avatar,firstname,lastname', 
        'receiver:id,avatar,firstname,lastname'
    ])
    ->where(function($query) use ($sellerId, $receiverId) {
        $query->where('sender_id', $sellerId)
              ->where('receiver_id', $receiverId);
    })
    ->orWhere(function($query) use ($sellerId, $receiverId) {
        $query->where('sender_id', $receiverId)
              ->where('receiver_id', $sellerId);
    })
    ->orderBy('created_at', 'asc')
    ->get();

    Log::info($messages."===========");
    return response()->json(['messages' => $messages]);
}
}