<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\useranswer;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


class UserAnswerController extends Controller
{

        public function store(Request $request)
        {
            $user_id = Auth::id(); // Get the authenticated user ID
         // Get current timestamp
            $now = Carbon::now()->toDateString(); // Only date (YYYY-MM-DD)
            // Store selected checkbox answers
            if ($request->selected_answers) {
                foreach ($request->selected_answers as $qs_id => $ans_ids) {
                    foreach ($ans_ids as $ans_id) {
                                            
                        DB::table('user_answer')->insert([
                            'group_id' => 1,
                            'teacher_id' => 1,
                            'std_id' => $user_id,
                            'qs_id' => $qs_id,
                            'ans_id' => $ans_id, // Selected answer ID
                            'text' => null, // No text for checkboxes
                            'updated_by' => $user_id,
                            'created_at' => $now,
                            'date' => $now,
                            'updated_at' => $now,
                        ]);


                    }
                }
            }

            // Store text answers (ans_id = 6)
            if ($request->text_answers) {
                foreach ($request->text_answers as $qs_id => $text) {
                    if (!empty($text)) {
                        DB::table('user_answer')->insert([
                            'group_id' => 1,
                            'teacher_id' => 1,
                            'std_id' => $user_id,
                            'qs_id' => $qs_id,
                            'ans_id' => 6, // Fixed ans_id for text answers
                            'text' => $text, // Save user input
                            'updated_by' => $user_id,
                            'created_at' => $now,
                            'updated_at' => $now,
                        ]);
                    }
                }
            }

            return redirect()->back()->with('success', 'Answers submitted successfully!');
        }


}
