<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use App\Models\User;
use App\Models\Role;

class UserController extends Controller
{
    // public function index(User $model)
    // {
    //     $this->authorize('manage-users', User::class);
    //     return view('laravel.users.index', ['users' => $model->all()]);
    // }
    // public function index(User $model)
    // {
    //     // if (auth()->user()->role === 'admin') {
    //         $this->authorize('manage-users', User::class); // Only admins
    //     // } else {
    //     //     $this->authorize('manage-students', User::class); // Admins & teachers
    //     // }
    //     Log::info($model);
    //     return view('laravel.users.index', ['users' => $model->all()]);
    // }
    public function index(User $model)
{
    $this->authorize('manage-users', User::class); // Authorization check

    $users = $model->all(); // Fetch users as Eloquent models
    Log::info($users );
    return view('laravel.users.index', ['users' => $users]);
}


    public function create()
    {
        $roles = Role::all();
        return view('laravel.users.create', compact('roles'));
    }

    public function store(Request $request)
    {
        $attributes = request()->validate([
            'firstname' => ['required'],
            'email' => ['required', 'unique:users', 'email'],
            'confirmation' => ['same:email'],
            'password' => ['required', 'min:5'],
            'confirm-password' => ['same:password'],
            'role' => ['required'],
            'image' => ['image'],
            'phone' => ['max:10']
        ]);

        if($request->get('choices-year') || $request->get('choices-month') || $request->get('choices-day'))
        {
            $birthday = $request->get('choices-year').'-'.$request->get('choices-month').'-'.$request->get('choices-day');
        }
        else{
            $birthday = null;
        }

        $user = User::create([
            'firstname' => $request->get('firstname'),
            'lastname' => $request->get('lastname'),
            'password' => $request->get('password'),
            'role_id' => $request->get('role'),
            'email' => $request->get('email'),
            'gender' => $request->get('gender'),
            'location' => $request->get('location'),
            'phone' => $request->get('phone'),
            'language' => $request->get('language'),
            'birthday' => $birthday,
            'skills' => $request->get('skills')
        ]);

        // if($request->file('avatar')) {
        //     $user->update([
        //         'avatar' => $request->file('avatar')->store('/', 'avatars')
        //     ]);
        // }
        if ($request->hasFile('avatar')) {
            // Store the image inside storage/app/public/avatars
            $avatarPath = $request->file('avatar')->store('avatars', 'public');
            Log::info($avatarPath);
          
            $user->update(['avatar' => $avatarPath]);
        }

        return redirect()->route('users-management')->with('succes', 'User succesfully saved');
    }

    public function edit($id)
    {
        $this->authorize('manage-users', User::class);
        $user = User::find($id);
        $roles = Role::all();

        $birthday = $user->birthday;
        if(!empty($birthday))
        {
            $year = Carbon::createFromFormat('Y-m-d', $birthday)->format('Y');
            $day = Carbon::createFromFormat('Y-m-d', $birthday)->format('d');
            $month = Carbon::createFromFormat('Y-m-d', $birthday)->format('m');
            $birthdayArray = array(
                "year" => $year,
                "day" => $day,
                "month" =>$month
              );
        }
        else{
            $birthdayArray = array(
                'year' => 0,
                'day' => 0,
                'month' => 0
              );

        }

        return view ('laravel.users.edit', compact('user', 'roles', 'birthdayArray'));
    }

    public function update(Request $request, $id)
    {
        $user = User::find($id);

        $attributes = request()->validate([
            'firstname' => ['required'],
            'email' => ['required', 'email',  Rule::unique('users')->ignore($user->id)],
            'confirmation' => [],
            'password' => [],
            'confirm-password' => ['same:password'],
            'role' => ['required'],
            'image' => ['image'],
            'phone' => ['max:10']
        ]);

        if($request->get('choices-year') || $request->get('choices-month') || $request->get('choices-day'))
        {
            $birthday = $request->get('choices-year').'-'.$request->get('choices-month').'-'.$request->get('choices-day');
        }
        else{
            $birthday = null;
        }

        $user ->update([
            'firstname' => $request->get('firstname'),
            'lastname' => $request->get('lastname'),
            'password' => $request->get('password'),
            'role_id' => $request->get('role'),
            'email' => $request->get('email'),
            'gender' => $request->get('gender'),
            'location' => $request->get('location'),
            'phone' => $request->get('phone'),
            'language' => $request->get('language'),
            'birthday' => $birthday,
            'skills' => $request->get('skills')
        ]);

        if($request->file('avatar')) {
            $user->update([
                'avatar' => $request->file('avatar')->store('/', 'avatars')
            ]);
        }

        return redirect()->route('users-management')->with('succes', 'User succesfully updated');
    }

    public function destroy($id)
    {
        $user = User::find($id);
        $user->delete();
        return redirect()->route('users-management')->with('succes', 'The user was succesfully deleted');
    }

    
    // public function chats()
    // {
    //     $userId = session('LoggedUserInfo');
    //     $LoggedUserInfo = User::find($userId);
    
    //     if (!$LoggedUserInfo) {
    //         return redirect('user/login')->with('fail', 'You must be logged in to access the dashboard');
    //     }
    
    //     // Retrieve all admins
    //     $admins = Admin::all();
    
    //     return view('laravel.users.chats', [
    //         'LoggedUserInfo' => $LoggedUserInfo,
    //         'admins' => $admins // Pass only admins to the view
    //     ]);
    // }

    
    public function chats()
    {
        Log::info("Chats method reached"); 
    
        
    
        $userId = Auth::id(); 

        $LoggedUserInfo = User::find($userId);
    
        if (!$LoggedUserInfo) {
            return redirect('user/login')->with('fail', 'You must be logged in to access the dashboard');
        }
    
        $admins = User::all();
        Log::info("Chats method reached".$admins); 
        return view('laravel.users.chats', compact('LoggedUserInfo', 'admins'));
    }
}
