@extends('layouts.app')

@section('content')
    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg  px-0 mx-4 shadow-none border-radius-xl z-index-sticky " id="navbarBlur"
        data-scroll="false">
        <div class="container-fluid py-1 px-3">
            @include('layouts.navbars.auth.topnav', ['title' => 'Default'])
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none ">
                <a href="javascript:;" class="nav-link p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                        <input type="text" class="form-control" placeholder="Type here...">
                    </div>
                </div>
                <ul class="navbar-nav  justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        @include('auth.logout')
                    </li>
                    <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                            <div class="sidenav-toggler-inner">
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                            </div>
                        </a>
                    </li>
                    <li class="nav-item px-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0">
                            <i class="fa fa-cog fixed-plugin-button-nav cursor-pointer"></i>
                        </a>
                    </li>
                    <li class="nav-item position-relative pe-2 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-bell cursor-pointer"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end px-2 py-3 me-sm-n4" aria-labelledby="dropdownMenuButton">
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/team-2.jpg" class="avatar avatar-sm  me-3 "
                                                alt="user image">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New message</span> from Laur
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                13 minutes ago
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/small-logos/logo-spotify.svg"
                                                class="avatar avatar-sm bg-gradient-dark  me-3 " alt="logo spotify">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New album</span> by Travis Scott
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                1 day
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="avatar avatar-sm bg-gradient-secondary  me-3  my-auto">
                                            <svg width="12px" height="12px" viewBox="0 0 43 36" version="1.1"
                                                xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink">
                                                <title>credit-card</title>
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <g transform="translate(-2169.000000, -745.000000)" fill="#FFFFFF"
                                                        fill-rule="nonzero">
                                                        <g transform="translate(1716.000000, 291.000000)">
                                                            <g transform="translate(453.000000, 454.000000)">
                                                                <path class="color-background"
                                                                    d="M43,10.7482083 L43,3.58333333 C43,1.60354167 41.3964583,0 39.4166667,0 L3.58333333,0 C1.60354167,0 0,1.60354167 0,3.58333333 L0,10.7482083 L43,10.7482083 Z"
                                                                    opacity="0.593633743"></path>
                                                                <path class="color-background"
                                                                    d="M0,16.125 L0,32.25 C0,34.2297917 1.60354167,35.8333333 3.58333333,35.8333333 L39.4166667,35.8333333 C41.3964583,35.8333333 43,34.2297917 43,32.25 L43,16.125 L0,16.125 Z M19.7083333,26.875 L7.16666667,26.875 L7.16666667,23.2916667 L19.7083333,23.2916667 L19.7083333,26.875 Z M35.8333333,26.875 L28.6666667,26.875 L28.6666667,23.2916667 L35.8333333,23.2916667 L35.8333333,26.875 Z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </svg>
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                Payment successfully completed
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                2 days
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- End Navbar -->
    <div class="card mx-1 my-1 mt-1 pt-1" id="basic-info">
    <div class="card-header mx-1 pt-1">
        <h5>Create Group Session</h5>
        <input type="hidden" id="UserId" name="UserId" value="{{ auth()->user()->id }}">
    </div>

    <div class="card-body mt-1 pt-1">
        <div class="row">
            <div class="col-lg-1"></div>

			<div class="col-lg-2 mt-2">
    <label class="form-label">Exercise Name</label>
    <div class="input-group">
        <span class="input-group-text text-body"><i class="fas fa-dumbbell" aria-hidden="true"></i></span>
        <input type="text" class="form-control" id="ex_name" name="ex_name" placeholder="Exercise Name...">
    </div>
    <p id="ex_name_error" class='text-danger text-xs pt-1 errmsg'></p>
</div>
<div class="col-lg-4 mt-2">
    <label class="form-label">Upload</label>
    <div class="input-group">
        <span class="input-group-text text-body">
            <i class="fas fa-upload" aria-hidden="true"></i>
        </span>
        <input type="file" class="form-control" id="file_upload" name="file_upload" onchange="showFileName()">
    </div>
    <p id="file_upload_error" class='text-danger text-xs pt-1 errmsg'></p>
    <p id="selected_file_name" class="text-muted mt-1"></p> <!-- File name display -->
</div>
<div class="d-flex justify-content-center mt-4">
    <button id="addExerciseBtn" class="btn btn-success" onclick="addExercise()" type="button">
        Add Exercise
    </button>
</div>

    </div>

@endsection
<script>
let formData = new FormData();
formData.append('_token', csrf_token);
formData.append('ex_name', 'wwq');
formData.append('video', document.getElementById('videoFile').files[0]); 

fetch('/your-upload-route', {
    method: 'POST',
    body: formData
})
.then(response => response.json())
.then(data => console.log(data))
.catch(error => console.error('Error:', error));



$(document).ready(function () {
    console.log("inside");
    // Initialize selectpicker
    $('.selectpicker').selectpicker();

    // Click event for the Add button
    $("#addGroupBtn").on("click", function () {
        addGroup();
    });
});

// Function to handle group creation
// function addGroup() {
//     console.log("inside");
//     // Clear previous error messages
//     $('.errmsg').text('');

//     let userId = $('#UserId').val();
//     let date = $('#date').val();
//     let teacher = $('#teacher').val();
//     let students = $('#students').val();

//     // Validate inputs
//     if (!date) {
//         $('#date_error').text('Date is required.');
//         return;
//     }
//     if (!teacher) {
//         $('#teacher_error').text('Teacher is required.');
//         return;
//     }
//     if (!students || students.length === 0) {
//         $('#student_error').text('At least one student must be selected.');
//         return;
//     }

//     // AJAX request
//     $.ajax({
//         url: "{{ route('groups.store') }}", // Laravel route for storing groups
//         type: "POST",
//         data: {
//             _token: "{{ csrf_token() }}", // CSRF token for security
//             user_id: userId,
//             date: date,
//             teacher_id: teacher,
//             student_ids: students
//         },
//         success: function (response) {
//             if (response.success) {
//                 alert("Group session created successfully!");
//                 location.reload(); // Refresh page or redirect
//             } else {
//                 alert("Something went wrong. Please try again.");
//             }
//         },
//         error: function (xhr) {
//             console.log(xhr.responseText);
//             alert("Error occurred while saving.");
//         }
//     });
// }
// Function to handle group creation
// function addGroup() {
//     console.log("inside");
//     // Clear previous error messages
//     $('.errmsg').text('');

//     let userId = $('#UserId').val();
//     let groupName = $('#group_name').val(); // Get group name
//     let date = $('#date').val();
//     let teacher = $('#teacher').val();
//     let students = $('#students').val();

//     // Validate inputs
//     if (!groupName) {
//         $('#group_name_error').text('Group Name is required.');
//         return;
//     }
//     if (!date) {
//         $('#date_error').text('Date is required.');
//         return;
//     }
//     if (!teacher) {
//         $('#teacher_error').text('Teacher is required.');
//         return;
//     }
//     if (!students || students.length === 0) {
//         $('#student_error').text('At least one student must be selected.');
//         return;
//     }
function addExercise() {
    console.log("Adding Exercise...");
    $('.errmsg').text('');

    let exName = $('#ex_name').val();
    let fileInput = $('#file_upload')[0].files[0];

    if (!exName) {
        $('#ex_name_error').text('Exercise Name is required.');
        return;
    }

    if (!fileInput) {
        $('#file_upload_error').text('Video file is required.');
        return;
    }

    let formData = new FormData();
    formData.append('_token','{{csrf_token()}}'); // Ensure CSRF token is available
    formData.append('ex_name', exName);
    formData.append('video', fileInput); // Send the file
    

    $.ajax({
        url: "{{ route('exercises.store') }}", // Ensure this matches your Laravel route
        type: "POST",
        data: formData,
        processData: false,  // Important for file upload
        contentType: false,  // Important for file upload
        success: function (response) {
            console.log("Success:", response);
            alert("Exercise and video saved successfully!");
            location.reload();
        },
        error: function (xhr) {
            console.log("Error:", xhr.responseText);
            alert("Error occurred while saving. Check console for details.");
        }
    });
}

    // AJAX request
//     $.ajax({
//         url: "{{ route('groups.store') }}", // Laravel route for storing groups
//         type: "POST",
//         data: {
//             _token: "{{ csrf_token() }}", // CSRF token for security
//             user_id: userId,
//             group_name: groupName, // Include group name
//             date: date,
//             teacher_id: teacher,
//             student_ids: students
//         },
//         success: function (response) {
//             if (response.success) {
//                 alert("Group session created successfully!");
//                 location.reload(); // Refresh page or redirect
//             } else {
//                 alert("Something went wrong. Please try again.");
//             }
//         },
//         error: function (xhr) {
//             console.log(xhr.responseText);
//             alert("Error occurred while saving.");
//         }
//     });
// }
// $.ajax({
//     url: "{{ route('groups.store') }}",
//     type: "POST",
//     data: {
//         _token: "{{ csrf_token() }}",
//         group_name: $('#group_name').val(),
//         date: $('#date').val(),
//         teacher_id: $('#teacher').val(),
//         student_ids: $('#students').val()
//     },
//     success: function (response) {
//         console.log("Success:", response);
//         alert("Group session created successfully!");
//         location.reload();
//     },
//     error: function (xhr) {
//         console.log("Error:", xhr.responseText);
//         alert("Error occurred while saving. Check console for details.");
//     }
// });
// }

</script>

	
@push('js')
    <script src="../../assets/js/plugins/chartjs.min.js"></script>
	<script src="/assets/js/core/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

	<script src="../../assets/js/paper/paper.js"></script>
    <script>
        $(document).ready(function(){
			
		})	
    </script>
	<!-- Bootstrap Select JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

@endpush

<style>
	<!-- Bootstrap Select CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.min.css">

</style>