@extends('layouts.app')

@section('content')
    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg  px-0 mx-4 shadow-none border-radius-xl z-index-sticky " id="navbarBlur"
        data-scroll="false">
        <div class="container-fluid py-1 px-3">
            @include('layouts.navbars.auth.topnav', ['title' => 'Default'])
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none ">
                <a href="javascript:;" class="nav-link p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                        <input type="text" class="form-control" placeholder="Type here...">
                    </div>
                </div>
                <ul class="navbar-nav  justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        @include('auth.logout')
                    </li>
                    <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                            <div class="sidenav-toggler-inner">
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                            </div>
                        </a>
                    </li>
                    <li class="nav-item px-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0">
                            <i class="fa fa-cog fixed-plugin-button-nav cursor-pointer"></i>
                        </a>
                    </li>
                    <li class="nav-item position-relative pe-2 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-bell cursor-pointer"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end px-2 py-3 me-sm-n4" aria-labelledby="dropdownMenuButton">
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/team-2.jpg" class="avatar avatar-sm  me-3 "
                                                alt="user image">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New message</span> from Laur
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                13 minutes ago
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/small-logos/logo-spotify.svg"
                                                class="avatar avatar-sm bg-gradient-dark  me-3 " alt="logo spotify">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New album</span> by Travis Scott
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                1 day
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="avatar avatar-sm bg-gradient-secondary  me-3  my-auto">
                                            <svg width="12px" height="12px" viewBox="0 0 43 36" version="1.1"
                                                xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink">
                                                <title>credit-card</title>
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <g transform="translate(-2169.000000, -745.000000)" fill="#FFFFFF"
                                                        fill-rule="nonzero">
                                                        <g transform="translate(1716.000000, 291.000000)">
                                                            <g transform="translate(453.000000, 454.000000)">
                                                                <path class="color-background"
                                                                    d="M43,10.7482083 L43,3.58333333 C43,1.60354167 41.3964583,0 39.4166667,0 L3.58333333,0 C1.60354167,0 0,1.60354167 0,3.58333333 L0,10.7482083 L43,10.7482083 Z"
                                                                    opacity="0.593633743"></path>
                                                                <path class="color-background"
                                                                    d="M0,16.125 L0,32.25 C0,34.2297917 1.60354167,35.8333333 3.58333333,35.8333333 L39.4166667,35.8333333 C41.3964583,35.8333333 43,34.2297917 43,32.25 L43,16.125 L0,16.125 Z M19.7083333,26.875 L7.16666667,26.875 L7.16666667,23.2916667 L19.7083333,23.2916667 L19.7083333,26.875 Z M35.8333333,26.875 L28.6666667,26.875 L28.6666667,23.2916667 L35.8333333,23.2916667 L35.8333333,26.875 Z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </svg>
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                Payment successfully completed
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                2 days
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- End Navbar -->
    <div class="card mx-1 my-1 mt-1 pt-1" id="basic-info">
    <div class="row">
        <!-- Start Video & Mic Button -->
        <button id="startButton" class="btn btn-success btn-sm">Start Video & Mic</button>
    </div>
</div>
<div class="card">

<div class="d-flex justify-content-between">
    <!-- Left Card -->
    <div class="card" id="fullcard" style="width: 35%;">
    
        <div class="card-header"><b>Connected User</b></div>
        
                <div class="card-body" id="user_list">
                    <p>Click "Start Video & Mic" to load users.</p>
                
                    <button id="toggle_audio" class="btn btn-warning btn-sm" disabled>Mute</button>
                    <h4>Group Name: {{ $group->grp_name }}</h4>
                    <pre>{{ print_r($group, true) }}</pre> {{-- Debugging output --}}

                    <h4>Group Name Not Found</h4>
                </div>
            </div>

    <!-- Right Card -->
    <div class="card" id="livechat" style="width: 58%;">
        <div class="card-header">
            <div class="row">
           
                <div class="col-md-6"><b>Live Video Chat</b></div>
                <div class="col-md-6 text-right">
                    <button id="toggle_video" class="btn btn-primary btn-sm" disabled>Turn Video Off</button>
                    <button id="toggle_audio" class="btn btn-warning btn-sm" disabled>Mute</button>
                    <button id="close_video" class="btn btn-danger btn-sm" disabled>End Call</button>
                </div>
            </div>
        </div>
        <div class="card-body">
            <video id="webcam" autoplay playsinline width="100%" height="auto"></video>
        </div>
    </div>

                <div class="card" style="height:255px; width: 38%;overflow-y: scroll;">
                    <div class="card-header">
                        <input type="text" class="form-control" placeholder="Search User..." autocomplete="off" id="search_people" onkeyup="search_user('{{ Auth::id() }}', this.value);" />
                    </div>
                    <div class="card-body">
                        <div id="search_people_area" class="mt-3"></div>
                    </div>
                </div>
                <br />
                <div class="card" style="height:255px; overflow-y: scroll;">
                    <div class="card-header"><b>Notification</b></div>
                    <div class="card-body">
                        <ul class="list-group" id="notification_area">

                        </ul>
                    </div>
                </div>
            

</div>

</div>
            <!-- <div class="col-sm-4 col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col col-md-6" id="chat_header"><b>Chat Area</b></div>
                            <div class="col col-md-6" id="close_chat_area"></div>
                        </div>
                    </div>
                    <div class="card-body" id="chat_area">

                    </div>
                </div>
            </div> -->
            <!-- <div class="col-sm-4 col-lg-6">
                <div class="card">for camera
                    <div class="card-header">
                        <div class="row">
                            <div class="col col-md-6" id="chat_header"><b>Webcam Area</b></div>
                            <div class="col col-md-6 text-right">
                                <button id="close_chat_area" class="btn btn-danger btn-sm">Close</button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body" id="chat_area">
                        <video id="webcam" autoplay playsinline width="100%" height="auto"></video>
                    </div>
                </div>
            </div> -->
            <!-- <div class="col-sm-4 col-lg-6"> for video
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-md-6" id="chat_header"><b>Live Video</b></div>
                            <div class="col-md-6 text-right">
                                <button id="toggle_video" class="btn btn-primary btn-sm">Turn Off</button>
                                <button id="close_video" class="btn btn-danger btn-sm">Close</button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body" id="chat_area">
                        <video id="webcam" autoplay playsinline width="100%" height="auto"></video>
                    </div>
                </div>
            </div> -->

            {{----}}
        </div>
    </div>
@endsection

@push('css')
    <style>
        .card{
            padding: 20px;
            margin-top: 10px;
        }
        #connectedcard{
            margin-left: 50px;
            margin-top: 20px;
            height: auto;
            width: 400px;
        }
        #fullcard{
            height: auto;
            margin-left: 20px;
            margin-top: 30px
        }
        #livechat{
            height: ;
            width: ;
            margin-right: 30px;
            margin-top: 30px

        }
        #chat_area
        {
            min-height: 500px;
            /*overflow-y: scroll*/;
        }

        #chat_history
        {
            min-height: 500px;
            max-height: 500px;
            overflow-y: scroll;
            margin-bottom:16px;
            background-color: #ece5dd;
            padding: 16px;
        }

        #user_list
        {
            min-height: 500px;
            max-height: 500px;
            overflow-y: scroll;
        }

    </style>
@endpush

@push('js')
    <script src="../../assets/js/plugins/chartjs.min.js"></script>
    <script src="/assets/js/core/jquery.min.js"></script>
    <script src="../../assets/js/paper/paper.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function(){

        })

        var conn = new WebSocket('ws://127.0.0.1:8090/?token={{ auth()->user()->token }}');

        var from_user_id = "{{ Auth::user()->id }}";

        var to_user_id = "";

        conn.onopen = function(e){

            console.log("Connection established!");

            load_unconnected_user(from_user_id);

            load_unread_notification(from_user_id);

            load_connected_chat_user(from_user_id);

        };

        conn.onmessage = function(e){

            var data = JSON.parse(e.data);

            if(data.image_link)
            {
                //Display Code for uploaded Image

                document.getElementById('message_area').innerHTML = `<img src="{{ asset('images/`+data.image_link+`') }}" class="img-thumbnail img-fluid" />`;
            }

            if(data.status)
            {
                var online_status_icon = document.getElementsByClassName('online_status_icon');

                for(var count = 0; count < online_status_icon.length; count++)
                {
                    if(online_status_icon[count].id == 'status_'+data.id)
                    {
                        if(data.status == 'Online')
                        {
                            online_status_icon[count].classList.add('text-success');

                            online_status_icon[count].classList.remove('text-danger');

                            document.getElementById('last_seen_'+data.id+'').innerHTML = 'Online';
                        }
                        else
                        {
                            online_status_icon[count].classList.add('text-danger');

                            online_status_icon[count].classList.remove('text-success');

                            document.getElementById('last_seen_'+data.id+'').innerHTML = data.last_seen;
                        }
                    }
                }
            }

            if(data.response_load_unconnected_user || data.response_search_user)
            {
                var html = '';

                if(data.data.length > 0)
                {
                    html += '<ul class="list-group">';

                    for(var count = 0; count < data.data.length; count++)
                    {
                        var user_image = '';

                        if(data.data[count].user_image != '')
                        {
                            user_image = `<img src="{{ asset('images/') }}/`+data.data[count].user_image+`" width="40" class="rounded-circle" />`;
                        }
                        else
                        {
                            user_image = `<img src="{{ asset('images/avathar.png') }}" width="40" class="rounded-circle" />`
                        }

                        html += `
                        <li class="list-group-item">
                            <div class="row">
                                <div class="col col-9">`+user_image+`&nbsp;`+data.data[count].name+`</div>
                                <div class="col col-3">
                                    <button type="button" name="send_request" class="btn btn-primary btn-sm float-end" onclick="send_request(this, `+from_user_id+`, `+data.data[count].id+`)"><i class="fas fa-paper-plane"></i>Send</button>
                                </div>
                            </div>
                        </li>
                        `;
                    }

                    html += '</ul>';
                }
                else
                {
                    html = 'No User Found';
                }

                document.getElementById('search_people_area').innerHTML = html;
            }

            if(data.response_from_user_chat_request)
            {
                search_user(from_user_id, document.getElementById('search_people').value);

                load_unread_notification(from_user_id);
            }

            if(data.response_to_user_chat_request)
            {
                load_unread_notification(data.user_id);
            }

            if(data.response_load_notification)
            {
                var html = '';

                for(var count = 0; count < data.data.length; count++)
                {
                    var user_image = '';

                    if(data.data[count].user_image != '')
                    {
                        user_image = `<img src="{{ asset('images/') }}/`+data.data[count].user_image+`" width="40" class="rounded-circle" />`;
                    }
                    else
                    {
                        user_image = `<img src="{{ asset('images/no-image.jpg') }}" width="40" class="rounded-circle" />`;
                    }

                    html += `
                    <li class="list-group-item">
                        <div class="row">
                            <div class="col col-8">`+user_image+`&nbsp;`+data.data[count].name+`</div>
                            <div class="col col-4">
                    `;
                    if(data.data[count].notification_type == 'Send Request')
                    {
                        if(data.data[count].status == 'Pending')
                        {
                            html += '<button type="button" name="send_request" class="btn btn-warning btn-sm float-end">Request Send</button>';
                        }
                        else
                        {
                            html += '<button type="button" name="send_request" class="btn btn-danger btn-sm float-end">Request Rejected</button>';
                        }
                    }
                    else
                    {
                        if(data.data[count].status == 'Pending')
                        {
                            html += '<button type="button" class="btn btn-danger btn-sm float-end" onclick="process_chat_request('+data.data[count].id+', '+data.data[count].from_user_id+', '+data.data[count].to_user_id+', `Reject`)"><i class="fas fa-times"></i></button>&nbsp;';
                            html += '<button type="button" class="btn btn-success btn-sm float-end" onclick="process_chat_request('+data.data[count].id+', '+data.data[count].from_user_id+', '+data.data[count].to_user_id+', `Approve`)"><i class="fas fa-check"></i></button>';
                        }
                        else
                        {
                            html += '<button type="button" name="send_request" class="btn btn-danger btn-sm float-end">Request Rejected</button>';
                        }
                    }

                    html += `
                            </div>
                        </div>
                    </li>
                    `;
                }

                document.getElementById('notification_area').innerHTML = html;
            }

            if(data.response_process_chat_request)
            {
                load_unread_notification(data.user_id);

                load_connected_chat_user(data.user_id);
            }

            if(data.response_connected_chat_user)
            {
                var html = '<div class="list-group">';

                if(data.data.length > 0)
                {
                    for(var count = 0; count < data.data.length; count++)
                    {
                        html += `
                        <a href="#" class="list-group-item d-flex justify-content-between align-items-start" onclick="make_chat_area(`+data.data[count].id+`, '`+data.data[count].name+`'); load_chat_data(`+from_user_id+`, `+data.data[count].id+`); ">
                            <div class="ms-2 me-auto">
                        `;

                        var last_seen = '';

                        if(data.data[count].user_status == 'Online')
                        {
                            html += '<span class="text-success online_status_icon" id="status_'+data.data[count].id+'"><i class="fas fa-circle"></i></span>';

                            last_seen = 'Online';
                        }
                        else
                        {
                            html += '<span class="text-danger online_status_icon" id="status_'+data.data[count].id+'"><i class="fas fa-circle"></i></span>';

                            last_seen = data.data[count].last_seen;
                        }

                        var user_image = '';

                        if(data.data[count].user_image != '')
                        {
                            user_image = `<img src="{{ asset('images/') }}/`+data.data[count].user_image+`" width="35" class="rounded-circle" />`;
                        }
                        else
                        {
                            user_image = `<img src="{{ asset('images/no-image.jpg') }}" width="35" class="rounded-circle" />`;
                        }



                        html += `
                                &nbsp; `+user_image+`&nbsp;<b>`+data.data[count].name+`</b>
                                <div class="text-right"><small class="text-muted last_seen" id="last_seen_`+data.data[count].id+`">`+last_seen+`</small></div>
                            </div>
                            <span class="user_unread_message" data-id="`+data.data[count].id+`" id="user_unread_message_`+data.data[count].id+`"></span>
                        </a>
                        `;
                    }
                }
                else
                {
                    html += 'No User Found';
                }

                html += '</div>';

                document.getElementById('user_list').innerHTML = html;

                check_unread_message();
            }

            if(data.message)
            {
                var html = '';

                if(data.from_user_id == from_user_id)
                {

                    var icon_style = '';

                    if(data.message_status == 'Not Send')
                    {
                        icon_style = '<span id="chat_status_'+data.chat_message_id+'" class="float-end"><i class="fas fa-check text-muted"></i></span>';
                    }
                    if(data.message_status == 'Send')
                    {
                        icon_style = '<span id="chat_status_'+data.chat_message_id+'" class="float-end"><i class="fas fa-check-double text-muted"></i></span>';
                    }

                    if(data.message_status == 'Read')
                    {
                        icon_style = '<span class="text-primary float-end" id="chat_status_'+data.chat_message_id+'"><i class="fas fa-check-double"></i></span>';
                    }

                    html += `
                    <div class="row">
                        <div class="col col-3">&nbsp;</div>
                        <div class="col col-9 alert alert-success text-dark shadow-sm">
                            `+data.message+ icon_style +`
                        </div>
                    </div>
                    `;
                }
                else
                {
                    if(to_user_id != '')
                    {
                        html += `
                        <div class="row">
                            <div class="col col-9 alert alert-light text-dark shadow-sm">
                            `+data.message+`
                            </div>
                        </div>
                        `;

                        update_message_status(data.chat_message_id, from_user_id, to_user_id, 'Read');
                    }
                    else
                    {
                        var count_unread_message_element = document.getElementById('user_unread_message_'+data.from_user_id+'');
                        if(count_unread_message_element)
                        {
                            var count_unread_message = count_unread_message_element.textContent;
                            if(count_unread_message == '')
                            {
                                count_unread_message = parseInt(0) + 1;
                            }
                            else
                            {
                                count_unread_message = parseInt(count_unread_message) + 1;
                            }
                            count_unread_message_element.innerHTML = '<span class="badge bg-primary rounded-pill">'+count_unread_message+'</span>';

                            update_message_status(data.chat_message_id, data.from_user_id, data.to_user_id, 'Send');
                        }
                    }

                }

                if(html != '')
                {
                    var previous_chat_element = document.querySelector('#chat_history');

                    var chat_history_element = document.querySelector('#chat_history');

                    chat_history_element.innerHTML = previous_chat_element.innerHTML + html;
                    scroll_top();
                }

            }

            if(data.chat_history)
            {
                var html = '';

                for(var count = 0; count < data.chat_history.length; count++)
                {
                    if(data.chat_history[count].from_user_id == from_user_id)
                    {
                        var icon_style = '';

                        if(data.chat_history[count].message_status == 'Not Send')
                        {
                            icon_style = '<span id="chat_status_'+data.chat_history[count].id+'" class="float-end"><i class="fas fa-check text-muted"></i></span>';
                        }

                        if(data.chat_history[count].message_status == 'Send')
                        {
                            icon_style = '<span id="chat_status_'+data.chat_history[count].id+'" class="float-end"><i class="fas fa-check-double text-muted"></i></span>';
                        }

                        if(data.chat_history[count].message_status == 'Read')
                        {
                            icon_style = '<span class="text-primary float-end" id="chat_status_'+data.chat_history[count].id+'"><i class="fas fa-check-double"></i></span>';
                        }

                        html +=`
                        <div class="row">
                            <div class="col col-3">&nbsp;</div>
                            <div class="col col-9 alert alert-success text-dark shadow-sm">
                            `+data.chat_history[count].chat_message+ icon_style + `
                            </div>
                        </div>
                        `;


                    }
                    else
                    {
                        if(data.chat_history[count].message_status != 'Read')
                        {
                            update_message_status(data.chat_history[count].id, data.chat_history[count].from_user_id, data.chat_history[count].to_user_id, 'Read');
                        }

                        html += `
                        <div class="row">
                            <div class="col col-9 alert alert-light text-dark shadow-sm">
                            `+data.chat_history[count].chat_message+`
                            </div>
                        </div>
                        `;

                        var count_unread_message_element = document.getElementById('user_unread_message_'+data.chat_history[count].from_user_id+'');

                        if(count_unread_message_element)
                        {
                            count_unread_message_element.innerHTML = '';
                        }
                    }
                }

                document.querySelector('#chat_history').innerHTML = html;

                scroll_top();
            }

            if(data.update_message_status)
            {
                var chat_status_element = document.querySelector('#chat_status_'+data.chat_message_id+'');

                if(chat_status_element)
                {
                    if(data.update_message_status == 'Read')
                    {
                        chat_status_element.innerHTML = '<i class="fas fa-check-double text-primary"></i>';
                    }
                    if(data.update_message_status == 'Send')
                    {
                        chat_status_element.innerHTML = '<i class="fas fa-check-double text-muted"></i>';
                    }
                }

                if(data.unread_msg)
                {
                    var count_unread_message_element = document.getElementById('user_unread_message_'+data.from_user_id+'');

                    if(count_unread_message_element)
                    {
                        var count_unread_message = count_unread_message_element.textContent;

                        if(count_unread_message == '')
                        {
                            count_unread_message = parseInt(0) + 1;
                        }
                        else
                        {
                            count_unread_message = parseInt(count_unread_message) + 1;
                        }

                        count_unread_message_element.innerHTML = '<span class="badge bg-danger rounded-pill">'+count_unread_message+'</span>';
                    }
                }
            }
        };

        function scroll_top()
        {
            document.querySelector('#chat_history').scrollTop = document.querySelector('#chat_history').scrollHeight;
        }

        function load_unconnected_user(from_user_id)
        {
            var data = {
                from_user_id : from_user_id,
                type : 'request_load_unconnected_user'
            };

            conn.send(JSON.stringify(data));
        }

        function search_user(from_user_id, search_query)
        {
            if(search_query.length > 0)
            {
                var data = {
                    from_user_id : from_user_id,
                    search_query : search_query,
                    type : 'request_search_user'
                };

                conn.send(JSON.stringify(data));
            }
            else
            {
                load_unconnected_user(from_user_id);
            }
        }

        function send_request(element, from_user_id, to_user_id)
        {
            var data = {
                from_user_id : from_user_id,
                to_user_id : to_user_id,
                type : 'request_chat_user'
            };

            element.disabled = true;

            conn.send(JSON.stringify(data));
        }

        function load_unread_notification(user_id)
        {
            var data = {
                user_id : user_id,
                type : 'request_load_unread_notification'
            };

            conn.send(JSON.stringify(data));

        }

        function process_chat_request(chat_request_id, from_user_id, to_user_id, action)
        {
            var data = {
                chat_request_id : chat_request_id,
                from_user_id : from_user_id,
                to_user_id : to_user_id,
                action : action,
                type : 'request_process_chat_request'
            };

            conn.send(JSON.stringify(data));
        }

        function load_connected_chat_user(from_user_id)
        {
            var data = {
                from_user_id : from_user_id,
                type : 'request_connected_chat_user'
            };

            conn.send(JSON.stringify(data));
        }

        function make_chat_area(user_id, to_user_name)
        {
            var html = `
            <div id="chat_history"></div>
            <div class="input-group mb-3">
                <div id="message_area" class="form-control" contenteditable style="min-height:125px; border:1px solid #ccc; border-radius:5px;"></div>
                <label class="btn btn-warning" style="line-height:125px;">
                    <i class="fas fa-upload"></i> <input type="file" id="browse_image" onchange="upload_image()" hidden />
                </label>
                <button type="button" class="btn btn-success" id="send_button" onclick="send_chat_message()"><i class="fas fa-paper-plane"></i></button>
            </div>
            `;

            document.getElementById('chat_area').innerHTML = html;

            document.getElementById('chat_header').innerHTML = 'Chat with <b>'+to_user_name+'</b>';

            document.getElementById('close_chat_area').innerHTML = '<button type="button" id="close_chat" class="btn btn-danger btn-sm float-end" onclick="close_chat();"><i class="fas fa-times"></i></button>';

            to_user_id = user_id;
        }

        function close_chat()
        {
            document.getElementById('chat_header').innerHTML = 'Chat Area';

            document.getElementById('close_chat_area').innerHTML = '';

            document.getElementById('chat_area').innerHTML = '';

            to_user_id = '';
        }

        function send_chat_message()
        {
            document.querySelector('#send_button').disabled = true;

            var message = document.getElementById('message_area').innerHTML.trim();

            var data = {
                message : message,
                from_user_id : from_user_id,
                to_user_id : to_user_id,
                type : 'request_send_message'
            };

            conn.send(JSON.stringify(data));

            document.querySelector('#message_area').innerHTML = '';

            document.querySelector('#send_button').disabled = false;
        }

        function load_chat_data(from_user_id, to_user_id)
        {
            var data = {
                from_user_id : from_user_id,
                to_user_id : to_user_id,
                type : 'request_chat_history'
            };

            conn.send(JSON.stringify(data));
        }

        function update_message_status(chat_message_id, from_user_id, to_user_id, chat_message_status)
        {
            var data = {
                chat_message_id : chat_message_id,
                from_user_id : from_user_id,
                to_user_id : to_user_id,
                chat_message_status : chat_message_status,
                type : 'update_chat_status'
            };

            conn.send(JSON.stringify(data));
        }

        function check_unread_message()
        {
            var unread_element = document.getElementsByClassName('user_unread_message');

            for(var count = 0; count < unread_element.length; count++)
            {
                var temp_user_id = unread_element[count].dataset.id;

                var data = {
                    from_user_id : from_user_id,
                    to_user_id : to_user_id,
                    type : 'check_unread_message'
                };

                conn.send(JSON.stringify(data));
            }
        }

        function upload_image()
        {
            var file_element = document.getElementById('browse_image').files[0];

            var file_name = file_element.name;

            var file_extension = file_name.split('.').pop().toLowerCase();

            var allowed_extension = ['png', 'jpg'];

            if(allowed_extension.indexOf(file_extension) == -1)
            {
                alert("Invalid Image File");

                return false;
            }

            var file_reader = new FileReader();

            var file_raw_data = new ArrayBuffer();

            file_reader.loadend = function()
            {

            }

            file_reader.onload = function(event){

                file_raw_data = event.target.result;

                conn.send(file_raw_data);
            }

            file_reader.readAsArrayBuffer(file_element);
        }


    // function loadStudents() {
    //     fetch('/get-students')
    //         .then(response => response.json())
    //         .then(data => {
    //             let userList = document.getElementById('user_list');
    //             userList.innerHTML = "";

    //             if (!data || data.length === 0) {
    //                 userList.innerHTML = "<p>No connected users.</p>";
    //             } else {
    //                 data.forEach(student => {
    //                     console.log("Student Data:", student); // Debugging: check the response
    //                     userList.innerHTML += `<p>ID: ${student.student_id} - Name: ${student.firstname || 'Unknown'}</p>`;
    //                 });
    //             }
    //         })
    //         .catch(error => {
    //             console.error("Fetch error:", error);
    //             document.getElementById('user_list').innerHTML = "<p>Error loading students.</p>";
    //         });
    // }


//     $(document).ready(function() {
//     $('#startButton').click(function() {
//         // Get values for user_id, grp_id, and date (You may adjust this logic based on your app)
//         var user_id = {{ auth()->user()->id }}; // logged-in user ID
//         var grp_id = 1; // Replace with actual group ID logic, this is hardcoded for now
//         var date = new Date().toISOString(); // Current date and time

//         // Send AJAX request to insert into the feedback table
//         $.ajax({
//             url: '{{ route("feedback.store") }}', // Your backend route to handle feedback insertion
//             type: 'POST',
//             data: {
//                 user_id: user_id,
//                 grp_id: grp_id,
//                 date: date,
//                 _token: '{{ csrf_token() }}' // CSRF token for security
//             },
//             success: function(response) {
//                 // Handle successful response
//                 alert('Video & Mic started, feedback inserted!');
//             },
//             error: function(xhr, status, error) {
//                 // Handle error response
//                 console.log(xhr);  // Log the full response object for debugging purposes
//                 console.log(status); // Log the status to see the specific type of error
//                 console.log(error);  // Log the specific error message

//                 // Custom error message based on the error response
//                 if (xhr.status === 500) {
//                     alert('Server error occurred, please try again later.');
//                 } else if (xhr.status === 404) {
//                     alert('Requested resource not found.');
//                 } else if (xhr.status === 403) {
//                     alert('You do not have permission to perform this action.');
//                 } else {
//                     alert('An error occurred while starting video and mic. Please try again.');
//                 }
//             }
//         });
//     });
// });
$(document).ready(function() {
    $('#startButton').click(function() {
        // Get values for user_id, grp_id, and date (You may adjust this logic based on your app)
        var user_id = {{ auth()->user()->id }}; // logged-in user ID
        var grp_id = 1; // Replace with actual group ID logic
        var date = new Date().toISOString(); // Current date and time in ISO format

        // Send AJAX request to insert into the feedback table
        $.ajax({
            url: '{{ route("feedback.store") }}', 
            type: 'POST',
            data: {
                user_id: user_id,
                grp_id: grp_id,
                date: date, // Send the date along with the other data
                _token: '{{ csrf_token() }}' // CSRF token for security
            },
            success: function(response) {
                // Handle successful response
                alert('Video & Mic started, feedback inserted!');
            },
            error: function(xhr, status, error) {
                // Handle error response
                console.log(xhr);  // Log the full response object for debugging purposes
                console.log(status); // Log the status to see the specific type of error
                console.log(error);  // Log the specific error message

                // Custom error message based on the error response
                if (xhr.status === 500) {
                    alert('Server error occurred, please try again later.');
                } else if (xhr.status === 404) {
                    alert('Requested resource not found.');
                } else if (xhr.status === 403) {
                    alert('You do not have permission to perform this action.');
                } else {
                    alert('An error occurred while starting video and mic. Please try again.');
                }
            }
        });
    });
});

    // document.addEventListener("DOMContentLoaded", loadStudents);
    document.getElementById("startButton").addEventListener("click", function() {
        startVideoAndMic();
        loadStudents();
    });

    function loadStudents() {
        fetch('/get-students')
            .then(response => response.json())
            .then(data => {
                let userList = document.getElementById('user_list');
                userList.innerHTML = ""; // Clear previous content

                if (!data || data.length === 0) {
                    userList.innerHTML = "<p>No connected users.</p>";
                } else {
                    userList.innerHTML = `<p><strong>ID - Name</strong></p>`;
                    data.forEach(student => {
                        userList.innerHTML += `<p>${student.student_id} - ${student.firstname || 'Unknown'}</p>`;
                    });
                }
            })
            .catch(error => {
                console.error("Fetch error:", error);
                document.getElementById('user_list').innerHTML = "<p>Error loading students.</p>";
            });
    }

    function startVideoAndMic() {
        let webcamElement = document.getElementById('webcam');
        let startButton = document.getElementById('startButton');
        let toggleVideo = document.getElementById('toggle_video');
        let toggleAudio = document.getElementById('toggle_audio');
        let closeVideo = document.getElementById('close_video');

        navigator.mediaDevices.getUserMedia({ video: true, audio: true })
            .then(function(stream) {
                webcamElement.srcObject = stream;

                // Enable buttons
                toggleVideo.disabled = false;
                toggleAudio.disabled = false;
                closeVideo.disabled = false;

                // Change start button text and disable it
                startButton.innerText = "Live";
                startButton.disabled = true;

                let videoTrack = stream.getVideoTracks()[0];
                let audioTrack = stream.getAudioTracks()[0];

                // Toggle video on/off
                toggleVideo.addEventListener("click", function() {
                    videoTrack.enabled = !videoTrack.enabled;
                    toggleVideo.innerText = videoTrack.enabled ? "Turn Video Off" : "Turn Video On";
                });

                // Toggle audio on/off
                toggleAudio.addEventListener("click", function() {
                    audioTrack.enabled = !audioTrack.enabled;
                    toggleAudio.innerText = audioTrack.enabled ? "Mute" : "Unmute";
                });

                // End call
                closeVideo.addEventListener("click", function() {
                    stream.getTracks().forEach(track => track.stop());
                    webcamElement.srcObject = null;

                    // Reset buttons
                    startButton.disabled = false;
                    startButton.innerText = "Start Video & Mic";
                    toggleVideo.disabled = true;
                    toggleAudio.disabled = true;
                    closeVideo.disabled = true;

                    // Clear the connected users list
                    let userList = document.getElementById('user_list');
                    userList.innerHTML = "<p>Click 'Start Video & Mic' to load users.</p>";
                });
            })
            .catch(function(error) {
                console.error("Error accessing webcam:", error);
                alert("Could not access webcam and microphone. Please allow permissions.");
            });
    }





    //  async function startWebcam() { for image
    //     try {
    //         const stream = await navigator.mediaDevices.getUserMedia({ video: true });
    //         document.getElementById('webcam').srcObject = stream;
    //     } catch (err) {
    //         console.error("Error accessing webcam: ", err);
    //     }
    // }

    // // Start webcam when the page loads
    // window.onload = startWebcam;

    // // Stop webcam when clicking the close button
    // document.getElementById("close_chat_area").addEventListener("click", function() {
    //     const video = document.getElementById('webcam');
    //     const stream = video.srcObject;
    //     if (stream) {
    //         const tracks = stream.getTracks();
    //         tracks.forEach(track => track.stop()); // Stop all webcam tracks
    //     }
    //     video.srcObject = null; // Remove video stream
    // });/////////////////////////////////////
    // let stream; for video

    // // Function to start webcam
    // async function startWebcam() {
    //     try {
    //         stream = await navigator.mediaDevices.getUserMedia({ video: true });
    //         document.getElementById('webcam').srcObject = stream;
    //     } catch (err) {
    //         console.error("Error accessing webcam: ", err);
    //     }
    // }

    // // Function to stop webcam
    // function stopWebcam() {
    //     if (stream) {
    //         let tracks = stream.getTracks();
    //         tracks.forEach(track => track.stop()); // Stop all video tracks
    //     }
    //     document.getElementById('webcam').srcObject = null;
    // }

    // // Toggle video on/off
    // document.getElementById("toggle_video").addEventListener("click", function () {
    //     let videoTrack = stream?.getVideoTracks()[0];
    //     if (videoTrack) {
    //         videoTrack.enabled = !videoTrack.enabled;
    //         this.innerText = videoTrack.enabled ? "Turn Off" : "Turn On";
    //     }
    // });

    // // Close webcam
    // document.getElementById("close_video").addEventListener("click", function () {
    //     stopWebcam();
    // });

    // // Start webcam when the page loads
    // window.onload = startWebcam;///////////////////
    let stream;

    // Start webcam & mic
    async function startMedia() {
        try {
            stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: true });
            document.getElementById('webcam').srcObject = stream;

            // Enable buttons after starting media
            document.getElementById('toggle_video').disabled = false;
            document.getElementById('toggle_audio').disabled = false;
            document.getElementById('close_video').disabled = false;
            document.getElementById('start_video').disabled = true;
        } catch (err) {
            console.error("Error accessing media: ", err);
        }
    }

    // Stop webcam & mic
    function stopMedia() {
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
        }
        document.getElementById('webcam').srcObject = null;

        // Disable buttons when media is stopped
        document.getElementById('toggle_video').disabled = true;
        document.getElementById('toggle_audio').disabled = true;
        document.getElementById('close_video').disabled = true;
        document.getElementById('start_video').disabled = false;
    }

    // Toggle video
    document.getElementById("toggle_video").addEventListener("click", function () {
        let videoTrack = stream?.getVideoTracks()[0];
        if (videoTrack) {
            videoTrack.enabled = !videoTrack.enabled;
            this.innerText = videoTrack.enabled ? "Turn Video Off" : "Turn Video On";
        }
    });

    // Toggle audio
    document.getElementById("toggle_audio").addEventListener("click", function () {
        let audioTrack = stream?.getAudioTracks()[0];
        if (audioTrack) {
            audioTrack.enabled = !audioTrack.enabled;
            this.innerText = audioTrack.enabled ? "Mute" : "Unmute";
        }
    });

    // Close media stream
    document.getElementById("close_video").addEventListener("click", stopMedia);

    // Start media when the user clicks "Start Video & Mic"
    document.getElementById("start_video").addEventListener("click", startMedia);

    </script>

@endpush
