@extends('layouts.app')

@section('content')
    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg  px-0 mx-4 shadow-none border-radius-xl z-index-sticky " id="navbarBlur"
        data-scroll="false">
        <div class="container-fluid py-1 px-3">
            @include('layouts.navbars.auth.topnav', ['title' => 'Default'])
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none ">
                <a href="javascript:;" class="nav-link p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                        <input type="text" class="form-control" placeholder="Type here...">
                    </div>
                </div>
                <ul class="navbar-nav  justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        @include('auth.logout')
                    </li>
                    <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                            <div class="sidenav-toggler-inner">
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                            </div>
                        </a>
                    </li>
                    <li class="nav-item px-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0">
                            <i class="fa fa-cog fixed-plugin-button-nav cursor-pointer"></i>
                        </a>
                    </li>
                    <li class="nav-item position-relative pe-2 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-bell cursor-pointer"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end px-2 py-3 me-sm-n4" aria-labelledby="dropdownMenuButton">
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/team-2.jpg" class="avatar avatar-sm  me-3 "
                                                alt="user image">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New message</span> from Laur
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                13 minutes ago
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/small-logos/logo-spotify.svg"
                                                class="avatar avatar-sm bg-gradient-dark  me-3 " alt="logo spotify">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New album</span> by Travis Scott
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                1 day
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="avatar avatar-sm bg-gradient-secondary  me-3  my-auto">
                                            <svg width="12px" height="12px" viewBox="0 0 43 36" version="1.1"
                                                xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink">
                                                <title>credit-card</title>
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <g transform="translate(-2169.000000, -745.000000)" fill="#FFFFFF"
                                                        fill-rule="nonzero">
                                                        <g transform="translate(1716.000000, 291.000000)">
                                                            <g transform="translate(453.000000, 454.000000)">
                                                                <path class="color-background"
                                                                    d="M43,10.7482083 L43,3.58333333 C43,1.60354167 41.3964583,0 39.4166667,0 L3.58333333,0 C1.60354167,0 0,1.60354167 0,3.58333333 L0,10.7482083 L43,10.7482083 Z"
                                                                    opacity="0.593633743"></path>
                                                                <path class="color-background"
                                                                    d="M0,16.125 L0,32.25 C0,34.2297917 1.60354167,35.8333333 3.58333333,35.8333333 L39.4166667,35.8333333 C41.3964583,35.8333333 43,34.2297917 43,32.25 L43,16.125 L0,16.125 Z M19.7083333,26.875 L7.16666667,26.875 L7.16666667,23.2916667 L19.7083333,23.2916667 L19.7083333,26.875 Z M35.8333333,26.875 L28.6666667,26.875 L28.6666667,23.2916667 L35.8333333,23.2916667 L35.8333333,26.875 Z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </svg>
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                Payment successfully completed
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                2 days
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- End Navbar -->
    <div class="card mx-1 my-1  mt-1 pt-1" id="basic-info">
        <div class="card-header  mx-1 pt-1">
            <h5>Session Form</h5>
            <input type="hidden" id="UserId" name="UserId" value="{{auth()->user()->id}}">
        </div>

        <div class="card-body mt-1 pt-1">
            <div class="row">
                <div class="col-lg-1"></div>
                <div class="col-lg-2  mt-2">
                    <label class="form-label">Date</label>
                    <div>
                        <input type="text" class="form-control" id="date" name="date"
                            placeholder="Date" value="<?php echo date('d-m-Y');?>" >
                    </div>
                    <p id="date_error" class='text-danger text-xs pt-1 errmsg'></p>
                </div>
                <div class="col-lg-4  mt-2">
                    <label class="form-label">Teacher</label>
                    <div>
                        <input type="text" class="form-control" id="teacher" name="teacher"
                            placeholder="Teacher" value="{{ old('teacher') }}" >
                    </div>
                    <p id="date_error" class='text-danger text-xs pt-1 errmsg'></p>
                </div>
                <div class="col-lg-4  mt-2">
                    <label class="form-label">Participant Name</label>
                    <div>
                        <input type="text" class="form-control" id="participant" name="participant"
                            placeholder="Participant Name" value="{{ old('participant') }}" >
                    </div>
                    <p id="date_error" class='text-danger text-xs pt-1 errmsg'></p>
                </div>
                <div class="col-lg-1"></div>
            </div>
            <div class="row">
                <div class="col-lg-1"></div>
                <div class="col-lg-10 mt-1 me-1">
                    <label class="form-label">Please shade in where you having pain or other problems : </label>
                </div>
            </div>
            <div class="row table-responsive">
                <div class="col-lg-3"></div>
                <div class="col-lg-6 table-responsive">
                    <table class="table table-striped" id="workOrderTable">
                        <tbody>
                            <tr class="mt-2">
                                <td class="text-sm text-center font-weight-normal text-middle">
                                    <label class="form-label">Severe</label>
                                    <input type="button" name="severe" id="severe" class="btn btn-sm ms-1 mt-3"
                                    style="background-color:#FF0000;border: 0px solid green;" />

                                    <label class="form-label">Moderate</label>
                                    <input type="button" name="moderate" id="moderate" class="btn btn-sm ms-1 mt-3"
                                    style="background-color:#FF8300;border: 0px solid green;"/>

                                    <label class="form-label">Mild</label>
                                    <input type="button" name="mild" id="mild" class="btn btn-sm ms-1 mt-3"
                                    style="background-color:#FFE400;border: 0px solid green;"/>
                                </td>
                                <td>
                                    <input type="button" name="clear" id="clear"
                                    class="btn btn-secondary btn-sm ms-1 mt-3" value="Clear" />
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="col-lg-3"></div>
            </div>
            <div class="row">
                <div class="col-lg-3"></div>
                <div class="col-lg-6">
                    <canvas id="mycanvas"  width="599" height="721">
                        <img id="anatomy" class="visuallyhidden" src="/assets/img/anatomy.png" >
                    </canvas>
                </div>
                <div class="col-lg-3"></div>
            </div>

            <div id="questionsContainer" style="margin-top: 20px; padding: 10px; border: 1px solid #ccc;">
  
  </div>
           
            <table>

    <thead>

        <tr>

            <h4><center>ABOUT YOURSELF</center>
            </h4>


        </tr>
    </thead>
    <tbody>
        <form action="{{ route('user_answers.store') }}" method="POST">
            @csrf

            @php
                $groupedQuestions = $questions->groupBy('question_id');
            @endphp

            <table>
                @foreach($groupedQuestions as $qs_id => $questionGroup)
                    @php
                        $question = $questionGroup->first();
                        $answers = $questionGroup->whereNotNull('ans_id')->unique('ans_id');
                    @endphp

                    <tr>
                        <td>
                           <h5>  {{ $loop->iteration }}.{{ $question->question }}</h5>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            {{-- Display checkboxes if answers exist --}}
                            <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                                @foreach($answers as $ans)
                                    @if($ans->answer != 'text' && $ans->answer != '6')
                                        <div>
                                            <input type="checkbox" name="selected_answers[{{ $qs_id }}][]" value="{{ $ans->ans_id }}" id="check_{{ $qs_id }}_{{ $loop->index }}">
                                            <label for="check_{{ $qs_id }}_{{ $loop->index }}">{{ $ans->answer }}</label>
                                        </div>
                                    @endif
                                @endforeach
                            </div>

                            {{-- Separate textarea for text answers --}}
                            <div style="margin-top: 10px;">
                                @foreach($answers as $ans)
                                    @if($ans->answer == 'text' || $ans->answer == '6')
                                        <textarea name="text_answers[{{ $qs_id }}]" placeholder="Enter your response" style="display: block; width: 100%; margin-bottom: 5px;"></textarea>
                                    @endif
                                @endforeach
                            </div>
                        </td>
                    </tr>
                @endforeach
            </table>

            {{-- Submit button outside the loop, at the bottom of the form --}}
            <div style="text-align: center; margin-top: 20px;">
                <button type="submit"id="btnSave"name="btnSave" class="btn btn-primary" onclick="">Submit</button>
            </div>
        </form>


    </tbody>
</table>

</table>

@endsection

@push('js')
    <script src="../../assets/js/plugins/chartjs.min.js"></script>
    <script src="/assets/js/core/jquery.min.js"></script>
    <script src="../../assets/js/paper/paper.js"></script>
    <script src="/assets/js/plugins/sweetalert.min.js"></script>
    <script>

    $(document).ready(function() {
        var user_id = @json(auth()->id()); // ✅ Properly encode Laravel variable
        var grp = "pi_001"; // Get selected group ID

        console.log("Selected Student ID:", user_id);
        console.log("Selected Group ID:", grp);

        if (user_id && grp) {
            kelvis(user_id, grp);
        }

        function kelvis(user_id, grp) {
            $.ajax({
                url: '/get-student-answers', // Laravel route to fetch answers
                type: 'GET',
                data: { user_id: user_id, grp: grp }, // ✅ Use data object
                success: function(response) {
                    console.log("Full Response:", response);
                    if (response.success && response.questions.length > 0) {
                        updateFields(response.questions);
                    } else {
                        console.log("No questions available");
                        $('#questionsContainer').html('<p>No questions available.</p>');
                    }
                },
                error: function(error) {
                    console.log("Error fetching data:", error);
                }
            });
        }

        // function updateFields(data) {
        //     $('#questionsContainer').empty(); // Clear previous questions

        //     if (data.length === 0) {
        //         $('#questionsContainer').append('<p>No questions available.</p>');
        //         return;
        //     }

        //     data.forEach(q => {
        //         let questionHTML = `
        //             <div class="question-item">
        //                 <p><strong>${q.question_text}</strong></p>
        //                 <p>Answer: ${q.answer}</p>
        //             </div>
        //         `;
        //         $('#questionsContainer').append(questionHTML);
        //     });
        // }

        function updateFields(data) {
    // Loop through each question in the response
    data.forEach(q => {
        let questionId = q.qs_id; // Assuming 'qs_id' is the question ID
        let answerId = q.ans_id; // Assuming 'ans_id' is the selected answer ID

        
        if (answerId !== null) {
            let checkbox = $(`input[type="checkbox"][name="selected_answers[${questionId}][]"][value="${answerId}"]`);
            if (checkbox.length) {
                checkbox.prop('checked', true);
            }
        }

        // If it's a text answer, fill in the corresponding text area
        if (q.answer === 'text' || q.answer === '6') {
            let textarea = $(`textarea[name="text_answers[${questionId}]"]`);
            if (textarea.length) {
                textarea.val(q.text); // Assuming 'text' contains the saved response
            }
        }
    });
}

    });
</script>
    
    <script type="text/paperscript" canvas="mycanvas">


    <!-- $(document).ready(function() { -->
     
<!-- }); -->

        var hitOptions = {
            fill: true,
            tolerance: 5
        };

        var user_id;
        var shape_id;
        var list_SelectedShapes = new Array();

        var pain_level_color = '#FF0000';
        var pain_level = 1;
        $('#severe').css('border-width', '3px');

        var isClearClicked = false;

        $('#severe').click(function(){
            pain_level_color = '#FF0000';
            pain_level = 1;
            $('#severe').css('border-width', '3px');
            $('#moderate').css('border-width', '0px');
            $('#mild').css('border-width', '0px');
        });

        $('#moderate').click(function(){
            pain_level_color = '#FF8300';
            pain_level = 2;
            $('#severe').css('border-width', '0px');
            $('#moderate').css('border-width', '3px');
            $('#mild').css('border-width', '0px');
        });

        $('#mild').click(function(){
            pain_level_color = '#FFE400';
            pain_level = 3;
            $('#severe').css('border-width', '0px');
            $('#moderate').css('border-width', '0px');
            $('#mild').css('border-width', '3px');
        });

        $('#clear').click(function(){
            isClearClicked = true;
        });

        createPaths();

        function createPaths() {

            // Create a raster item using the image tag with id='img1'
            var raster = new Raster('anatomy');
            // Move the raster to the center of the view
            raster.position = view.center;
            // Scale the raster by 50%
            raster.scale(1.25);

            user_id = $('#UserId').val();

            var fd = new FormData();

            fd.append('userId',user_id);

            fd.append('_token','{{csrf_token()}}');

            $.ajax({

                url: '{{route('fetchshapes')}}',
                type: 'post',
                data:fd,
                contentType: false,
                processData: false,
                success: function(response){

                    if (response.success)
                    {
                        list_SelectedShapes = new Array();

                        for(var i = 0; i < response.selectedshapes.length; i++)
                        {
                            var object = new Object();
                            object.user_id = response.selectedshapes[i].user_id;
                            object.shape_id = response.selectedshapes[i].shape_id;
                            object.pain_level = response.selectedshapes[i].pain_level;

                            list_SelectedShapes.push(object);
                        }

                        for(var cnt = 0; cnt < response.shapes.length; cnt++)
                        {
                            var isSelected = false;
                            var filltoColor = 'lightyellow';

                            for(var i = 0; i < list_SelectedShapes.length; i++)
                            {
                                if (list_SelectedShapes[i].shape_id == cnt+1)
                                {
                                    isSelected = true;
                                    if(list_SelectedShapes[i].pain_level == 1)
                                        filltoColor = '#FF0000';
                                    if(list_SelectedShapes[i].pain_level == 2)
                                        filltoColor = '#FF8300';
                                    if(list_SelectedShapes[i].pain_level == 3)
                                        filltoColor = '#FFE400';
                                }

                            }
                            if(isSelected)
                            {
                                var path = new Path({
                                    strokeColor: 'lightyellow',
                                    fillColor: filltoColor
                                });

                                path.name = cnt+1;

                                var ptList = response.shapes[cnt].points.split(',');

                                path.moveTo(new Point(parseFloat(ptList[0]), 721-parseFloat(ptList[1])));

                                for(var i = 2; i < ptList.length; i+=2)
                                {
                                    path.lineTo(new Point(parseFloat(ptList[i]), 721-parseFloat(ptList[i+1])));
                                }

                                path.closed = true;
                            }
                            else
                            {
                                var path = new Path({
                                    strokeColor: 'lightyellow',
                                    fillColor: 'lightyellow'
                                });

                                path.name = cnt+1;

                                var ptList = response.shapes[cnt].points.split(',');

                                path.moveTo(new Point(parseFloat(ptList[0]), 721-parseFloat(ptList[1])));

                                for(var i = 2; i < ptList.length; i+=2)
                                {
                                    path.lineTo(new Point(parseFloat(ptList[i]), 721-parseFloat(ptList[i+1])));
                                }

                                path.closed = true;

                                // When the mouse enters the item, set its fill color to red:
                                /*path.onMouseEnter = function(event) {
                                    this.fillColor = 'pink';
                                }

                                // When the mouse leaves the item, set its fill color to black:
                                path.onMouseLeave = function(event) {
                                    this.fillColor = 'lightyellow';
                                }*/
                            }

                        }
                    }
                    else
                    {

                    }

                },
            });

        }

        $('#btnSave').click(function()
        {
            user_id = $('#UserId').val();

            var fd = new FormData();

            fd.append('userId',user_id);
            fd.append('selectedShapes', JSON.stringify(list_SelectedShapes));

            fd.append('_token','{{csrf_token()}}');

            $.ajax({
                url: '{{route('saveshapes')}}',
                type: 'post',
                data:fd,
                contentType: false,
                processData: false,
                success: function(response){
                    if (response.success)
                    {
                        Swal.fire({
                            icon: 'success',
                            title: 'Session',
                            text: response.message,
                            showCancelButton: false,
                            customClass: {
                                confirmButton: 'btn btn-success mx-2'
                            },
                            buttonsStyling: false
                        });
                    }
                    else
                    {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Session',
                            text: response.message,
                            showCancelButton: false,
                            customClass: {
                                confirmButton: 'btn btn-success mx-2'
                            },
                            buttonsStyling: false
                        });
                    }

                },
            });
        });

        var hitItem = null;

        function onMouseDown(event) {

            hitItem = null;
            var hitResult = project.hitTest(event.point);

            if (!hitResult)
                return;

            if (hitResult) {
                hitItem = hitResult.item;
            }

            if (hitResult.type == 'fill') {
                currentAction = 'move';

                if(isClearClicked)
                {
                    isClearClicked = false;

                    if(hitItem.fillColor != 'lightyellow')
                    {
                        var idx = -1;

                        for(var i = 0; i < list_SelectedShapes.length; i++) {
                            if (list_SelectedShapes[i].shape_id == hitItem.name) {
                                idx = i;
                                break;
                            }
                        }

                        if (idx > -1)
                        {
                          list_SelectedShapes.splice(idx, 1);
                        }

                        hitItem.fillColor = 'lightyellow';
                        return;
                    }
                }

                if(hitItem.fillColor == 'lightyellow')
                {
                    hitItem.fillColor = pain_level_color;

                    var object = new Object();
                    object.user_id = user_id;
                    object.shape_id = hitItem.name;
                    object.pain_level = pain_level;

                    list_SelectedShapes.push(object);

                }
                else
                {
                    for(var i = 0; i < list_SelectedShapes.length; i++) {
                        if (list_SelectedShapes[i].shape_id == hitItem.name)
                        {
                            if (hitItem.fillColor == pain_level_color) {
                                break;
                            }
                            else
                            {
                                hitItem.fillColor = pain_level_color;
                                if(hitItem.fillColor == '#FF0000')
                                {
                                    list_SelectedShapes[i].pain_level = 1;
                                }
                                if(hitItem.fillColor == '#FF8300')
                                {
                                    list_SelectedShapes[i].pain_level = 2;
                                }
                                if(hitItem.fillColor == '#FFE400')
                                {
                                    list_SelectedShapes[i].pain_level = 3;
                                }

                            }
                        }

                    }

                    //hitItem.fillColor = 'lightyellow';
                }

                console.log(list_SelectedShapes.length);

            }
        }

        var lastSelected = null;

        function onMouseMove(event) {

            if (lastSelected != null)
            {
                lastSelected.strokeColor = lastSelected.fillColor;
                lastSelected.strokeWidth = 1;
                lastSelected = null;
            }

            hitItem = null;
            var hitResult = project.hitTest(event.point);
            if (hitResult != null && hitResult.item != null)
            {
                hitResult.item.strokeColor = 'blue';
                hitResult.item.strokeWidth = 3;
                lastSelected = hitResult.item;
            }
        }

        /*function onMouseDrag(event) {
            if (!hitItem) {
                return;
            }
            if (currentAction == 'move') {
                hitItem.position += event.delta;
            }
        }*/

    </script>

@endpush

