

<!doctype html>
    
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title></title>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <link rel="stylesheet" href="/vendors/feather/feather.css">
    <link rel="stylesheet" href="/vendors/ti-icons/css/themify-icons.css">
    <link rel="stylesheet" href="/vendors/css/vendor.bundle.base.css">

    <!-- endinject -->
    <!-- Plugin css for this page -->
    <link rel="stylesheet" href="/vendors/datatables.net-bs4/dataTables.bootstrap4.css">
    <link rel="stylesheet" href="/vendors/ti-icons/css/themify-icons.css">
    <link rel="stylesheet" type="text/css" href="/usertemplate/js/select.dataTables.min.css">
    <!-- End plugin css for this page -->
    <!-- inject:css -->
    <link rel="stylesheet" href="/css/vertical-layout-light/style.css">
    <!-- endinject -->
    <link rel="shortcut icon" href="/images/favicon.png" />
</head>
<style>
    .chat-list {
        max-height: 500px;
        overflow-y: auto;
    }

    .chat-item {
        display: flex;
        align-items: center;
        padding: 10px;
        cursor: pointer;
    }

    .chat-item:hover {
        background-color: #f5f5f5;
    }

    .avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        margin-right: 10px;
    }

    .chat-details {
        flex: 1;
    }

    .chat-title {
        display: flex;
        align-items: center;
        padding: 10px;
    }

    .chat-message {
        display: flex;
        margin-bottom: 10px;
    }

    .message-avatar {
        margin-right: 10px;
    }

    .message-content {
        background-color: #f2f2f2;
        padding: 10px;
        border-radius: 10px;
    }

    .sender .message-content {
        background-color: #dcf8c6;
    }

    .card-footer {
        padding: 10px;
    }

    .chat-window {
        max-height: 500px;
        overflow-y: auto;
    }

    .chat-message-container {
        min-height: 400px;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 5px;
        background-color: #ffffff;
        ;
        margin-bottom: 10px;
    }

    .chat-message.sender {
        margin-bottom: 10px;
        text-align: left;
    }

    .chat-message.receiver {
        margin-bottom: 10px;
        text-align: right;
    }

    .list-group-item.active {
        z-index: 2;
        color: #fff;
        background-color: #4B49AC;
        border-color: #4B49AC;
    }

    .chat-message {
        display: flex;
        align-items: center;
        margin: 10px 0;
    }
    .chat-message {
    display: flex;
    align-items: center;
    margin-bottom: 10px;
}

.sender {
    justify-content: flex-end; /* Align sender messages to the right */
    text-align: right;
}

.receiver {
    justify-content: flex-start; /* Align receiver messages to the left */
    text-align: left;
}

.message-avatar img {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    margin-right: 10px;
}

.sender .message-avatar {
    order: 2; /* Place sender avatar on the right */
    margin-left: 10px;
    float:right;
}

.receiver .message-avatar {
    order: 0; /* Place receiver avatar on the left */
    margin-left: 10px;
}

    .chat-message .message-avatar img {
        width: 40px;
        height: 40px;
    }

    .chat-message .message-content {
        display: inline-block;
        padding: 10px;
        border-radius: 5px;
        background-color: #f1f1f1;
        margin: 0 10px;
        max-width: 70%;
    }

    .chat-message.sender .message-content {

        background-color: #d1e7dd;
        /* Example color for sender */
        text-align: right;
        margin-left: auto;
        /* Align right */
    }

    .chat-message.sender {
        flex-direction: row-reverse;
    }

    .chat-message .timestamp {
        font-size: 0.8em;
        color: #888;
    }

    .chat-message.sender .timestamp {
        margin-right: 10px;
    }

    .profile_card {
        display: flex;
        align-items: center;
        padding: 15px;
        margin: 10px 0;
        background-color: #f8f9fa;
        /* Light background color */
        border-radius: 10px;
        /* Rounded corners */
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        /* Subtle shadow */
        transition: transform 0.2s;
        /* Animation for hover effect */
    }

    .profile_card:hover {
        transform: translateY(-5px);
        /* Lift the card on hover */
    }

    .profile_img {
        width: 60px;
        /* Avatar size */
        height: 60px;
        margin-right: 15px;
        border: 2px solid #007bff;
        /* Border color matching badge */
    }

    .chat-details {
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .profile_name {
        font-size: 1.1em;
        /* Slightly larger font size */
        font-weight: bold;
        color: #343a40;
        /* Darker text color */
        margin-bottom: 5px;
    }

    .badge-primary {
        background-color: #007bff;
        /* Badge background color */
        color: #fff;
        /* Badge text color */
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 0.9em;
        align-self: flex-start;
        /* Align the badge to the start */
    }
</style>

@extends('layouts.app')
@section('content')
    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg  px-0 mx-4 shadow-none border-radius-xl z-index-sticky " id="navbarBlur"
        data-scroll="false">
        <div class="container-fluid py-1 px-3">
            @include('layouts.navbars.auth.topnav', ['title' => 'Default'])
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none ">
                <a href="javascript:;" class="nav-link p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                        <input type="text" class="form-control" placeholder="Type here...">
                    </div>
                </div>
                <ul class="navbar-nav  justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        @include('auth.logout')
                    </li>
                    <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                            <div class="sidenav-toggler-inner">
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                            </div>
                        </a>
                    </li>
                    <li class="nav-item px-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0">
                            <i class="fa fa-cog fixed-plugin-button-nav cursor-pointer"></i>
                        </a>
                    </li>
                    <li class="nav-item position-relative pe-2 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-bell cursor-pointer"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end px-2 py-3 me-sm-n4" aria-labelledby="dropdownMenuButton">
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/team-2.jpg" class="avatar avatar-sm  me-3 "
                                                alt="user image">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New message</span> from Laur
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                13 minutes ago
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/small-logos/logo-spotify.svg"
                                                class="avatar avatar-sm bg-gradient-dark  me-3 " alt="logo spotify">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New album</span> by Travis Scott
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                1 day
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="avatar avatar-sm bg-gradient-secondary  me-3  my-auto">
                                            <svg width="12px" height="12px" viewBox="0 0 43 36" version="1.1"
                                                xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink">
                                                <title>credit-card</title>
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <g transform="translate(-2169.000000, -745.000000)" fill="#FFFFFF"
                                                        fill-rule="nonzero">
                                                        <g transform="translate(1716.000000, 291.000000)">
                                                            <g transform="translate(453.000000, 454.000000)">
                                                                <path class="color-background"
                                                                    d="M43,10.7482083 L43,3.58333333 C43,1.60354167 41.3964583,0 39.4166667,0 L3.58333333,0 C1.60354167,0 0,1.60354167 0,3.58333333 L0,10.7482083 L43,10.7482083 Z"
                                                                    opacity="0.593633743"></path>
                                                                <path class="color-background"
                                                                    d="M0,16.125 L0,32.25 C0,34.2297917 1.60354167,35.8333333 3.58333333,35.8333333 L39.4166667,35.8333333 C41.3964583,35.8333333 43,34.2297917 43,32.25 L43,16.125 L0,16.125 Z M19.7083333,26.875 L7.16666667,26.875 L7.16666667,23.2916667 L19.7083333,23.2916667 L19.7083333,26.875 Z M35.8333333,26.875 L28.6666667,26.875 L28.6666667,23.2916667 L35.8333333,23.2916667 L35.8333333,26.875 Z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </svg>
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                Payment successfully completed
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                2 days
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>


    <div class="container-scroller">
        <!-- partial:partials/_navbar.html -->
       
        <!-- partial -->
        <!-- <div class="container-fluid page-body-wrapper">
            overflow partial:partials/_settings-panel.html 
            <div class="theme-setting-wrapper">
                <div id="settings-trigger"><i class="ti-settings"></i></div>
                <div id="theme-settings" class="settings-panel">
                    <i class="settings-close ti-close"></i>
                    <p class="settings-heading">SIDEBAR SKINS</p>
                    <div class="sidebar-bg-options selected" id="sidebar-light-theme">
                        <div class="img-ss rounded-circle bg-light border mr-3"></div>Light
                    </div>
                    <div class="sidebar-bg-options" id="sidebar-dark-theme">
                        <div class="img-ss rounded-circle bg-dark border mr-3"></div>Dark
                    </div>
                    <p class="settings-heading mt-2">HEADER SKINS</p>
                    <div class="color-tiles mx-0 px-4">
                        <div class="tiles success"></div>
                        <div class="tiles warning"></div>
                        <div class="tiles danger"></div>
                        <div class="tiles info"></div>
                        <div class="tiles dark"></div>
                        <div class="tiles default"></div>
                    </div>
                </div>
            </div> -->

            <!-- partial -->
            <!-- partial:partials/_sidebar.html -->
     
            <!-- partial -->
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="row">
                        <div class="col-md-12 grid-margin">
                            <div class="row">


                                <br>
                                <div class="col-md-12 mt-4 grid-margin">
    <div class="row">
        <!-- Left column: Chat list -->
        <div class="col-md-4 col-lg-3">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Chats</h4>
        </div>
        <div class="list-group chat-list" id="chatList" style="max-height: 500px; overflow-y: auto;">
            <ul class="list-group list-group-flush">
                @foreach ($admins as $admin)
                    @if(auth()->user()->role_id == 3 && $admin->role_id == 2) 
                        <li class="list-group-item d-flex align-items-center chat-item">
                            <!-- If the logged-in user has role_id 3, show only users with role_id 2 -->
                            <img src="{{ asset('avatars/' . $admin->avatar) }}" class="profile_img rounded-circle mr-3" style="width:80px; height: 80px;" alt="Profile Picture">
                            <div class="profile_info">
                                <span class="profile_name font-weight-bold">{{ $admin->name }}</span>
                                <span class="id">{{ $admin->id }}</span>
                                <span class="name">{{ $admin->firstname }}</span>
                            </div>
                        </li>
                    @elseif(auth()->user()->role_id == 2 && $admin->role_id == 3)
                        <li class="list-group-item d-flex align-items-center chat-item">
                            <!-- If the logged-in user has role_id 2, show only users with role_id 3 -->
                            <img src="{{ asset('avatars/' . $admin->avatar) }}" class="profile_img rounded-circle mr-3" style="width:80px; height: 80px;" alt="Profile Picture">
                            <div class="profile_info">
                                <span class="profile_name font-weight-bold">{{ $admin->name }}</span>
                                <span class="id">{{ $admin->id }}</span>
                                <span class="name">{{ $admin->firstname }}</span>
                            </div>
                        </li>
                    @endif
                @endforeach
            </ul>
        </div>
    </div>
</div>


        <!-- Right column: Chat area -->
        <div class="col-md-8 col-lg-9">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex align-items-center">
                        <!-- <img id="chat_img" src="" class="rounded-circle mr-3" alt="Profile Picture" style="width: 40px; height: 40px;"> -->
                        <h4 class="mb-0" id="chat_name">Chatting with</h4>
                    </div>
                </div>

                <div class="card-body chat-window" style="height: 400px; overflow-y: auto;">
                    <div class="chat-message-container" id="chatMessageContainer">
                        <!-- Chat messages will be dynamically loaded here -->
                    </div>
                </div>

                <div class="card-footer">
                    <form id="messageForm" method="POST">
                        @csrf
                        <input type="hidden" name="receiver_id" id="receiver_id">
                        <div class="input-group">
                            <input type="text" class="form-control" placeholder="Type your message here..." id="messageInput" name="message">
                            <button class="btn btn-primary" type="submit" id="sendMessageButton">Send</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


                            </div>
                        </div>
                    </div>

                    <div class="col-12 grid-margin stretch-card">
                        <div class="card">

                        </div>
                    </div>



                    <!-- content-wrapper ends -->
                    <!-- partial:partials/_footer.html -->
                  
                    <!-- partial -->
                </div>
                <!-- main-panel ends -->
            </div>
            <!-- page-body-wrapper ends -->
        </div>
        @endsection
        <script src="{{ asset('/build/assets/app-D1ylovWN.js') }}"></script>

        <!-- container-scroller -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
        <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
        <script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

        <!-- plugins:js -->
        <script src="/vendors/js/vendor.bundle.base.js"></script>
        <!-- endinject -->
        <!-- Plugin js for this page -->
        <script src="/vendors/chart.js/Chart.min.js"></script>
        <script src="/vendors/datatables.net/jquery.dataTables.js"></script>
        <script src="/vendors/datatables.net-bs4/dataTables.bootstrap4.js"></script>
        <script src="/js/dataTables.select.min.js"></script>

        <!-- End plugin js for this page -->
        <!-- inject:js -->
        <script src="/js/off-canvas.js"></script>
        <script src="/js/hoverable-collapse.js"></script>
        <script src="/js/template.js"></script>
        <script src="/js/settings.js"></script>
        <script src="/js/todolist.js"></script>
        <!-- endinject -->
        <!-- Custom js for this page-->
        <script src="/js/dashboard.js"></script>
        <script src="/js/Chart.roundedBarCharts.js"></script>
        <!-- End custom js for this page-->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


        <script src="https://cdnjs.cloudflare.com/ajax/libs/pusher/7.0.3/pusher.min.js"></script>
        <script>
    // Initialize Pusher
    var pusher = new Pusher('b23d71886d55f985f153', {
        cluster: 'ap2',
        encrypted: true
    });

    // Subscribe to the 'admin-messages' channel
    var channel = pusher.subscribe('admin-messages');

    // Bind to the 'admin-message' event
    channel.bind('admin-message', function(data) {
        console.log('Message received:', data);

        let senderId = data.sender_id;
        console.log(senderId)
        let message = data.message;
        let senderName = data.admin.name;
        let senderImage = data.admin.avatar;
        console.log(senderImage);
        let messageTime = new Date(data.created_at).toLocaleTimeString([], {
            hour: '2-digit',
            minute: '2-digit'
        });

        // Create message HTML with proper asset URL
        let messageHtml = `
            <div class="chat-message receiver"> <!-- Left alignment for received messages -->
                <div class="message-avatar">
                    <img src="${senderImage}" class="rounded-circle avatar" alt="${senderName} Avatar">
                </div>
                <div class="message-content">
                    <p><strong>${senderName}:</strong> ${message}</p>
                    <div class="timestamp">${messageTime}</div>
                </div>
            </div>`;

        // Append message to chat container
        document.getElementById('chatMessageContainer').insertAdjacentHTML('beforeend', messageHtml);
    });
</script> 
    <!-- JavaScript to handle profile card click -->
    <script>
$(document).ready(function() {
    // Bind click event to the chat-item list elements
    $('.chat-item').on('click', function() {
        let profileImage = $(this).find('.profile_img').attr('src');
        let profileName = $(this).find('.profile_name').text();
        let receiverId = $(this).find('.id').text();

        console.log(receiverId+"==============");
        $('#receiver_id').val(receiverId);
        $('#chat_img').attr('src', profileImage);
        $('#chat_name').text('Chatting with ' + profileName);
        
       
        $.ajax({
           url: "{{ route('fetch.messagesFromSellerToAdmin') }}",
            method: 'GET',
            data: {
                receiver_id: receiverId
            },
            success: function(response) {
                $('#chatMessageContainer').empty();

                
                // response.messages.forEach(function(message) {
                //     console.log(message + "________+++=====__________");
                //     console.log(message.receiver.avatar);
                //     console.log(message.receiver.firstname+"firstnamefirstnamefirstname");
                    
                //     let loggedInUserId = '{{ auth()->id() }}'; 

                    
                //     let isSender = message.sender_id == loggedInUserId;

                    
                //     let userAvatar = isSender ? '{{ asset("avatars/" . auth()->user()->avatar) }}' : '{{ asset("avatars/") }}/' + message.receiver.avatar;
                //     let receiverAvatar = isSender==message.receiver.avatar ? '{{ asset("avatars/" . auth()->user()->avatar) }}' : '{{ asset("avatars/") }}/' + message.receiver.avatar;

                //     // Set username based on sender or receiver
                //     let userName = isSender ? '{{ auth()->user()->firstname }}' : message.receiver.firstname;
                //     let receivername = isSender==message.receiver.firstname ? '{{ auth()->user()->firstname }}' : message.receiver.firstname;


                //     console.log(userName);
                //     console.log(isSender);
                //     // Format message time
                //     let messageTime = new Date(message.created_at).toLocaleTimeString([], {
                //         hour: '2-digit',
                //         minute: '2-digit'
                //     });

                //     // Message HTML structure
                //     let messageHtml = `
                //         <div class="chat-message ${isSender ? 'sender' : 'receiver'}">
                //             <div class="message-avatar">
                //                 <img src="${userAvatar}" class="rounded-circle avatar" alt="User Avatar">
                //             </div>
                //             <div class="message-content">
                //                 <p><strong>${userName}:</strong> ${message.message}</p>
                //                 <div class="timestamp">${messageTime}</div>
                //             </div>
                //         </div>`;

                //     // Append to chat container
                //     $('#chatMessageContainer').append(messageHtml);
                // });
                response.messages.forEach(function(message) {
                    console.log(message + "________+++=====__________");

                    // Get logged-in user ID
                    let loggedInUserId = '{{ auth()->id() }}'; 

                    // Check if the logged-in user is the sender
                    let isSender = message.sender_id == loggedInUserId;
                    let userAvatar;
                    if(isSender=='{{ auth()->user()->firstname }}'){
                        userAvatar=message.sender.avatar;
                    }
                    else{
                        userAvatar=message.sender.avatar;
                    } 

                    let receiverAvatar;
                    if(isSender=='{{ auth()->user()->firstname }}'){
                        receiverAvatar=message.receiver.avatar;
                    }
                    else{
                        receiverAvatar=message.receiver.avatar;
                    } 
                    // Set avatar based on sender or receiver
                   
                    // Set username based on sender or receiver
                    let userName ;
                    if(isSender=='{{ auth()->user()->firstname }}'){
                        userName=message.sender.firstname;
                    }
                    else{
                        userName=message.sender.lastname;
                    } 
                    let receiverName;
                    if(isSender!='{{ auth()->user()->firstname }}'){
                        receiverName=message.receiver.firstname;
                    }
                    else{
                        receiverName=message.receiver.lastname;
                    } 

                    console.log("Sender Name:", userName);
                    console.log("Receiver Name:", receiverName);
                    console.log("Sender Name:", userAvatar);
                    console.log("Receiver Name:", receiverAvatar);
                    console.log("Is Sender:", isSender);

                    // Format message time
                    let messageTime = new Date(message.created_at).toLocaleTimeString([], {
                        hour: '2-digit',
                        minute: '2-digit'
                    });

                    // Message HTML structure
                    let messageHtml = `
        <div class="chat-message ${isSender ? 'sender' : 'receiver'}">
            <div class="message-avatar">
                <img src="avatars/${userAvatar}" class="rounded-circle avatar" alt="${userName}">
            </div>
            <div class="message-content">
                <p><strong>${userName}:</strong> ${message.message}</p>
                <div class="timestamp">${messageTime}</div>
            </div>
        </div>`;
                    // Append to chat container
                    $('#chatMessageContainer').append(messageHtml);
                });

                // Scroll to the bottom of the chat container
                $('#chatMessageContainer').scrollTop($('#chatMessageContainer')[0].scrollHeight);
            },
            error: function(xhr, status, error) {
                console.error('Error fetching messages:', error);
            }
        });
    });

    $('#messageForm').on('submit', function(e) {
    e.preventDefault();

    let message = $('#messageInput').val().trim();
    let receiverId = $('#receiver_id').val();

    if (message === "") {
        alert("Message cannot be empty.");
        return;
    }

    $.ajax({
        type: 'POST',
        url: '{{ route('send.Messageofsellertoadmin') }}',
        data: {
            _token: $('input[name="_token"]').val(),
            message: message,
            receiver_id: receiverId
        },
        beforeSend: function() {
            // Disable the send button and change its text to "Sending..."
            $('#sendMessageButton').text('Sending...').attr('disabled', true);
        },
        success: function(response) {
            if (response.success) {
                toastr.success(response.message, "Success");
                $('#messageInput').val(''); // Clear the input

                let userAvatar = '{{ asset('avatars/' . $LoggedUserInfo->avatar) }}';
                let userName = '{{ $LoggedUserInfo->name }}';

                let messageTime = new Date().toLocaleTimeString([], {
                    hour: '2-digit',
                    minute: '2-digit'
                });

                let messageHtml = `
                    <div class="chat-message sender">
                    <div class="message-content">
                      
                            <img src="${userAvatar}" class="rounded-circle avatar" alt="User Avatar">
                     
                        
                            <p><strong>${userName}:</strong> ${message}</p>
                            <div class="timestamp">${messageTime}</div>
                        </div>
                    </div>`;

                $('#chatMessageContainer').append(messageHtml);

                // Scroll to the bottom of the chat container after sending a message
                $('#chatMessageContainer').scrollTop($('#chatMessageContainer')[0].scrollHeight);
            } else {
                toastr.error(response.message, "Error");
            }
        },
        error: function(xhr) {
            console.error('Error:', xhr.responseJSON.message);
            toastr.error('Failed to send message', "Error");
        },
        complete: function() {
            // Re-enable the send button and change its text back to "Send"
            $('#sendMessageButton').text('Send').attr('disabled', false);
        }
    });
});
});
</script>


</body>

</html>