<?php

use Illuminate\Support\Facades\Route;


use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\ResetPassword;
use App\Http\Controllers\Auth\ChangePassword;
use App\Http\Controllers\PageController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\TagController;
use App\Http\Controllers\ItemController;
use App\Http\Controllers\IndividualSessionController;
use App\Http\Controllers\GroupSessionController;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserAnswerController;
use App\Http\Controllers\ExerciseController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// Route::get('/default-dashboard', function () {
//     return view('/dashboard');  // Adjust this to your actual admin/teacher dashboard view
// })->middleware('auth');

// Route::get('/landing', function () {
//     return view('/landing');  // Adjust this to your student landing page view
// })->middleware('auth');
      Route::get('/', function () {
            return redirect('/default');
        })->middleware('auth');
        Route::put('/feedback/update', [HomeController::class, 'feedbackupdate'])->name('feedback.update');


        Route::get('/groups', [HomeController::class, 'groupname'])->name('groups');




        Route::get('/login', [LoginController::class, 'show'])->middleware('guest')->name('login');
        Route::post('/login', [LoginController::class, 'login'])->middleware('guest')->name('login.perform');

        Route::get('/register', [RegisterController::class, 'show'])->middleware('guest')->name('register');
        Route::post('/register', [RegisterController::class, 'register'])->middleware('guest')->name('register.perform');

        Route::get('/reset-password', [ResetPassword::class, 'show'])->middleware('guest')->name('reset-password');
        Route::post('/reset-password', [ResetPassword::class, 'send'])->middleware('guest')->name('reset.perform');

        Route::get('/change-password', [ChangePassword::class, 'show'])->middleware('guest')->name('change-password');
        Route::post('/change-password', [ChangePassword::class, 'update'])->middleware('guest')->name('change.perform');
        Route::get('/chats', [UserController::class, 'chats'])->name('chats');
        Route::get('/users-management', [UserController::class, 'index'])->name('users-management');
        Route::post('/user_answers', [UserAnswerController::class, 'store'])->name('user_answers.store');
        Route::post('/stores_chat', [IndividualSessionController::class, 'store'])->withoutMiddleware(['auth'])->name('send.group.message');

        Route::get('/get_chat_messages', function () {
            $messages = DB::select("
                SELECT gc.*, u.firstname as user_name 
                FROM group_chat gc 
                JOIN users u ON gc.from_user_id = u.id 
                ORDER BY gc.date ASC
            ");
        
            return Response::json($messages);
        });
    
         
Route::group(['middleware' => 'auth'], function () {
    // Route::get('user/login', [UserController::class, 'chats'])->name('users_chats');
    Route::get('/users_chats', [UserController::class, 'chats'])->name('users_chats');
    Route::get('/exercise', [ExerciseController::class, 'index'])->name('exercise');
    Route::post('/save-exercise', [ExerciseController::class, 'store'])->name('save.exercise');
    Route::post('/exercises/store', [ExerciseController::class, 'store'])->name('exercises.store');

    Route::get('/fetch-messages', [ChatController::class, 'fetchMessagesFromUserToAdmin'])
    ->name('fetch.messagesFromSellerToAdmin');
    Route::post('/send-message', [ChatController::class, 'sendMessageFromUserToAdmin'])->name('send.Messageofsellertoadmin');
    Route::get('/home', [HomeController::class, 'showStudents']);
    //santhosh\
    Route::get('/homes', [HomeController::class, 'groupredirect'])->name('homes');
    // Route::get('/groups/details/{grp_name}', [HomeController::class, 'groupDetails'])->name('groups.details');
    Route::get('/group/join/{id}', [HomeController::class, 'joinGroup'])->name('group.join');
    //sharan
    Route::post('/feedback', [HomeController::class, 'store'])->name('feedback.store');
    
   Route::get('exerciseforstudent',[ExerciseController::class,'indexfordownload'])->name('exerciseforstudent');


   Route::get('/automotive', [HomeController::class, 'showDashboard']);
    // Route::get('users_chats', [UserController::class, 'chats'])->name('users_chats');
        Route::post('/groups/store', [GroupSessionController::class, 'store'])->name('groups.store');
        Route::get('/fetch-students', [GroupSessionController::class, 'fetchStudents'])->name('fetch.students');
        
        Route::get('/individualsession_result', [IndividualSessionController::class, 'individualsession_result'])->name('individualsession_result');
        Route::get('/individualsession', [IndividualSessionController::class, 'index'])->name('individualsession');
        Route::post('/fetchshapes', [IndividualSessionController::class, 'fetchShapes'])->name('fetchshapes');
        Route::post('/saveshapes', [IndividualSessionController::class, 'saveshapes'])->name('saveshapes');
        Route::get('/get-student-answers', [IndividualSessionController::class, 'getStudentAnswers']);

        Route::get('/groupsession', [GroupSessionController::class, 'index'])->name('groupsession');
        
        
        Route::get('/profile', [LoginController::class, 'profile'])->name('profile');

        Route::post('/profile_validation', [LoginController::class, 'profile_validation'])->name('profile_validation');
	
        Route::get('/user-profile', [ProfileController::class, 'show'])->name('user-profile');
        Route::post('/user-profile', [ProfileController::class, 'update'])->name('user-profile.perform');
        Route::get('/home', [HomeController::class, 'index'])->name('home');
        // Route::get('/automotive', [HomeController::class, 'automotive'])->name('automotive');
    
        // Route::get('/users-management', [UserController::class, 'index'])->name('users-management');
        Route::get('/home', [HomeController::class, 'showStudents']);
        Route::get('/get-students', [HomeController::class, 'getStudents'])->name('get-students');
        // Route::post('/stores_chat', [GroupSessionController::class, 'stores_chat'])->name('stores_chat');
       

// Route::post('/stores_chat', [GroupSessionController::class, 'stores_chat'])->name('send.group.message');

        Route::get('/exercise', [ExerciseController::class, 'index'])->name('exercise');
        Route::post('/save-exercise', [ExerciseController::class, 'store'])->name('save.exercise');
        Route::post('/exercises/store', [ExerciseController::class, 'store'])->name('exercises.store');


        Route::get('/individualsession', [IndividualSessionController::class, 'index'])->name('individualsession');
        Route::post('/fetchshapes', [IndividualSessionController::class, 'fetchShapes'])->name('fetchshapes');
        Route::post('/saveshapes', [IndividualSessionController::class, 'saveshapes'])->name('saveshapes');
    Route::controller(UserController::class)->group(function() {

        Route::get('/users-management', 'index')->name('users-management');
        Route::get('/student-management', 'index')->name('student-management');
      
        Route::get('/user-management', 'create')->name('user-new');
        Route::post('/users-management/new', 'store')->name('user-new.store');
        Route::get('/users-management/edit/{id}', 'edit')->name('user-edit');
        Route::post('/users-management/edit/{id}', 'update')->name('user-edit.update');
        Route::post('/user-delete/{id}', 'destroy')->name('user-destroy');
        
    });
    Route::get('/admin/chats', [HomeController::class, 'chats'])->name('admin.chats');
    Route::controller(RoleController::class)->group(function() {
        Route::get('/role-management', 'index')->name('role-management');
        Route::get('/role-management/new', 'create')->name('role-new');
        Route::post('/role-management/new', 'store')->name('role-new.store');
        Route::get('/role-management/edit/{id}', 'edit')->name('role-edit');
        Route::post('/role-management/edit/{id}', 'update')->name('role-edit.update');
        Route::post('/role-delete/{id}', 'destroy')->name('role-destroy');
    });

    Route::controller(CategoryController::class)->group(function() {
        Route::get('/category-management', 'index')->name('category-management');
        Route::get('/category-management/new', 'create')->name('category-new');
        Route::post('/category-management/new', 'store')->name('category-new.store');
        Route::get('/category-management/edit/{id}', 'edit')->name('category-edit');
        Route::post('/category-management/edit/{id}', 'update')->name('category-edit.update');
        Route::post('/category-delete/{id}', 'destroy')->name('category-destroy');
    });

    Route::controller(TagController::class)->group(function() {
        Route::get('/tag-management', 'index')->name('tag-management');
        Route::get('/tag-management/new', 'create')->name('tag-new');
        Route::post('/tag-management/new', 'store')->name('tag-new.store');
        Route::get('/tag-management/edit/{id}', 'edit')->name('tag-edit');
        Route::post('/tag-management/edit/{id}', 'update')->name('tag-edit.update');
        Route::post('/tag-delete/{id}', 'destroy')->name('tag-destroy');
    });

    Route::controller(ItemController::class)->group(function() {
        Route::get('/item-management', 'index')->name('item-management');
        Route::get('/item-management/new', 'create')->name('item-new');
        Route::post('/item-management/new', 'store')->name('item-new.store');
        Route::get('/item-management/edit/{id}', 'edit')->name('item-edit');
        Route::post('/item-management/edit/{id}', 'update')->name('item-edit.update');
        Route::post('/item-delete/{id}', 'destroy')->name('item-destroy');
    });

    Route::get('/{page}', [PageController::class, 'dashboards'])->name('dashboards');

    Route::get('/pages/profile/{page}', [PageController::class, 'profiles'])->name('profiles');

    Route::get('/pages/user/{page}', [PageController::class, 'users'])->name('users');

    Route::get('/pages/account/{page}', [PageController::class, 'accounts'])->name('accounts');

    Route::get('/pages/project/{page}', [PageController::class, 'projects'])->name('projects');

    Route::get('/pages/{page}', [PageController::class, 'pages'])->name('pages');

    Route::get('/applications/{page}', [PageController::class, 'applications'])->name('applications');

    Route::get('/ecommerce/products/{page}', [PageController::class, 'products'])->name('products');

    Route::get('/ecommerce/orders/{page}', [PageController::class, 'orders'])->name('orders');

    Route::get('/ecommerce/{page}', [PageController::class, 'ecommerce'])->name('ecommerce');

    Route::get('/authentication/sign-in/{page}', [PageController::class, 'signins'])->name('signins');

    Route::get('/authentication/sign-up/{page}', [PageController::class, 'signups'])->name('signups');

    Route::get('/authentication/reset-password/{page}', [PageController::class, 'resets'])->name('resets');

    Route::get('/authentication/lock/{page}', [PageController::class, 'locks'])->name('locks');

    Route::get('/authentication/verification/{page}', [PageController::class, 'verifications'])->name('verifications');

    Route::get('/authentication/errors/{page}', [PageController::class, 'errors'])->name('errors');

    Route::post('logout', [LoginController::class, 'logout'])->name('logout');


  
});
