

<?php $__env->startSection('content'); ?>
    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg  px-0 mx-4 shadow-none border-radius-xl z-index-sticky " id="navbarBlur"
        data-scroll="false">
        <div class="container-fluid py-1 px-3">
            <?php echo $__env->make('layouts.navbars.auth.topnav', ['title' => 'Default'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none ">
                <a href="javascript:;" class="nav-link p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                        <input type="text" class="form-control" placeholder="Type here...">
                    </div>
                </div>
                <ul class="navbar-nav  justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        <?php echo $__env->make('auth.logout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </li>
                    <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                            <div class="sidenav-toggler-inner">
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                            </div>
                        </a>
                    </li>
                    <li class="nav-item px-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0">
                            <i class="fa fa-cog fixed-plugin-button-nav cursor-pointer"></i>
                        </a>
                    </li>
                    <li class="nav-item position-relative pe-2 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-bell cursor-pointer"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end px-2 py-3 me-sm-n4" aria-labelledby="dropdownMenuButton">
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/team-2.jpg" class="avatar avatar-sm  me-3 "
                                                alt="user image">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New message</span> from Laur
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                13 minutes ago
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/small-logos/logo-spotify.svg"
                                                class="avatar avatar-sm bg-gradient-dark  me-3 " alt="logo spotify">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New album</span> by Travis Scott
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                1 day
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="avatar avatar-sm bg-gradient-secondary  me-3  my-auto">
                                            <svg width="12px" height="12px" viewBox="0 0 43 36" version="1.1"
                                                xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink">
                                                <title>credit-card</title>
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <g transform="translate(-2169.000000, -745.000000)" fill="#FFFFFF"
                                                        fill-rule="nonzero">
                                                        <g transform="translate(1716.000000, 291.000000)">
                                                            <g transform="translate(453.000000, 454.000000)">
                                                                <path class="color-background"
                                                                    d="M43,10.7482083 L43,3.58333333 C43,1.60354167 41.3964583,0 39.4166667,0 L3.58333333,0 C1.60354167,0 0,1.60354167 0,3.58333333 L0,10.7482083 L43,10.7482083 Z"
                                                                    opacity="0.593633743"></path>
                                                                <path class="color-background"
                                                                    d="M0,16.125 L0,32.25 C0,34.2297917 1.60354167,35.8333333 3.58333333,35.8333333 L39.4166667,35.8333333 C41.3964583,35.8333333 43,34.2297917 43,32.25 L43,16.125 L0,16.125 Z M19.7083333,26.875 L7.16666667,26.875 L7.16666667,23.2916667 L19.7083333,23.2916667 L19.7083333,26.875 Z M35.8333333,26.875 L28.6666667,26.875 L28.6666667,23.2916667 L35.8333333,23.2916667 L35.8333333,26.875 Z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </svg>
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                Payment successfully completed
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                2 days
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- End Navbar -->
    <div class="container">

    <!-- Start Video & Mic Button -->
  

    <div class="card p-3">
        <div class="d-flex justify-content-between">

            <!-- Left Card -->
            <div class="card" id="fullscard" style="width: 35%; height:45%">
                <?php if(isset($group)): ?>
                    <h4 class="p-2">Group Name: <?php echo e($group->grp_name); ?></h4>
                <?php endif; ?>

                <div class="card-header"><b>Connected Users</b></div>
                <div class="card-body" id="user_list">
                    <p>Click "Start Video & Mic" to load users.</p>
                </div>
            </div>

            <!-- Right Card (Live Video Chat) -->
            <div class="card" id="livechat" style="width: 58%; height:45%">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-6"><b>Live Video Chat</b></div>
                        <div class="col-md-6 text-right">
                           
                        </div>
                        
                    </div>
                    <div class="d-flex justify-content-end gap-2">
                    <button id="startButton" class="btn btn-success btn-sm">Start Video & Mic</button>
       
                                <button id="toggle_video" class="btn btn-primary btn-sm" disabled>Turn Video Off</button>
                               
                                <button id="toggle_audio" class="btn btn-warning btn-sm" disabled>Mute</button>
                                <button id="close_video" class="btn btn-danger btn-sm" disabled>End Call</button>
                            </div>
                </div>
                <div class="card-body">
                    <video id="webcam" autoplay playsinline width="100%" height="auto"></video>
                </div>
              
            </div>

        </div>
    </div>

    <div class="col-sm-12 col-lg-6 mt-3" style="width: 88%; height:20%">
    <div class="card" id="chat"  style="display: none;">
        <div class="card-header"><b>Communication Panel</b></div>
        <div class="card-body">
            <div class="row">
                <!-- Left Column: Chat Area -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header d-flex justify-content-between">
                            <b>Chat Area</b>
                            <div id="close_chat_area"></div>
                        </div>
                        <div class="card-body" id="chat_area"></div>
                        <div class="card-footer d-flex">
                        <input type="text" id="chat_message" class="form-control me-2" placeholder="Type a message..." />
                        <button class="btn btn-primary" onclick="sendMessage()">Send</button>
                    </div>
                    </div>
                </div>

                <!-- Right Column: Search Users & Notifications (Stacked) -->
                <div class="col-md-6 d-flex flex-column">
                    <!-- Search Users -->
                    <div class="card mb-3 flex-fill" style="max-height: 50%; overflow-y: auto;">
                        <div class="card-header">
                            <input type="text" class="form-control" placeholder="Search User..." autocomplete="off" 
                                id="search_people" onkeyup="search_user('<?php echo e(Auth::id()); ?>', this.value);" />
                        </div>
                        <div class="card-body">
                            <div id="search_people_area" class="mt-3"></div>
                        </div>
                    </div>

                    <!-- Notifications -->
                    <div class="card flex-fill" style="max-height: 50%; overflow-y: auto;">
                        <div class="card-header"><b>Notifications</b></div>
                        <div class="card-body">
                            <ul class="list-group" id="notification_area"></ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <style>
        .card{
            padding: 20px;
            margin-top: 10px;
        }
        #connectedcard{
            margin-left: 50px;
            margin-top: 20px;
            height: auto;
            width: 400px;
        }
        #fullcard{
            height: auto;
            margin-left: 20px;
            margin-top: 30px
        }
        #livechat{
            height: ;
            width: ;
            margin-left: 20px;
            margin-right: 30px;
            margin-top: 30px

        }
        #chat_area
        {
            min-height: 500px;
            /*overflow-y: scroll*/;
        }

        #chat_history
        {
            min-height: 500px;
            max-height: 500px;
            overflow-y: scroll;
            margin-bottom:16px;
            background-color: #ece5dd;
            padding: 16px;
        }

        #user_list
        {
            min-height: 500px;
            max-height: 500px;
            overflow-y: scroll;
        }

    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script src="../../assets/js/plugins/chartjs.min.js"></script>
    <script src="/assets/js/core/jquery.min.js"></script>
    <script src="../../assets/js/paper/paper.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.getElementById("startButton").addEventListener("click", function () {
    document.getElementById("chat").style.display = "block";  // Show chat panel
    this.style.display = "none";  // Hide the start button
});
function sendMessage() {
    console.log("hello");
    let messageInput = document.getElementById('chat_message');
    let message = messageInput.value.trim();
    let groupId = "<?php echo e($group->id); ?>";  // Assuming $group is passed to the view
    let userId = "<?php echo e(Auth::id()); ?>"; // Get logged-in user ID

    if (message === "") {
        alert("Please enter a message.");
        return;
    }

    // Send message to the backend using AJAX
    fetch("<?php echo e(route('send.group.message')); ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
        },
        body: JSON.stringify({
            from_user_id: userId,
            grp_id: groupId,
            chat_message: message
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            let chatArea = document.getElementById('chat_area');
            chatArea.innerHTML += `<p><b>You:</b> ${message}</p>`;
            messageInput.value = ""; // Clear input after sending
        } else {
            alert("Failed to send message.");
        }
    })
    .catch(error => {
        console.error("Error sending message:", error);
    });
}

// function loadChatMessages() {
//     fetch("/get_chat_messages")
//         .then(response => response.json())
//         .then(data => {
//             let chatArea = document.getElementById("chat_area");
//             chatArea.innerHTML = "";

//             data.forEach(msg => {
//                 let isMyMessage = msg.from_user_id == "<?php echo e(Auth::id()); ?>";
//                 let alignment = isMyMessage ? "text-end bg-primary text-white p-2 rounded" : "text-start bg-light p-2 rounded";
//                 let senderName = isMyMessage ? "You" : msg.user_name;

//                 chatArea.innerHTML += `
//                     <div class="d-flex ${isMyMessage ? 'justify-content-end' : 'justify-content-start'} mb-2">
//                         <div class="${alignment}" style="max-width: 70%;">
//                             <b>${senderName}</b><br>
//                             ${msg.chat_message}
//                         </div>
//                     </div>
//                 `;
//             });

//             chatArea.scrollTop = chatArea.scrollHeight; // Auto-scroll to the latest message
//         })
//         .catch(error => console.error("Error:", error));
// }
// Load messages every 5 seconds for real-time updates
setInterval(loadChatMessages, 5000);
window.onload = loadChatMessages;

function loadChatMessages() {
    fetch("/get_chat_messages")
        .then(response => response.json())
        .then(data => {
            let chatArea = document.getElementById("chat_area");
            chatArea.innerHTML = "";

            data.forEach(msg => {
                let isMyMessage = msg.from_user_id == "<?php echo e(Auth::id()); ?>";
                let alignment = isMyMessage ? "text-end bg-primary text-white p-2 rounded" : "text-start bg-light p-2 rounded";
                let senderName = isMyMessage ? "You" : msg.user_name;

                chatArea.innerHTML += `
                    <div class="d-flex ${isMyMessage ? 'justify-content-end' : 'justify-content-start'} mb-2">
                        <div class="${alignment}" style="max-width: 70%;">
                            <b>${senderName}</b><br>
                            ${msg.chat_message}
                        </div>
                    </div>
                `;
            });

            chatArea.scrollTop = chatArea.scrollHeight; // Auto-scroll to the latest message
        })
        .catch(error => console.error("Error:", error));
}

</script>
    <script>
        $(document).ready(function(){

        })

        var conn = new WebSocket('ws://127.0.0.1:8090/?token=<?php echo e(auth()->user()->token); ?>');

        var from_user_id = "<?php echo e(Auth::user()->id); ?>";

        var to_user_id = "";

        conn.onopen = function(e){

            console.log("Connection established!");

            load_unconnected_user(from_user_id);

            load_unread_notification(from_user_id);

            load_connected_chat_user(from_user_id);

        };

        conn.onmessage = function(e){

            var data = JSON.parse(e.data);

            if(data.image_link)
            {
                //Display Code for uploaded Image

                document.getElementById('message_area').innerHTML = `<img src="<?php echo e(asset('images/`+data.image_link+`')); ?>" class="img-thumbnail img-fluid" />`;
            }

            if(data.status)
            {
                var online_status_icon = document.getElementsByClassName('online_status_icon');

                for(var count = 0; count < online_status_icon.length; count++)
                {
                    if(online_status_icon[count].id == 'status_'+data.id)
                    {
                        if(data.status == 'Online')
                        {
                            online_status_icon[count].classList.add('text-success');

                            online_status_icon[count].classList.remove('text-danger');

                            document.getElementById('last_seen_'+data.id+'').innerHTML = 'Online';
                        }
                        else
                        {
                            online_status_icon[count].classList.add('text-danger');

                            online_status_icon[count].classList.remove('text-success');

                            document.getElementById('last_seen_'+data.id+'').innerHTML = data.last_seen;
                        }
                    }
                }
            }

            if(data.response_load_unconnected_user || data.response_search_user)
            {
                var html = '';

                if(data.data.length > 0)
                {
                    html += '<ul class="list-group">';

                    for(var count = 0; count < data.data.length; count++)
                    {
                        var user_image = '';

                        if(data.data[count].user_image != '')
                        {
                            user_image = `<img src="<?php echo e(asset('images/')); ?>/`+data.data[count].user_image+`" width="40" class="rounded-circle" />`;
                        }
                        else
                        {
                            user_image = `<img src="<?php echo e(asset('images/avathar.png')); ?>" width="40" class="rounded-circle" />`
                        }

                        html += `
                        <li class="list-group-item">
                            <div class="row">
                                <div class="col col-9">`+user_image+`&nbsp;`+data.data[count].name+`</div>
                                <div class="col col-3">
                                    <button type="button" name="send_request" class="btn btn-primary btn-sm float-end" onclick="send_request(this, `+from_user_id+`, `+data.data[count].id+`)"><i class="fas fa-paper-plane"></i>Send</button>
                                </div>
                            </div>
                        </li>
                        `;
                    }

                    html += '</ul>';
                }
                else
                {
                    html = 'No User Found';
                }

                document.getElementById('search_people_area').innerHTML = html;
            }

            if(data.response_from_user_chat_request)
            {
                search_user(from_user_id, document.getElementById('search_people').value);

                load_unread_notification(from_user_id);
            }

            if(data.response_to_user_chat_request)
            {
                load_unread_notification(data.user_id);
            }

            if(data.response_load_notification)
            {
                var html = '';

                for(var count = 0; count < data.data.length; count++)
                {
                    var user_image = '';

                    if(data.data[count].user_image != '')
                    {
                        user_image = `<img src="<?php echo e(asset('images/')); ?>/`+data.data[count].user_image+`" width="40" class="rounded-circle" />`;
                    }
                    else
                    {
                        user_image = `<img src="<?php echo e(asset('images/no-image.jpg')); ?>" width="40" class="rounded-circle" />`;
                    }

                    html += `
                    <li class="list-group-item">
                        <div class="row">
                            <div class="col col-8">`+user_image+`&nbsp;`+data.data[count].name+`</div>
                            <div class="col col-4">
                    `;
                    if(data.data[count].notification_type == 'Send Request')
                    {
                        if(data.data[count].status == 'Pending')
                        {
                            html += '<button type="button" name="send_request" class="btn btn-warning btn-sm float-end">Request Send</button>';
                        }
                        else
                        {
                            html += '<button type="button" name="send_request" class="btn btn-danger btn-sm float-end">Request Rejected</button>';
                        }
                    }
                    else
                    {
                        if(data.data[count].status == 'Pending')
                        {
                            html += '<button type="button" class="btn btn-danger btn-sm float-end" onclick="process_chat_request('+data.data[count].id+', '+data.data[count].from_user_id+', '+data.data[count].to_user_id+', `Reject`)"><i class="fas fa-times"></i></button>&nbsp;';
                            html += '<button type="button" class="btn btn-success btn-sm float-end" onclick="process_chat_request('+data.data[count].id+', '+data.data[count].from_user_id+', '+data.data[count].to_user_id+', `Approve`)"><i class="fas fa-check"></i></button>';
                        }
                        else
                        {
                            html += '<button type="button" name="send_request" class="btn btn-danger btn-sm float-end">Request Rejected</button>';
                        }
                    }

                    html += `
                            </div>
                        </div>
                    </li>
                    `;
                }

                document.getElementById('notification_area').innerHTML = html;
            }

            if(data.response_process_chat_request)
            {
                load_unread_notification(data.user_id);

                load_connected_chat_user(data.user_id);
            }

            if(data.response_connected_chat_user)
            {
                var html = '<div class="list-group">';

                if(data.data.length > 0)
                {
                    for(var count = 0; count < data.data.length; count++)
                    {
                        html += `
                        <a href="#" class="list-group-item d-flex justify-content-between align-items-start" onclick="make_chat_area(`+data.data[count].id+`, '`+data.data[count].name+`'); load_chat_data(`+from_user_id+`, `+data.data[count].id+`); ">
                            <div class="ms-2 me-auto">
                        `;

                        var last_seen = '';

                        if(data.data[count].user_status == 'Online')
                        {
                            html += '<span class="text-success online_status_icon" id="status_'+data.data[count].id+'"><i class="fas fa-circle"></i></span>';

                            last_seen = 'Online';
                        }
                        else
                        {
                            html += '<span class="text-danger online_status_icon" id="status_'+data.data[count].id+'"><i class="fas fa-circle"></i></span>';

                            last_seen = data.data[count].last_seen;
                        }

                        var user_image = '';

                        if(data.data[count].user_image != '')
                        {
                            user_image = `<img src="<?php echo e(asset('images/')); ?>/`+data.data[count].user_image+`" width="35" class="rounded-circle" />`;
                        }
                        else
                        {
                            user_image = `<img src="<?php echo e(asset('images/no-image.jpg')); ?>" width="35" class="rounded-circle" />`;
                        }



                        html += `
                                &nbsp; `+user_image+`&nbsp;<b>`+data.data[count].name+`</b>
                                <div class="text-right"><small class="text-muted last_seen" id="last_seen_`+data.data[count].id+`">`+last_seen+`</small></div>
                            </div>
                            <span class="user_unread_message" data-id="`+data.data[count].id+`" id="user_unread_message_`+data.data[count].id+`"></span>
                        </a>
                        `;
                    }
                }
                else
                {
                    html += 'No User Found';
                }

                html += '</div>';

                document.getElementById('user_list').innerHTML = html;

                check_unread_message();
            }

            if(data.message)
            {
                var html = '';

                if(data.from_user_id == from_user_id)
                {

                    var icon_style = '';

                    if(data.message_status == 'Not Send')
                    {
                        icon_style = '<span id="chat_status_'+data.chat_message_id+'" class="float-end"><i class="fas fa-check text-muted"></i></span>';
                    }
                    if(data.message_status == 'Send')
                    {
                        icon_style = '<span id="chat_status_'+data.chat_message_id+'" class="float-end"><i class="fas fa-check-double text-muted"></i></span>';
                    }

                    if(data.message_status == 'Read')
                    {
                        icon_style = '<span class="text-primary float-end" id="chat_status_'+data.chat_message_id+'"><i class="fas fa-check-double"></i></span>';
                    }

                    html += `
                    <div class="row">
                        <div class="col col-3">&nbsp;</div>
                        <div class="col col-9 alert alert-success text-dark shadow-sm">
                            `+data.message+ icon_style +`
                        </div>
                    </div>
                    `;
                }
                else
                {
                    if(to_user_id != '')
                    {
                        html += `
                        <div class="row">
                            <div class="col col-9 alert alert-light text-dark shadow-sm">
                            `+data.message+`
                            </div>
                        </div>
                        `;

                        update_message_status(data.chat_message_id, from_user_id, to_user_id, 'Read');
                    }
                    else
                    {
                        var count_unread_message_element = document.getElementById('user_unread_message_'+data.from_user_id+'');
                        if(count_unread_message_element)
                        {
                            var count_unread_message = count_unread_message_element.textContent;
                            if(count_unread_message == '')
                            {
                                count_unread_message = parseInt(0) + 1;
                            }
                            else
                            {
                                count_unread_message = parseInt(count_unread_message) + 1;
                            }
                            count_unread_message_element.innerHTML = '<span class="badge bg-primary rounded-pill">'+count_unread_message+'</span>';

                            update_message_status(data.chat_message_id, data.from_user_id, data.to_user_id, 'Send');
                        }
                    }

                }

                if(html != '')
                {
                    var previous_chat_element = document.querySelector('#chat_history');

                    var chat_history_element = document.querySelector('#chat_history');

                    chat_history_element.innerHTML = previous_chat_element.innerHTML + html;
                    scroll_top();
                }

            }

            if(data.chat_history)
            {
                var html = '';

                for(var count = 0; count < data.chat_history.length; count++)
                {
                    if(data.chat_history[count].from_user_id == from_user_id)
                    {
                        var icon_style = '';

                        if(data.chat_history[count].message_status == 'Not Send')
                        {
                            icon_style = '<span id="chat_status_'+data.chat_history[count].id+'" class="float-end"><i class="fas fa-check text-muted"></i></span>';
                        }

                        if(data.chat_history[count].message_status == 'Send')
                        {
                            icon_style = '<span id="chat_status_'+data.chat_history[count].id+'" class="float-end"><i class="fas fa-check-double text-muted"></i></span>';
                        }

                        if(data.chat_history[count].message_status == 'Read')
                        {
                            icon_style = '<span class="text-primary float-end" id="chat_status_'+data.chat_history[count].id+'"><i class="fas fa-check-double"></i></span>';
                        }

                        html +=`
                        <div class="row">
                            <div class="col col-3">&nbsp;</div>
                            <div class="col col-9 alert alert-success text-dark shadow-sm">
                            `+data.chat_history[count].chat_message+ icon_style + `
                            </div>
                        </div>
                        `;


                    }
                    else
                    {
                        if(data.chat_history[count].message_status != 'Read')
                        {
                            update_message_status(data.chat_history[count].id, data.chat_history[count].from_user_id, data.chat_history[count].to_user_id, 'Read');
                        }

                        html += `
                        <div class="row">
                            <div class="col col-9 alert alert-light text-dark shadow-sm">
                            `+data.chat_history[count].chat_message+`
                            </div>
                        </div>
                        `;

                        var count_unread_message_element = document.getElementById('user_unread_message_'+data.chat_history[count].from_user_id+'');

                        if(count_unread_message_element)
                        {
                            count_unread_message_element.innerHTML = '';
                        }
                    }
                }

                document.querySelector('#chat_history').innerHTML = html;

                scroll_top();
            }

            if(data.update_message_status)
            {
                var chat_status_element = document.querySelector('#chat_status_'+data.chat_message_id+'');

                if(chat_status_element)
                {
                    if(data.update_message_status == 'Read')
                    {
                        chat_status_element.innerHTML = '<i class="fas fa-check-double text-primary"></i>';
                    }
                    if(data.update_message_status == 'Send')
                    {
                        chat_status_element.innerHTML = '<i class="fas fa-check-double text-muted"></i>';
                    }
                }

                if(data.unread_msg)
                {
                    var count_unread_message_element = document.getElementById('user_unread_message_'+data.from_user_id+'');

                    if(count_unread_message_element)
                    {
                        var count_unread_message = count_unread_message_element.textContent;

                        if(count_unread_message == '')
                        {
                            count_unread_message = parseInt(0) + 1;
                        }
                        else
                        {
                            count_unread_message = parseInt(count_unread_message) + 1;
                        }

                        count_unread_message_element.innerHTML = '<span class="badge bg-danger rounded-pill">'+count_unread_message+'</span>';
                    }
                }
            }
        };

        function scroll_top()
        {
            document.querySelector('#chat_history').scrollTop = document.querySelector('#chat_history').scrollHeight;
        }

        function load_unconnected_user(from_user_id)
        {
            var data = {
                from_user_id : from_user_id,
                type : 'request_load_unconnected_user'
            };

            conn.send(JSON.stringify(data));
        }

        function search_user(from_user_id, search_query)
        {
            if(search_query.length > 0)
            {
                var data = {
                    from_user_id : from_user_id,
                    search_query : search_query,
                    type : 'request_search_user'
                };

                conn.send(JSON.stringify(data));
            }
            else
            {
                load_unconnected_user(from_user_id);
            }
        }

        function send_request(element, from_user_id, to_user_id)
        {
            var data = {
                from_user_id : from_user_id,
                to_user_id : to_user_id,
                type : 'request_chat_user'
            };

            element.disabled = true;

            conn.send(JSON.stringify(data));
        }

        function load_unread_notification(user_id)
        {
            var data = {
                user_id : user_id,
                type : 'request_load_unread_notification'
            };

            conn.send(JSON.stringify(data));

        }

        function process_chat_request(chat_request_id, from_user_id, to_user_id, action)
        {
            var data = {
                chat_request_id : chat_request_id,
                from_user_id : from_user_id,
                to_user_id : to_user_id,
                action : action,
                type : 'request_process_chat_request'
            };

            conn.send(JSON.stringify(data));
        }

        function load_connected_chat_user(from_user_id)
        {
            var data = {
                from_user_id : from_user_id,
                type : 'request_connected_chat_user'
            };

            conn.send(JSON.stringify(data));
        }

        function make_chat_area(user_id, to_user_name)
        {
            var html = `
            <div id="chat_history"></div>
            <div class="input-group mb-3">
                <div id="message_area" class="form-control" contenteditable style="min-height:125px; border:1px solid #ccc; border-radius:5px;"></div>
                <label class="btn btn-warning" style="line-height:125px;">
                    <i class="fas fa-upload"></i> <input type="file" id="browse_image" onchange="upload_image()" hidden />
                </label>
                <button type="button" class="btn btn-success" id="send_button" onclick="send_chat_message()"><i class="fas fa-paper-plane"></i></button>
            </div>
            `;

            document.getElementById('chat_area').innerHTML = html;

            document.getElementById('chat_header').innerHTML = 'Chat with <b>'+to_user_name+'</b>';

            document.getElementById('close_chat_area').innerHTML = '<button type="button" id="close_chat" class="btn btn-danger btn-sm float-end" onclick="close_chat();"><i class="fas fa-times"></i></button>';

            to_user_id = user_id;
        }

        function close_chat()
        {
            document.getElementById('chat_header').innerHTML = 'Chat Area';

            document.getElementById('close_chat_area').innerHTML = '';

            document.getElementById('chat_area').innerHTML = '';

            to_user_id = '';
        }

        function send_chat_message()
        {
            document.querySelector('#send_button').disabled = true;

            var message = document.getElementById('message_area').innerHTML.trim();

            var data = {
                message : message,
                from_user_id : from_user_id,
                to_user_id : to_user_id,
                type : 'request_send_message'
            };

            conn.send(JSON.stringify(data));

            document.querySelector('#message_area').innerHTML = '';

            document.querySelector('#send_button').disabled = false;
        }

        function load_chat_data(from_user_id, to_user_id)
        {
            var data = {
                from_user_id : from_user_id,
                to_user_id : to_user_id,
                type : 'request_chat_history'
            };

            conn.send(JSON.stringify(data));
        }

        function update_message_status(chat_message_id, from_user_id, to_user_id, chat_message_status)
        {
            var data = {
                chat_message_id : chat_message_id,
                from_user_id : from_user_id,
                to_user_id : to_user_id,
                chat_message_status : chat_message_status,
                type : 'update_chat_status'
            };

            conn.send(JSON.stringify(data));
        }

        function check_unread_message()
        {
            var unread_element = document.getElementsByClassName('user_unread_message');

            for(var count = 0; count < unread_element.length; count++)
            {
                var temp_user_id = unread_element[count].dataset.id;

                var data = {
                    from_user_id : from_user_id,
                    to_user_id : to_user_id,
                    type : 'check_unread_message'
                };

                conn.send(JSON.stringify(data));
            }
        }

        function upload_image()
        {
            var file_element = document.getElementById('browse_image').files[0];

            var file_name = file_element.name;

            var file_extension = file_name.split('.').pop().toLowerCase();

            var allowed_extension = ['png', 'jpg'];

            if(allowed_extension.indexOf(file_extension) == -1)
            {
                alert("Invalid Image File");

                return false;
            }

            var file_reader = new FileReader();

            var file_raw_data = new ArrayBuffer();

            file_reader.loadend = function()
            {

            }

            file_reader.onload = function(event){

                file_raw_data = event.target.result;

                conn.send(file_raw_data);
            }

            file_reader.readAsArrayBuffer(file_element);
        }


    // function loadStudents() {
    //     fetch('/get-students')
    //         .then(response => response.json())
    //         .then(data => {
    //             let userList = document.getElementById('user_list');
    //             userList.innerHTML = "";

    //             if (!data || data.length === 0) {
    //                 userList.innerHTML = "<p>No connected users.</p>";
    //             } else {
    //                 data.forEach(student => {
    //                     console.log("Student Data:", student); // Debugging: check the response
    //                     userList.innerHTML += `<p>ID: ${student.student_id} - Name: ${student.firstname || 'Unknown'}</p>`;
    //                 });
    //             }
    //         })
    //         .catch(error => {
    //             console.error("Fetch error:", error);
    //             document.getElementById('user_list').innerHTML = "<p>Error loading students.</p>";
    //         });
    // }


//     $(document).ready(function() {
//     $('#startButton').click(function() {
//         // Get values for user_id, grp_id, and date (You may adjust this logic based on your app)
//         var user_id = <?php echo e(auth()->user()->id); ?>; // logged-in user ID
//         var grp_id = 1; // Replace with actual group ID logic, this is hardcoded for now
//         var date = new Date().toISOString(); // Current date and time

//         // Send AJAX request to insert into the feedback table
//         $.ajax({
//             url: '<?php echo e(route("feedback.store")); ?>', // Your backend route to handle feedback insertion
//             type: 'POST',
//             data: {
//                 user_id: user_id,
//                 grp_id: grp_id,
//                 date: date,
//                 _token: '<?php echo e(csrf_token()); ?>' // CSRF token for security
//             },
//             success: function(response) {
//                 // Handle successful response
//                 alert('Video & Mic started, feedback inserted!');
//             },
//             error: function(xhr, status, error) {
//                 // Handle error response
//                 console.log(xhr);  // Log the full response object for debugging purposes
//                 console.log(status); // Log the status to see the specific type of error
//                 console.log(error);  // Log the specific error message

//                 // Custom error message based on the error response
//                 if (xhr.status === 500) {
//                     alert('Server error occurred, please try again later.');
//                 } else if (xhr.status === 404) {
//                     alert('Requested resource not found.');
//                 } else if (xhr.status === 403) {
//                     alert('You do not have permission to perform this action.');
//                 } else {
//                     alert('An error occurred while starting video and mic. Please try again.');
//                 }
//             }
//         });
//     });
// });

$(document).ready(function() {
    $('#startButton').click(function() {
        var user_id = <?php echo e(auth()->user()->id); ?>; // Logged-in user ID
        var grp_id = 4; // Replace with actual group ID logic
        var date = new Date().toISOString(); // Current date and time in ISO format

        // AJAX request to insert into the feedback table
        $.ajax({
            url: '<?php echo e(route("feedback.store")); ?>', // Backend route to insert feedback
            type: 'POST',
            data: {
                user_id: user_id,
                grp_id: grp_id,
                date: date,
                start_off: 1, // Initially, set start_off to 0 when starting the session
                _token: '<?php echo e(csrf_token()); ?>' // CSRF token for security
            },
            success: function(response) {
                alert('Video & Mic started, feedback inserted!');
                $('#toggle_video, #toggle_audio, #close_video').prop('disabled', false); // Enable buttons
            },
            error: function(xhr, status, error) {
                console.log(xhr, status, error);
                alert('An error occurred while starting video and mic. Please try again.');
            }
        });
    });

    // End Call button click event
    $('#close_video').click(function() {
        var user_id = <?php echo e(auth()->user()->id); ?>; // Get logged-in user ID

        // AJAX request to update the feedback table (set start_off to 1)
        $.ajax({
            url: '<?php echo e(route("feedback.update")); ?>', // Backend route to update feedback
            type: 'PUT', // Use PUT for updates
            data: {
                user_id: user_id,
                start_off: 0, // Update start_off to indicate the session ended
                _token: '<?php echo e(csrf_token()); ?>' // CSRF token
            },
            success: function(response) {
                alert('Call ended, feedback updated!');
                $('#toggle_video, #toggle_audio, #close_video').prop('disabled', true); // Disable buttons
            },
            error: function(xhr, status, error) {
                console.log(xhr, status, error);
                alert('An error occurred while ending the call. Please try again.');
            }
        });
    });
});

    // document.addEventListener("DOMContentLoaded", loadStudents);
    document.getElementById("startButton").addEventListener("click", function() {
        startVideoAndMic();
        loadStudents();
        loadStudentschat();

    });

    // function loadStudents() {
    //     fetch('/get-students')
    //         .then(response => response.json())
    //         .then(data => {
    //             let userList = document.getElementById('user_list');
    //             userList.innerHTML = ""; // Clear previous content

    //             if (!data || data.length === 0) {
    //                 userList.innerHTML = "<p>No connected users.</p>";
    //             } else {
    //                 // Add an image above the student list
    //                 userList.innerHTML += `<p><strong>ID - Name</strong></p>`;

    //                 data.forEach(student => {
    //                     let greenDot = student.is_active ? "<span style='color: #65fe08; font-size: 28px; margin-left: 8px;'>●</span>" : "";
    //                     userList.innerHTML += `
    //                     <h5 style="display: flex; align-items: center;">
    //                             ${student.student_id} - ${student.firstname || 'Unknown'} ${greenDot}
    //                         </h5>`;
                            
    //                 });
    //             }
    //         })
    //         .catch(error => {
    //             console.error("Fetch error:", error);
    //             document.getElementById('user_list').innerHTML = "<p>Error loading students.</p>";
    //         });
    // }
    function loadStudents() {
    fetch('/get-students')
        .then(response => response.json())
        .then(data => {
            let userList = document.getElementById('user_list');
            userList.innerHTML = ""; // Clear previous content

            if (!data || data.length === 0) {
                userList.innerHTML = "<p>No connected users.</p>";
            } else {
                data.forEach(teacher => {
                    let isTeacherActive = teacher.teacher_active == "1";
                    let teacherAvatar = teacher.teacher_avatar
                        ? `<img src="/avatars/${teacher.teacher_avatar}" style="width: 50px; height: 50px; border-radius: 50%; margin-right: 8px;">`
                        : `<img src="/avatars/default.png" style="width: 50px; height: 50px; border-radius: 50%; margin-right: 8px;">`;

                    let greenDot = isTeacherActive ? "<span style='color: #65fe08; font-size: 20px; margin-left: 8px;'>●</span>" : "";

                    // Display Teacher Name with Active Indicator
                    userList.innerHTML += `
                        <div style="display: flex; align-items: center; margin-top: 10px; margin-bottom: 5px; border-bottom: 1px solid #ccc; padding-bottom: 5px;">
                            ${teacherAvatar}
                            <h3>${teacher.teacher_name} ${greenDot}</h3>
                        </div>
                        <ul id="students_${teacher.teacher_id}" style="padding-left: 20px;"></ul>
                    `;

                    let studentList = document.getElementById(`students_${teacher.teacher_id}`);

                    // Parse students_list
                    if (teacher.students_list) {
                        teacher.students_list.split('|').forEach(studentData => {
                            let studentParts = studentData.split(':'); // [id, name, is_active]
                            let studentId = studentParts[0];
                            let studentName = studentParts[1];
                            let isActive = studentParts[2] == "1";

                            let greenDot = isActive ? "<span style='color: #65fe08; font-size: 20px; margin-left: 8px;'>●</span>" : "";
                            studentList.innerHTML += `<li style="font-size: 16px;">${studentName} ${greenDot}</li>`;
                        });
                    }
                });
            }
        })
        .catch(error => {
            console.error("Fetch error:", error);
            document.getElementById('user_list').innerHTML = "<p>Error loading students.</p>";
        });
}
function loadStudentschat() {
    fetch('/get-students')
        .then(response => response.json())
        .then(data => {
            let userList = document.getElementById('user_list');
            let chatArea = document.getElementById("search_people_area");

            // Clear previous content
            userList.innerHTML = ""; 
            chatArea.innerHTML = "<h5><b>Active Users:</b></h5>";

            if (!data || data.length === 0) {
                userList.innerHTML = "<p>No connected users.</p>";
                chatArea.innerHTML += "<p>No active users.</p>";
                return;
            }

            // Add table headers to user list
            userList.innerHTML += `<p><strong>ID - Name</strong></p>`;

            // data.forEach(student => {
            //     let greenDot = student.is_active ? 
            //         "<span style='color: #65fe08; font-size: 28px; margin-left: 8px;'>●</span>" 
            //         : "";

            //     // Append users to user list
            //     userList.innerHTML += `
            //         <h5 style="display: flex; align-items: center;">
            //             ${student.student_id} - ${student.firstname || 'Unknown'} ${greenDot}
            //         </h5>`;

            //     // If user is active, add to chat area
            //     if (student.is_active) {
            //         chatArea.innerHTML += `
            //             <h6 style="display: flex; align-items: center; margin: 5px 0;">
            //                 ${student.student_id} - ${student.firstname || 'Unknown'} ${greenDot}
            //             </h6>`;
            //     }
            // });
        })
        .catch(error => {
            console.error("Fetch error:", error);
            document.getElementById('user_list').innerHTML = "<p>Error loading students.</p>";
        });
}
    function startVideoAndMic() {
        let webcamElement = document.getElementById('webcam');
        let startButton = document.getElementById('startButton');
        let toggleVideo = document.getElementById('toggle_video');
        let toggleAudio = document.getElementById('toggle_audio');
        let closeVideo = document.getElementById('close_video');

        navigator.mediaDevices.getUserMedia({ video: true, audio: true })
            .then(function(stream) {
                webcamElement.srcObject = stream;

                // Enable buttons
                toggleVideo.disabled = false;
                toggleAudio.disabled = false;
                closeVideo.disabled = false;

                // Change start button text and disable it
                startButton.innerText = "Live";
                startButton.disabled = true;

                let videoTrack = stream.getVideoTracks()[0];
                let audioTrack = stream.getAudioTracks()[0];

                // Toggle video on/off
                toggleVideo.addEventListener("click", function() {
                    videoTrack.enabled = !videoTrack.enabled;
                    toggleVideo.innerText = videoTrack.enabled ? "Turn Video Off" : "Turn Video On";
                });

                // Toggle audio on/off
                toggleAudio.addEventListener("click", function() {
                    audioTrack.enabled = !audioTrack.enabled;
                    toggleAudio.innerText = audioTrack.enabled ? "Mute" : "Unmute";
                });

                // End call
                closeVideo.addEventListener("click", function() {
                    stream.getTracks().forEach(track => track.stop());
                    webcamElement.srcObject = null;

                    // Reset buttons
                    startButton.disabled = false;
                    startButton.innerText = "Start Video & Mic";
                    toggleVideo.disabled = true;
                    toggleAudio.disabled = true;
                    closeVideo.disabled = true;

                    // Clear the connected users list
                    let userList = document.getElementById('user_list');
                    userList.innerHTML = "<p>Click 'Start Video & Mic' to load users.</p>";
                });
            })
            .catch(function(error) {
                console.error("Error accessing webcam:", error);
                alert("Could not access webcam and microphone. Please allow permissions.");
            });
    }





    //  async function startWebcam() { for image
    //     try {
    //         const stream = await navigator.mediaDevices.getUserMedia({ video: true });
    //         document.getElementById('webcam').srcObject = stream;
    //     } catch (err) {
    //         console.error("Error accessing webcam: ", err);
    //     }
    // }

    // // Start webcam when the page loads
    // window.onload = startWebcam;

    // // Stop webcam when clicking the close button
    // document.getElementById("close_chat_area").addEventListener("click", function() {
    //     const video = document.getElementById('webcam');
    //     const stream = video.srcObject;
    //     if (stream) {
    //         const tracks = stream.getTracks();
    //         tracks.forEach(track => track.stop()); // Stop all webcam tracks
    //     }
    //     video.srcObject = null; // Remove video stream
    // });/////////////////////////////////////
    // let stream; for video

    // // Function to start webcam
    // async function startWebcam() {
    //     try {
    //         stream = await navigator.mediaDevices.getUserMedia({ video: true });
    //         document.getElementById('webcam').srcObject = stream;
    //     } catch (err) {
    //         console.error("Error accessing webcam: ", err);
    //     }
    // }

    // // Function to stop webcam
    // function stopWebcam() {
    //     if (stream) {
    //         let tracks = stream.getTracks();
    //         tracks.forEach(track => track.stop()); // Stop all video tracks
    //     }
    //     document.getElementById('webcam').srcObject = null;
    // }

    // // Toggle video on/off
    // document.getElementById("toggle_video").addEventListener("click", function () {
    //     let videoTrack = stream?.getVideoTracks()[0];
    //     if (videoTrack) {
    //         videoTrack.enabled = !videoTrack.enabled;
    //         this.innerText = videoTrack.enabled ? "Turn Off" : "Turn On";
    //     }
    // });

    // // Close webcam
    // document.getElementById("close_video").addEventListener("click", function () {
    //     stopWebcam();
    // });

    // // Start webcam when the page loads
    // window.onload = startWebcam;///////////////////
    let stream;

    // Start webcam & mic
    async function startMedia() {
        try {
            stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: true });
            document.getElementById('webcam').srcObject = stream;

            // Enable buttons after starting media
            document.getElementById('toggle_video').disabled = false;
            document.getElementById('toggle_audio').disabled = false;
            document.getElementById('close_video').disabled = false;
            document.getElementById('start_video').disabled = true;
        } catch (err) {
            console.error("Error accessing media: ", err);
        }
    }

    // Stop webcam & mic
    function stopMedia() {
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
        }
        document.getElementById('webcam').srcObject = null;

        // Disable buttons when media is stopped
        document.getElementById('toggle_video').disabled = true;
        document.getElementById('toggle_audio').disabled = true;
        document.getElementById('close_video').disabled = true;
        document.getElementById('start_video').disabled = false;
    }

    // Toggle video
    document.getElementById("toggle_video").addEventListener("click", function () {
        let videoTrack = stream?.getVideoTracks()[0];
        if (videoTrack) {
            videoTrack.enabled = !videoTrack.enabled;
            this.innerText = videoTrack.enabled ? "Turn Video Off" : "Turn Video On";
        }
    });

    // Toggle audio
    document.getElementById("toggle_audio").addEventListener("click", function () {
        let audioTrack = stream?.getAudioTracks()[0];
        if (audioTrack) {
            audioTrack.enabled = !audioTrack.enabled;
            this.innerText = audioTrack.enabled ? "Mute" : "Unmute";
        }
    });

    // Close media stream
    document.getElementById("close_video").addEventListener("click", stopMedia);

    // Start media when the user clicks "Start Video & Mic"
    document.getElementById("start_video").addEventListener("click", startMedia);

    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\pilates_app\pilates_app\resources\views/dashboards/homes.blade.php ENDPATH**/ ?>