<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use App\Models\ENEntity;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Task;
use App\Models\Role;
use App\Models\Project;
use App\Models\Customer;
use App\Models\ProcessStep;
use App\Models\Queries;


class ProjectController extends Controller
{
    public function index()
    {
        $customer = Customer::where('active', 0)->get(); 
        $projects = Project::where('active', 0)->get(); 
        $sections = DB::table('project_section')->get(); // Load from table
    
        return view('laravel.project.show_project', compact('projects', 'sections','customer'));
    }

    
    public function generateProjectCode(Request $request)
{
    $sectionId = $request->section_id;

    // Get section type from project_section table
    $section = DB::table('project_section')->where('id', $sectionId)->first();
    if (!$section) {
        return response()->json(['error' => 'Invalid section'], 400);
    }

    // Generate prefix and date part
    $prefix = strtoupper(substr($section->section_type, 0, 3)); // e.g. "SOF", "EMB"
    $yearMonth = Carbon::now()->format('ym'); // e.g. "2504"
    $dateCode = "{$prefix}_{$yearMonth}_"; // e.g. "SOF_2504_"

    // Get highest suffix (last 4 digits) globally across all project_code values
    $lastNumber = DB::table('project')
        ->select(DB::raw("MAX(CAST(RIGHT(project_code, 4) AS UNSIGNED)) AS max_code"))
        ->first();

    $nextNumber = $lastNumber && $lastNumber->max_code ? $lastNumber->max_code + 1 : 1;
    $formattedNumber = str_pad($nextNumber, 4, '0', STR_PAD_LEFT); // e.g. "0058"

    // Combine to generate new project code
    $newProjectCode = $dateCode . $formattedNumber;

    return response()->json(['project_code' => $newProjectCode]);
}
    public function details()
    { 
        $projects = DB::table('project')
        ->leftJoin('task', 'project.id', '=', 'task.project_id') // Use LEFT JOIN to include projects without tasks
        ->leftJoin('users', 'task.user_id', '=', 'users.id') // Use LEFT JOIN to include tasks without a user
        ->select(
            'project.project_name',
            'project.project_code',
            'task.task_name',
            'user.username' // Fetch the username from the users table (nullable if no user is assigned)
        )
        ->orderBy('project.project_name') // Order by project name
        ->get();
    
    return view('laravel.project.shows_project', compact('projects'));
    
    }

    public function deactivate($id)
    {
        try {
            $project = Project::findOrFail($id); // Find the project by ID
            $project->active = 1; // Set the active field to 1
            $project->save(); // Save the changes
    
            return response()->json([
                'success' => true,
                'message' => 'Project deactivated successfully!',
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to deactivate the project.',
            ], 500);
        }
    }
    public function update(Request $request, $id)
{
    $request->validate([
        'project_name' => 'required|string|max:255',
 
    ]);

    try {
        $project = Project::findOrFail($id);
        $project->project_name = $request->project_name;
       
        $project->update();

        return response()->json([
            'success' => true,
            'message' => 'Project updated successfully!',
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'Failed to update the project.',
        ], 500);
    }
}

    public function getLatestProjectCode()
{
    // Fetch the latest project code from the database
    $latestProject = DB::table('project')
        ->orderBy('id', 'desc') // Assuming `id` is the primary key
        ->value('project_code'); // Fetch only the `project_code` column

    // Extract the numeric part from the code (e.g., NR24100 -> 100)
    $latestNumber = $latestProject ? (int) substr($latestProject, 4) : 100;

    // Return the next incremented number
    return response()->json(['nextProjectCode' => 'NR24' . ($latestNumber + 1)]);
}
    public function showproject($id)
    {
       $projectname= Project::where('id', $id)
                    ->select('project_name','id')
                    ->get();
        $taskdetails = DB::table('project as po')
            ->join('task as ta', 'ta.project_id', '=', 'po.id') 
            ->leftJoin('user as user', 'user.id', '=', 'ta.user_id') 
            ->select('po.project_name', 'ta.id', 'ta.task_name', 'user.username')
            ->where('po.id', $id) 
            ->get();
            $userdetails = User::all();

        Log::info($taskdetails);
        return view('laravel.project.details', compact('taskdetails','projectname','userdetails'));
    }
    public function viewproject($id)
    {
       $projectname= Project::where('id', $id)
                    ->select('project_name','id','project_code')
                    ->get();
		$taskdetails = DB::table('project as po')
			->leftjoin('task as ta', 'ta.project_id', '=', 'po.id') 
			->leftJoin('users as user', 'user.id', '=', 'ta.user_id') 
			->select('po.project_name', 'ta.id','ta.status', 'ta.task_name', 'user.firstname','po.project_code')
			->where('po.id', $id) 
            ->where('ta.active',0)
			->get();
			$userdetails = User::all();

		Log::info($taskdetails);
        return view('laravel.project.view_project', compact('taskdetails','projectname','userdetails'));
    }


	public function updateproject($id)
{
    // Fetch task names
    $tasknames = Task::where('id', $id)->get();

    // Fetch assigned user
    $assignuser = DB::table('task as ta')
        ->join('user as user', 'user.id', '=', 'ta.user_id')
        ->select('user.firstname', 'user.id as user_id') // Include user_id
        ->where('ta.id', $id)
        ->first();

    // Fetch project name
    $projectname = DB::table('task as ta')
        ->join('project as po', 'po.id', '=', 'ta.project_id')
        ->where('ta.id', $id)
        ->get();

    // Fetch task details
    $taskdetails = DB::table('task as ta')
        ->join('project as po', 'po.id', '=', 'ta.project_id')
        ->join('user as user', 'user.id', '=', 'ta.user_id')
        ->where('ta.id', $id)
        ->get();

    // Fetch all user details
    $userdetails = User::all();

    // Extract the user ID (if available)
    $user_id = $assignuser->user_id ?? null;

    // Pass all required data to the view
    return view('laravel.project.update_project', compact('taskdetails', 'tasknames', 'userdetails', 'projectname', 'assignuser', 'user_id'));
}


	public function updateuserproject($id)
    {
       // Fetch task names
    $tasknames = Task::where('id', $id)->get();

    // Fetch assigned user
    $assignuser = DB::table('task as ta')
        ->join('user as user', 'user.id', '=', 'ta.user_id')
        ->select('user.firstname', 'user.id as user_id') // Include user_id
        ->where('ta.id', $id)
        ->first();

    // Fetch project name
    $projectname = DB::table('task as ta')
        ->join('project as po', 'po.id', '=', 'ta.project_id')
        ->where('ta.id', $id)
        ->get();

    // Fetch task details
    $taskdetails = DB::table('task as ta')
        ->join('project as po', 'po.id', '=', 'ta.project_id')
        ->join('user as user', 'user.id', '=', 'ta.user_id')
        ->where('ta.id', $id)
        ->get();

    // Fetch all user details
    $userdetails = User::all();

    // Extract the user ID (if available)
    $user_id = $assignuser->user_id ?? null;

    // Pass all required data to the view
    return view('laravel.project.update_user_project', compact('taskdetails', 'tasknames', 'userdetails', 'projectname', 'assignuser', 'user_id'));
      
    }

// 	public function assignTaskToUser(Request $request)
// {
//     $taskId = $request->input('taskId');
//     $assignedUserId = $request->input('assignedUserId');

//     $task = Task::find($taskId);
//     if ($task) {
//         $task->assigned_user_id = $assignedUserId;
//         $task->save();

//         return response()->json(['success' => true]);
//     }

//     return response()->json(['success' => false, 'message' => 'Task not found']);
// }

public function detail()
{
    $today = Carbon::today(); // Carbon instance for today's date
    $currentMonth = $today->format('Y-m'); // Format to 'YYYY-MM'

    // Fetch all users
    $allUsers = DB::table('users')
        ->select('id', 'firstname') // Ensure 'id' is fetched
        ->get();

    // Fetch attendance data for today's date
    $attendance = DB::table('attendance')
        ->leftJoin('leave', 'leave.id', '=', 'attendance.leave_id')
        ->leftJoin('users', 'attendance.user_id', '=', 'users.id')
        ->select(
            'user.id as user_id', // Alias to differentiate
            'user.firstname',
            'attendance.leave_id',
            'attendance.leave_date'
        )
        ->where(function ($query) use ($today) {
            $query->where('attendance.leave_date', '=', $today->toDateString()) // Convert Carbon to string
                ->orWhereNull('attendance.leave_date');
        })
        ->get();
        $groupedProjects = $attendance->groupBy('project_name');
    // Calculate leave and present counts for the current month
    $userStats = DB::table('attendance')
        ->select(
            'user_id',
            DB::raw("SUM(CASE WHEN leave_id = 0 THEN 1 ELSE 0 END) as present_count"),
            DB::raw("SUM(CASE WHEN leave_id = 1 THEN 1 ELSE 0 END) as absent_count"),
            DB::raw('COUNT(*) as total_days')
        )
        ->where('leave_date', 'LIKE', "{$currentMonth}%") // Filter by current month
        ->groupBy('user_id')
        ->get()
        ->keyBy('user_id'); // Group data by user_id for easy access

    // Pass data to the view
    return view('laravel.project.user_project', compact('allUsers', 'attendance', 'userStats','groupedProjects'));
}

public function updateTaskAction(Request $request)
{
    $taskId = $request->input('task_id');
    $task = Task::find($taskId);
    
    if ($task) {
        // Update the action column to 1
        $task->active = 1;
        $task->save();
        
        return response()->json(['success' => true, 'message' => 'Task action updated successfully']);
    }

    return response()->json(['success' => false, 'message' => 'Task not found']);
}

public function assigntasktouser(Request $request)
{
    try {
        Log::info($request);

        $taskId = $request->taskid;
        $taskName = $request->taskName;
        $assignedToUserId = $request->assignedToUserId;
        $projectName = $request->project_name;

        Log::info("Task ID: " . $taskId);
        Log::info("Assigned to User ID: " . $assignedToUserId);
        Log::info("Project Name: " . $projectName);

        // Get project ID
        $projectId = DB::table('task')
            ->where('task_name', $taskName)
            ->value('project_id');

        if (!$projectId) {
            return response()->json(['success' => false, 'message' => 'Project not found.'], 404);
        }

        Log::info("Project ID: " . $projectId);

        // Get task ID
        $taskRecord = DB::table('task')
            ->where('task_name', $taskName)
            ->select('id')
            ->first();

        if (!$taskRecord || !isset($taskRecord->id)) {
            return response()->json(['success' => false, 'message' => 'Task not found.'], 404);
        }

        $taskId = $taskRecord->id;
        Log::info("Task ID from DB: " . $taskId);

        // Update task
        $taskToUpdate = Task::find($taskId); // Use Eloquent to fetch the task

        if ($taskToUpdate) {
            $taskToUpdate->project_id = $projectId;
            $taskToUpdate->user_id = $assignedToUserId;
            $taskToUpdate->status = 1;
            $taskToUpdate->save(); // Use save() for Eloquent updates
        } else {
            return response()->json(['success' => false, 'message' => 'Task not found for update.'], 404);
        }

        return response()->json(['success' => true], 200);
    } catch (Exception $e) {
        Log::error("Error in assigning task: " . $e->getMessage());
        return response()->json(['success' => false, 'message' => $e->getMessage()], 500);
    }
}


public function assigntasktousers(Request $request)
{
    try {
        // Log::info($request);
        $taskId = $request->taskid;
        $assignedToUserId = $request->assignedToUserId;
        $project_name = $request->project_name;
        Log::info($taskId);
        Log::info($assignedToUserId . " assignedToUserId");
        Log::info($project_name);
        // Get project ID
        $project = DB::table('project')
            ->where('project_name', $project_name)
            ->select('id')
            ->first();
            // Log::info($project."projectIdprojectId");
       
        // $project = Project::where('project_name', $project_name)->get(); 
        $projectId = $project->id;
        if (!$project) {
            return response()->json(['success' => false, 'message' => 'Project not found.'], 404);
        }
        Log::info($projectId."projectIdprojectId");
        // Get task ID
        // $task = DB::table('task as ta')
        //     ->join('project as po', 'po.id', '=', 'ta.project_id')
        //     ->where('ta.task_name', $task_name)
        //     ->select('ta.id as task_id')
        //     ->first();
           
        if (!$taskId) {
            return response()->json(['success' => false, 'message' => 'Task not found.'], 404);
        }

        // $taskId = $task->task_id;

        // Update task
        $taskToUpdate = Task::where('id', $taskId)->first();

        if ($taskToUpdate) {
            $taskToUpdate->project_id = $projectId;
            $taskToUpdate->user_id = $assignedToUserId;
            $taskToUpdate->status = 1;
            $taskToUpdate->update();
        }

        return response()->json(['success' => true], 200);
    } catch (Exception $e) {
        return response()->json(['success' => false, 'message' => $e->getMessage()], 200);
    }
}
	
// 	public function createTask()
// {
//     $userdetails = User::all(); // Fetch all users from the database
//     return view('your_view', compact('userdetails')); // Pass users to the view
// }

public function addtasks(Request $request)
{
    Log::info($request);
    try {
        

        $project_id = $request->project_id;
        $assignedToUserId = $request->user_name;
        $taskName = $request->task_name;
		// $baseCode= $request->task_name;


        $parent_id = $request->parent_id;
        $project_code_id = $request->project_name;
        Log::info($project_code_id."project_code_id");
        $start_date = $request->start_date;
        $project = Project::where('id', $project_id)->first();
        Log::info($project."project");
        if ($project) {
            $project->task_count = $project->task_count + 1; // Increment task_count
            $project->save(); // Save the updated project
        }
        $taskCount=$project->task_count ;
        $projectTaskCode = $project_code_id . str_pad($taskCount, 4, '_0', STR_PAD_LEFT);
        Log::info($projectTaskCode."projectTaskCode");
        $taskStatus = new Task();
        $taskStatus->task_name = $taskName;
        $taskStatus->project_id = $project_id;
        $taskStatus->status = 0;
        $taskStatus->user_id = $assignedToUserId;
        $taskStatus->start_date = $start_date;
        $taskStatus->parent_id = $parent_id;
        $taskStatus->project_code_id = $projectTaskCode;
        $taskStatus->created_at = Carbon::now();
        $taskStatus->save();

		
        
        Log::info($taskStatus);
        


        return response()->json(['success' => true, 'message' => 'Task added successfully!']);
    } catch (\Exception $e) {
        Log::error('Error adding task: ' . $e->getMessage());
        return response()->json(['success' => false, 'message' => 'Failed to add task. Please try again.'], 500);
    }
}

public function storeProjectWithTasks(Request $request)
{
    Log::info($request->all());

    try {
        // Skip validation for task_count
        // Optionally add validation for other fields if needed

        $project = new Project();
        $project->project_name = $request->project_name;
        $project->task_count = $request->task_count;
        $project->project_code = $request->project_code;
        $project->customer_id = $request->customer;
        $project->section_id =$request->project_section;
        $project->status = 0;
        $project->created_at = now();

        if ($request->project_type === 'External') {
            $project->project_type = 1;
            $project->customer_id = $request->customer;
            $project->estimation_cost = $request->estimation_cost;
        } else {
            $project->project_type = 0;
            $project->customer = null;
            $project->estimation_cost = null;
        }

        $project->save();
        Log::info($project);

        // Continue storing tasks only if task_count is provided
        if ($request->has('task_names')) {
            // Get current count of tasks for this project to start from next number
            $existingTaskCount = Task::where('project_id', $project->id)->count();
            $taskIndex = $existingTaskCount + 1;
        
            foreach ($request->task_names as $task_name) {
                $task = new Task();
                $task->task_name = $task_name;
                $task->project_id = $project->id;
                $task->status = 0;
                $task->duration = 0;
                $task->created_at = now();
            
                // ✅ Generate project_task_code like: SOF_2504_0058-T001
                $task->project_task_code = $project->project_code . '_' . str_pad($taskIndex, 3, '0', STR_PAD_LEFT);
            
                $task->save();
                $taskIndex++; // increment for next task
            
                Log::info($task);
            }
        }

        return response()->json(['success' => true, 'message' => 'Project and tasks added successfully!']);
    } catch (\Exception $e) {
        Log::error('Error adding project and tasks: ' . $e->getMessage());
        return response()->json(['success' => false, 'message' => 'Failed to add project and tasks. Please try again.'], 500);
    }
}
public function projectsection_updates(Request $request)
{
    DB::table('project_section')
        ->where('id', $request->id)
        ->update([
            'section_type' => $request->section_type,
            'section' => $request->section,
            'section_count' => $request->section_count,
            'updated_at' => now(),
        ]);

    return redirect()->back()->with('success', 'Section updated successfully.');
}
public function projectsection_delete(Request $request)
{
    $sectionId = $request->id;

    DB::table('project_section')
        ->where('id', $sectionId)
        ->update([
            'active' => 1,  // Mark as active
            'updated_at' => now(),
        ]);

    return redirect()->back()->with('success', 'Section activated successfully.');
}
public function projectsection_add(Request $request)
{
    DB::table('project_section')->insert([
        'section_type' => $request->section_type,
        'section' => $request->section,
        'section_count' => $request->section_count,
        'active' => 0,
        'created_at' => now(),
        'updated_at' => now(),
        'created_by'    => Auth::id(),
        'updated_by'    => Auth::id(),
    ]);

    return redirect()->back()->with('success', 'Section added successfully.');
}

public function projectsession_index()
{
     
    $sections = DB::table('project_section')->where('active', 0)->get(); // make sure this line is included

    return view('laravel.project.project_session', compact('sections'));
}
    
public function customer()
{
    $customers = DB::table('customers')
    ->select('id',
     'company_name', 
     'customer_name', 
     'location', 
     'project_count', 
     'connected_year', 
     'short_name')
    ->get();


return view('laravel.project.customer', compact('customers'));
}
    
public function view($id)
{
    $customer = DB::table('customers')->where('id', $id)->first();
    return view('laravel.project.customer_view', compact('customer'));
}

public function store(Request $request)
{
    $request->validate([
        'company_name' => 'required|string|max:255',
        'customer_name' => 'nullable|string|max:255',
        'location' => 'required|string|max:255',
        'project_count' => 'nullable|integer',
        'connected_year' => 'required|integer',
        'short_name' => 'nullable|string|max:255',
    ]);

    try {
        DB::table('customers')->insert([
            'company_name' => $request->company_name,
            'customer_name' => $request->customer_name,
            'location' => $request->location,
            'project_count' => $request->project_count,
            'connected_year' => $request->connected_year,
            'short_name' => $request->short_name,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['success' => true]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'Database insert failed.',
            'error' => $e->getMessage()
        ], 500);
    }
}

public function updates(Request $request, $id)
{
    $customer = DB::table('customers')->where('id', $id)->first();

    if (!$customer) {
        return response()->json(['success' => false, 'message' => 'Customer not found.'], 404);
    }

    try {
        DB::table('customers')->where('id', $id)->update([
            'customer_name' => $request->customer_name,
            'company_name' => $request->company_name,
            'location' => $request->location,
            'project_count' => $request->project_count,
            'connected_year' => $request->connected_year,
            'short_name' => $request->short_name,
            'updated_at' => now(),
        ]);

        return response()->json(['success' => true, 'message' => 'Customer updated successfully']);
    } catch (\Exception $e) {
        return response()->json(['success' => false, 'message' => 'Update failed.', 'error' => $e->getMessage()], 500);
    }
}




public function destroy($id)
{
    
    $customer = DB::table('customers')->where('id', $id)->first();

    if (!$customer) {
        return response()->json(['success' => false, 'message' => 'Customer not found.'], 404);
    }

    try {
        // Delete the customer
        DB::table('customers')->where('id', $id)->delete();

        return response()->json(['success' => true]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'Delete failed.',
            'error' => $e->getMessage()
        ], 500);
    }
}
  
public function show($id)
    {
        $customer = Customer::findOrFail($id);
        $projects = Project::where('customer_id', $id)->get();
        return view('laravel.project.invoicedetails', compact('customer','projects'));
    }

    public function invoice()
    {
        $customers = Customer::where('active', 0)->get();
        return view('laravel.project.invoice', compact('customers'));
    }




   public function invoice_store(Request $request)
    {
        $request->validate([
            'unit_amount' => 'required|numeric',
            'date_issued' => 'required|date',
            'due_date' => 'required|date',
            'notes' => 'nullable|string',
            // 'created_by' => 'required|string', // Optionally, you can remove this if it's automatically set
        ]);
        $lastInvoiceNumber = Invoice::max('invoice_number') ?? 999;

        $invoice = new Invoice();
        $invoice->customer_id = $request->customer_id; // ✅ Insert customer ID
        $invoice->project_id = $request->project_id; // ✅ Insert customer ID
        $invoice->invoice_number = $lastInvoiceNumber + 1; // Auto increment
        $invoice->unit_amount = $request->unit_amount;
        $invoice->date_issued = $request->date_issued;
        $invoice->due_date = $request->due_date;
        $invoice->notes = $request->notes;
        $invoice->created_by = Auth::id(); // Assign logged-in user's ID to created_by
        $invoice->updated_by = Auth::id(); // Assign logged-in user's ID to updated_by
        $invoice->save();

        return redirect()->route('customer.show', $request->customer_id)
        ->with('success', 'Invoice created successfully');
    }

}
