@extends('layouts.app')

@section('content')
    <nav class="navbar navbar-main navbar-expand-lg  px-0 mx-4 shadow-none border-radius-xl z-index-sticky " id="navbarBlur"
        data-scroll="false">
        <div class="container-fluid py-1 px-3">
            @include('layouts.navbars.auth.topnav', ['title' => 'New Role'])
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none ">
                <a href="javascript:;" class="nav-link p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                        <input type="text" class="form-control" placeholder="Type here...">
                    </div>
                </div>
                <ul class="navbar-nav  justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        @include('auth.logout')
                    </li>
                    <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                            <div class="sidenav-toggler-inner">
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                            </div>
                        </a>
                    </li>
                    <li class="nav-item px-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0">
                            <i class="fa fa-cog fixed-plugin-button-nav cursor-pointer"></i>
                        </a>
                    </li>
                    <li class="nav-item position-relative pe-2 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-bell cursor-pointer"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end px-2 py-3 me-sm-n4" aria-labelledby="dropdownMenuButton">
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../../assets/img/team-2.jpg" class="avatar avatar-sm  me-3 "
                                                alt="user image">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New message</span> from Laur
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                13 minutes ago
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../../assets/img/small-logos/logo-spotify.svg"
                                                class="avatar avatar-sm bg-gradient-dark  me-3 " alt="logo spotify">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New album</span> by Travis Scott
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                1 day
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="avatar avatar-sm bg-gradient-secondary  me-3  my-auto">
                                            <svg width="12px" height="12px" viewBox="0 0 43 36" version="1.1"
                                                xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink">
                                                <title>credit-card</title>
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <g transform="translate(-2169.000000, -745.000000)" fill="#FFFFFF"
                                                        fill-rule="nonzero">
                                                        <g transform="translate(1716.000000, 291.000000)">
                                                            <g transform="translate(453.000000, 454.000000)">
                                                                <path class="color-background"
                                                                    d="M43,10.7482083 L43,3.58333333 C43,1.60354167 41.3964583,0 39.4166667,0 L3.58333333,0 C1.60354167,0 0,1.60354167 0,3.58333333 L0,10.7482083 L43,10.7482083 Z"
                                                                    opacity="0.593633743"></path>
                                                                <path class="color-background"
                                                                    d="M0,16.125 L0,32.25 C0,34.2297917 1.60354167,35.8333333 3.58333333,35.8333333 L39.4166667,35.8333333 C41.3964583,35.8333333 43,34.2297917 43,32.25 L43,16.125 L0,16.125 Z M19.7083333,26.875 L7.16666667,26.875 L7.16666667,23.2916667 L19.7083333,23.2916667 L19.7083333,26.875 Z M35.8333333,26.875 L28.6666667,26.875 L28.6666667,23.2916667 L35.8333333,23.2916667 L35.8333333,26.875 Z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </svg>
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                Payment successfully completed
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                2 days
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <div class="card mx-1 my-1  mt-1 pt-1" id="basic-info">

		<div class="card-header  mt-1 pt-1">

			<h5>@lang('words.newworkordersss')</h5>

		</div>

		<div class="card-body mt-1 pt-1">

			<form method="POST" action="{{ route('wo_create.store') }}" enctype="multipart/form-data">

				@csrf

				<div class="row">

					<div class="col-lg-6  mt-2">

						<label class="form-label">@lang('words.woname')</label>

						<div class="input-group">

							<input id="inWorkOrderName" name="inWorkOrderName" class="form-control" type="text"

								placeholder="@lang('words.woname')" value="">

						</div>

						@error('name')

							<p class='text-danger text-xs pt-1'> {{ $message }} </p>

						@enderror

					</div>

					

					<div class="col-lg-6  mt-2">

						<label class="form-label">@lang('words.woarea')</label>

						<select name="selWorkarea" id="selWorkarea" class="form-control">

							<option value="">...</option>									

							@foreach($workAreaList as $workArea)

								<option value='{{$workArea->id}}'>{{$workArea->workarea_name}}</option>

							@endforeach                                    

						</select>                               

					</div>

				</div>

				

				<div class="row">

					<div class="col-lg-6 mt-2">

						<label class="form-label">@lang('words.plannedstartdate')</label>

						<div class="input-group">

							<input id="startdate" name="startdate" class="form-control" type="date" value="" onfocus="this.showPicker()">

						</div>

						@error('name')

							<p class='text-danger text-xs pt-1'> {{ $message }} </p>

						@enderror

					</div>

				

					<div class="col-lg-6 mt-2">

						<label class="form-label">@lang('words.plannedenddate')</label>

						<div class="input-group">

							<input id="enddate" name="enddate" class="form-control" type="date" value="" onfocus="this.showPicker()">

						</div>

						@error('name')

							<p class='text-danger text-xs pt-1'> {{ $message }} </p>

						@enderror

					</div>

				</div>





				<div class="d-flex justify-content-center mt-4">                                

					<button id="btnCreate" onclick="createWorkOrder();" type="button" class="btn btn-success m-0 ms-2">@lang('words.create')</button>

				</div>

			</form>

		</div>

        

    </div>

@endsection



@push('css')

	

    <style>

        .choices {

            margin-bottom: 0;

        }

    </style>

@endpush



@push('js')

    <script src="/assets/js/plugins/choices.min.js"></script>

	<script src="/assets/js/core/jquery.min.js"></script>

	<script src="/assets/js/plugins/sweetalert.min.js"></script>

    <script>

	function profileSetting(user){
        window.location.href = "/profileView/"+user;
    }

	

	var workOrderName = "";

	var workAreaId = 0;

	var workAreaName = "";

	var startDateTxt = "";

	var endDateTxt = "";

	var workOrderId = 0;

	

	$(document).ready(function() {

		

	});

	

	

	function createWorkOrder() {

		workOrderName = $("#inWorkOrderName").val();

		var errorMsg = "";

		if ($.trim(workOrderName)=="")
		{
			$("#inWorkOrderName").focus(); 

			Swal.fire({
				icon: 'warning',
				title: '@lang('words.workorder')',
				text: '@lang('words.pleaseenterworkordername')',

				//html: '<div class="form-group"><label class="form-label">Please enter Work Order Name.</label></div>',

				showCancelButton: false,
				customClass: {
				  confirmButton: 'btn btn-success mx-2',
				  //cancelButton: 'btn btn-danger mx-2'
				},
				buttonsStyling: false
			  }).then(function (result) {
				
				});
		
			  return;
		}

		

		var pattern = /^\d{4}[A-Z]{2}$/ ;

		

		if (!pattern.test(workOrderName)) {

			 

			$("#inWorkOrderName").focus();

			  

			Swal.fire({

				icon: 'warning',

				title: '@lang('words.workorder')',

				title: '@lang('words.invalidworkorderformat')',

				//html: '<div class="form-group"><label class="form-label">Invalid Work Order Name format!</label></div>',

				showCancelButton: false,

				customClass: {

				  confirmButton: 'btn btn-success mx-2',

				  //cancelButton: 'btn btn-danger mx-2'

				},

				buttonsStyling: false

			}).then(function (result) {

				

				});

			  

			  return;

		  } 

		

		var fd = new FormData();

		

		fd.append('workOrderName',workOrderName);

		

		fd.append('_token','{{csrf_token()}}');

		

		$.ajax({

			 

			url: '{{ route('check_workordername') }}',

			type: 'post',

			data:fd,

			contentType: false,

			processData: false,

			success: function(response){

				if(response.result){

					$('#inWorkOrderName').focus();

					//console.log(response);

					//alert(response.result);

					Swal.fire({

						icon: 'warning',

						title: '@lang('words.workorder')',

						text: '@lang('words.workordernamealreadyexists')',

						//html: '<div class="form-group"><label class="form-label">Work Order Name Already Exists.</label></div>',

						showCancelButton: false,

						customClass: {

						  confirmButton: 'btn btn-success mx-2'

						},

						buttonsStyling: false

					  }).then(function (result) {

						$('#inWorkOrderName').val('').focus();

					  });

				  

				}else{

					validateFileds();

				}

				

			},

		});

	}

	function validateFileds(){



		workAreaId =$("#selWorkarea").val();

		

		if (workAreaId <= 0) {

			 

			$("#selWorkarea").focus();

			  

			Swal.fire({

				icon: 'warning',

				title: '@lang('words.workorder')',

				text: '@lang('words.pleaseselecttheworkarea')',

				//html: '<div class="form-group"><label class="form-label">Please select the workarea!</label></div>',

				showCancelButton: false,

				customClass: {

				  confirmButton: 'btn btn-success mx-2',

				  //cancelButton: 'btn btn-danger mx-2'

				},

				buttonsStyling: false

			  }).then(function (result) {

				

			  });

			  

			  return;

		} 

		if($("#startdate").val() == "")

		{

			Swal.fire({

				icon: 'warning',

				title: '@lang('words.workorder')',

				text: '@lang('words.pleaseselectstartdate')',

				//html: '<div class="form-group"><label class="form-label">Please Select EndDate </label></div>',

				showCancelButton: false,

				customClass: {

				  confirmButton: 'btn btn-success mx-2',

				  //cancelButton: 'btn btn-danger mx-2'

				},

				buttonsStyling: false

			  }).then(function (result) {

				

			  });

			  

			  return;

		}
		

		startDateTxt =$("#startdate").val();

		

		if($("#enddate").val() == "")

		{

			Swal.fire({

				icon: 'warning',

				title: '@lang('words.workorder')',

				text: '@lang('words.pleaseselectenddate')',

				//html: '<div class="form-group"><label class="form-label">Please Select EndDate </label></div>',

				showCancelButton: false,

				customClass: {

				  confirmButton: 'btn btn-success mx-2',

				  //cancelButton: 'btn btn-danger mx-2'

				},

				buttonsStyling: false

			  }).then(function (result) {

				

			  });

			  

			  return;

		}

		

		endDateTxt =$("#enddate").val();

		

		

		

		sendCreateRequest();

			

	}

	

	

	function sendCreateRequest()

	{		

		var fd = new FormData();

		

		fd.append('workOrderName',workOrderName);

		fd.append('workAreaId',workAreaId);

		fd.append('workAreaName',workAreaName);

		fd.append('planned_startdate',startDateTxt);

		fd.append('planned_enddate',endDateTxt);

		

		fd.append('_token','{{csrf_token()}}');

		

		$.ajax({

			 

			url: '{{ route('workorder_create') }}',

			type: 'post',

			data:fd,

			contentType: false,

			processData: false,

			success: function(response){

			 workOrderId = response.workorderid;

				Swal.fire({

					icon: 'success',

					title: workOrderName,

					text: '@lang('words.workordercreatedsuccessfully')',

					//html: '<div class="form-group"><label class="form-label">Work Order Name Already Exists.</label></div>',

					showCancelButton: false,

					customClass: {

					  confirmButton: 'btn btn-success mx-2'

					},

					buttonsStyling: false

				  }).then(function (result) {

						window.location.href = "/home";

				  });
			},
		});
	}
    </script>

@endpush

