@extends('layouts.app')

@section('content')
<div class="d-flex justify-content-center" style="margin-top: 10%;">
    <div class="card shadow-sm" style="width: 80%; max-width: 1000px;">
        <div class="card-header bg-primary text-white text-center">
            <h5 class="mb-0">Customer List</h5>
        </div>
        <div class="card-body p-3"> {{-- Reduced padding --}}
            <table class="table table-bordered table-striped text-center align-middle table-sm w-100">
                <thead class="thead-dark">
                    <tr>
                        <th>Company Name</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($customers as $customer)
                        <tr>
                            <td class="text-sm font-weight-normal">
                                {{ $customer->company_name }}
                            </td>
                            <td>
                                <button class="btn btn-primary btn-sm"
                                    data-id="{{ $customer->id }}"
                                    onclick="viewproject(this)">
                                    <i class="fa fa-eye"></i> View
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    function viewproject(button) {
        // Get the customer ID from the data attribute
        var customerId = button.getAttribute('data-id');

        // Redirect to the customer detail page
        window.location.href = '/customers/' + customerId;
    }
</script>
<style>
    table{
        margin-top: 2%;
        background-color: white;
        width: 100px;

    }
</style>
@endsection
