@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <div class="card shadow">
        <div class="card-header bg-secondary text-white text-center">
            <h4 class="mb-0">Invoice Details</h4>
        </div>
        <div class="card-body">
            <form action="{{ route('invoices.store') }}" method="POST">
                @csrf

                @if ($projects->count() > 0)
                    @foreach ($projects as $project)
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="project_name" class="form-label">Project Name</label>
                                <input type="text" class="form-control form-control-sm" name="project_name"
                                    value="{{ $project->project_name }}" readonly>
                            </div>
                            <div class="col-md-6">
                                <label for="Estimation_cost" class="form-label">Estimation Cost</label>
                                <input type="text" class="form-control form-control-sm" name="Estimation_cost"
                                    value="{{ $project->estimation_cost }}" readonly>
                            </div>
                        </div>
                        <input type="hidden" name="project_id" value="{{ $project->id }}">
                    @endforeach
                @else
                    <p class="text-muted">No projects found for this customer.</p>
                @endif

                <input type="hidden" name="customer_id" value="{{ $customer->id }}">

                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="unit_amount" class="form-label">Unit Amount</label>
                        <input type="text" class="form-control form-control-sm" name="unit_amount"
                            value="{{ old('unit_amount') }}" required>
                        @error('unit_amount')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-3">
                        <label for="date_issued" class="form-label">Date Issued</label>
                        <input type="date" class="form-control form-control-sm" name="date_issued"
                            value="{{ old('date_issued', now()->toDateString()) }}" required>
                    </div>

                    <div class="col-md-3">
                        <label for="due_date" class="form-label">Due Date</label>
                        <input type="date" class="form-control form-control-sm" name="due_date"
                            value="{{ old('due_date') }}" required>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="notes" class="form-label">Notes</label>
                    <textarea class="form-control form-control-sm" name="notes" rows="2">{{ old('notes') }}</textarea>
                </div>
                <div class="d-flex justify-content-between">
                    <a href="{{ route('invoice') }}" class="btn btn-sm btn-danger">
                        <i class="fa fa-arrow-left me-1"></i> Back
                    </a>
                    <button type="submit" class="btn btn-sm btn-success">Save Invoice</button>
                </div>

            </form>
        </div>
    </div>
</div>
<style>
    h4{
        font-family: Arial, Helvetica, sans-serif;
    }
</style>
@endsection
