<?php

use Illuminate\Support\Facades\Route;


use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\ResetPassword;
use App\Http\Controllers\Auth\ChangePassword;
use App\Http\Controllers\PageController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\TagController;
use App\Http\Controllers\ItemController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\UserWorkController;
/*
|---------------------------------------Route::post('/store-project', [ProjectController::class, 'addtasks'])->name('store-project');
Route::post('/store-task', [ProjectController::class, 'addtasks'])->name('tasks.store');
Route::post('/project.store', [ProjectController::class, 'storeProjectWithTasks'])->name('project.store');
-----------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
	return redirect('/landing');
})->middleware('auth');

Route::get('/login', [LoginController::class, 'show'])->middleware('guest')->name('login');
Route::post('/login', [LoginController::class, 'login'])->middleware('guest')->name('login.perform');

Route::get('/register', [RegisterController::class, 'show'])->middleware('guest')->name('register');
Route::post('/register', [RegisterController::class, 'register'])->middleware('guest')->name('register.perform');

Route::get('/reset-password', [ResetPassword::class, 'show'])->middleware('guest')->name('reset-password');
Route::post('/reset-password', [ResetPassword::class, 'send'])->middleware('guest')->name('reset.perform');

Route::get('/change-password', [ChangePassword::class, 'show'])->middleware('guest')->name('change-password');
Route::post('/change-password', [ChangePassword::class, 'update'])->middleware('guest')->name('change.perform');

Route::group(['middleware' => 'auth'], function () {
// Return only task details as JSON
Route::get('/get-project-tasks/{id}', [TaskController::class, 'getProjectTasks']);
Route::get('/get-project-data/{id}', [TaskController::class, 'getProjectData']);

    Route::get('/user-profile', [ProfileController::class, 'show'])->name('user-profile');
    Route::post('/user-profile', [ProfileController::class, 'update'])->name('user-profile.perform');
    Route::get('/projectview', [ProjectController::class, 'index'])->name('projectview');
    Route::get('/viewproject/{id}', [ProjectController::class, 'viewproject'])->name('viewproject');
	Route::post('/store-project', [ProjectController::class, 'addtasks'])->name('store-project');
Route::post('/store-task', [ProjectController::class, 'addtasks'])->name('tasks.store');
Route::post('/project.store', [ProjectController::class, 'storeProjectWithTasks'])->name('project.store');
Route::get('/viewworkorder/{id}', [WorkOrderController::class, 'viewWorkOrder'])->name('viewworkorder');
Route::get('/home_preproduction', [HomeController::class, 'index_PreProduction'])->name('home_preproduction');
Route::get('/assignToUserPreproduction/{id}', [HomeController::class, 'assignToUserPreproduction'])->name('assignToUserPreproduction');
Route::post('/assignToUserPreproductionPost', [HomeController::class, 'assignToUserPreproductionPost'])->name('assignToUserPreproductionPost');
Route::post('/getuserroleforid', [UserWorkController::class, 'getuserroleforid'])->name('getuserroleforid');
Route::post('/assigntasktouser', [ProjectController::class, 'assigntasktouser'])->name('assigntasktouser');
	Route::post('/assigntasktousers', [ProjectController::class, 'assigntasktousers'])->name('assigntasktousers');
	Route::get('/updateuserproject/{id}', [ProjectController::class, 'updateuserproject'])->name('updateuserproject');
	//-krishna
    Route::get('/projectcustomer', [ProjectController::class, 'customer'])->name('projectcustomer');
    Route::get('/customers/view/{id}', [ProjectController::class, 'view']); 
   
    Route::post('/customers/store', [ProjectController::class, 'store'])->name('customers.store');
    Route::put('/customers/update/{id}', [ProjectController::class, 'updates'])->name('customers.update');
    Route::delete('/customers/delete/{id}', [ProjectController::class, 'destroy']);

    Route::get('/invoice', [ProjectController::class, 'invoice'])->name('invoice');
    Route::get('/customers/{id}', [ProjectController::class, 'show'])->name('customer.show');
    Route::post('/invoices', [ProjectController::class, 'invoice_store'])->name('invoices.store');

    Route::get('/projectsessionview', [ProjectController::class, 'projectsession_index'])->name('projectsessionview');
    Route::post('/project-sections/update', [ProjectController::class, 'projectsection_updates'])->name('project-sections.update');
    Route::post('/project-sections/delete', [ProjectController::class, 'projectsection_delete'])->name('project-sections.delete');
    Route::post('/project-sections/add', [ProjectController::class, 'projectsection_add'])->name('project-sections.add');

Route::get('/updateproject/{id}', [TaskController::class, 'updateproject'])->name('updateproject');

Route::post('/save-task', [TaskController::class, 'saveTask']);
//
Route::get('/task/details/{taskId}', [TaskController::class, 'getTaskDetails']);
Route::post('/task/update/{taskId}', [TaskController::class, 'updateTask']);
Route::post('/update-task-action', [ProjectController::class, 'updateTaskAction'])->name('update-task-action');
Route::post('/update-user-action', [UserController::class, 'updateuserAction'])->name('update-user-action');
Route::get('/viewuser/{id}', [UserController::class, 'viewUser'])->name('viewuser');

Route::get('/wo_create', [WorkOrderController::class, 'index'])->name('wo_create');
Route::post('/wo_create', [WorkOrderController::class, 'store'])->name('wo_create.store');
Route::post('/wo_create-store', [ObjectController::class, 'save_objects'])->name('wo_create-store');

Route::post('/workorder_create', [WorkOrderController::class, 'workorder_create'])->name('workorder_create');
Route::post('/check_workordername', [WorkOrderController::class, 'check_WorkOrderName'])->name('check_workordername');
Route::get('/generate-project-code', [ProjectController::class, 'generateProjectCode'])->name('generate.project.code');


    Route::controller(UserController::class)->group(function() {
        Route::get('/user-management', 'index')->name('user-management');
        Route::get('/user-management/new', 'create')->name('user-new');
        Route::post('/user-management/new', 'store')->name('user-new.store');
        Route::get('/user-management/edit/{id}', 'edit')->name('user-edit');
        Route::post('/user-management/edit/{id}', 'update')->name('user-edit.update');
        Route::post('/user-delete/{id}', 'destroy')->name('user-destroy');
    });

    Route::controller(RoleController::class)->group(function() {
        Route::get('/role-management', 'index')->name('role-management');
        Route::get('/role-management/new', 'create')->name('role-new');
        Route::post('/role-management/new', 'store')->name('role-new.store');
        Route::get('/role-management/edit/{id}', 'edit')->name('role-edit');
        Route::post('/role-management/edit/{id}', 'update')->name('role-edit.update');
        Route::post('/role-delete/{id}', 'destroy')->name('role-destroy');
    });

    Route::controller(CategoryController::class)->group(function() {
        Route::get('/category-management', 'index')->name('category-management');
        Route::get('/category-management/new', 'create')->name('category-new');
        Route::post('/category-management/new', 'store')->name('category-new.store');
        Route::get('/category-management/edit/{id}', 'edit')->name('category-edit');
        Route::post('/category-management/edit/{id}', 'update')->name('category-edit.update');
        Route::post('/category-delete/{id}', 'destroy')->name('category-destroy');
    });

    Route::controller(TagController::class)->group(function() {
        Route::get('/tag-management', 'index')->name('tag-management');
        Route::get('/tag-management/new', 'create')->name('tag-new');
        Route::post('/tag-management/new', 'store')->name('tag-new.store');
        Route::get('/tag-management/edit/{id}', 'edit')->name('tag-edit');
        Route::post('/tag-management/edit/{id}', 'update')->name('tag-edit.update');
        Route::post('/tag-delete/{id}', 'destroy')->name('tag-destroy');
    });

    Route::controller(ItemController::class)->group(function() {
        Route::get('/item-management', 'index')->name('item-management');
        Route::get('/item-management/new', 'create')->name('item-new');
        Route::post('/item-management/new', 'store')->name('item-new.store');
        Route::get('/item-management/edit/{id}', 'edit')->name('item-edit');
        Route::post('/item-management/edit/{id}', 'update')->name('item-edit.update');
        Route::post('/item-delete/{id}', 'destroy')->name('item-destroy');
    });

    Route::get('/{page}', [PageController::class, 'dashboards'])->name('dashboards');

    Route::get('/pages/profile/{page}', [PageController::class, 'profiles'])->name('profiles');

    Route::get('/pages/user/{page}', [PageController::class, 'users'])->name('users');

    Route::get('/pages/account/{page}', [PageController::class, 'accounts'])->name('accounts');

    Route::get('/pages/project/{page}', [PageController::class, 'projects'])->name('projects');

    Route::get('/pages/{page}', [PageController::class, 'pages'])->name('pages');

    Route::get('/applications/{page}', [PageController::class, 'applications'])->name('applications');

    Route::get('/ecommerce/products/{page}', [PageController::class, 'products'])->name('products');

    Route::get('/ecommerce/orders/{page}', [PageController::class, 'orders'])->name('orders');

    Route::get('/ecommerce/{page}', [PageController::class, 'ecommerce'])->name('ecommerce');

    Route::get('/authentication/sign-in/{page}', [PageController::class, 'signins'])->name('signins');

    Route::get('/authentication/sign-up/{page}', [PageController::class, 'signups'])->name('signups');

    Route::get('/authentication/reset-password/{page}', [PageController::class, 'resets'])->name('resets');

    Route::get('/authentication/lock/{page}', [PageController::class, 'locks'])->name('locks');

    Route::get('/authentication/verification/{page}', [PageController::class, 'verifications'])->name('verifications');

    Route::get('/authentication/errors/{page}', [PageController::class, 'errors'])->name('errors');

    Route::post('logout', [LoginController::class, 'logout'])->name('logout');
});
