

<?php $__env->startSection('content'); ?>
    <nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none border-radius-xl z-index-sticky" id="navbarBlur" data-scroll="false">
        <div class="container-fluid py-1 px-3">
            <?php echo $__env->make('layouts.navbars.auth.topnav', ['title' => 'Customers'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none">
                <a href="javascript:;" class="nav-link p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                        <input type="text" class="form-control" placeholder="Type here...">
                    </div>
                </div>
                <ul class="navbar-nav justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        <?php echo $__env->make('auth.logout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </li>
                    <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="iconNavbarSidenav">
                            <div class="sidenav-toggler-inner">
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                                <i class="sidenav-toggler-line bg-white"></i>
                            </div>
                        </a>
                    </li>
                    <li class="nav-item px-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0">
                            <i class="fa fa-cog fixed-plugin-button-nav cursor-pointer"></i>
                        </a>
                    </li>
                    <li class="nav-item position-relative pe-2 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-white p-0" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-bell cursor-pointer"></i>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<div class="container-fluid py-4">
    <div class="row mb-5">
        <div class="col-lg-9 col-12 mx-auto">
            <div class="card card-body mt-4">
                <h3 class="text-center mt-4">Customer Details</h3>

                <div class="row" style="margin-left:auto;">
                    <button class="btn btn-icon5 text-white" style="background-color:#B17457;" onclick="$('#addCustomerModal').modal('show')">
                        <span class="btn-inner--icon"><i class="fa fa-user"></i></span>
                        <span class="btn-inner--text ms-1"> + Add New Customer</span>
                    </button>
                </div>

              
<!-- Modal Structure -->
<div class="modal fade" id="addCustomerModal" tabindex="-1" aria-labelledby="addCustomerLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="addCustomerForm">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="addCustomerLabel">Add New Customer</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-2">
                        <label for="company_name" class="form-label">Company Name</label>
                        <input id="company_name" name="company_name" class="form-control" placeholder="Company Name" required>
                    </div>
                    <div class="mb-2">
                        <label for="customer_name" class="form-label">Customer Name</label>
                        <input id="customer_name" name="customer_name" class="form-control" placeholder="Customer Name">
                    </div>
                    <div class="mb-2">
                        <label for="location" class="form-label">Location</label>
                        <input id="location" name="location" class="form-control" placeholder="Location" required>
                    </div>
                    <div class="mb-2">
                        <label for="connected_year" class="form-label">Connected Year</label>
                        <input id="connected_year" name="connected_year" class="form-control" placeholder="Connected Year" required>
                    </div>
                    <div class="mb-2">
                        <label for="short_name" class="form-label">Short Name</label>
                        <input id="short_name" name="short_name" class="form-control" placeholder="Short Name">
                    </div>
                    <div class="mb-2">
                        <label for="project_count" class="form-label">Project Count</label>
                        <input id="project_count" name="project_count" class="form-control" placeholder="Project Count" type="number">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Save</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="table-responsive mt-4">
    <table class="table table-bordered" id="customerTable">
        <thead class="table-dark">
            <tr class="text-center">
                <th class="text-sm">Company Name</th>
                <th class="text-sm">Customer Name</th>
                <th class="text-sm text-center">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="text-center">
                    <td><span class="fw-bold" style="font-size: 18px;"><?php echo e($customer->company_name); ?></span></td>
                    <td><span class="fw-bold" style="font-size: 18px;"><?php echo e($customer->customer_name); ?></span></td>
                    <td class="text-center">
                        <a href="<?php echo e(url('/customers/view/'.$customer->id)); ?>" class="btn btn-sm btn-info me-1" title="View">
                        <i class="fas fa-eye" style="font-size: 17px;"></i>
                        </a>

                        <button class="btn btn-sm btn-warning me-1" title="Edit"
                            onclick="confirmUpdate(
                                '<?php echo e($customer->id); ?>',
                                '<?php echo e($customer->customer_name); ?>',
                                '<?php echo e($customer->company_name); ?>',
                                '<?php echo e($customer->location); ?>',
                                '<?php echo e($customer->project_count); ?>',
                                '<?php echo e($customer->connected_year); ?>',
                                '<?php echo e($customer->short_name); ?>'
                            )">
                             <i class="fas fa-edit fa-lg" style="font-size: 17px;"></i>
                        </button>

                        <button class="btn btn-sm btn-danger" title="Delete"
                            onclick="confirmDelete('<?php echo e($customer->id); ?>', '<?php echo e($customer->company_name); ?>')">
                            <i class="fa fa-trash" style="font-size: 17px;"></i>
                        </button>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<div id="noDataMessage" class="container justify-content-center text-center" style="display: none;">
    <?php echo app('translator')->get('words.nmresultsfound'); ?>
</div>


</div>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
function confirmDelete(id, name) {
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

    Swal.fire({
        title: 'Are you sure?',
        text: `Do you want to delete customer: ${name}?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'Cancel',
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/customers/delete/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Content-Type': 'application/json'
                }
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('Deleted!', 'Customer has been deleted.', 'success')
                    .then(() => location.reload());
                } else {
                    Swal.fire('Error!', 'Something went wrong.', 'error');
                }
            })
            .catch(() => {
                Swal.fire('Error!', 'Failed to delete. Try again later.', 'error');
            });
        }
    });
}


    document.getElementById('addCustomerForm').addEventListener('submit', function (e) {
    e.preventDefault();

    const form = e.target;
    const formData = new FormData(form);

    fetch('<?php echo e(route("customers.store")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire('Success!', 'Customer added successfully.', 'success')
            .then(() => {
                form.reset();
                let modal = bootstrap.Modal.getInstance(document.getElementById('addCustomerModal'));
                modal.hide();
                location.reload(); // or update the view dynamically
            });
        } else {
            Swal.fire('Error!', data.message || 'Something went wrong.', 'error');
        }
    })
    .catch(error => {
        console.error(error);
        Swal.fire('Error!', 'Failed to add customer. Please try again.', 'error');
    });
});

function confirmUpdate(id, customerName, companyName, location, projectCount, connectedYear, shortName) {
    const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

    Swal.fire({
        title: 'Edit Customer',
        html: `
            <div style="display: flex; align-items: center; margin-bottom: 10px;">
            <label for="swal-customer_name" style="width: 130px;">Customer Name</label>
            <input id="swal-customer_name" class="swal2-input" placeholder="Customer Name" value="${customerName}">
        </div>
        <div style="display: flex; align-items: center; margin-bottom: 10px;">
            <label for="swal-company_name" style="width: 130px;">Company Name</label>
            <input id="swal-company_name" class="swal2-input" placeholder="Company Name" value="${companyName}">
        </div>
        <div style="display: flex; align-items: center; margin-bottom: 10px;">
            <label for="swal-location" style="width: 130px;">Location</label>
            <input id="swal-location" class="swal2-input" placeholder="Location" value="${location}">
        </div>
        <div style="display: flex; align-items: center; margin-bottom: 10px;">
            <label for="swal-project_count" style="width: 130px;">Project Count</label>
            <input id="swal-project_count" class="swal2-input" placeholder="Project Count" value="${projectCount}">
        </div>
        <div style="display: flex; align-items: center; margin-bottom: 10px;">
            <label for="swal-connected_year" style="width: 130px;">Connected Year</label>
            <input id="swal-connected_year" class="swal2-input" placeholder="Connected Year" value="${connectedYear}">
        </div>
        <div style="display: flex; align-items: center; margin-bottom: 10px;">
            <label for="swal-short_name" style="width: 130px;">Short Name</label>
            <input id="swal-short_name" class="swal2-input" placeholder="Short Name" value="${shortName}">
        </div>
        `,
        focusConfirm: false,
        showCancelButton: true,
        confirmButtonText: 'Save Changes',
        cancelButtonText: 'Cancel',
        preConfirm: () => {
            return {
                customer_name: document.getElementById('swal-customer_name').value,
                company_name: document.getElementById('swal-company_name').value,
                location: document.getElementById('swal-location').value,
                project_count: document.getElementById('swal-project_count').value,
                connected_year: document.getElementById('swal-connected_year').value,
                short_name: document.getElementById('swal-short_name').value
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const formData = result.value;

            fetch(`/customers/update/${id}`, {
                method: 'PUT',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('Updated!', 'Customer has been updated.', 'success')
                        .then(() => location.reload());
                } else {
                    Swal.fire('Error!', data.message || 'Something went wrong.', 'error');
                }
            })
            .catch(() => {
                Swal.fire('Error!', 'Failed to update. Try again later.', 'error');
            });
        }
    });
}

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\project_management\resources\views/laravel/project/customer.blade.php ENDPATH**/ ?>