<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

use App\Models\Item;
use App\Models\Category;
use App\Models\Tag;

class DashboardController extends Controller
{
    public function index(Item $model)
    {
        return view('laravel.items.index', ['items' => $model->all()]);
    }

    public function welcome_page()
    {
        if (view()->exists("laravel.dashboards.welcome_page")) {
            return view("laravel.dashboards.welcome_page");
        }

        return abort(404);
    }

    public function dealanalysis_page()
    {
        if (view()->exists("laravel.dashboards.dealanalysis_page")) {
            return view("laravel.dashboards.dealanalysis_page");
        }

        return abort(404);
    }

    public function dealprocess_page()
    {
        if (view()->exists("laravel.dashboards.dealprocess_page")) {
            return view("laravel.dashboards.dealprocess_page");
        }

        return abort(404);
    }
}
