@extends('layouts.app')

@section('content')
    @include('layouts.navbars.guest.topnav', [
        'classes' => 'top-0 z-index-3 w-100 shadow-none my-3 navbar-transparent mt-4',
        'container' => 'container',
        'text' => 'text-white',
        'arrow' => '/assets/img/down-arrow-white.svg',
    ])

    <main class="main-content mt-0">
        <div class="container-fluid">
            <div class="row g-0 min-vh-100">
                
                {{-- Left side: Login Card --}}
                <div class="col-lg-6 d-flex align-items-center justify-content-center bg-white">
                    <div class="card shadow-sm border rounded p-4" style="max-width: 400px; width: 100%;">
                        <div class="card-header pb-0 text-start bg-white border-0">
                            <h3 class="font-weight-bolder">Welcome back</h3>
                            <!-- <p class="mb-0">Enter your email and password to sign in</p> -->
                        </div>
                        <div class="card-body">
                            <form role="form" method="POST" action="{{ route('login.perform') }}" class="text-start">
                                @csrf
                                <label>Email</label>
                                <div class="mb-3">
                                    <input type="email" name="email" value="{{ old('email') ?? 'admin@argon.com' }}"
                                        class="form-control" placeholder="Email" aria-label="Email">
                                    @error('email') <p class='text-danger text-xs pt-1'> {{ $message }} </p> @enderror
                                </div>

                                <label>Password</label>
                                <div class="mb-3">
                                    <input type="password" name="password" value="secret" class="form-control"
                                        placeholder="Password" aria-label="Password">
                                    @error('password') <p class='text-danger text-xs pt-1'> {{ $message }} </p> @enderror
                                </div>

                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="rememberMe" checked="">
                                    <label class="form-check-label" for="rememberMe">Remember me</label>
                                </div>

                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary w-100 mt-4 mb-0">Sign in</button>
                                </div>
                            </form>
                        </div>
                        <div class="card-footer text-center pt-0 px-lg-2 px-1 bg-white border-0">
                            <p class="mb-1 text-sm mx-auto">
                                Forgot your password? Reset it
                                <a href="{{ route('reset-password') }}" class="text-primary text-gradient font-weight-bold">here</a>
                            </p>
                            <p class="mb-4 text-sm mx-auto">
                                Don't have an account?
                                <a href="{{ route('register') }}" class="text-primary font-weight-bold">Sign up</a>
                            </p>
                        </div>
                    </div>
                </div>

                {{-- Right side: Image --}}
                <div class="col-lg-6 d-none d-lg-block">
                    <div class="h-100 w-100" 
     style="background: url('assets/logo/Asset.png') no-repeat center center; background-size: cover;">
</div>

                </div>

            </div>
        </div>
    </main>
@endsection
