<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Deal Analysis - Sevi Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  

  <style>
    body {
      background-color: #f8f9fa;
    }
    .navbar-dark {
      background-color: #1b1b1b;
    }
    .card {
      border-radius: 15px;
      box-shadow: 0px 2px 5px rgba(0,0,0,0.1);
    }
.hero-section {
    background-color: #000; /* black background */
    color: #fff;            /* text in white */
    border-radius: 0px;    /* optional rounded edges */
    padding: 40px 30px;     /* make it taller */
    margin-bottom: 40px;    /* space so next content doesn't overlap */
}
.custom-overlap {
  margin-top: -200px;       /* reset */
  position: relative;
  z-index: 2;
}
    .custom-mt {
    margin-top: -130px;
    }
  </style>
</head>
<body>

  <!-- Navbar -->
  <nav class="navbar navbar-dark navbar-expand-lg px-3" style="background-color: #000;">
    <a class="navbar-brand fw-bold text-warning d-flex align-items-center" href="#">
      <img src="assets/logo/Logo.png" alt="Logo" style="height: 40px; width: auto; object-fit: contain;">
    </a>
    <div class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto">
        <li class="nav-item">
            <a class="nav-link" href="{{ route('welcome_page') }}">
                <i class="bi bi-speedometer2"></i>
                <span>Dashboard</span>
            </a>
        </li>
        <li class="nav-item"><a class="nav-link" href="#">Pipeline</a></li>
        <li class="nav-item">
            <a class="nav-link" href="{{ route('dealanalysis_page') }}">
                <i class="bi bi-speedometer2"></i>
                <span>Deal Analysis</span>
            </a>
        </li>
        </li><li class="nav-item">
            <a class="nav-link" href="{{ route('dealprocess_page') }}">
                <i class="bi bi-speedometer2"></i>
                <span>Deal Process</span>
            </a>
        </li>
        <li class="nav-item"><a class="nav-link" href="#">NDA Tool</a></li>
      </ul>
      <form class="d-flex me-3">
        <input class="form-control me-2" type="search" placeholder="Search..." aria-label="Search">
        <button class="btn btn-outline-warning" type="submit">Search</button>
      </form>
      <div class="dropdown">
        <!-- Profile Image -->
        <a href="#" class="d-block" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
          <img src="{{ asset('assets/img/team-4.jpg') }}" 
              alt="Profile" 
              class="rounded-circle" 
              width="40" 
              height="40" 
              style="object-fit: cover; cursor: pointer;">
        </a>

        <!-- Dropdown Menu -->
        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="profileDropdown">
          <li class="dropdown-item-text">
            👋 Welcome, <strong>{{ Auth::user()->name }}</strong>
          </li>
          <li><hr class="dropdown-divider"></li>
          <li>
            <form action="{{ route('logout') }}" method="POST">
              @csrf
              <button type="submit" class="dropdown-item text-danger">Logout</button>
            </form>
          </li>
        </ul>
      </div>
      
    </div>
  </nav>
<div class="hero-section py-5">
  <!-- Hero Section (Black Background in Middle) -->
    <div class="hero-section py-4">
        <div class="d-flex justify-content-between align-items-center">
            <!-- Left Content -->
            <div>
            <h4 class="fw-bold mb-1 text-white">Ready to dive in? Let’s break this deal down.</h4>
            <small class="text-light">Dashboard > Deal Analysis</small>
            </div>

            <!-- Right Buttons -->
            <div>
            <button class="btn btn-light me-2" style="border-radius:20px;">Produce Pre-screener</button>
            <button class="btn btn-warning" style="border-radius:20px;">Deal Files</button>
            </div>
        </div>
    </div>
</div>
    <div class="container mt-n5 position-relative custom-mt custom-overlap" style="z-index: 10;">
        <!-- Content -->
        <div class="container-fluid py-4">
            <!-- Deal Preview Cards -->
            <div class="row">
            <div class="col-md-3 mb-4">
                <div class="card shadow-sm">
                <img src="assets/logo/Asset2.png" class="card-img-top" alt="Asset">
                <div class="card-body">
                    <h6 class="card-title">Asset</h6>
                    <p class="text-sm text-muted">An image of the deal site highlighting its prime location and architectural design.</p>
                </div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="card shadow-sm">
                <img src="assets/logo/Asset2.png" class="card-img-top" alt="Location">
                <div class="card-body">
                    <h6 class="card-title">Location</h6>
                    <p class="text-sm text-muted">An image of the deal site highlighting its prime location and architectural design.</p>
                </div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="card shadow-sm">
                <img src="assets/logo/Asset2.png" class="card-img-top" alt="Aerial View">
                <div class="card-body">
                    <h6 class="card-title">Aerial View</h6>
                    <p class="text-sm text-muted">An image of the deal site highlighting its prime location and architectural design.</p>
                </div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="card shadow-sm">
                <img src="assets/logo/Asset2.png" class="card-img-top" alt="Site Plan">
                <div class="card-body">
                    <h6 class="card-title">Site Plan</h6>
                    <p class="text-sm text-muted">An image of the deal site highlighting its prime location and architectural design.</p>
                </div>
                </div>
            </div>
        </div>

    <!-- Deal Details + Underwriting Metrics -->
    <div class="row">
      <!-- Deal Details -->
      <div class="col-md-6 mb-4">
        <div class="card shadow-sm">
          <div class="card-header"><h6 class="mb-0">Deal Details</h6></div>
          <div class="card-body p-0">
            <table class="table table-borderless align-middle mb-0">
              <tbody>
                <tr><td>Deal Name</td><td class="fw-bold text-end">Project Sam</td></tr>
                <tr><td>Location</td><td class="fw-bold text-end">London</td></tr>
                <tr><td>Asset Class</td><td class="fw-bold text-end">COR</td></tr>
                <tr><td>Asset Type</td><td class="fw-bold text-end">Hotel</td></tr>
                <tr><td>Tenant</td><td class="fw-bold text-end">Sevi Limited</td></tr>
                <tr><td>Start Date</td><td class="fw-bold text-end">20/07/2025</td></tr>
                <tr><td>Expiry Date</td><td class="fw-bold text-end">01/02/2050</td></tr>
                <tr><td>Review Pattern</td><td class="fw-bold text-end">Annual</td></tr>
                <tr><td>Indexation</td><td class="fw-bold text-end">CPI+1%</td></tr>
                <tr><td>Collar / Cap</td><td class="fw-bold text-end">0 / 5</td></tr>
                <tr><td>Rent</td><td class="fw-bold text-end">£3,000,000</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <!-- Underwriting Metrics -->
      <div class="col-md-6 mb-4">
        <div class="card shadow-sm">
          <div class="card-header"><h6 class="mb-0">Underwriting Metrics</h6></div>
          <div class="card-body p-0">
            <table class="table table-borderless align-middle mb-0">
              <tbody>
                <tr><td>Pricing Date</td><td class="fw-bold text-end">20/07/2025</td></tr>
                <tr><td>Target Spread</td><td class="fw-bold text-end">Z-250</td></tr>
                <tr><td>Credit Rating</td><td class="fw-bold text-end">A-</td></tr>
                <tr><td>Stabilised NOI</td><td class="fw-bold text-end">£3,000,000</td></tr>
                <tr><td>VPV</td><td class="fw-bold text-end">£200,000,000</td></tr>
                <tr><td>IRR</td><td class="fw-bold text-end">7.12%</td></tr>
                <tr><td>Duration</td><td class="fw-bold text-end">14.74</td></tr>
                <tr><td>WAL</td><td class="fw-bold text-end">27.13</td></tr>
                <tr><td>Assumed Costs</td><td class="fw-bold text-end">6.8%</td></tr>
                <tr><td>Comparator Bond Spread</td><td class="fw-bold text-end">80 Bps</td></tr>
                <tr><td>Illiquidity Premium</td><td class="fw-bold text-end">129 Bps</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <!-- Deal Metrics + Sensitivity Metrics -->
    <div class="row">
      <!-- Deal Metrics -->
      <div class="col-md-6 mb-4">
        <div class="card shadow-sm">
          <div class="card-header"><h6 class="mb-0">Deal Metrics</h6></div>
          <div class="card-body p-0">
            <table class="table table-borderless align-middle mb-0">
              <tbody>
                <tr><td>NIY</td><td class="fw-bold text-end">3.51%</td></tr>
                <tr><td>Net Price</td><td class="fw-bold text-end">£7,965,000</td></tr>
                <tr><td>Gross Price</td><td class="fw-bold text-end">34.6%</td></tr>
                <tr><td>LTV</td><td class="fw-bold text-end">15%</td></tr>
                <tr><td>Income Cover</td><td class="fw-bold text-end">15%</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <!-- Sensitivity Metrics -->
      <div class="col-md-6 mb-4">
        <div class="card shadow-sm">
          <div class="card-header"><h6 class="mb-0">Sensitivity Metrics</h6></div>
          <div class="card-body p-0">
            <table class="table table-borderless align-middle mb-0">
              <tbody>
                <tr><td>Z-230</td><td class="fw-bold text-end">£7,965,000</td></tr>
                <tr><td>Z-240</td><td class="fw-bold text-end">£7,965,000</td></tr>
                <tr><td>Z-250</td><td class="fw-bold text-end">£7,965,000</td></tr>
                <tr><td>Z-260</td><td class="fw-bold text-end">£7,965,000</td></tr>
                <tr><td>Z-270</td><td class="fw-bold text-end">£7,965,000</td></tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <!-- Scenario Analysis -->
    <div class="row">
      <div class="col-12 mb-4">
        <div class="card shadow-sm">
          <div class="card-header"><h6 class="mb-0">Scenario Analysis</h6></div>
          <div class="card-body">
            <canvas id="scenarioChart" height="120"></canvas>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

  <!-- JS -->
 <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  const ctx = document.getElementById('scenarioChart').getContext('2d');
  new Chart(ctx, {
    type: 'line',
    data: {
      labels: ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug'],
      datasets: [{
        label: 'Scenario',
        data: [3,5,4,6,7,6,5,4],
        borderColor: '#3b82f6',
        backgroundColor: 'rgba(59, 130, 246, 0.3)',
        fill: true,
        tension: 0.3,
        pointBackgroundColor: '#3b82f6', // make points visible
        pointRadius: 5,
        pointHoverRadius: 7
      }]
    },
    options: {
      plugins: {
        legend: { display: false },
        tooltip: {
          enabled: true,
          callbacks: {
            label: function(context) {
              return 'Value: ' + context.raw;
            }
          }
        }
      },
      scales: {
        x: { display: false, grid: { display: false } },
        y: { display: false, grid: { display: false } }
      }
    }
  });
</script>
</body>
</html>
