<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Deal Analysis - Sevi Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  <style>
    body {
      background-color: #f8f9fa;
    }
    .navbar-dark {
      background-color: #1b1b1b;
    }
    .card {
      border-radius: 15px;
      box-shadow: 0px 2px 5px rgba(0,0,0,0.1);
    }
.hero-section {
    background-color: #000; /* black background */
    color: #fff;            /* text in white */
    border-radius: 0px;    /* optional rounded edges */
    padding: 40px 30px;     /* make it taller */
    margin-bottom: 40px;    /* space so next content doesn't overlap */
}
.custom-overlap {
  margin-top: -200px;       /* reset */
  position: relative;
  z-index: 2;
}
    .custom-mt {
    margin-top: -130px;
    }
  </style>
</head>
<body>

    <!-- Navbar -->
  <nav class="navbar navbar-dark navbar-expand-lg px-3" style="background-color: #000;">
    <a class="navbar-brand fw-bold text-warning d-flex align-items-center" href="#">
      <img src="assets/logo/Logo.png" alt="Logo" style="height: 40px; width: auto; object-fit: contain;">
    </a>
    <div class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto">
        <li class="nav-item">
            <a class="nav-link" href="{{ route('welcome_page') }}">
                <i class="bi bi-speedometer2"></i>
                <span>Dashboard</span>
            </a>
        </li>
        <li class="nav-item"><a class="nav-link" href="#">Pipeline</a></li>
        <li class="nav-item">
            <a class="nav-link" href="{{ route('dealanalysis_page') }}">
                <i class="bi bi-speedometer2"></i>
                <span>Deal Analysis</span>
            </a>
        </li>
        </li><li class="nav-item">
            <a class="nav-link" href="{{ route('dealprocess_page') }}">
                <i class="bi bi-speedometer2"></i>
                <span>Deal Process</span>
            </a>
        </li>
        <li class="nav-item"><a class="nav-link" href="#">NDA Tool</a></li>
      </ul>
      <form class="d-flex me-3">
        <input class="form-control me-2" type="search" placeholder="Search..." aria-label="Search">
        <button class="btn btn-outline-warning" type="submit">Search</button>
      </form>
      <div class="dropdown">
            <!-- Profile Image -->
            <a href="#" class="d-block" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                <img src="{{ asset('assets/img/team-4.jpg') }}" 
                    alt="Profile" 
                    class="rounded-circle" 
                    width="40" 
                    height="40" 
                    style="object-fit: cover; cursor: pointer;">
            </a>

            <!-- Dropdown Menu -->
            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="profileDropdown">
                <li class="dropdown-item-text">
                👋 Welcome, <strong>{{ Auth::user()->name }}</strong>
                </li>
                <li><hr class="dropdown-divider"></li>
                <li>
                <form action="{{ route('logout') }}" method="POST">
                    @csrf
                    <button type="submit" class="dropdown-item text-danger">Logout</button>
                </form>
                </li>
            </ul>
        </div>
    </div>
  </nav>

<div class="hero-section py-5">
  <!-- Hero Section (Black Background in Middle) -->
    <div class="hero-section py-4">
        <div class="d-flex justify-content-between align-items-center">
            <!-- Left Content -->
            <div>
            <h4 class="fw-bold mb-1 text-white">Deal Process</h4>
            <small class="text-light">Dashboard > Deal Process</small>
            </div>

            <!-- Right Buttons -->
            <div>
            <button class="btn btn-light me-2" style="border-radius:20px;">Deal Timeline</button>
            <button class="btn btn-warning" style="border-radius:20px;">Deal Files</button>
            </div>
        </div>
    </div>
</div>
    <div class="container mt-n5 position-relative custom-mt custom-overlap" style="z-index: 10;">
<div class="container-fluid py-4">
  <div class="card">
    <div class="card-header pb-0">
      <h6>Deal Summary</h6>
    </div>
    <div class="card-body">
      <!-- Deal Summary Grid -->
      <div class="row">
        <div class="col-md-3">
          <p class="text-sm mb-1 fw-bold">Deal Name</p>
          <h6>Project Sevi</h6>
        </div>
        <div class="col-md-3">
          <p class="text-sm mb-1 fw-bold">Address</p>
          <h6>Sevi Court, 123 Sevi Lane, SE5 1V1</h6>
        </div>
        <div class="col-md-3">
          <p class="text-sm mb-1 fw-bold">Tenant</p>
          <h6>Sevi Incorporated</h6>
        </div>
        <div class="col-md-3">
          <p class="text-sm mb-1 fw-bold">Credit Rating</p>
          <h6>A-</h6>
        </div>
      </div>
      <div class="row mt-3">
        <div class="col-md-2">
          <p class="text-sm mb-1 fw-bold">UXT</p>
          <h6>23.5 yrs</h6>
        </div>
        <div class="col-md-2">
          <p class="text-sm mb-1 fw-bold">Indexation</p>
          <h6>Annual, CPI+1.0(5)</h6>
        </div>
        <div class="col-md-2">
          <p class="text-sm mb-1 fw-bold">LTV / Income Cover</p>
          <h6>39.1% / 14.3%</h6>
        </div>
        <div class="col-md-2">
          <p class="text-sm mb-1 fw-bold">NIY</p>
          <h6>3.26%</h6>
        </div>
        <div class="col-md-2">
          <p class="text-sm mb-1 fw-bold">Spread</p>
          <h6>Z+260</h6>
        </div>
        <div class="col-md-2">
          <p class="text-sm mb-1 fw-bold">Price</p>
          <h6>£79,800,000</h6>
        </div>
      </div>

      <!-- Divider -->
      <hr class="my-4">

      <!-- Deal Workflow Overview -->
      <h6>Deal Workflow Overview</h6>
        <div class="row mt-3">
            <!-- 01 Bid -->
            <div class="col-md-2">
            <div class="card border border-danger">
                <div class="card-header py-2 bg-gradient-danger text-dark">
                <!-- Skyblue Circle -->
                <span class="me-2" style="
                    display: inline-block;
                    width: 12px;
                    height: 12px;
                    background-color: red;
                    border-radius: 50%;
                "></span>
                <h6 class="mb-0">Bid</h6>
                </div>
                <div class="card-body p-2">
                    <div class="progress">
                        <div class="progress-bar" style="width:70%"></div>
                    </div>
                </div>
            </div>
            </div>
             <!-- 02 Board -->
            <div class="col-md-2">
                <div class="card border border-danger">
                    <div class="card-header py-2 bg-gradient-danger text-dark">
                    <!-- Skyblue Circle -->
                    <span class="me-2" style="
                        display: inline-block;
                        width: 12px;
                        height: 12px;
                        background-color: yellow;
                        border-radius: 50%;
                    "></span>
                    <h6 class="mb-0">Board Requirements</h6>
                    </div>
                    <div class="card-body p-2">
                        <div class="progress">
                            <div class="progress-bar" style="width:70%"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- 03 Legal Queries -->
            <div class="col-md-2">
            <div class="card border border-success">
                <div class="card-header py-2 bg-gradient-success text-dark d-flex align-items-center">
                <!-- Green Circle -->
                <span class="me-2" style="
                    display: inline-block;
                    width: 12px;
                    height: 12px;
                    background-color: green;
                    border-radius: 50%;
                "></span>
                <h6 class="mb-0">Legal Queries</h6>
                </div>
                <div class="card-body p-2">
                <div class="progress">
                    <div class="progress-bar bg-success" style="width: 70%"></div>
                </div>
                </div>
            </div>
            </div>

              <!-- 04 Due Diligence -->
            <div class="col-md-2">
                <div class="card border border-skyblue">
                    <div class="card-header py-2" style="color: black; display: flex; align-items: center;">
                        <!-- Skyblue Circle -->
                        <span class="me-2" style="
                            display: inline-block;
                            width: 12px;
                            height: 12px;
                            background-color: skyblue;
                            border-radius: 50%;
                        "></span>
                        <h6 class="mb-0">Due Diligence</h6>
                    </div>
                    <div class="card-body p-2">
                        <div class="progress">
                            <div class="progress-bar" style="width:70%; background-color: skyblue;"></div>
                        </div>
                    </div>
                </div>
            </div>


            <!-- 05 Pre-Exchange Sign Off -->
            <div class="col-md-2">
                <div class="card border border-danger">
                    <div class="card-header py-1 bg-gradient-danger text-dark">
                    <!-- Skyblue Circle -->
                    <span class="me-2" style="
                        display: inline-block;
                        width: 12px;
                        height: 12px;
                        background-color: blue;
                        border-radius: 50%;
                    "></span>
                    <h6 class="mb-0">Pre-Exchange</h6>
                    </div>
                    <div class="card-body p-2">
                        <div class="progress">
                            <div class="progress-bar" style="width:70%"></div>
                        </div>
                    </div>
                </div>
            </div>
                        
            <!-- 06 Onboarding -->
            <div class="col-md-2">
                <div class="card border border-danger">
                    <div class="card-header py-2 bg-gradient-danger text-dark">
                    <!-- Skyblue Circle -->
                    <span class="me-2" style="
                        display: inline-block;
                        width: 12px;
                        height: 12px;
                        background-color: black;
                        border-radius: 50%;
                    "></span>
                    <h6 class="mb-0">Onboarding</h6>
                    </div>
                    <div class="card-body p-2">
                    <div class="card-body p-2">
                    <div class="progress">
                        <div class="progress-bar" style="width:70%"></div>
                    </div>
                    </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Divider -->
      <hr class="my-4">

      <div class="row mt-3">
        <!-- 01 Bid -->
        <div class="col-md-2">
        <div class="card" style="border: 1px solid #b12230ff;"> <!-- Red border -->
            <div class="card-header py-2" style="color: black;">
            <h6 class="mb-0">01 Bid</h6>
            </div>
            <div class="card-body p-2">
            <ul class="list-group list-group-flush">
                <li class="list-group-item text-sm">
                NDA Review
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 70%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Conflict Check
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 50%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Environment Tool
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 80%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Pricing Approval
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 60%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                CDD Check
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 90%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Bid Letter
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 40%;"></div>
                </div>
                </li>
            </ul>
            </div>
        </div>
        </div>


        <!-- 02 Board -->
        <div class="col-md-2">
        <div class="card" style="border: 1px solid #ffc107;"> <!-- Yellow border -->
            <div class="card-header py-2" style="color: black;">
            <h6 class="mb-0">02 Board</h6>
            </div>
            <div class="card-body p-2">
            <ul class="list-group list-group-flush">
                <li class="list-group-item text-sm">
                Credit Review
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar" style="width: 70%; background-color: #ffc107;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Research Review
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar" style="width: 50%; background-color: #ffc107;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                NZ DD Report
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar" style="width: 80%; background-color: #ffc107;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Board Paper
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar" style="width: 60%; background-color: #ffc107;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                IC Submission
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar" style="width: 90%; background-color: #ffc107;"></div>
                </div>
                </li>
            </ul>
            </div>
        </div>
        </div>


        <!-- 03 Legal Queries -->
        <div class="col-md-2">
        <div class="card" style="border: 1px solid #28a745;">
            <div class="card-header py-2" style="color: black;">
            <h6 class="mb-0">03 Legal Queries</h6>
            </div>
            <div class="card-body p-2">
            <ul class="list-group list-group-flush">
                <li class="list-group-item text-sm">
                Solicitor Selection
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-success" style="width: 70%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Term Sheet
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-success" style="width: 50%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Lease Assessment
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-success" style="width: 80%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Sales & Purchase
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-success" style="width: 60%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Legal Queries
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-success" style="width: 90%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Legal Attestation
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-success" style="width: 40%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Execute Documents
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-success" style="width: 75%;"></div>
                </div>
                </li>
            </ul>
            </div>
        </div>
        </div>


        <!-- 04 Due Diligence -->
      <div class="col-md-2">
        <div class="card" style="border: 1px solid skyblue;">
            <div class="card-header py-2" style="color: black;">
            <h6 class="mb-0">04 Due Diligence</h6>
            </div>
            <div class="card-body p-2">
            <ul class="list-group list-group-flush">
                <li class="list-group-item text-sm">
                Flood Risk Assessment
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 70%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Environmental Assessment
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 50%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Building Survey
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 80%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Fire Risk Audit
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 60%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Valuation
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 90%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Tax
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 40%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Finance
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 75%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Compliance
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 60%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Execute Documents
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-danger" style="width: 85%;"></div>
                </div>
                </li>
            </ul>
            </div>
        </div>
        </div>



        <!-- 05 Pre-Exchange -->
        <div class="col-md-2">
        <div class="card" style="border: 1px solid rgba(58, 45, 246, 1);"> <!-- Blue border -->
            <div class="card-header py-2" style="color: black;">
            <h6 class="mb-0">05 Pre-Exchange</h6>
            </div>
            <div class="card-body p-2">
            <ul class="list-group list-group-flush">
                <li class="list-group-item text-sm">
                IC Conditions Met
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-blue" style="width: 70%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Credit Conditions Met
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-blue" style="width: 50%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                DD Completed
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-blue" style="width: 80%;"></div>
                </div>
                </li>
                <li class="list-group-item text-sm">
                Attestation
                <div class="progress mt-1" style="height: 6px;">
                    <div class="progress-bar bg-blue" style="width: 60%;"></div>
                </div>
                </li>
            </ul>
            </div>
        </div>
        </div>


        <!-- 06 Onboarding -->
        <div class="col-md-2">
            <div class="card" style="border: 1px solid #343a40;"> <!-- Dark grey border -->
                <div class="card-header py-2" style="color: black;">
                <h6 class="mb-0">06 Onboarding</h6>
                </div>
                <div class="card-body p-2">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item text-sm">
                    Confirmed Closing
                    <div class="progress mt-1" style="height: 6px;">
                        <div class="progress-bar bg-dark" style="width: 70%;"></div>
                    </div>
                    </li>
                    <li class="list-group-item text-sm">
                    SDLT Paid
                    <div class="progress mt-1" style="height: 6px;">
                        <div class="progress-bar bg-dark" style="width: 50%;"></div>
                    </div>
                    </li>
                    <li class="list-group-item text-sm">
                    Onboarding Documentation
                    <div class="progress mt-1" style="height: 6px;">
                        <div class="progress-bar bg-dark" style="width: 80%;"></div>
                    </div>
                    </li>
                    <li class="list-group-item text-sm">
                    Asset Manager
                    <div class="progress mt-1" style="height: 6px;">
                        <div class="progress-bar bg-dark" style="width: 60%;"></div>
                    </div>
                    </li>
                    <li class="list-group-item text-sm">
                    Valuer Information
                    <div class="progress mt-1" style="height: 6px;">
                        <div class="progress-bar bg-dark" style="width: 90%;"></div>
                    </div>
                    </li>
                    <li class="list-group-item text-sm">
                    Public Relations & External
                    <div class="progress mt-1" style="height: 6px;">
                        <div class="progress-bar bg-dark" style="width: 40%;"></div>
                    </div>
                    </li>
                    <li class="list-group-item text-sm">
                    Communication
                    <div class="progress mt-1" style="height: 6px;">
                        <div class="progress-bar bg-dark" style="width: 75%;"></div>
                    </div>
                    </li>
                </ul>
                </div>
            </div>
        </div>

        </div>
      </div> <!-- row -->
    </div>
  </div>
</div>
</div>

  </main>


    
</body>
</html>
