<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deal Analysis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/a2e0e9c6e4.js" crossorigin="anonymous"></script>
</head>
<body class="g-sidenav-show bg-gray-100">

    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg px-0 mx-4 shadow-none border-radius-xl z-index-sticky" id="navbarBlur"
        data-scroll="false">
        <div class="container-fluid py-1 px-3">
            <!-- Title left out since Blade include removed -->
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none ">
                <a href="javascript:;" class="nav-link p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                        <i class="sidenav-toggler-line bg-white"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search"></i></span>
                        <input type="text" class="form-control" placeholder="Search deals or alerts">
                    </div>
                </div>
                <ul class="navbar-nav justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        <a class="nav-link text-body font-weight-bold px-0" href="#">
                            <i class="fa fa-sign-out-alt me-sm-1"></i> Logout
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container-fluid py-4">
        <!-- Title -->
        <div class="row mb-4">
            <div class="col-12">
                <h4 class="fw-bold">Ready to dive in? Let’s break this deal down.</h4>
                <small class="text-muted">Dashboard > Overview</small>
            </div>
        </div>

        <!-- Deal Preview Cards -->
        <div class="row">
            <div class="col-md-3 mb-4">
                <div class="card shadow-sm">
                    <img src="/assets/img/img-3.jpg" class="card-img-top" alt="Asset">
                    <div class="card-body">
                        <h6 class="card-title">Asset</h6>
                        <p class="text-sm text-muted">An image of the deal site highlighting its prime location and architectural design.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="card shadow-sm">
                    <img src="/assets/img/img-3.jpg" class="card-img-top" alt="Location">
                    <div class="card-body">
                        <h6 class="card-title">Location</h6>
                        <p class="text-sm text-muted">An image of the deal site highlighting its prime location and architectural design.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="card shadow-sm">
                    <img src="/assets/img/img-3.jpg" class="card-img-top" alt="Aerial View">
                    <div class="card-body">
                        <h6 class="card-title">Aerial View</h6>
                        <p class="text-sm text-muted">An image of the deal site highlighting its prime location and architectural design.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="card shadow-sm">
                    <img src="/assets/img/img-3.jpg" class="card-img-top" alt="Site Plan">
                    <div class="card-body">
                        <h6 class="card-title">Site Plan</h6>
                        <p class="text-sm text-muted">An image of the deal site highlighting its prime location and architectural design.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Deal Details + Underwriting Metrics -->
        <div class="row">
            <!-- Deal Details -->
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header"><h6 class="mb-0">Deal Details</h6></div>
                    <div class="card-body p-0">
                        <table class="table table-borderless align-middle mb-0">
                            <tbody>
                                <tr><td>Deal Name</td><td class="fw-bold text-end">Project Sam</td></tr>
                                <tr><td>Location</td><td class="fw-bold text-end">London</td></tr>
                                <tr><td>Asset Class</td><td class="fw-bold text-end">COR</td></tr>
                                <tr><td>Asset Type</td><td class="fw-bold text-end">Hotel</td></tr>
                                <tr><td>Tenant</td><td class="fw-bold text-end">Sevi Limited</td></tr>
                                <tr><td>Start Date</td><td class="fw-bold text-end">20/07/2025</td></tr>
                                <tr><td>Expiry Date</td><td class="fw-bold text-end">01/02/2050</td></tr>
                                <tr><td>Review Pattern</td><td class="fw-bold text-end">Annual</td></tr>
                                <tr><td>Indexation</td><td class="fw-bold text-end">CPI+1%</td></tr>
                                <tr><td>Collar / Cap</td><td class="fw-bold text-end">0 / 5</td></tr>
                                <tr><td>Rent</td><td class="fw-bold text-end">£3,000,000</td></tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Underwriting Metrics -->
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header"><h6 class="mb-0">Underwriting Metrics</h6></div>
                    <div class="card-body p-0">
                        <table class="table table-borderless align-middle mb-0">
                            <tbody>
                                <tr><td>Pricing Date</td><td class="fw-bold text-end">20/07/2025</td></tr>
                                <tr><td>Target Spread</td><td class="fw-bold text-end">Z-250</td></tr>
                                <tr><td>Credit Rating</td><td class="fw-bold text-end">A-</td></tr>
                                <tr><td>Stabilised NOI</td><td class="fw-bold text-end">£3,000,000</td></tr>
                                <tr><td>VPV</td><td class="fw-bold text-end">£200,000,000</td></tr>
                                <tr><td>IRR</td><td class="fw-bold text-end">7.12%</td></tr>
                                <tr><td>Duration</td><td class="fw-bold text-end">14.74</td></tr>
                                <tr><td>WAL</td><td class="fw-bold text-end">27.13</td></tr>
                                <tr><td>Assumed Costs</td><td class="fw-bold text-end">6.8%</td></tr>
                                <tr><td>Comparator Bond Spread</td><td class="fw-bold text-end">80 Bps</td></tr>
                                <tr><td>Illiquidity Premium</td><td class="fw-bold text-end">129 Bps</td></tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Deal Metrics + Sensitivity Metrics -->
        <div class="row">
            <!-- Deal Metrics -->
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header"><h6 class="mb-0">Deal Metrics</h6></div>
                    <div class="card-body p-0">
                        <table class="table table-borderless align-middle mb-0">
                            <tbody>
                                <tr><td>NIY</td><td class="fw-bold text-end">3.51%</td></tr>
                                <tr><td>Net Price</td><td class="fw-bold text-end">£7,965,000</td></tr>
                                <tr><td>Gross Price</td><td class="fw-bold text-end">34.6%</td></tr>
                                <tr><td>LTV</td><td class="fw-bold text-end">15%</td></tr>
                                <tr><td>Income Cover</td><td class="fw-bold text-end">15%</td></tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Sensitivity Metrics -->
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header"><h6 class="mb-0">Sensitivity Metrics</h6></div>
                    <div class="card-body p-0">
                        <table class="table table-borderless align-middle mb-0">
                            <tbody>
                                <tr><td>Z-230</td><td class="fw-bold text-end">£7,965,000</td></tr>
                                <tr><td>Z-240</td><td class="fw-bold text-end">£7,965,000</td></tr>
                                <tr><td>Z-250</td><td class="fw-bold text-end">£7,965,000</td></tr>
                                <tr><td>Z-260</td><td class="fw-bold text-end">£7,965,000</td></tr>
                                <tr><td>Z-270</td><td class="fw-bold text-end">£7,965,000</td></tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Scenario Analysis -->
        <div class="row">
            <div class="col-12 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header"><h6 class="mb-0">Scenario Analysis</h6></div>
                    <div class="card-body">
                        <canvas id="scenarioChart" height="120"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
    const ctx = document.getElementById('scenarioChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug'],
            datasets: [{
                label: 'Scenario',
                data: [3,5,4,6,7,6,5,4],
                borderColor: '#3b82f6',
                backgroundColor: 'rgba(59, 130, 246, 0.3)',
                fill: true,
                tension: 0.3
            }]
        },
        options: {
            plugins: {
                legend: { display: false },
                tooltip: { enabled: false }
            },
            scales: {
                x: { display: false, grid: { display: false } },
                y: { display: false, grid: { display: false } }
            }
        }
    });
    </script>
</body>
</html>
