{{-- resources/views/deal-analysis.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="bg-gray-900 min-h-screen text-gray-900">
    <!-- Header -->
    <div class="bg-gray-800 text-white px-8 py-4 flex items-center justify-between">
        <div class="flex items-center space-x-2">
            <img src="/images/logos/sevi.png" alt="Logo" class="h-8">
            <span class="text-xl font-bold">Sevi</span>
        </div>
        <div class="flex items-center space-x-6">
            <nav class="space-x-4">
                <a href="#" class="hover:text-orange-400">Dashboard</a>
                <a href="#" class="hover:text-orange-400">Pipeline</a>
                <a href="#" class="hover:text-orange-400 font-semibold border-b-2 border-orange-400">Deal Analysis</a>
                <a href="#" class="hover:text-orange-400">Deal Process</a>
                <a href="#" class="hover:text-orange-400">NDA Tool</a>
            </nav>
            <input type="text" placeholder="Search deals or alerts"
                class="rounded-md px-3 py-1 text-black focus:outline-none">
            <img src="/images/user-avatar.png" alt="User" class="h-10 w-10 rounded-full">
        </div>
    </div>

    <!-- Title -->
    <div class="px-8 py-6">
        <h1 class="text-2xl font-bold">Ready to dive in? Let’s break this deal down.</h1>
        <p class="text-sm text-gray-500">Dashboard > Overview</p>
    </div>

    <!-- Deal Preview Cards -->
    <div class="grid grid-cols-4 gap-6 px-8">
        @foreach(['Asset','Location','Aerial View','Site Plan'] as $card)
            <div class="bg-white rounded-xl shadow p-3">
                <img src="/images/sample.jpg" alt="{{ $card }}" class="rounded-lg mb-3">
                <h2 class="font-bold">{{ $card }}</h2>
                <p class="text-sm text-gray-600">An image of the deal site highlighting its prime location and architectural design.</p>
            </div>
        @endforeach
    </div>

    <!-- Deal Details and Underwriting -->
    <div class="grid grid-cols-2 gap-6 px-8 mt-6">
        <!-- Deal Details -->
        <div class="bg-white p-6 rounded-xl shadow">
            <h3 class="font-bold mb-4">Deal Details</h3>
            <ul class="space-y-2 text-sm">
                <li><strong>Deal Name:</strong> Project Sam</li>
                <li><strong>Location:</strong> London</li>
                <li><strong>Asset Class:</strong> COR</li>
                <li><strong>Asset Type:</strong> Hotel</li>
                <li><strong>Tenant:</strong> Sevi Limited</li>
                <li><strong>Start Date:</strong> 20/07/2025</li>
                <li><strong>Expiry Date:</strong> 01/02/2050</li>
                <li><strong>Review Pattern:</strong> Annual</li>
                <li><strong>Indexation:</strong> CPI+1%</li>
                <li><strong>Collar / Cap:</strong> 0 / 5</li>
                <li><strong>Rent:</strong> £3,000,000</li>
            </ul>
        </div>

        <!-- Underwriting Metrics -->
        <div class="bg-white p-6 rounded-xl shadow">
            <h3 class="font-bold mb-4">Underwriting Metrics</h3>
            <ul class="space-y-2 text-sm">
                <li><strong>Pricing Date:</strong> 20/07/2025</li>
                <li><strong>Target Spread:</strong> Z-250</li>
                <li><strong>Credit Rating:</strong> A-</li>
                <li><strong>Stabilised NOI:</strong> £3,000,000</li>
                <li><strong>VPV:</strong> £200,000,000</li>
                <li><strong>IRR:</strong> 7.12%</li>
                <li><strong>Duration:</strong> 14.74</li>
                <li><strong>WAL:</strong> 27.13</li>
                <li><strong>Assumed Costs:</strong> 6.8%</li>
                <li><strong>Comparator Bond Spread:</strong> 80 Bps</li>
                <li><strong>Illiquidity Premium:</strong> 129 Bps</li>
            </ul>
        </div>
    </div>

    <!-- Deal Metrics and Sensitivity -->
    <div class="grid grid-cols-2 gap-6 px-8 mt-6">
        <!-- Deal Metrics -->
        <div class="bg-white p-6 rounded-xl shadow">
            <h3 class="font-bold mb-4">Deal Metrics</h3>
            <ul class="space-y-2 text-sm">
                <li><strong>NIY:</strong> 3.51%</li>
                <li><strong>Net Price:</strong> £7,965,000</li>
                <li><strong>Gross Price:</strong> 34.6%</li>
                <li><strong>LTV:</strong> 15%</li>
                <li><strong>Income Cover:</strong> 15%</li>
            </ul>
        </div>

        <!-- Sensitivity Metrics -->
        <div class="bg-white p-6 rounded-xl shadow">
            <h3 class="font-bold mb-4">Sensitivity Metrics</h3>
            <ul class="space-y-2 text-sm">
                <li>Z-230 → £7,965,000</li>
                <li>Z-240 → £7,965,000</li>
                <li>Z-250 → £7,965,000</li>
                <li>Z-260 → £7,965,000</li>
                <li>Z-270 → £7,965,000</li>
            </ul>
        </div>
    </div>

    <!-- Scenario Analysis -->
    <div class="px-8 mt-6">
        <div class="bg-white p-6 rounded-xl shadow">
            <h3 class="font-bold mb-4">Scenario Analysis</h3>
            <canvas id="scenarioChart"></canvas>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('scenarioChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug'],
            datasets: [{
                label: 'Scenario',
                data: [3,5,4,6,7,6,5,4],
                borderColor: '#3b82f6',
                backgroundColor: 'rgba(59, 130, 246, 0.3)',
                fill: true,
                tension: 0.3
            }]
        }
    });
</script>
@endpush
